/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.xprotect.camera;

import com.tridium.videoDriver.ui.videoStream.decoder.GenericMjpegDecoder;
import com.tridium.videoDriver.videoStream.decoder.VidFrame;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PushbackInputStream;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.sys.BAbsTime;

public class XProtectMjpegVideoDecoder
extends GenericMjpegDecoder {
    protected LineNumberReader lineNumberReader;

    protected void readUntilStartOfJpeg_driverSpecific(VidFrame vf) throws IOException {
        PushbackInputStream videoIn = (PushbackInputStream)this.videoIn;
        if (videoIn != null) {
            videoIn.read(this.buffer, 0, 2);
            int positionInBuffer = 1;
            while (true) {
                int nextByte;
                boolean isLastByte0xd8;
                int secondToLastByte = this.buffer[positionInBuffer - 1] & 0xFF;
                int lastByte = this.buffer[positionInBuffer] & 0xFF;
                boolean isSecondToLastByte0xff = secondToLastByte == 255;
                boolean bl = isLastByte0xd8 = lastByte == 216;
                if (isSecondToLastByte0xff && isLastByte0xd8) break;
                if (++positionInBuffer >= this.buffer.length) {
                    byte[] newBuffer = new byte[this.buffer.length * 2];
                    ByteArrayUtil.copy((byte[])this.buffer, (byte[])newBuffer);
                    this.buffer = newBuffer;
                }
                if ((nextByte = videoIn.read()) < 0) {
                    throw new EOFException();
                }
                this.buffer[positionInBuffer] = (byte)nextByte;
            }
            this.readForCurrentTime(vf, this.buffer);
            videoIn.unread(this.buffer, positionInBuffer - 1, 2);
        }
    }

    public void readForCurrentTime(VidFrame vf, byte[] buffer) {
        try {
            String strbuf = new String(buffer);
            String strMillis = "";
            if (strbuf.contains("Current")) {
                strMillis = strbuf.substring(strbuf.indexOf("Current: ") + 9, strbuf.indexOf("Next") - 1);
            }
            this.lineNumberReader = new LineNumberReader(new InputStreamReader(new ByteArrayInputStream(buffer)));
            long currentMillis = -1L;
            if (!strMillis.equalsIgnoreCase("")) {
                currentMillis = Long.parseLong(strMillis.trim());
                vf.timeIndex = BAbsTime.make((long)currentMillis);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

