/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.xprotect;

import com.tridium.ndriver.comm.NComm;
import com.tridium.ndriver.datatypes.BHttpCommConfig;
import com.tridium.ndriver.poll.BNPollScheduler;
import com.tridium.nvideo.BVideoNetwork;
import com.tridium.xprotect.comm.BXProtectTcpCommConfig;
import com.tridium.xprotect.server.management.BXProtectManagementConnection;
import com.tridium.xprotect.server.management.BXProtectManagementServer;
import com.tridium.xprotect.server.management.BXProtectManagementServerFolder;
import com.tridium.xprotect.util.WebProcessUtil;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.driver.BDevice;
import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.license.LicenseDatabaseException;
import javax.baja.nre.util.Array;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public class BMilestoneXProtectNetwork
extends BVideoNetwork {
    protected static Logger log = Logger.getLogger("xprotect.network");
    public static final Property poll = BMilestoneXProtectNetwork.newProperty((int)0, (BValue)new BNPollScheduler(), null);
    public static final Property nativeProcessPort = BMilestoneXProtectNetwork.newProperty((int)0, (int)9117, null);
    public static final Property nativeProcessAppGuid = BMilestoneXProtectNetwork.newProperty((int)1, (String)"", null);
    public static final Property tcpRsConfig = BMilestoneXProtectNetwork.newProperty((int)0, (BValue)new BXProtectTcpCommConfig(), null);
    public static final Property httpConfig = BMilestoneXProtectNetwork.newProperty((int)0, (BValue)new BHttpCommConfig(), null);
    public static final Action connect = BMilestoneXProtectNetwork.newAction((int)2048, null);
    public static final Action disconnect = BMilestoneXProtectNetwork.newAction((int)2052, null);
    public static final Action restartNativeProcess = BMilestoneXProtectNetwork.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BMilestoneXProtectNetwork.class);
    public static Lexicon LEX = Lexicon.make(BMilestoneXProtectNetwork.class);

    public BNPollScheduler getPoll() {
        return (BNPollScheduler)this.get(poll);
    }

    public void setPoll(BNPollScheduler v) {
        this.set(poll, (BValue)v, null);
    }

    public int getNativeProcessPort() {
        return this.getInt(nativeProcessPort);
    }

    public void setNativeProcessPort(int v) {
        this.setInt(nativeProcessPort, v, null);
    }

    public String getNativeProcessAppGuid() {
        return this.getString(nativeProcessAppGuid);
    }

    public void setNativeProcessAppGuid(String v) {
        this.setString(nativeProcessAppGuid, v, null);
    }

    public BXProtectTcpCommConfig getTcpRsConfig() {
        return (BXProtectTcpCommConfig)this.get(tcpRsConfig);
    }

    public void setTcpRsConfig(BXProtectTcpCommConfig v) {
        this.set(tcpRsConfig, (BValue)v, null);
    }

    public BHttpCommConfig getHttpConfig() {
        return (BHttpCommConfig)this.get(httpConfig);
    }

    public void setHttpConfig(BHttpCommConfig v) {
        this.set(httpConfig, (BValue)v, null);
    }

    public void connect() {
        this.invoke(connect, null, null);
    }

    public void disconnect() {
        this.invoke(disconnect, null, null);
    }

    public void restartNativeProcess() {
        this.invoke(restartNativeProcess, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public String getNetworkName() {
        return "XProtectNetwork";
    }

    protected boolean useAutoManager() {
        return false;
    }

    public Type getDeviceFolderType() {
        return BXProtectManagementServerFolder.TYPE;
    }

    public Type getDeviceType() {
        return BXProtectManagementServer.TYPE;
    }

    public final Feature getLicenseFeature() {
        BComplex netParent = this.getParent();
        if (netParent != null && netParent.getClass().getName().equals("com.tridium.remoteVideo.BRemoteVideoSource")) {
            return Sys.getLicenseManager().getFeature("Tridium", "remoteVideo");
        }
        Feature feature = null;
        try {
            feature = Sys.getLicenseManager().getFeature("tridium", "milestoneCorporate");
        }
        catch (FeatureNotLicensedException e) {
            log.log(Level.SEVERE, "\"milestoneCorporate\" Feature Not LicensedException. Check for \"milestoneVideo\" License");
        }
        catch (LicenseDatabaseException e) {
            log.log(Level.SEVERE, "\"milestoneCorporate\" Feature Not LicensedException. Check for \"milestoneVideo\" License");
        }
        if (feature != null) {
            return feature;
        }
        return Sys.getLicenseManager().getFeature("tridium", "milestoneVideo");
    }

    public void videoNetworkStarted() throws Exception {
        int flag = this.getHttpConfig().getFlags((Slot)BHttpCommConfig.useTls);
        if ((flag & Integer.MIN_VALUE) == 0) {
            flag &= 0xFFFFFFFE;
            flag &= 0xFFFFFFFB;
            this.getHttpConfig().setFlags((Slot)BHttpCommConfig.useTls, flag |= Integer.MIN_VALUE);
            this.getHttpConfig().setUseTls(true);
            flag = this.getFlags((Slot)nativeProcessPort);
            flag &= 0xFFFFFFFE;
            this.setFlags((Slot)nativeProcessPort, flag &= 0xFFFFFFFD);
            flag = this.getFlags((Slot)restartNativeProcess);
            this.setFlags((Slot)restartNativeProcess, flag &= 0xFFFFFFFB);
        }
        WebProcessUtil.startWebProcess(this.getNativeProcessPort(), this.getHttpConfig().getUseTls());
        this.checkProcessPort();
        this.setNativeProcessAppGuid(WebProcessUtil.getAppGuid());
    }

    public void serviceStopped() throws Exception {
        WebProcessUtil.endWebProcess();
    }

    public void descendantsStarted() throws Exception {
        if (!this.isFault()) {
            this.connect();
        }
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property == enabled) {
            if (this.getEnabled()) {
                this.connect();
            } else {
                this.disconnect();
            }
        }
    }

    public void doConnect() throws Exception {
        this.invokeOnConnections(BXProtectManagementConnection.connect, null, null);
    }

    public void doDisconnect() throws Exception {
        this.invokeOnConnections(BXProtectManagementConnection.disconnect, null, null);
    }

    public void doRestartNativeProcess() throws Exception {
        this.doDisconnect();
        WebProcessUtil.endWebProcess();
        WebProcessUtil.startWebProcess(this.getNativeProcessPort(), this.getHttpConfig().getUseTls());
        this.checkProcessPort();
        this.setNativeProcessAppGuid(WebProcessUtil.getAppGuid());
        this.doConnect();
    }

    private void checkProcessPort() {
        int port = WebProcessUtil.getWebProcessPort();
        if (port == -1) {
            this.configFail(WebProcessUtil.getWebProcessFault());
        } else {
            this.setNativeProcessPort(port);
            this.configOk();
        }
    }

    private BXProtectManagementServer[] getConnectedServers() {
        BDevice[] devices = this.getDevices();
        Array connected = new Array(BXProtectManagementServer.class);
        for (int i = 0; i < devices.length; ++i) {
            if (!((BXProtectManagementServer)devices[i]).getConnection().isConnected()) continue;
            connected.add((Object)((BXProtectManagementServer)devices[i]));
        }
        return (BXProtectManagementServer[])connected.trim();
    }

    private void invokeOnConnections(Action action, BValue arg, Context cx) {
        BDevice[] devices = this.getDevices();
        for (int i = 0; i < devices.length; ++i) {
            BXProtectManagementServer server = (BXProtectManagementServer)devices[i];
            server.getConnection().invoke(action, arg, cx);
        }
    }

    public NComm tcpComm() {
        return (NComm)this.getTcpRsConfig().comm();
    }
}

