/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.provisioningNiagara.license;

import com.tridium.crypto.core.cert.CertificateChainValidator;
import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.install.InstallScenario;
import com.tridium.install.installable.BDeleteFileInstallable;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.nd.BNiagaraStation;
import com.tridium.platcrypto.daemon.BPlatCryptoManager;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.license.BCertificateSummary;
import com.tridium.platform.license.BEnvLicenseSummary;
import com.tridium.platform.license.BVendorLicenseSummary;
import com.tridium.platform.license.LicenseInfo;
import com.tridium.platform.license.LicenseModel;
import com.tridium.platform.license.LicenseSync;
import com.tridium.platform.license.PortalLicenseUtil;
import com.tridium.provisioningNiagara.BPlatformConnection;
import com.tridium.provisioningNiagara.BProvisioningNiagaraNetworkExt;
import com.tridium.provisioningNiagara.NiagaraNetworkJobOp;
import com.tridium.provisioningNiagara.license.BLicenseInstallable;
import com.tridium.provisioningNiagara.license.BLicenseStationExt;
import com.tridium.provisioningNiagara.license.BLicenseStatus;
import com.tridium.sys.license.dom.CertificateDatabase;
import com.tridium.sys.license.dom.LicenseDatabase;
import com.tridium.sys.license.dom.VendorCertificate;
import com.tridium.sys.license.dom.VendorLicense;
import com.tridium.util.ThrowableUtil;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.BatchJobOp;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.BNetworkJobStep;
import javax.baja.batchJob.driver.BNetworkStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.file.BIFile;
import javax.baja.io.BIEncodable;
import javax.baja.job.BJobState;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.platform.ICancelHint;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.Version;
import javax.baja.xml.XElem;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="changeBrand", type="boolean", defaultValue="false"), @NiagaraProperty(name="brandName", type="String", defaultValue="BString.DEFAULT")})
public class BUpdateLicensesJobStep
extends BNetworkJobStep
implements ICancelHint,
NiagaraNetworkJobOp.InstallListener {
    public static final Property changeBrand = BUpdateLicensesJobStep.newProperty((int)0, (boolean)false, null);
    public static final Property brandName = BUpdateLicensesJobStep.newProperty((int)0, (BValue)BString.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BUpdateLicensesJobStep.class);
    private static final BIcon icon = BIcon.std((String)"doc.png");
    protected static final Logger log = Logger.getLogger("provisioningNiagara");
    private static final String BOOTSTRAPPED_STATIONS_KEY = "bootstrappedStations";

    public boolean getChangeBrand() {
        return this.getBoolean(changeBrand);
    }

    public void setChangeBrand(boolean v) {
        this.setBoolean(changeBrand, v, null);
    }

    public String getBrandName() {
        return this.getString(brandName);
    }

    public void setBrandName(String v) {
        this.setString(brandName, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    protected void doRun(BBatchJobService svc, BNetworkStepDetails details, BDeviceNetwork nw, BDevice[] devices, DeviceNetworkJobOp opIn) throws Exception {
        AccessController.doPrivileged(() -> {
            this.doRunPrivileged(svc, details, nw, devices, opIn);
            return null;
        });
    }

    /*
     * WARNING - void declaration
     */
    protected final void doRunPrivileged(BBatchJobService svc, BNetworkStepDetails details, BDeviceNetwork nw, BDevice[] devices, DeviceNetworkJobOp opIn) throws Exception {
        void var16_42;
        Object stationCertSummaryByVendor32;
        NiagaraNetworkJobOp op = (NiagaraNetworkJobOp)opIn;
        HashMap<String, BEnvLicenseSummary> licenseSummaryByHostId = new HashMap<String, BEnvLicenseSummary>();
        HashMap certInfoByHostId = new HashMap();
        HashMap<Object, BCertificateSummary> latestCertSummaryByVendor = new HashMap<Object, BCertificateSummary>();
        Set<BNiagaraStation> stations = this.getBootstrappedStationList((BatchJobOp)op);
        BProvisioningNiagaraNetworkExt nwExt = (BProvisioningNiagaraNetworkExt)Sys.getService((Type)BProvisioningNiagaraNetworkExt.TYPE);
        for (BDevice bDevice : devices) {
            this.checkCanceled();
            BNiagaraStation bNiagaraStation = (BNiagaraStation)bDevice;
            details.start("provisioningNiagara", "UpdateLicensesJobStep.getExisting", bNiagaraStation.getDisplayName(null));
            boolean bootstrapMode = stations.contains(bNiagaraStation);
            if (bootstrapMode) {
                details.message("provisioningNiagara", "UpdateLicensesJobStep.bootstrapMode", bNiagaraStation.getStationName());
                continue;
            }
            BLicenseStationExt ext = (BLicenseStationExt)bNiagaraStation.getMixIn(BLicenseStationExt.TYPE);
            if (ext.isUnoperational()) {
                details.endFailed("provisioningNiagara", "UpdateLicensesJobStep.licenseExtUnoperational", new String[]{bNiagaraStation.getDisplayName(null), BFormat.getEncodedPattern((BIEncodable)ext.getStatus())});
                continue;
            }
            BPlatformConnection platformConn = (BPlatformConnection)bNiagaraStation.getMixIn(BPlatformConnection.TYPE);
            if (platformConn.isUnoperational()) {
                details.endFailed("provisioningNiagara", "UpdateLicensesJobStep.platformConnUnoperational", new String[]{bNiagaraStation.getDisplayName(null), BFormat.getEncodedPattern((BIEncodable)platformConn.getStatus())});
                continue;
            }
            BDaemonSession daemonSession = platformConn.getDaemonSession();
            if (daemonSession != null) continue;
            details.endFailed("provisioningNiagara", "UpdateLicensesJobStep.platformConnUnavailable", new String[]{bNiagaraStation.getDisplayName(null)});
        }
        for (BDevice bDevice : devices) {
            this.checkCanceled();
            BNiagaraStation bNiagaraStation = (BNiagaraStation)bDevice;
            BLicenseStationExt ext = (BLicenseStationExt)bNiagaraStation.getMixIn(BLicenseStationExt.TYPE);
            BPlatformConnection platformConn = (BPlatformConnection)bNiagaraStation.getMixIn(BPlatformConnection.TYPE);
            BDaemonSession daemonSession = platformConn.getDaemonSession();
            if (daemonSession.getHostProperties().getIsLicenseReadonly()) {
                details.endFailed("provisioningNiagara", "UpdateLicensesJobStep.licensesReadonly", new String[]{bNiagaraStation.getDisplayName(null)});
                continue;
            }
            this.checkCanceled();
            BEnvLicenseSummary licenses = ext.makeLicenseSummary();
            licenseSummaryByHostId.put(licenses.getHostId(), licenses);
            this.checkCanceled();
            stationCertSummaryByVendor32 = new HashMap();
            BCertificateSummary[] bCertificateSummaryArray = ext.makeCertificateSummaries();
            this.checkCanceled();
            for (BCertificateSummary cert : bCertificateSummaryArray) {
                String vendor = cert.getVendor();
                stationCertSummaryByVendor32.put(vendor, cert);
                BCertificateSummary latest = (BCertificateSummary)latestCertSummaryByVendor.get(vendor);
                if (latest != null && latest.getCertificateGenerated() >= cert.getCertificateGenerated()) continue;
                latestCertSummaryByVendor.put(vendor, cert);
            }
            certInfoByHostId.put(licenses.getHostId(), stationCertSummaryByVendor32);
        }
        HashMap licenseUpdateByHostId = new HashMap();
        boolean checkAgainstSupervisorLicenseDb = true;
        if (nwExt.getLicenses().getAllowLicenseServerAccess()) {
            try {
                BEnvLicenseSummary[] licenseSummaries = new BEnvLicenseSummary[licenseSummaryByHostId.size()];
                licenseSummaryByHostId.values().toArray(licenseSummaries);
                if (this.getChangeBrand()) {
                    log.log(Level.FINE, "Find branded licenses for brandId = " + this.getBrandName());
                    for (Map.Entry entry : licenseSummaryByHostId.entrySet()) {
                        void var22_65;
                        String hostId = (String)entry.getKey();
                        log.log(Level.FINE, "host ID = " + hostId + " Brand ID = " + this.getBrandName());
                        String existingLicenseBrand = ((BEnvLicenseSummary)entry.getValue()).getBrandIdString();
                        if (existingLicenseBrand != null && existingLicenseBrand.equalsIgnoreCase(this.getBrandName())) {
                            details.message("provisioningNiagara", "UpdateLicensesJobStep.brandChangeRequestFailed", new String[]{hostId, this.getBrandName()});
                            log.fine(() -> String.format("Existing license for host id %s matches the requested brand", hostId));
                            continue;
                        }
                        ArrayList<Object> existingVersions = new ArrayList<Object>();
                        String[] licenses = ((BEnvLicenseSummary)entry.getValue()).getVendors();
                        int stationCertSummaryByVendor32 = licenses.length;
                        boolean bl = false;
                        while (var22_65 < stationCertSummaryByVendor32) {
                            String vendor = licenses[var22_65];
                            BVendorLicenseSummary licenseSummary = ((BEnvLicenseSummary)entry.getValue()).getVendorInfo(vendor);
                            Version licenseVersion = new Version(licenseSummary.getLicenseVersionString());
                            existingVersions.add(licenseVersion);
                            ++var22_65;
                        }
                        existingVersions.sort(Comparator.reverseOrder());
                        log.log(Level.FINE, "Existing versions = " + existingVersions.toString());
                        boolean brandedLicenseFound = false;
                        for (Version version : existingVersions) {
                            List brandedModels = PortalLicenseUtil.getExistingLicenses((String)hostId, (String)this.getBrandName(), (Version)version);
                            block10: for (LicenseModel brandedModel : brandedModels) {
                                for (XElem licenseElem : brandedModel.getLicenseElements()) {
                                    VendorLicense brandedLicense = VendorLicense.make((String)"portal", (XElem)licenseElem);
                                    brandedLicense.load("portal", licenseElem);
                                    LicenseDatabase.LOCAL_INSTANCE.add(brandedLicense);
                                    Version vendorLicenseVersion = brandedLicense.getVersion();
                                    String vendorLicenseBrand = brandedLicense.getBrandId();
                                    if (vendorLicenseBrand == null || !vendorLicenseBrand.equalsIgnoreCase(this.getBrandName())) continue;
                                    log.log(Level.FINE, " Portal license version = " + vendorLicenseVersion);
                                    log.log(Level.FINE, " Portal license brand = " + vendorLicenseBrand);
                                    details.message("provisioningNiagara", "UpdateLicensesJobStep.brandedLicenseFound", new String[]{hostId, vendorLicenseBrand});
                                    ArrayList<VendorLicense> hostLicenses = (ArrayList<VendorLicense>)licenseUpdateByHostId.get(hostId);
                                    if (hostLicenses == null) {
                                        hostLicenses = new ArrayList<VendorLicense>();
                                        licenseUpdateByHostId.put(hostId, hostLicenses);
                                    }
                                    hostLicenses.add(brandedLicense);
                                    checkAgainstSupervisorLicenseDb = false;
                                    brandedLicenseFound = true;
                                    continue block10;
                                }
                            }
                            if (!brandedLicenseFound) continue;
                            break;
                        }
                        if (!brandedLicenseFound) continue;
                        stationCertSummaryByVendor32 = (Map)certInfoByHostId.get(hostId);
                        for (VendorLicense hostLicense : (List)licenseUpdateByHostId.get(hostId)) {
                            String brandedLicenseVendor;
                            if (!hostLicense.getBrandId().equalsIgnoreCase(this.getBrandName()) || (brandedLicenseVendor = hostLicense.getVendor()) == null) continue;
                            if (!stationCertSummaryByVendor32.containsKey(brandedLicenseVendor)) {
                                log.log(Level.FINE, "Existing certificate was not found for" + brandedLicenseVendor);
                                stationCertSummaryByVendor32.put(brandedLicenseVendor, BCertificateSummary.makeEmpty((String)brandedLicenseVendor));
                            }
                            if (latestCertSummaryByVendor.containsKey(brandedLicenseVendor)) continue;
                            latestCertSummaryByVendor.put(brandedLicenseVendor, BCertificateSummary.makeEmpty((String)brandedLicenseVendor));
                        }
                    }
                } else {
                    for (VendorLicense updatedLicense : PortalLicenseUtil.getPortalUpdates((BEnvLicenseSummary[])licenseSummaries)) {
                        VendorLicense[] vendor = updatedLicense.getVendor();
                        LicenseDatabase.LOCAL_INSTANCE.add(updatedLicense);
                        ArrayList<VendorLicense> hostLicenses = (ArrayList<VendorLicense>)licenseUpdateByHostId.get(updatedLicense.getHostId());
                        if (hostLicenses == null) {
                            hostLicenses = new ArrayList<VendorLicense>();
                            licenseUpdateByHostId.put(updatedLicense.getHostId(), hostLicenses);
                        }
                        hostLicenses.add(updatedLicense);
                        stationCertSummaryByVendor32 = (Map)certInfoByHostId.get(updatedLicense.getHostId());
                        if (!stationCertSummaryByVendor32.containsKey(vendor)) {
                            stationCertSummaryByVendor32.put(vendor, BCertificateSummary.makeEmpty((String)vendor));
                        }
                        if (!latestCertSummaryByVendor.containsKey(vendor)) {
                            latestCertSummaryByVendor.put(vendor, BCertificateSummary.makeEmpty((String)vendor));
                        }
                        checkAgainstSupervisorLicenseDb = false;
                    }
                }
            }
            catch (Exception e) {
                log.log(Level.FINE, "Exception getting license update information", e);
                details.message("provisioningNiagara", "UpdateLicensesJobStep.licenseSyncFailed", new String[]{ThrowableUtil.dumpToString((Throwable)e)});
            }
        }
        if (checkAgainstSupervisorLicenseDb) {
            for (BEnvLicenseSummary bEnvLicenseSummary : licenseSummaryByHostId.values()) {
                VendorLicense[] supLicenses;
                String string;
                String string2 = string = this.getChangeBrand() ? this.getBrandName() : bEnvLicenseSummary.getBrandId();
                if (string.length() == 0) {
                    details.message("provisioningNiagara", "UpdateLicensesJobStep.emptyBrandId", bEnvLicenseSummary.getHostId());
                }
                ArrayList<VendorLicense> hostLicenses = (ArrayList<VendorLicense>)licenseUpdateByHostId.get(bEnvLicenseSummary.getHostId());
                for (VendorLicense vendorLicense : supLicenses = LicenseDatabase.LOCAL_INSTANCE.getLicenses(bEnvLicenseSummary.getHostId(), string)) {
                    if (vendorLicense.getGenerated() <= bEnvLicenseSummary.getLicenseGenerated(vendorLicense.getVendor())) continue;
                    if (hostLicenses == null) {
                        hostLicenses = new ArrayList<VendorLicense>();
                        licenseUpdateByHostId.put(bEnvLicenseSummary.getHostId(), hostLicenses);
                    }
                    log.log(Level.FINE, "Adding license from local database for host ID " + bEnvLicenseSummary.getHostId() + " and brand " + string);
                    hostLicenses.add(vendorLicense);
                }
            }
        }
        if (nwExt.getLicenses().getAllowLicenseServerAccess()) {
            try {
                VendorCertificate[] vendorCertificateArray;
                BCertificateSummary[] certSummaries = new BCertificateSummary[latestCertSummaryByVendor.size()];
                latestCertSummaryByVendor.values().toArray(certSummaries);
                for (VendorCertificate aResult : vendorCertificateArray = PortalLicenseUtil.getPortalUpdates((BCertificateSummary[])certSummaries)) {
                    log.log(Level.FINE, "Adding certificate to local database for vendor " + aResult.getVendor());
                    CertificateDatabase.LOCAL_INSTANCE.add(aResult);
                }
            }
            catch (Exception e) {
                details.message("provisioningNiagara", "UpdateLicensesJobStep.certSyncFailed", new String[]{ThrowableUtil.dumpToString((Throwable)e)});
            }
        }
        this.checkCanceled();
        BDevice[] bDeviceArray = devices;
        int n = bDeviceArray.length;
        boolean bl = false;
        while (var16_42 < n) {
            BDaemonSession daemonSession;
            BPlatformConnection platformConn;
            BDevice device = bDeviceArray[var16_42];
            this.checkCanceled();
            BNiagaraStation station2 = (BNiagaraStation)device;
            BLicenseStationExt ext = (BLicenseStationExt)station2.getMixIn(BLicenseStationExt.TYPE);
            if (!ext.isUnoperational() && !(platformConn = (BPlatformConnection)station2.getMixIn(BPlatformConnection.TYPE)).isUnoperational() && (daemonSession = platformConn.getDaemonSession()) != null) {
                boolean bl2 = daemonSession.getHostProperties().isNiagara4();
                BLicenseInstallable installable = null;
                BEnvLicenseSummary newLicenseSummary = (BEnvLicenseSummary)ext.getLicenseSummary().newCopy();
                List hostLicenses = (List)licenseUpdateByHostId.get(ext.getLicenseSummary().getHostId());
                if (hostLicenses != null && hostLicenses.size() > 0) {
                    for (VendorLicense license : hostLicenses) {
                        if (license.getVersion().major() == 3 && bl2) continue;
                        List<LicenseInfo> existingLicenses = ext.getExistingLicenses();
                        VendorLicense[] vendorLicenseArray = new VendorLicense[]{license};
                        LicenseInfo[] toInstall = LicenseInfo.make((VendorLicense[])vendorLicenseArray);
                        LicenseSync sync = PortalLicenseUtil.syncLicenses((String)ext.getLicenseSummary().getHostId(), (LicenseInfo[])existingLicenses.toArray(new LicenseInfo[0]), (LicenseInfo[])toInstall);
                        if (!this.getChangeBrand() && this.licenseFileCapitalChange(sync.toRemove, license)) {
                            this.deleteExistingLicenseFile(sync.toRemove, details, daemonSession);
                        }
                        if (this.getChangeBrand()) {
                            this.deleteExistingLicenseFile(existingLicenses, details, daemonSession);
                        }
                        newLicenseSummary.updateVendorInfo(license);
                        if (installable == null) {
                            installable = new BLicenseInstallable();
                            op.install(station2, installable, this);
                        }
                        installable.addLicense(license);
                        if (this.getChangeBrand()) {
                            installable.setRebootFlag();
                        }
                        details.message("provisioningNiagara", "UpdateLicensesJobStep.scheduleLicense", new String[]{license.getLicenseName(), station2.getDisplayName(null)});
                    }
                } else {
                    details.message("provisioningNiagara", "UpdateLicensesJobStep.noUpdatedLicenses", station2.getDisplayName(null));
                }
                BVector newCertificateSummaries = (BVector)ext.getCertificateSummaries().newCopy();
                Map stationCertSummaryByVendor2 = (Map)certInfoByHostId.get(newLicenseSummary.getHostId());
                boolean anyCertUpdates = false;
                for (String vendor : stationCertSummaryByVendor2.keySet()) {
                    VendorCertificate cert;
                    BCertificateSummary existingSummary = (BCertificateSummary)stationCertSummaryByVendor2.get(vendor);
                    if (existingSummary == null) {
                        existingSummary = BCertificateSummary.makeEmpty((String)vendor);
                    }
                    if ((cert = CertificateDatabase.LOCAL_INSTANCE.getCertificate(vendor)) == null) {
                        if (!existingSummary.isEmpty()) continue;
                        details.message("provisioningNiagara", "UpdateLicensesJobStep.vendorCertMissing", new String[]{vendor, station2.getDisplayName(null)});
                        continue;
                    }
                    if (existingSummary.getCertificateGenerated() >= cert.getGenerated()) continue;
                    this.updateCertSummaries(newCertificateSummaries, cert);
                    if (installable == null) {
                        installable = new BLicenseInstallable();
                        op.install(station2, installable, this);
                    }
                    installable.addCertificate(cert);
                    details.message("provisioningNiagara", "UpdateLicensesJobStep.scheduleCert", new String[]{cert.getVendor(), station2.getDisplayName(null)});
                    anyCertUpdates = true;
                }
                if (!anyCertUpdates) {
                    details.message("provisioningNiagara", "UpdateLicensesJobStep.noUpdatedCerts", station2.getDisplayName(null));
                }
            }
            ++var16_42;
        }
    }

    private Set<BNiagaraStation> getBootstrappedStationList(BatchJobOp op) {
        HashSet stations = (HashSet)op.getAttribute((Object)BOOTSTRAPPED_STATIONS_KEY);
        if (stations == null) {
            stations = new HashSet();
            op.setAttribute((Object)BOOTSTRAPPED_STATIONS_KEY, stations);
        }
        return stations;
    }

    private boolean licenseFileCapitalChange(List<LicenseInfo> toRemove, VendorLicense toInstall) {
        if (toRemove.isEmpty()) {
            return false;
        }
        try {
            BIFile removeFile = toRemove.get(0).getFile();
            String removeFileName = removeFile.getFileName();
            VendorLicense[] vendorLicenseArray = new VendorLicense[]{toInstall};
            LicenseInfo[] toInstallInfo = LicenseInfo.make((VendorLicense[])vendorLicenseArray);
            boolean fileMatch = removeFileName.contentEquals(toInstallInfo[0].getInstalledFileName());
            boolean capChange = TextUtil.capitalize((String)removeFileName).contentEquals(toInstallInfo[0].getInstalledFileName());
            return !fileMatch && capChange;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void deleteExistingLicenseFile(List<LicenseInfo> toDelete, BNetworkStepDetails details, BDaemonSession daemonSession) throws Exception {
        if (toDelete == null || toDelete.isEmpty()) {
            return;
        }
        ArrayList<BDeleteFileInstallable> deleteInstallables = new ArrayList<BDeleteFileInstallable>();
        for (LicenseInfo existingLicense : toDelete) {
            log.log(Level.FINE, "Deleting license " + existingLicense.file.getAbsoluteOrd().toString(null));
            details.message("provisioningNiagara", "UpdateLicensesJobStep.deletingLicense", new String[]{existingLicense.file.getFileName(), existingLicense.vendorLicense.getHostId()});
            deleteInstallables.add(new BDeleteFileInstallable(existingLicense.file));
        }
        Listener listener = new Listener(details);
        InstallScenario removeLicenseScenario = new InstallScenario((BDaemonPlatform)BRemoteDaemonPlatform.make((BDaemonSession)daemonSession, null, (boolean)false), (DaemonSessionTaskListener)listener, new String[0], new BDependency[0], (BInstallable[])deleteInstallables.toArray(new BDeleteFileInstallable[0]), (InstallableRegistry)LocalInstallableRegistry.getInstance(), CertificateChainValidator.make((ICoreCryptoManager)new BPlatCryptoManager(daemonSession))).solve();
        if (removeLicenseScenario.canCommit()) {
            removeLicenseScenario.commit((DaemonSessionTaskListener)listener, (ICancelHint)this);
        }
    }

    private void updateCertSummaries(BVector summaries, VendorCertificate cert) {
        String propName = SlotPath.escape((String)cert.getVendor());
        Property prop = summaries.getProperty(propName);
        if (prop == null) {
            summaries.add(propName, (BValue)BCertificateSummary.make((VendorCertificate)cert));
        } else {
            summaries.set(prop, (BValue)BCertificateSummary.make((VendorCertificate)cert));
        }
    }

    @Override
    public void installComplete(BDeviceStepDetails details, BInstallable installable, NiagaraNetworkJobOp op) {
        if (details.getState() == BJobState.success) {
            BNiagaraStation station = (BNiagaraStation)details.getDevice();
            BLicenseStationExt ext = (BLicenseStationExt)station.getMixIn(BLicenseStationExt.TYPE);
            BLicenseInstallable licInst = (BLicenseInstallable)installable;
            BEnvLicenseSummary[] licenseSummaries = licInst.getLicenseSummaries();
            if (licenseSummaries.length > 0) {
                ext.setLicenseSummary(licenseSummaries[0]);
            }
            ext.setCertificateSummaries(licInst.getCertificateSummaries());
            ext.setLastUpdate(BAbsTime.now());
            ext.setLicenseStatus(BLicenseStatus.upToDate);
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    protected static class Listener
    implements DaemonSessionTaskListener {
        private BNetworkStepDetails details;
        private String lastTaskMessage = null;

        public Listener(BNetworkStepDetails details) {
            this.details = details;
        }

        public void taskStarted(DaemonSessionTask task) {
            this.taskUpdated(task);
        }

        public void taskUpdated(DaemonSessionTask task) {
            if (!task.getMessage().equals(this.lastTaskMessage)) {
                this.details.message(task.getMessage());
                this.lastTaskMessage = task.getMessage();
            }
        }

        public void taskFinished(DaemonSessionTask task) {
            this.taskUpdated(task);
        }

        public boolean isCancelEnabled() {
            return false;
        }
    }
}

