/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.provisioningNiagara.backup;

import com.tridium.backup.BBackupChannel;
import com.tridium.fox.session.ServerException;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.file.FoxFileException;
import com.tridium.nd.BNiagaraStation;
import com.tridium.provisioningNiagara.BPlatformConnection;
import com.tridium.provisioningNiagara.backup.BBackupStationExt;
import com.tridium.provisioningNiagara.backup.BBackupStepDetails;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Collections;
import java.util.Set;
import javax.baja.backup.BBackupService;
import javax.baja.batchJob.BBatchJob;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.driver.BDeviceJobStep;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.driver.BDevice;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.io.BIEncodable;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.platform.BStationStatus;
import javax.baja.platform.RemoteStation;
import javax.baja.provisioningNiagara.BNiagaraNetworkJob;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

public class BProvisioningBackupStep
extends BDeviceJobStep
implements BFoxClientConnection.Interest {
    public static final Type TYPE = Sys.loadType(BProvisioningBackupStep.class);
    private static final BIcon icon = BIcon.std((String)"backup.png");

    public Type getType() {
        return TYPE;
    }

    public static BBatchJob makeJob(String stationName) {
        BNiagaraNetworkJob result = new BNiagaraNetworkJob(stationName);
        result.addStep(new BProvisioningBackupStep());
        return result;
    }

    protected BDeviceStepDetails makeDetails(BDevice device) {
        BNiagaraStation station = (BNiagaraStation)device;
        BBackupStepDetails result = new BBackupStepDetails(station, this);
        this.add(SlotPath.escape((String)station.getStationName()), (BValue)result, 4);
        return result;
    }

    protected void doRun(BBatchJobService svc, BDeviceStepDetails details, BDevice device, DeviceNetworkJobOp op) throws Exception {
        BBackupService backupSvc;
        BNiagaraStation station = (BNiagaraStation)device;
        details.message("provisioningNiagara", "ProvisioningBackupStep.backingUp", station.getDisplayName(null));
        try {
            backupSvc = (BBackupService)Sys.getService((Type)BBackupService.TYPE);
        }
        catch (ServiceNotFoundException snfe) {
            backupSvc = new BBackupService();
        }
        BBackupStationExt stationExt = (BBackupStationExt)station.getMixIn(BBackupStationExt.TYPE);
        if (stationExt.isUnoperational()) {
            details.failed("provisioningNiagara", "ProvisioningBackupStep.backupExtUnoperational", new String[]{station.getDisplayName(null), BFormat.getEncodedPattern((BIEncodable)stationExt.getStatus())});
            details.complete(BJobState.failed);
            return;
        }
        OrdQuery[] q = ((BBackupStepDetails)details).getBackupFileOrd().parse();
        FilePath backupFilePath = (FilePath)q[q.length - 1];
        BPlatformConnection platformConn = (BPlatformConnection)station.getMixIn(BPlatformConnection.TYPE);
        this.checkCanceled((BDevice)station);
        RemoteStation remoteStation = platformConn.getPlatformDaemon().getStationManager().getStation(station.getStationName());
        this.checkCanceled((BDevice)station);
        if (remoteStation == null) {
            details.failed("provisioningNiagara", "ProvisioningBackupStep.stationNotFound", station.getDisplayName(null));
            details.complete(BJobState.failed);
        } else {
            try {
                BBackupService finalBackupSvc = backupSvc;
                AccessController.doPrivileged(() -> {
                    BIFile backupFile = BFileSystem.INSTANCE.makeFile(backupFilePath);
                    if (remoteStation.getStatus() == BStationStatus.running) {
                        int n;
                        this.checkCanceled((BDevice)station);
                        station.getClientConnection().engageNoRetry((BFoxClientConnection.Interest)this);
                        BBackupChannel channel = (BBackupChannel)station.getClientConnection().getChannels().get("backup", BBackupChannel.TYPE);
                        InputStream in = channel.backup(false);
                        this.checkCanceled((BDevice)station);
                        BufferedOutputStream out = new BufferedOutputStream(backupFile.getOutputStream());
                        int len = 4096;
                        byte[] buf = new byte[len];
                        while ((n = in.read(buf, 0, len)) >= 0) {
                            ((OutputStream)out).write(buf, 0, n);
                            this.checkCanceled((BDevice)station);
                        }
                        try {
                            ((OutputStream)out).close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        station.getClientConnection().disengage((BFoxClientConnection.Interest)this);
                        details.message("provisioningNiagara", "ProvisioningBackupStep.backupFileWritten", backupFile.getFilePath().getBody());
                    } else {
                        finalBackupSvc.zip(details.log(), BBackupService.makeCanceler((BJob)this.getJob()), platformConn.getPlatformDaemon(), backupFile.getOutputStream(), true);
                        details.message("provisioningNiagara", "ProvisioningBackupStep.backupFileWritten", backupFile.getFilePath().getBody());
                    }
                    return null;
                });
            }
            catch (PrivilegedActionException pae) {
                throw pae.getException();
            }
            catch (ServerException | FoxFileException e) {
                BIFile bFile = BFileSystem.INSTANCE.findFile(backupFilePath);
                if (bFile != null) {
                    bFile.delete();
                    details.failed("provisioningNiagara", "ProvisioningBackupStep.backupFileDelete", bFile.getFilePath().getBody());
                    details.complete(BJobState.failed);
                }
                throw e;
            }
        }
    }

    public void deviceJobStepComplete(BDeviceStepDetails details, DeviceNetworkJobOp op) {
        super.deviceJobStepComplete(details, op);
        if (details.getState() != BJobState.success) {
            return;
        }
        BNiagaraStation station = (BNiagaraStation)details.getDevice();
        BBackupStationExt stationExt = (BBackupStationExt)station.getMixIn(BBackupStationExt.TYPE);
        stationExt.fireBackupCreated(((BBackupStepDetails)details).getBackupFileOrd());
        stationExt.setLastBackupTime(details.getStartTime());
    }

    public Set<BDevice> getParallelExecutionConflicts(BBatchJobService svc, BDevice device, Set<BDevice> allDevices, DeviceNetworkJobOp op) {
        return Collections.singleton(device);
    }

    public BIcon getIcon() {
        return icon;
    }
}

