/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.provisioningNiagara;

import com.tridium.batchJob.driver.BIPrivilegedDeviceJobStep;
import com.tridium.nd.BNiagaraStation;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.message.AuthenticationInfoMessage;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.SystemPasswordMessage;
import com.tridium.provisioningNiagara.NiagaraNetworkJobOp;
import com.tridium.provisioningNiagara.ProvisioningConnectionUtil;
import com.tridium.provisioningNiagara.software.BAbstractSoftwareStep;
import com.tridium.provisioningNiagara.software.BStationInstallablesStep;
import java.util.ArrayList;
import javax.baja.batchJob.driver.BDeviceJobStep;
import javax.baja.batchJob.driver.BForEachDeviceStage;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.driver.BDevice;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Version;
import javax.baja.xml.XElem;

public class BForEachStationStage
extends BForEachDeviceStage {
    public static final Type TYPE = Sys.loadType(BForEachStationStage.class);

    public Type getType() {
        return TYPE;
    }

    public BForEachStationStage() {
        super("forEachStation");
    }

    protected BDeviceJobStep[] getCombinedSteps(DeviceNetworkJobOp opIn) {
        BDevice[] devices;
        boolean anyStationInstallables = false;
        NiagaraNetworkJobOp op = (NiagaraNetworkJobOp)opIn;
        for (BDevice device : devices = this.getDevices()) {
            if (!op.hasStationInstallables((BNiagaraStation)device)) continue;
            anyStationInstallables = true;
            break;
        }
        if (anyStationInstallables) {
            BStationInstallablesStep step = new BStationInstallablesStep();
            ArrayList<Property> stepProps = new ArrayList<Property>();
            int insertAt = -1;
            SlotCursor c = this.getSteps().getProperties();
            while (c.next(BDeviceJobStep.class)) {
                stepProps.add(c.property());
                if (insertAt >= 0 || !(c.get() instanceof BAbstractSoftwareStep)) continue;
                insertAt = stepProps.size();
            }
            Property stepProp = this.getSteps().add("step?", (BValue)step);
            if (insertAt >= 0) {
                stepProps.add(insertAt, stepProp);
                this.getSteps().reorder(stepProps.toArray(new Property[stepProps.size()]));
            }
        }
        return super.getCombinedSteps((DeviceNetworkJobOp)op);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canPassDefaultCheck(BDevice device, BDeviceJobStep step) {
        if (step instanceof BIPrivilegedDeviceJobStep) {
            return true;
        }
        try {
            Throwable throwable = null;
            try (ProvisioningConnectionUtil connectionUtil = new ProvisioningConnectionUtil(device, null);){
                BDaemonSession daemonSession = connectionUtil.getDaemonSession();
                if (daemonSession == null) {
                    this.getJob().log().failed("provisioningNiagara", "Provisioning.error.daemonSession");
                    boolean bl = false;
                    return bl;
                }
                if (new Version(connectionUtil.getDaemonSession().getHostProperties().getDaemonVersion()).compareTo(new Version("4.4")) < 0) {
                    boolean bl = true;
                    return bl;
                }
                XElem authInfo = connectionUtil.getDaemonResponse((DaemonMessage)new AuthenticationInfoMessage());
                if (authInfo.elem("auth").elem("user").getb("default", false)) {
                    this.getJob().log().failed("provisioningNiagara", "Provisioning.error.defaultPlatformCredentials");
                    boolean bl = false;
                    return bl;
                }
                XElem systemPasswordElem = connectionUtil.getDaemonResponse((DaemonMessage)new SystemPasswordMessage());
                if (systemPasswordElem.getb("default", false)) {
                    this.getJob().log().failed("provisioningNiagara", "Provisioning.error.defaultSystemPassphrase");
                    boolean bl = false;
                    return bl;
                }
                if (connectionUtil.hasRunningStation() == false) return true;
                if (!connectionUtil.getEngagedFoxSession().getConnection().isPasswordResetRequired()) return true;
                this.getJob().log().failed("provisioningNiagara", "Provisioning.error.stationPasswordResetRequired");
                boolean bl = false;
                return bl;
            }
            catch (ProvisioningConnectionUtil.ProvisioningConnectionException e) {
                this.getJob().log().failed("provisioningNiagara", "Provisioning.error.daemonSession");
                boolean bl = false;
                return bl;
            }
            catch (IllegalArgumentException iae) {
                boolean bl = true;
                return bl;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Exception e) {
            this.getJob().log().failed("provisioningNiagara", "Provisioning.error.securityCheckFailed", (Throwable)e);
            return false;
        }
    }
}

