/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui.time;

import com.tridium.platform.posix.BNtpHostMode;
import com.tridium.platform.qnx.BNtpServerQnx;
import com.tridium.platform.ui.ntp.BNtpServerQnxFE;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.BCommandDialog;
import com.tridium.platform.ui.util.BCommandEnablePolicy;
import com.tridium.platform.ui.util.BCoordinatedGridPane;
import com.tridium.platform.ui.util.CommandBindings;
import com.tridium.platform.ui.util.DialogCommand;
import com.tridium.provisioningNiagara.time.BNtpSettings;
import com.tridium.ui.util.LabelUtil;
import com.tridium.workbench.fieldeditors.BBooleanFE;
import com.tridium.workbench.fieldeditors.BFrozenEnumFE;
import java.util.ArrayList;
import javax.baja.gx.BImage;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;
import javax.baja.workbench.BWbEditor;

@NiagaraType
public class BNtpSettingsEditor
extends BWbEditor {
    public static final Type TYPE = Sys.loadType(BNtpSettingsEditor.class);
    private final BBooleanFE ntpEnabledFE = new BBooleanFE();
    private final BFrozenEnumFE hostModeFE;
    private final BBooleanFE syncLocalFE;
    private final BBooleanFE syncAtBootFE;
    private final BBooleanFE localAsBackupFE;
    private final BBooleanFE ntpStatsFE;
    private final BTable serverTable;
    private Command deleteCommand;
    private Command editCommand;
    private Command upCommand;
    private Command downCommand;
    private static final Lexicon LEX = Lexicon.make((String)"provisioningNiagara");

    public Type getType() {
        return TYPE;
    }

    public BNtpSettingsEditor() {
        this.ntpEnabledFE.loadValue((BObject)BBoolean.make((boolean)true));
        this.hostModeFE = new BFrozenEnumFE();
        this.hostModeFE.loadValue((BObject)BNtpHostMode.server);
        this.syncLocalFE = new BBooleanFE();
        this.syncLocalFE.loadValue((BObject)BBoolean.make((boolean)true));
        this.syncAtBootFE = new BBooleanFE();
        this.syncAtBootFE.loadValue((BObject)BBoolean.make((boolean)false));
        this.localAsBackupFE = new BBooleanFE();
        this.localAsBackupFE.loadValue((BObject)BBoolean.make((boolean)false));
        this.ntpStatsFE = new BBooleanFE();
        this.ntpStatsFE.loadValue((BObject)BBoolean.make((boolean)false));
        BGridPane booleanPane = new BGridPane(2);
        Lexicon lex = Lexicon.make((String)"platform");
        LabelUtil.addLabelWidgetPair((BPane)booleanPane, (String)lex.getText("NtpPlatformService.enabled.label"), (BWidget)this.ntpEnabledFE);
        LabelUtil.addLabelWidgetPair((BPane)booleanPane, (String)lex.getText("NtpPlatformServicePosix.hostMode.label"), (BWidget)this.hostModeFE);
        LabelUtil.addLabelWidgetPair((BPane)booleanPane, (String)lex.getText("NtpPlatformServicePosix.ntp.label"), (BWidget)this.syncLocalFE);
        LabelUtil.addLabelWidgetPair((BPane)booleanPane, (String)lex.getText("NtpPlatformService.syncAtBoot.label"), (BWidget)this.syncAtBootFE);
        LabelUtil.addLabelWidgetPair((BPane)booleanPane, (String)lex.getText("NtpPlatformServicePosix.localBackup.label"), (BWidget)this.localAsBackupFE);
        LabelUtil.addLabelWidgetPair((BPane)booleanPane, (String)lex.getText("NtpPlatformServicePosix.stats.label"), (BWidget)this.ntpStatsFE);
        this.serverTable = new BTable();
        this.serverTable.setMultipleSelection(false);
        this.serverTable.setModel((TableModel)new ServerTableModel());
        this.serverTable.setController((TableController)new ServerTableController());
        this.serverTable.setMultipleSelection(false);
        this.serverTable.setOptionsButtonVisible(false);
        BGridPane ntpButtons = this.makeNtpButtons();
        this.setContent((BWidget)new BEdgePane((BWidget)booleanPane, (BWidget)ntpButtons, (BWidget)new BBox(0.0, 100.0), null, (BWidget)this.serverTable));
    }

    private BGridPane makeNtpButtons() {
        BToolBar toolbar = new BToolBar();
        BFlowPane toolbarPane = new BFlowPane(BHalign.center);
        toolbarPane.add(null, (BValue)toolbar, null);
        BButton addButton = new BButton((Command)new AddCommand());
        addButton.setButtonStyle(BButtonStyle.toolBar);
        toolbar.add("add", (BValue)addButton, null);
        this.deleteCommand = new DeleteCommand();
        BButton deleteButton = new BButton(this.deleteCommand);
        deleteButton.setButtonStyle(BButtonStyle.toolBar);
        toolbar.add("delete", (BValue)deleteButton, null);
        this.editCommand = new EditCommand();
        BButton editButton = new BButton(this.editCommand);
        editButton.setButtonStyle(BButtonStyle.toolBar);
        toolbar.add("edit", (BValue)editButton, null);
        this.upCommand = new UpCommand();
        BButton upButton = new BButton(this.upCommand);
        upButton.setButtonStyle(BButtonStyle.toolBar);
        toolbar.add("up", (BValue)upButton, null);
        this.downCommand = new DownCommand();
        BButton downButton = new BButton(this.downCommand);
        downButton.setButtonStyle(BButtonStyle.toolBar);
        toolbar.add("down", (BValue)downButton, null);
        BGridPane outerGrid = new BGridPane(1);
        outerGrid.add(null, (BValue)toolbarPane);
        outerGrid.setHalign(BHalign.center);
        outerGrid.setColumnAlign(BHalign.center);
        return outerGrid;
    }

    private void setArrowCommandEnabledStates() {
        int selectedRow = this.serverTable.getModel().getSelection().getRow();
        int maxServerIndex = this.serverTable.getModel().getRowCount() - 1;
        this.upCommand.setEnabled(selectedRow > 0);
        this.downCommand.setEnabled(selectedRow < maxServerIndex && selectedRow >= 0);
        this.editCommand.setEnabled(selectedRow >= 0);
        this.deleteCommand.setEnabled(selectedRow >= 0);
    }

    private BCoordinatedGridPane makeHeader() {
        BCoordinatedGridPane header = new BCoordinatedGridPane(6);
        header.setHalign(BHalign.left);
        header.setColumnAlign(BHalign.center);
        header.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((String)"platform", (String)"NtpPlatformService.address.label"), (boolean)true));
        header.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((String)"platform", (String)"NtpPlatformServicePosix.peerMode.label"), (boolean)true));
        header.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((String)"platform", (String)"NtpPlatformServicePosix.burst.label"), (boolean)true));
        header.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((String)"platform", (String)"NtpPlatformServicePosix.prefer.label"), (boolean)true));
        header.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((String)"platform", (String)"NtpPlatformServicePosix.minPollInterval.label"), (boolean)true));
        header.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((String)"platform", (String)"NtpPlatformServicePosix.maxPollInterval.label"), (boolean)true));
        return header;
    }

    protected void doLoadValue(BObject value, Context cx) {
        BNtpSettings settings = (BNtpSettings)value;
        this.ntpEnabledFE.loadValue((BObject)BBoolean.make((boolean)settings.getNtpEnabled()));
        this.hostModeFE.loadValue((BObject)settings.getHostMode());
        this.syncLocalFE.loadValue((BObject)BBoolean.make((boolean)settings.getSyncLocal()));
        this.localAsBackupFE.loadValue((BObject)BBoolean.make((boolean)settings.getLocalAsBackup()));
        this.ntpStatsFE.loadValue((BObject)BBoolean.make((boolean)settings.getNtpStats()));
        this.syncAtBootFE.loadValue((BObject)BBoolean.make((boolean)settings.getSyncAtBoot()));
        ((ServerTableModel)this.serverTable.getModel()).loadServers(settings.getServers());
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        return new BNtpSettings(((BIBoolean)this.ntpEnabledFE.saveValue()).getBoolean(), (BNtpHostMode)this.hostModeFE.saveValue(), ((BIBoolean)this.syncLocalFE.saveValue()).getBoolean(), ((BIBoolean)this.localAsBackupFE.saveValue()).getBoolean(), ((BIBoolean)this.ntpStatsFE.saveValue()).getBoolean(), ((BIBoolean)this.syncAtBootFE.saveValue()).getBoolean(), ((ServerTableModel)this.serverTable.getModel()).saveServers());
    }

    private BNtpServerQnx showEditDialog(BNtpServerQnx server) {
        BNtpServerQnxFE serverFE = new BNtpServerQnxFE();
        BCoordinatedGridPane headerPane = this.makeHeader();
        serverFE.useHeader((BWidget)headerPane);
        serverFE.loadValue((BObject)server);
        DialogCommand ok = DialogCommand.makeOk((BWidget)this.serverTable);
        DialogCommand cancel = DialogCommand.makeCancel((BWidget)this.serverTable);
        CommandBindings bindings = new CommandBindings();
        bindings.addCommand((Command)ok, BCommandEnablePolicy.always);
        bindings.addCommand((Command)cancel, BCommandEnablePolicy.always);
        if (1 == BCommandDialog.open((BWidget)this.serverTable, (String)LEX.getText("SetTimeStepDialog.editor.editServer"), (Object)new BGridPane(1, new BWidget[]{headerPane, serverFE}), (DialogCommand[])new DialogCommand[]{ok, cancel})) {
            try {
                BNtpServerQnx tempServer = (BNtpServerQnx)serverFE.saveValue();
                if (tempServer.getAddress().isEmpty() && server.getAddress().isEmpty()) {
                    BDialog.error((BWidget)this, (Object)LEX.getText("SetTimeStepDialog.editor.serverEmpty"));
                    return null;
                }
                return (BNtpServerQnx)serverFE.saveValue();
            }
            catch (Exception e) {
                BDialog.error((BWidget)this, (Object)LEX.getText("SetTimeStepDialog.editor.error"));
                return null;
            }
        }
        return null;
    }

    class ServerTableController
    extends TableController {
        ServerTableController() {
        }

        public void mouseReleased(BMouseEvent event) {
            super.mouseReleased(event);
            BNtpSettingsEditor.this.setArrowCommandEnabledStates();
        }
    }

    class ServerTableModel
    extends TableModel {
        private final ArrayList<BNtpServerQnx> servers = new ArrayList();

        ServerTableModel() {
        }

        public int getRowCount() {
            return this.servers.size();
        }

        public int getColumnCount() {
            return 6;
        }

        public String getColumnName(int col) {
            Lexicon lex = Lexicon.make((String)"platform");
            switch (col) {
                case 0: {
                    return lex.getText("NtpPlatformService.address.label");
                }
                case 1: {
                    return lex.getText("NtpPlatformServicePosix.peerMode.label");
                }
                case 2: {
                    return lex.getText("NtpPlatformServicePosix.burst.label");
                }
                case 3: {
                    return lex.getText("NtpPlatformServicePosix.prefer.label");
                }
                case 4: {
                    return lex.getText("NtpPlatformServicePosix.minPollInterval.label");
                }
                case 5: {
                    return lex.getText("NtpPlatformServicePosix.maxPollInterval.label");
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public Object getValueAt(int row, int col) {
            BNtpServerQnx server = this.getValueAt(row);
            switch (col) {
                case 0: {
                    return server.getAddress();
                }
                case 1: {
                    return server.getPeerMode();
                }
                case 2: {
                    return server.getUseBurst();
                }
                case 3: {
                    return server.getServerPreferred();
                }
                case 4: {
                    return server.getMinPollInterval();
                }
                case 5: {
                    return server.getMaxPollInterval();
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public BNtpServerQnx getValueAt(int row) {
            return this.servers.get(row);
        }

        public void setValueAt(int row, BNtpServerQnx server) {
            this.servers.set(row, server);
        }

        public void removeValueAt(int row) {
            this.servers.remove(row);
        }

        public void moveDown(int rowA) {
            int maxServerIndex = BNtpSettingsEditor.this.serverTable.getModel().getRowCount() - 1;
            if (rowA < maxServerIndex) {
                this.swap(rowA, rowA + 1);
            }
        }

        public void moveUp(int rowA) {
            if (rowA > 0) {
                this.swap(rowA, rowA - 1);
            }
        }

        private void swap(int rowA, int rowB) {
            BNtpServerQnx server = this.servers.get(rowA);
            server = this.servers.set(rowB, server);
            this.servers.set(rowA, server);
        }

        public void addServer(BNtpServerQnx server) {
            this.servers.add(server);
        }

        public void loadServers(String serverString) {
            String[] servers;
            for (String server : servers = serverString.split(";")) {
                this.addServer(new BNtpServerQnx(server));
            }
        }

        public String saveServers() {
            StringBuilder builder = new StringBuilder();
            for (BNtpServerQnx server : this.servers) {
                builder.append(server.getServerString());
                builder.append(';');
            }
            return builder.toString();
        }
    }

    private class DownCommand
    extends Command {
        public DownCommand() {
            super((BWidget)BNtpSettingsEditor.this, "", BImage.make((BIcon)BIcon.std((String)"arrowDown.png")), null, "");
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() {
            int selectedIndex = BNtpSettingsEditor.this.serverTable.getSelection().getRow();
            ((ServerTableModel)BNtpSettingsEditor.this.serverTable.getModel()).moveDown(selectedIndex);
            BNtpSettingsEditor.this.serverTable.getSelection().deselectAll();
            BNtpSettingsEditor.this.serverTable.getSelection().select(selectedIndex + 1);
            BNtpSettingsEditor.this.serverTable.getModel().updateTable();
            BNtpSettingsEditor.this.setArrowCommandEnabledStates();
            return null;
        }
    }

    private class UpCommand
    extends Command {
        public UpCommand() {
            super((BWidget)BNtpSettingsEditor.this, "", BImage.make((BIcon)BIcon.std((String)"arrowUp.png")), null, "");
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() {
            int selectedIndex = BNtpSettingsEditor.this.serverTable.getSelection().getRow();
            ((ServerTableModel)BNtpSettingsEditor.this.serverTable.getModel()).moveUp(selectedIndex);
            BNtpSettingsEditor.this.serverTable.getSelection().deselectAll();
            BNtpSettingsEditor.this.serverTable.getSelection().select(selectedIndex - 1);
            BNtpSettingsEditor.this.setArrowCommandEnabledStates();
            BNtpSettingsEditor.this.serverTable.getModel().updateTable();
            return null;
        }
    }

    private class EditCommand
    extends Command {
        public EditCommand() {
            super((BWidget)BNtpSettingsEditor.this, "", BImage.make((BIcon)BIcon.std((String)"edit.png")), null, "");
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() {
            ServerTableModel model = (ServerTableModel)BNtpSettingsEditor.this.serverTable.getModel();
            int row = BNtpSettingsEditor.this.serverTable.getSelection().getRow();
            BNtpServerQnx server = model.getValueAt(row);
            if ((server = BNtpSettingsEditor.this.showEditDialog(server)) != null) {
                model.setValueAt(row, server);
                BNtpSettingsEditor.this.setArrowCommandEnabledStates();
                BNtpSettingsEditor.this.serverTable.getModel().updateTable();
            }
            return null;
        }
    }

    private class DeleteCommand
    extends Command {
        public DeleteCommand() {
            super((BWidget)BNtpSettingsEditor.this, "", BImage.make((BIcon)BIcon.std((String)"delete.png")), null, "");
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() {
            if (BNtpSettingsEditor.this.serverTable.getModel().getRowCount() == 0) {
                return null;
            }
            int row = BNtpSettingsEditor.this.serverTable.getSelection().getRow();
            ((ServerTableModel)BNtpSettingsEditor.this.serverTable.getModel()).removeValueAt(row);
            int count = BNtpSettingsEditor.this.serverTable.getModel().getRowCount();
            BNtpSettingsEditor.this.serverTable.getSelection().deselectAll();
            if (count > 0) {
                if (count - 1 > row) {
                    BNtpSettingsEditor.this.serverTable.getSelection().select(row);
                } else {
                    BNtpSettingsEditor.this.serverTable.getSelection().select(count - 1);
                }
            }
            BNtpSettingsEditor.this.serverTable.getModel().updateTable();
            BNtpSettingsEditor.this.setArrowCommandEnabledStates();
            return null;
        }
    }

    private class AddCommand
    extends Command {
        public AddCommand() {
            super((BWidget)BNtpSettingsEditor.this, "", BImage.make((BIcon)BIcon.std((String)"add.png")), null, "");
            this.setEnabled(true);
        }

        public CommandArtifact doInvoke() {
            BNtpServerQnx server = new BNtpServerQnx();
            if ((server = BNtpSettingsEditor.this.showEditDialog(server)) != null) {
                ((ServerTableModel)BNtpSettingsEditor.this.serverTable.getModel()).addServer(server);
                BNtpSettingsEditor.this.serverTable.getSelection().deselectAll();
                BNtpSettingsEditor.this.serverTable.getSelection().select(BNtpSettingsEditor.this.serverTable.getModel().getRowCount() - 1);
                BNtpSettingsEditor.this.setArrowCommandEnabledStates();
                BNtpSettingsEditor.this.serverTable.getModel().updateTable();
            }
            return null;
        }
    }
}

