/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui.software;

import com.tridium.install.BDependency;
import com.tridium.install.BPartInstallStatus;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.BInstallableSpec;
import com.tridium.install.part.BModulePart;
import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platDaemon.ui.DaemonSessionTaskHandler;
import com.tridium.platDaemon.ui.softwaremanager.BPartDetailsPane;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.ui.util.AsyncCommand;
import com.tridium.platform.ui.util.AsyncGroup;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.provisioningNiagara.BProvisioningNiagaraNetworkExt;
import com.tridium.provisioningNiagara.software.BInstallBySpecStep;
import com.tridium.provisioningNiagara.software.BSoftwareContainer;
import com.tridium.provisioningNiagara.software.BSoftwareStationExt;
import com.tridium.provisioningNiagara.software.BUninstallModuleStep;
import com.tridium.provisioningNiagara.station.BStationProxy;
import com.tridium.provisioningNiagara.ui.software.BStationSoftwareFilter;
import com.tridium.provisioningNiagara.ui.software.CancelInstallCommand;
import com.tridium.provisioningNiagara.ui.software.CancelUninstallCommand;
import com.tridium.provisioningNiagara.ui.software.InstallCommand;
import com.tridium.provisioningNiagara.ui.software.InstallVersionCommand;
import com.tridium.provisioningNiagara.ui.software.ResetCommand;
import com.tridium.provisioningNiagara.ui.software.SoftwareCellRenderer;
import com.tridium.provisioningNiagara.ui.software.SoftwareTableModel;
import com.tridium.provisioningNiagara.ui.software.UninstallCommand;
import com.tridium.provisioningNiagara.ui.software.UpgradeOutOfDateCommand;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.util.LabelUtil;
import java.text.DecimalFormat;
import java.util.logging.Level;
import javax.baja.batchJob.BBatchJob;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.file.FilePath;
import javax.baja.gx.BBrush;
import javax.baja.gx.BInsets;
import javax.baja.gx.IInsets;
import javax.baja.gx.Insets;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.provisioningNiagara.BNiagaraNetworkJob;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BActionMenuItem;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.options.BOptions;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.util.LexiconText;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType(agent={@AgentOn(types={"provisioningNiagara:SoftwareStationExt"})})
@NiagaraActions(value={@NiagaraAction(name="handleTableModified"), @NiagaraAction(name="handleSelectionModified")})
public class BStationSoftwareView
extends BWbComponentView {
    public static final Action handleTableModified = BStationSoftwareView.newAction((int)0, null);
    public static final Action handleSelectionModified = BStationSoftwareView.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BStationSoftwareView.class);
    private final SoftwareTableModel tableModel;
    private final DaemonSessionTaskListener taskListener;
    private final BButton leftButton;
    private final BButton rightButton;
    private final BLabel currentSpaceLabel;
    private final BLabel spaceDeltaLabel;
    private final BLabel afterSpaceLabel;
    private long currentFreeSpace = 0L;
    boolean trapSelectionModified = true;
    private final AsyncCommand cancelInstallCommand;
    private final AsyncCommand cancelUninstallCommand;
    private final AsyncCommand cancelUpgradeCommand;
    private final AsyncCommand cancelReinstallCommand;
    private final AsyncCommand cancelDowngradeCommand;
    private final AsyncCommand commitCommand;
    private final AsyncCommand installCommand;
    private final AsyncCommand resetCommand;
    private final AsyncCommand uninstallCommand;
    private final AsyncCommand upgradeCommand;
    private final AsyncCommand reinstallCommand;
    private final AsyncCommand downgradeCommand;
    private final AsyncCommand upgradeOODCommand;
    private final BWidget loadedContent;
    private final Command[] leftButtonCommands;
    private final Command[] rightButtonCommands;

    public void handleTableModified() {
        this.invoke(handleTableModified, null, null);
    }

    public void handleSelectionModified() {
        this.invoke(handleSelectionModified, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BStationSoftwareView() {
        this.autoRegisterForComponentEvents = false;
        this.taskListener = new DaemonSessionTaskHandler((BWidget)this);
        BGridPane spacePane = new BGridPane(7);
        BLabel bigSpaceLabel = new BLabel(((DecimalFormat)DaemonFileUtil.kbFormat.get()).format(88888888L));
        bigSpaceLabel.computePreferredSize();
        BLabel smallSpaceLabel = new BLabel(((DecimalFormat)DaemonFileUtil.kbFormat.get()).format(88888L));
        smallSpaceLabel.computePreferredSize();
        spacePane.add(null, (BValue)new BNullWidget());
        spacePane.add(null, (BValue)new BNullWidget());
        spacePane.add(null, (BValue)new BBox((double)((int)bigSpaceLabel.getPreferredWidth() + 5), 0.0));
        spacePane.add(null, (BValue)new BNullWidget());
        spacePane.add(null, (BValue)new BBox((double)((int)smallSpaceLabel.getPreferredWidth() + 5), 0.0));
        spacePane.add(null, (BValue)new BNullWidget());
        spacePane.add(null, (BValue)new BBox((double)((int)bigSpaceLabel.getPreferredWidth() + 5), 0.0));
        spacePane.setHalign(BHalign.left);
        BButton button = new BButton((Command)new EditFilterCommand(), false, true);
        spacePane.add("editFilter", (BValue)button);
        button.setButtonStyle(BButtonStyle.toolBar);
        this.currentSpaceLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)spacePane, (LexiconText)LexiconText.make((Type)TYPE, (String)"StationSoftwareView.currentSpaceLabel"), (BWidget)this.currentSpaceLabel);
        this.spaceDeltaLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)spacePane, (LexiconText)LexiconText.make((Type)TYPE, (String)"StationSoftwareView.spaceDeltaLabel"), (BWidget)this.spaceDeltaLabel);
        this.afterSpaceLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)spacePane, (LexiconText)LexiconText.make((Type)TYPE, (String)"StationSoftwareView.afterSpaceLabel"), (BWidget)this.afterSpaceLabel);
        BGridPane topPane = new BGridPane(1);
        topPane.setHalign(BHalign.left);
        topPane.add(null, (BValue)new BBorderPane((BWidget)spacePane, 0.0, 0.0, 4.0, 0.0));
        this.tableModel = new SoftwareTableModel();
        BTable table = new BTable((TableModel)this.tableModel);
        this.tableModel.setFilter(this.loadFilter());
        table.setCellRenderer((TableCellRenderer)new SoftwareCellRenderer());
        table.setController((TableController)new SoftwareTableController());
        AsyncGroup commandGroup = new AsyncGroup();
        this.cancelInstallCommand = CancelInstallCommand.makeCancelInstall((BWidget)this, this.tableModel);
        commandGroup.add((AsyncGroup.AsyncGroupMember)this.cancelInstallCommand);
        this.cancelUninstallCommand = new CancelUninstallCommand((BWidget)this, this.tableModel);
        commandGroup.add((AsyncGroup.AsyncGroupMember)this.cancelUninstallCommand);
        this.cancelUpgradeCommand = CancelInstallCommand.makeCancelUpgrade((BWidget)this, this.tableModel);
        commandGroup.add((AsyncGroup.AsyncGroupMember)this.cancelUpgradeCommand);
        this.cancelReinstallCommand = CancelInstallCommand.makeCancelReinstall((BWidget)this, this.tableModel);
        commandGroup.add((AsyncGroup.AsyncGroupMember)this.cancelReinstallCommand);
        this.cancelDowngradeCommand = CancelInstallCommand.makeCancelDowngrade((BWidget)this, this.tableModel);
        commandGroup.add((AsyncGroup.AsyncGroupMember)this.cancelDowngradeCommand);
        this.commitCommand = new CommitCommand();
        commandGroup.add((AsyncGroup.AsyncGroupMember)this.commitCommand);
        this.installCommand = InstallCommand.makeInstall((BWidget)this, this.tableModel);
        commandGroup.add((AsyncGroup.AsyncGroupMember)this.installCommand);
        this.resetCommand = new ResetCommand((BWidget)this, this.tableModel);
        commandGroup.add((AsyncGroup.AsyncGroupMember)this.resetCommand);
        this.uninstallCommand = new UninstallCommand((BWidget)this, this.tableModel);
        commandGroup.add((AsyncGroup.AsyncGroupMember)this.uninstallCommand);
        this.upgradeCommand = InstallCommand.makeUpgrade((BWidget)this, this.tableModel);
        commandGroup.add((AsyncGroup.AsyncGroupMember)this.upgradeCommand);
        this.reinstallCommand = InstallCommand.makeReinstall((BWidget)this, this.tableModel);
        commandGroup.add((AsyncGroup.AsyncGroupMember)this.reinstallCommand);
        this.downgradeCommand = InstallCommand.makeDowngrade((BWidget)this, this.tableModel);
        commandGroup.add((AsyncGroup.AsyncGroupMember)this.downgradeCommand);
        this.upgradeOODCommand = new UpgradeOutOfDateCommand((BWidget)this, this.tableModel);
        commandGroup.add((AsyncGroup.AsyncGroupMember)this.upgradeOODCommand);
        this.resetCommand.setEnabled(false);
        this.installCommand.setEnabled(false);
        this.uninstallCommand.setEnabled(false);
        this.commitCommand.setEnabled(false);
        this.upgradeOODCommand.setEnabled(false);
        this.leftButtonCommands = new Command[]{this.installCommand, this.reinstallCommand, this.upgradeCommand, this.downgradeCommand, this.cancelInstallCommand, this.cancelUpgradeCommand, this.cancelUpgradeCommand, this.cancelDowngradeCommand};
        this.rightButtonCommands = new Command[]{this.uninstallCommand, this.cancelUninstallCommand};
        this.linkTo((BComponent)table, (Slot)BTable.selectionModified, (Slot)handleSelectionModified);
        this.linkTo((BComponent)table, (Slot)BTable.tableModified, (Slot)handleTableModified);
        Insets buttonInsets = new Insets(4.0, 3.0, 4.0, 3.0);
        BFlowPane buttonPane = new BFlowPane(BHalign.center);
        button = new BButton((Command)this.upgradeOODCommand, true, false);
        buttonPane.add("upgradeOOD", (BValue)button);
        button.setPadding(BInsets.make((IInsets)buttonInsets));
        buttonPane.add("spacer1", (BValue)new BBox(3.0, 0.0));
        this.leftButton = new BButton((Command)this.installCommand, true, false);
        buttonPane.add("leftButton", (BValue)this.leftButton);
        this.leftButton.setPadding(BInsets.make((IInsets)buttonInsets));
        this.rightButton = new BButton((Command)this.uninstallCommand, true, false);
        buttonPane.add("rightButton", (BValue)this.rightButton);
        this.rightButton.setPadding(BInsets.make((IInsets)buttonInsets));
        BButton resetButton = new BButton((Command)this.resetCommand, true, false);
        buttonPane.add("resetButton", (BValue)resetButton);
        resetButton.setPadding(BInsets.make((IInsets)buttonInsets));
        BButton commitButton = new BButton((Command)this.commitCommand, true, false);
        buttonPane.add("commitButton", (BValue)commitButton);
        commitButton.setPadding(BInsets.make((IInsets)buttonInsets));
        this.loadedContent = new BEdgePane((BWidget)new BBorderPane((BWidget)topPane, 0.0, 0.0, 0.0, 4.0), (BWidget)new BBorderPane((BWidget)buttonPane, 4.0, 0.0, 4.0, 0.0), null, null, (BWidget)new BBorderPane((BWidget)new BBorderPane((BWidget)table, BBorder.inset, BInsets.DEFAULT), 0.0, 4.0, 0.0, 0.0));
        this.setContent(this.loadedContent);
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        BSoftwareStationExt stationExt = (BSoftwareStationExt)value;
        stationExt.lease();
        if (stationExt.getStatus().isFault()) {
            this.setContent((BWidget)new BLabel(this.getLexicon().getText("StationSoftwareView.fault", new Object[]{stationExt.getFaultCause()})));
            return;
        }
        BProvisioningNiagaraNetworkExt prov = (BProvisioningNiagaraNetworkExt)BOrd.make((String)"service:provisioningNiagara:ProvisioningNiagaraNetworkExt").get((BObject)stationExt);
        prov.lease();
        BSoftwareContainer container = prov.getSoftware();
        container.lease();
        if (container.getLoaded()) {
            new Loader(stationExt).start();
        } else {
            this.setContent((BWidget)new BLabel(this.getLexicon().getText("StationSoftwareView.loading")));
            this.registerForComponentEvents(container, 1);
        }
    }

    public void handleComponentEvent(BComponentEvent evt) {
        if (evt.getSourceComponent() instanceof BSoftwareContainer && evt.getId() == 0 && evt.getSlot() == BSoftwareContainer.loaded) {
            new Loader((BSoftwareStationExt)this.getCurrentValue()).start();
        }
    }

    public void doHandleTableModified() {
        boolean enableCommit = false;
        boolean enableUpgradeOOD = false;
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            int status;
            if (this.tableModel.getInstallStatusAt(i) != BPartInstallStatus.noChange && this.tableModel.getInstallStatusAt(i) != BPartInstallStatus.notFound) {
                enableCommit = true;
            }
            if ((status = this.tableModel.getStatusAt(i)) == 3 || status == 4) {
                enableUpgradeOOD = true;
            }
            if (enableCommit && enableUpgradeOOD) break;
        }
        this.commitCommand.setEnabled(enableCommit);
        this.upgradeOODCommand.setEnabled(enableUpgradeOOD);
        long freeSpaceDeltaKb = (int)(this.tableModel.getSizeDeltaOnCommit() / 1024L);
        this.spaceDeltaLabel.setText(((DecimalFormat)DaemonFileUtil.kbFormat.get()).format(freeSpaceDeltaKb));
        long proposedFreeSpace = this.currentFreeSpace - freeSpaceDeltaKb;
        this.afterSpaceLabel.setText(((DecimalFormat)DaemonFileUtil.kbFormat.get()).format(proposedFreeSpace));
        this.handleSelectionModified();
    }

    public void doHandleSelectionModified() {
        if (!this.trapSelectionModified) {
            return;
        }
        this.resetCommand.setEnabled(true);
        int[] rows = this.tableModel.getSelection().getRows();
        if (rows.length == 0) {
            this.setLeftButtonCommand((Command)this.installCommand, false);
            this.setRightButtonCommand((Command)this.uninstallCommand, false);
            return;
        }
        if (rows.length > 1) {
            BPartInstallStatus testAction = this.tableModel.getInstallStatusAt(rows[0]);
            for (int i = 1; i < rows.length; ++i) {
                if (this.tableModel.getInstallStatusAt(rows[i]) == testAction) continue;
                this.setLeftButtonCommand((Command)this.installCommand, false);
                this.setRightButtonCommand((Command)this.uninstallCommand, false);
                return;
            }
        }
        if (this.tableModel.getInstallStatusAt(rows[0]) == BPartInstallStatus.noChange || this.tableModel.getInstallStatusAt(rows[0]) == BPartInstallStatus.notFound) {
            AsyncCommand lc = null;
            boolean lcEnable = true;
            boolean rcEnable = true;
            boolean anyCurrent = false;
            for (int row : rows) {
                int rowStatus = this.tableModel.getStatusAt(row);
                if (this.tableModel.getInstallableVersionAt(row) == null) {
                    lc = this.installCommand;
                    lcEnable = false;
                } else {
                    switch (rowStatus) {
                        case 7: 
                        case 9: 
                        case 13: {
                            lc = this.installCommand;
                            lcEnable = false;
                            break;
                        }
                        case 0: 
                        case 6: {
                            lc = this.installCommand;
                            break;
                        }
                        case 2: 
                        case 4: 
                        case 5: 
                        case 8: {
                            if (lc != null) break;
                            lc = this.reinstallCommand;
                            break;
                        }
                        case 3: {
                            if (lc != null) break;
                            lc = this.upgradeCommand;
                            break;
                        }
                        case 12: {
                            if (lc == null) {
                                lc = this.upgradeCommand;
                            }
                            lcEnable = false;
                            break;
                        }
                        default: {
                            if (lc != null) break;
                            lc = this.downgradeCommand;
                        }
                    }
                }
                if (rowStatus == 0 || rowStatus == 6) {
                    rcEnable = false;
                    continue;
                }
                if (!rcEnable) continue;
                anyCurrent = true;
                if (this.tableModel.isModule(row)) {
                    BModulePart mp = (BModulePart)this.tableModel.getCurrentPartAt(row);
                    if (mp != null && !mp.getPartName().equals("wbapplet") && !mp.getPartName().equals("build")) continue;
                    rcEnable = false;
                    continue;
                }
                rcEnable = false;
            }
            if (lc == null) {
                this.setLeftButtonCommand((Command)this.installCommand, false);
            } else {
                this.setLeftButtonCommand((Command)lc, lcEnable);
            }
            this.setRightButtonCommand((Command)this.uninstallCommand, rcEnable && anyCurrent);
        } else {
            switch (this.tableModel.getInstallStatusAt(rows[0]).getOrdinal()) {
                case 2: {
                    this.setLeftButtonCommand((Command)this.cancelInstallCommand, true);
                    this.setRightButtonCommand((Command)this.uninstallCommand, false);
                    return;
                }
                case 3: {
                    this.setLeftButtonCommand((Command)this.cancelUpgradeCommand, true);
                    this.setRightButtonCommand((Command)this.uninstallCommand, false);
                    return;
                }
                case 5: {
                    this.setLeftButtonCommand((Command)this.cancelDowngradeCommand, true);
                    this.setRightButtonCommand((Command)this.uninstallCommand, false);
                    return;
                }
                case 4: {
                    this.setLeftButtonCommand((Command)this.cancelReinstallCommand, true);
                    this.setRightButtonCommand((Command)this.uninstallCommand, false);
                    return;
                }
                case 6: {
                    this.setLeftButtonCommand((Command)this.installCommand, false);
                    this.setRightButtonCommand((Command)this.cancelUninstallCommand, true);
                    return;
                }
            }
            BDaemonSessionView.log.warning("unrecognized install status " + this.tableModel.getInstallStatusAt(rows[0]));
        }
    }

    protected BStationSoftwareFilter loadFilter() {
        BStationSoftwareFilter result;
        try {
            BOptions options = BOptions.load((String)this.getType().toString(), (Type)BOptions.TYPE);
            result = (BStationSoftwareFilter)options.get("filter");
            if (result == null) {
                result = new BStationSoftwareFilter();
            }
        }
        catch (Exception e) {
            BDaemonSessionView.log.log(Level.WARNING, "Failed to load filter, returning default", e);
            result = new BStationSoftwareFilter();
        }
        return result;
    }

    protected void saveFilter(BStationSoftwareFilter filter) {
        try {
            BOptions options = BOptions.load((String)this.getType().toString(), (Type)BOptions.TYPE);
            if (options.get("filter") == null) {
                options.add("filter", filter.newCopy());
            } else {
                options.set("filter", filter.newCopy());
            }
            options.save();
        }
        catch (Exception e) {
            BDaemonSessionView.log.log(Level.WARNING, "Failed to save filter", e);
        }
    }

    private void setLeftButtonCommand(Command command, boolean enable) {
        for (Command leftButtonCommand : this.leftButtonCommands) {
            leftButtonCommand.setEnabled(leftButtonCommand == command && enable);
        }
        if (command != this.leftButton.getCommand()) {
            this.leftButton.setCommand(command, true, false);
            this.leftButton.relayout();
            this.relayout();
        }
    }

    private void setRightButtonCommand(Command command, boolean enable) {
        for (Command rightButtonCommand : this.rightButtonCommands) {
            rightButtonCommand.setEnabled(rightButtonCommand == command && enable);
        }
        if (command != this.rightButton.getCommand()) {
            this.rightButton.setCommand(command, true, false);
            this.rightButton.relayout();
            this.relayout();
        }
    }

    private class EditFilterCommand
    extends Command {
        public EditFilterCommand() {
            super((BWidget)BStationSoftwareView.this, TYPE.getModule(), "StationSoftwareView.command.editFilter");
        }

        public CommandArtifact doInvoke() {
            try {
                BStationSoftwareFilter filter = BStationSoftwareFilter.getFilter((BWidget)BStationSoftwareView.this, BStationSoftwareView.this.tableModel.getFilter());
                if (filter != null) {
                    BStationSoftwareView.this.tableModel.setFilter(filter);
                    BStationSoftwareView.this.saveFilter(filter);
                }
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
            return null;
        }
    }

    private class CommitCommand
    extends AsyncCommand {
        public CommitCommand() {
            super((BWidget)BStationSoftwareView.this, TYPE.getModule(), "StationSoftwareView.command.installNow");
        }

        public void doInvokeAsync() {
            try {
                BSoftwareStationExt stationExt = (BSoftwareStationExt)BStationSoftwareView.this.getCurrentValue();
                BNiagaraNetworkJob job = new BNiagaraNetworkJob(stationExt.getNiagaraStation().getStationName());
                for (BInstallable bInstallable : BStationSoftwareView.this.tableModel.getScenario().getToInstall()) {
                    job.addStep(new BInstallBySpecStep(BInstallableSpec.make((BInstallable)bInstallable)));
                }
                for (String string : BStationSoftwareView.this.tableModel.getScenario().getModulesToUninstall()) {
                    job.addStep(new BUninstallModuleStep(string));
                }
                BBatchJobService bBatchJobService = (BBatchJobService)BOrd.make((String)"service:batchJob:BatchJobService").get(BStationSoftwareView.this.getCurrentValue());
                job = (BNiagaraNetworkJob)bBatchJobService.submitJob((BBatchJob)job, null);
                BWbShell shell = BWbShell.getWbShell((BWidget)BStationSoftwareView.this);
                if (shell != null) {
                    shell.hyperlink(job.getNavOrd());
                }
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
        }
    }

    private class DetailCommand
    extends Command {
        private final int row;

        public DetailCommand(int pRow) {
            super((BWidget)BStationSoftwareView.this, TYPE.getModule(), "StationSoftwareView.command.details");
            this.row = pRow;
        }

        public CommandArtifact doInvoke() {
            try {
                BPartDetailsPane detail = new BPartDetailsPane(BStationSoftwareView.this.tableModel.getCertValidator(), BStationSoftwareView.this.tableModel.getModuleVerificationMode());
                detail.loadValue(BStationSoftwareView.this.tableModel.getCurrentPartAt(this.row), BStationSoftwareView.this.tableModel.getInstallablePartAt(this.row), BStationSoftwareView.this.tableModel.getTypeAt(this.row), BStationSoftwareView.this.tableModel.getForwardDependenciesAt(this.row), BStationSoftwareView.this.tableModel.getDependentPartsAt(this.row));
                BBrush bgcolor = Theme.scrollPane().getControlBackground();
                BScrollPane scrollpane = new BScrollPane((BWidget)new BBorderPane((BWidget)detail, 10.0, 10.0, 5.0, 10.0));
                scrollpane.setViewportBackground(bgcolor);
                scrollpane.setBorderPolicy(BScrollBarPolicy.asNeeded);
                BConstrainedPane dlgContent = new BConstrainedPane((BWidget)scrollpane);
                dlgContent.setFixedSize(500.0, 350.0);
                BDialog.message((BWidget)BStationSoftwareView.this, (String)BStationSoftwareView.this.getLexicon().getText("StationSoftwareView.command.details.dlgTitle"), (Object)dlgContent);
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
            return null;
        }
    }

    private class SoftwareTableController
    extends TableController {
        private SoftwareTableController() {
        }

        protected void cellPressed(BMouseEvent event, int row, int column) {
            if (event.isPopupTrigger()) {
                super.cellPressed(event, row, column);
                return;
            }
            if (column != 0 || event.getX() > 14.0) {
                if (event.getClickCount() > 1) {
                    new DetailCommand(row).invoke();
                } else {
                    super.cellPressed(event, row, column);
                }
            }
        }

        protected void cellPopup(BMouseEvent event, int row, int column) {
            BMenu menu = new BMenu();
            menu.add(null, (BValue)new BActionMenuItem((Command)new DetailCommand(row)), null);
            if (BStationSoftwareView.this.tableModel.getSelection().getRowCount() == 1 && (BStationSoftwareView.this.tableModel.getInstallStatusAt(row) == BPartInstallStatus.noChange || BStationSoftwareView.this.tableModel.getInstallStatusAt(row) == BPartInstallStatus.notFound)) {
                try {
                    for (BInstallable inst : BStationSoftwareView.this.tableModel.getInstallableRegistry().getInstallables(BDependency.forModule((String)BStationSoftwareView.this.tableModel.getNameAt(row)), BStationSoftwareView.this.taskListener)) {
                        menu.add(null, (BValue)new BActionMenuItem((Command)new InstallVersionCommand(BStationSoftwareView.this.tableModel, inst)), null);
                    }
                }
                catch (Exception e) {
                    BDaemonSessionView.log.log(Level.WARNING, "Failed to build popup menu install version item", e);
                }
            } else {
                menu.add(null, (BValue)new BActionMenuItem(BStationSoftwareView.this.leftButton.getCommand()), null);
            }
            menu.add(null, (BValue)new BActionMenuItem(BStationSoftwareView.this.rightButton.getCommand()), null);
            menu.add(null, (BValue)new BSeparator());
            menu.add(null, (BValue)new BActionMenuItem((Command)BStationSoftwareView.this.upgradeOODCommand), null);
            menu.add(null, (BValue)new BSeparator());
            menu.add(null, (BValue)new BActionMenuItem((Command)BStationSoftwareView.this.commitCommand), null);
            menu.add(null, (BValue)new BActionMenuItem((Command)BStationSoftwareView.this.resetCommand), null);
            menu.open((BWidget)BStationSoftwareView.this.tableModel.getTable(), event.getX(), event.getY());
        }
    }

    private class Loader
    extends Thread {
        private final BSoftwareStationExt stationExt;

        public Loader(BSoftwareStationExt stationExt) {
            this.stationExt = stationExt;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.stationExt.getNiagaraStation().lease();
                BStationProxy proxy = (BStationProxy)this.stationExt.getNiagaraStation().getMixIn(BStationProxy.TYPE);
                DaemonSessionTask task = new DaemonSessionTask(BStationSoftwareView.this.getLexicon(), "StationSoftwareView.loading.title", "StationSoftwareView.freeSpace.message");
                BStationSoftwareView.this.taskListener.taskStarted(task);
                try {
                    BStationSoftwareView.this.currentFreeSpace = proxy.getFilesystemAttributes(new FilePath("!")).getFreeSpace();
                    BStationSoftwareView.this.currentSpaceLabel.setText(((DecimalFormat)DaemonFileUtil.kbFormat.get()).format(BStationSoftwareView.this.currentFreeSpace));
                    BStationSoftwareView.this.spaceDeltaLabel.setText(((DecimalFormat)DaemonFileUtil.kbFormat.get()).format(0L));
                    BStationSoftwareView.this.afterSpaceLabel.setText(((DecimalFormat)DaemonFileUtil.kbFormat.get()).format(BStationSoftwareView.this.currentFreeSpace));
                    if (BStationSoftwareView.this.loadedContent.getParent() == null) {
                        BStationSoftwareView.this.setContent(BStationSoftwareView.this.loadedContent);
                    }
                    BStationSoftwareView.this.registerForComponentEvents((BComponent)this.stationExt, Integer.MAX_VALUE);
                    task.setMessage(BStationSoftwareView.this.getLexicon().getText("StationSoftwareView.updateSnapshot.message"));
                    BStationSoftwareView.this.taskListener.taskUpdated(task);
                    BComponentSpace space = (BComponentSpace)this.stationExt.getSpace();
                    this.stationExt.invokeSync(BSoftwareStationExt.takeSnapshotWithNotify, null, null);
                    space.sync();
                }
                finally {
                    BStationSoftwareView.this.taskListener.taskFinished(task);
                }
                BStationSoftwareView.this.tableModel.init(this.stationExt, BStationSoftwareView.this.taskListener, true);
                BStationSoftwareView.this.registerForComponentEvents((BComponent)proxy, Integer.MAX_VALUE);
            }
            catch (Exception e) {
                BDaemonSessionView.log.log(Level.WARNING, "Failed to run Loader, loaded value may be incomplete", e);
            }
        }
    }
}

