/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui.software;

import com.tridium.crypto.core.cert.CertificateChainValidator;
import com.tridium.crypto.core.io.CoreCryptoManager;
import com.tridium.crypto.core.io.ICoreTrustStore;
import com.tridium.install.BDependency;
import com.tridium.install.BVersion;
import com.tridium.install.ModuleSignatureStatusEnum;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.BInstallableSpec;
import com.tridium.install.installable.BModuleInstallable;
import com.tridium.install.part.BModulePart;
import com.tridium.install.part.BPart;
import com.tridium.nre.security.ISecurityInfoProvider;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.BCommandDialog;
import com.tridium.platform.ui.util.BCommandEnablePolicy;
import com.tridium.platform.ui.util.BIndentPane;
import com.tridium.platform.ui.util.BStringPromptDialog;
import com.tridium.platform.ui.util.CommandBindings;
import com.tridium.platform.ui.util.DialogCommand;
import com.tridium.provisioningNiagara.BProvisioningNiagaraNetworkExt;
import com.tridium.provisioningNiagara.software.BFileCopyStep;
import com.tridium.provisioningNiagara.software.BInstallBySpecStep;
import com.tridium.provisioningNiagara.software.BInstallCombinedBySpecStep;
import com.tridium.provisioningNiagara.software.BInstallStep;
import com.tridium.provisioningNiagara.software.BInstallableNavNode;
import com.tridium.provisioningNiagara.software.BInstallableSummary;
import com.tridium.provisioningNiagara.software.ProvisioningRegistry;
import com.tridium.provisioningNiagara.ui.software.BInstallSoftwareDialog;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.util.ValidatingTextController;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.baja.batchJob.BBatchJob;
import javax.baja.batchJob.BJobStep;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.gx.BInsets;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.provisioningNiagara.ui.BStationStepFactory;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.ListController;
import javax.baja.ui.list.ListSelection;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.text.TextController;

@NiagaraSingleton
@NiagaraType
public class BInstallSoftwareFactory
extends BStationStepFactory {
    public static final BInstallSoftwareFactory INSTANCE = new BInstallSoftwareFactory();
    public static final Type TYPE = Sys.loadType(BInstallSoftwareFactory.class);
    private static final BIcon icon = BIcon.std((String)"backup.png");
    private static final int SIGNATURE_WARNING_DIALOG_WIDTH = 475;
    private static final int SIGNATURE_WARNING_DIALOG_HEIGHT = 260;
    private static final int SIGNATURE_ERROR_DIALOG_WIDTH = 375;
    private static final int SIGNATURE_ERROR_DIALOG_HEIGHT = 160;
    private static final int WORD_WRAP_LABEL_BUFFER = 35;

    @Override
    public Type getType() {
        return TYPE;
    }

    protected BInstallSoftwareFactory() {
    }

    public String getDescription(Context cx) {
        return LEX.getText("InstallSoftwareFactory.description");
    }

    public BJobStep makeStep(BWidget owner, BBatchJob currentBatchJob, BObject jobTarget, BObject source, Context cx) throws Exception {
        List<BInstallableSpec> specs;
        BInstallableSpec spec = null;
        BProvisioningNiagaraNetworkExt ext = (BProvisioningNiagaraNetworkExt)BOrd.make((String)"service:provisioningNiagara:ProvisioningNiagaraNetworkExt").get(jobTarget);
        ProvisioningRegistry registry = ext.getInstallableRegistry();
        if (source instanceof BIFile) {
            BIFile sourceFile = (BIFile)source;
            BInstallable inst = ext.getSoftware().getInstallable(sourceFile);
            if (inst != null && !inst.getIsValid()) {
                BDialog.error((BWidget)owner, (String)LEX.getText("InstallSoftwareFactory.badInstallable.dlgTitle"), (Object)LEX.getText("InstallSoftwareFactory.badInstallable.dlgMessage"));
                return null;
            }
            if (inst == null) {
                BISession fileSession;
                BISession targetSession;
                if (BInstallable.isInstallableFile((BIFile)sourceFile)) {
                    BDialog.error((BWidget)owner, (String)LEX.getText("InstallSoftwareFactory.badInstallable.dlgTitle"), (Object)LEX.getText("InstallSoftwareFactory.badInstallable.dlgMessage"));
                    return null;
                }
                if (currentBatchJob != null && !(targetSession = BOrd.toSession((BObject)currentBatchJob)).equals(fileSession = sourceFile.getFileSpace().getSession())) {
                    BDialog.error((BWidget)owner, (String)LEX.getText("InstallSoftwareFactory.badFileSession.dlgTitle"), (Object)LEX.getText("InstallSoftwareFactory.badFileSession.dlgMessage"));
                    return null;
                }
                FilePath destDirPath = this.getDestDirPath(sourceFile.getFilePath(), owner);
                if (destDirPath == null) {
                    return null;
                }
                BFileCopyStep result = new BFileCopyStep(sourceFile, destDirPath);
                result.setFactoryType(this.getType().getTypeSpec());
                return result;
            }
            if (inst.getPart() == null) {
                BInstallStep result = new BInstallStep(inst, sourceFile.getFileSpace().getSession(), true);
                result.setFactoryType(this.getType().getTypeSpec());
                return result;
            }
            BInstallable existing = registry.findInstallable(BDependency.forPart((BPart)inst.getPart()), null);
            if (existing == null) {
                if (sourceFile.getFileSpace().getSession().equals(BOrd.toSession((BObject)ext))) {
                    registry.registerLocal(inst, null);
                } else {
                    registry.register(inst, null);
                }
            }
            spec = BInstallableSpec.make((BInstallable)inst);
        } else if (source instanceof BInstallableSummary) {
            BInstallableSummary summary = (BInstallableSummary)source;
            BVersion[] versions = summary.getVersions();
            BVersion version = null;
            if (versions.length == 1) {
                version = versions[0];
            } else if (versions.length > 1) {
                BList versionList = new BList();
                for (BVersion version1 : versions) {
                    versionList.addItem((Object)version1);
                }
                CommandBindings bindings = new CommandBindings();
                DialogCommand ok = DialogCommand.makeOk((BWidget)owner);
                DialogCommand cancel = DialogCommand.makeCancel((BWidget)owner);
                bindings.addCommand((Command)ok, BCommandEnablePolicy.singleSelection);
                bindings.addCommand((Command)cancel, BCommandEnablePolicy.always);
                bindings.setDoubleClickCommand((Command)ok);
                versionList.setController((ListController)new CommandBindings.ListController(bindings));
                versionList.setSelection((ListSelection)new CommandBindings.ListSelection(bindings));
                BLabel dlgLabel = new BLabel(LEX.getText("InstallSoftwareFactory.chooseVersion.dlgMessage", new Object[]{summary.getInstallableName()}));
                dlgLabel.setHalign(BHalign.left);
                if (1 == BCommandDialog.open((BWidget)owner, (String)LEX.getText("InstallSoftwareFactory.chooseVersion.dlgTitle"), (Object)new BBorderPane((BWidget)new BEdgePane((BWidget)dlgLabel, (BWidget)new BBox(300.0, 0.0), (BWidget)new BBox(0.0, 200.0), null, (BWidget)new BBorderPane((BWidget)new BBorderPane((BWidget)versionList, BBorder.inset, BInsets.DEFAULT), 10.0, 0.0, 4.0, 0.0)), 4.0, 10.0, 4.0, 10.0), (DialogCommand[])new DialogCommand[]{ok, cancel})) {
                    version = (BVersion)versionList.getSelectedItem();
                }
            }
            if (version == null) {
                return null;
            }
            spec = summary.getInstallableSpec(version);
        } else if (source instanceof BInstallableSpec) {
            spec = (BInstallableSpec)source;
        } else if (source instanceof BInstallableNavNode) {
            spec = ((BInstallableNavNode)source).getInstallableSpec();
        }
        if (spec == null) {
            specs = BInstallSoftwareDialog.show(owner, jobTarget);
            if (specs == null || specs.isEmpty()) {
                return null;
            }
        } else {
            specs = new ArrayList<BInstallableSpec>();
            specs.add(spec);
        }
        CertificateChainValidator certValidator = new CertificateChainValidator();
        CoreCryptoManager mgr = AccessController.doPrivileged(() -> CoreCryptoManager.get((ISecurityInfoProvider)SecurityInitializer.getInstance().getSecurityInfoProvider()));
        ICoreTrustStore trustStore = mgr.getSystemTrustStore();
        certValidator.addTrustAnchors(trustStore);
        if (!this.showSignatureWarningsOrErrors(owner, specs, registry, certValidator)) {
            return null;
        }
        if (specs.size() > 1) {
            BInstallCombinedBySpecStep combinedResult = new BInstallCombinedBySpecStep(specs);
            combinedResult.setFactoryType(this.getType().getTypeSpec());
            return combinedResult;
        }
        BInstallBySpecStep result = new BInstallBySpecStep(specs.get(0));
        result.setFactoryType(this.getType().getTypeSpec());
        return result;
    }

    private boolean showSignatureWarningsOrErrors(BWidget owner, List<BInstallableSpec> installables, ProvisioningRegistry registry, CertificateChainValidator certValidator) throws Exception {
        BConstrainedPane cpane;
        Object label;
        BIndentPane result;
        ArrayList<BModuleInstallable> failures = new ArrayList<BModuleInstallable>();
        HashMap<ModuleSignatureStatusEnum, List> warnings = new HashMap<ModuleSignatureStatusEnum, List>();
        for (BInstallableSpec spec : installables) {
            BInstallable installable = registry.findInstallable(spec.asDependency(), null);
            if (!(installable instanceof BModuleInstallable)) continue;
            BModulePart bModulePart = ((BModuleInstallable)installable).getModulePart();
            List statuses = bModulePart.getSignatureStatus(certValidator);
            if (statuses.contains(ModuleSignatureStatusEnum.INVALID_SIGNATURE)) {
                failures.add((BModuleInstallable)installable);
                continue;
            }
            if (statuses.contains(ModuleSignatureStatusEnum.OK)) continue;
            for (ModuleSignatureStatusEnum status : statuses) {
                warnings.computeIfAbsent(status, k -> new ArrayList()).add(installable.toString());
            }
        }
        if (!failures.isEmpty()) {
            int targetWidth = 340;
            result = new BIndentPane();
            label = new BLabel(LEX.getText("InstallSoftwareFactory.INVALID_SIGNATURE.error"));
            label.setWordWrapEnabled(true, (double)targetWidth);
            label.setHalign(BHalign.left);
            result.add((BWidget)label);
            result.indent();
            for (BModuleInstallable installable : failures) {
                result.add(installable.toString());
            }
            result.unindent();
            result.add(" ");
            BScrollPane bScrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)result, 5.0, 5.0, 5.0, 5.0));
            bScrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
            bScrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
            cpane = new BConstrainedPane((BWidget)bScrollPane);
            cpane.setFixedSize(375.0, 160.0);
            BCommandDialog.open((BWidget)owner, (String)LEX.getText("InstallSoftwareFactory.signingError.title"), (Object)cpane, (int)1);
            return false;
        }
        if (!warnings.isEmpty()) {
            int targetWidth = 440;
            result = new BIndentPane();
            for (Map.Entry entry : warnings.entrySet()) {
                BLabel label2 = new BLabel(LEX.getText("InstallSoftwareFactory." + ((ModuleSignatureStatusEnum)entry.getKey()).toString() + ".warning"));
                label2.setWordWrapEnabled(true, (double)targetWidth);
                label2.setHalign(BHalign.left);
                result.add((BWidget)label2);
                result.indent();
                for (String module : (List)entry.getValue()) {
                    result.add(module);
                }
                result.unindent();
                result.add(" ");
            }
            label = new BLabel(LEX.getText("InstallSoftwareFactory.continue"));
            label.setWordWrapEnabled(true, (double)targetWidth);
            label.setHalign(BHalign.left);
            result.add((BWidget)label);
            BScrollPane bScrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)result, 5.0, 5.0, 5.0, 5.0));
            bScrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
            bScrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
            cpane = new BConstrainedPane((BWidget)bScrollPane);
            cpane.setFixedSize(475.0, 260.0);
            return 1 == BCommandDialog.open((BWidget)owner, (String)LEX.getText("InstallSoftwareFactory.signingWarning.title"), (Object)cpane, (int)3);
        }
        return true;
    }

    private FilePath getDestDirPath(FilePath currentPath, BWidget owner) {
        String initialValue = currentPath.isStationHomeAbsolute() || currentPath.isProtectedStationHomeAbsolute() || currentPath.isSysHomeAbsolute() ? currentPath.getParent().getBody() : "^^";
        String result = BStringPromptDialog.getString((BWidget)owner, null, (String)LEX.getText("InstallSoftwareFactory.destDir.dlgTitle"), (String)LEX.getText("InstallSoftwareFactory.destDir.dlgMessage", new Object[]{currentPath.getName()}), (String)initialValue, (TextController)new FilePathController(), (boolean)true);
        if (result != null && result.length() > 0 && result.charAt(result.length() - 1) == '/') {
            result = result.substring(0, result.length() - 1);
        }
        return result == null ? null : new FilePath(result);
    }

    public BIcon getIcon() {
        return icon;
    }

    private static class FilePathController
    extends ValidatingTextController {
        private FilePathController() {
        }

        protected boolean valid(String updatedText) {
            if (updatedText.trim().length() == 0) {
                return true;
            }
            try {
                FilePath path;
                if (updatedText.charAt(updatedText.length() - 1) == '/') {
                    updatedText = updatedText.substring(0, updatedText.length() - 1);
                }
                return (path = new FilePath(updatedText)).isStationHomeAbsolute() || path.isSysHomeAbsolute() || path.isProtectedStationHomeAbsolute();
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

