/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui.software;

import com.tridium.crypto.core.cert.CertificateChainValidator;
import com.tridium.crypto.core.io.CoreCryptoManager;
import com.tridium.crypto.core.io.ICoreTrustStore;
import com.tridium.install.ModuleSignatureStatusEnum;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.BInstallableSpec;
import com.tridium.install.installable.BModuleInstallable;
import com.tridium.install.part.BModulePart;
import com.tridium.nre.security.ISecurityInfoProvider;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.platDaemon.ui.BModuleView;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.provisioningNiagara.BProvisioningNiagaraNetworkExt;
import com.tridium.provisioningNiagara.software.BInstallableSummary;
import com.tridium.ui.theme.Theme;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BActionMenuItem;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.pane.BTreePane;
import javax.baja.ui.text.Line;
import javax.baja.ui.text.Segment;
import javax.baja.ui.text.TextRenderer;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeController;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNode;
import javax.baja.ui.tree.TreeSelection;
import javax.baja.ui.tree.TreeSubject;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.util.Lexicon;
import javax.baja.util.PatternFilter;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="updateNavTree"), @NiagaraAction(name="searchKeyEvent", parameterType="BKeyEvent", defaultValue="new BKeyEvent()")})
public class BInstallSoftwareDialog
extends BDialog {
    public static final Action updateNavTree = BInstallSoftwareDialog.newAction((int)0, null);
    public static final Action searchKeyEvent = BInstallSoftwareDialog.newAction((int)0, (BValue)new BKeyEvent(), null);
    public static final Type TYPE = Sys.loadType(BInstallSoftwareDialog.class);
    private static final Lexicon LEX = Lexicon.make((String)"provisioningNiagara");
    private static final Logger LOG = Logger.getLogger("provisioningNiagara");
    private static final BInsets INSETS = BInsets.make((double)7.0);
    private static final int DIALOG_INIT_W = 400;
    private static final int DIALOG_INIT_H = 400;
    private BTextField searchField = new BTextField("", 40);
    private BButton okButton;
    private BTree tree;
    BScrollPane treePane;
    BEdgePane containerPane;

    public void updateNavTree() {
        this.invoke(updateNavTree, null, null);
    }

    public void searchKeyEvent(BKeyEvent parameter) {
        this.invoke(searchKeyEvent, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BInstallSoftwareDialog(BWidget owner, BObject jobTarget) {
        super(owner, LEX.getText("InstallSoftwareFactory.title"), true);
        this.setContent(this.buildDialog(jobTarget));
    }

    private BWidget buildDialog(BObject jobTarget) {
        BEdgePane pane = new BEdgePane();
        pane.setTop(this.buildHeader());
        pane.setBottom(this.buildButtonPane());
        pane.setCenter(this.buildBody(jobTarget));
        return pane;
    }

    private BWidget buildHeader() {
        return new BWizardHeader(null, LEX.getText("InstallSoftwareFactory.chooseSoftware.dlgTitle"), LEX.getText("InstallSoftwareFactory.chooseSoftware.dlgMessage"));
    }

    private BWidget buildBody(BObject jobTarget) {
        BProvisioningNiagaraNetworkExt ext = (BProvisioningNiagaraNetworkExt)BOrd.make((String)"service:provisioningNiagara:ProvisioningNiagaraNetworkExt").get(jobTarget);
        BGridPane contentPane = new BGridPane(1);
        contentPane.setHalign(BHalign.center);
        contentPane.setColumnAlign(BHalign.center);
        this.searchField.setRenderer(new TextRenderer(){

            public void paintLine(Graphics g, TextRenderer.LineInfo info) {
                if (info.line.segments.length == 0) {
                    TextRenderer.LineInfo info2 = new TextRenderer.LineInfo();
                    info2.lineIndex = 0;
                    info2.selectionStartColumn = 0;
                    info2.selectionEndColumn = 0;
                    String filterText = LEX.getText("InstallSoftwareFactory.filter");
                    info2.line = new Line(filterText.toCharArray(), new Segment[]{new Segment(-1, 0, filterText.length())});
                    super.paintLine(g, info2);
                } else {
                    super.paintLine(g, info);
                }
            }

            public BBrush getForeground(Segment seg) {
                if (seg.type == -1) {
                    return Theme.textEditor().getDisabledTextBrush();
                }
                return super.getForeground(seg);
            }
        });
        this.linkTo((BComponent)this.searchField, (Slot)BTextField.textModified, (Slot)updateNavTree);
        this.linkTo((BComponent)this.searchField, (Slot)BWidget.keyEvent, (Slot)searchKeyEvent);
        BGridPane searchFieldGrid = new BGridPane(2);
        searchFieldGrid.add(null, (BValue)new BLabel(BImage.make((BIcon)BIcon.std((String)"filter.png"))));
        searchFieldGrid.add(null, (BValue)this.searchField);
        BGridPane searchGrid = new BGridPane(1);
        searchGrid.add(null, (BValue)new BLabel(LEX.getText("InstallSoftwareFactory.filterMessage")));
        searchGrid.add(null, (BValue)searchFieldGrid);
        searchGrid.add(null, (BValue)new BLabel("   "));
        searchGrid.add(null, (BValue)new BLabel(LEX.getText("InstallSoftwareFactory.multiSelect")));
        this.tree = new BTree((TreeModel)new Model(ext));
        this.tree.setSelection((TreeSelection)new Selection(this.okButton.getCommand()));
        this.tree.setController((TreeController)new Controller(this.okButton.getCommand()));
        this.tree.setMultipleSelection(true);
        this.treePane = new BTreePane(this.tree){

            public void computePreferredSize() {
                if (this.needsLayout()) {
                    this.setPreferredSize(400.0, 400.0);
                    return;
                }
                double searchHeight = BInstallSoftwareDialog.this.containerPane.getTop().getHeight();
                double dialogHeight = BInstallSoftwareDialog.this.getHeight();
                double dialogWidth = BInstallSoftwareDialog.this.getWidth();
                BWidget contentWidget = BInstallSoftwareDialog.this.getContent();
                if (!(contentWidget instanceof BEdgePane)) {
                    this.setPreferredSize(dialogWidth - 10.0, dialogHeight - searchHeight - 100.0);
                    return;
                }
                BEdgePane contentPane = (BEdgePane)contentWidget;
                double contentCenter = contentPane.getCenter().getHeight();
                double contentTop = contentPane.getTop().getHeight();
                double contentBottom = contentPane.getBottom().getHeight();
                double insets = 14.0;
                this.setPreferredSize(dialogWidth - 10.0, contentCenter - contentTop - contentBottom - insets);
            }
        };
        this.containerPane = new BEdgePane((BWidget)searchGrid, null, null, null, (BWidget)new BBorderPane((BWidget)this.treePane, BBorder.inset, BInsets.make((double)10.0, (double)0.0, (double)4.0, (double)0.0)));
        contentPane.add(null, (BValue)this.containerPane);
        return contentPane;
    }

    private BWidget buildButtonPane() {
        this.okButton = new BButton(UiLexicon.bajaui().getText("dialog.ok"));
        BButton cancelButton = new BButton(UiLexicon.bajaui().getText("dialog.cancel"));
        this.okButton.setEnabled(true);
        OkCommand ok = new OkCommand((BWidget)this.okButton);
        CancelCommand cancel = new CancelCommand((BWidget)cancelButton);
        this.okButton.setCommand((Command)ok, true, false);
        cancelButton.setCommand((Command)cancel, true, false);
        BGridPane buttonPane = new BGridPane(2);
        buttonPane.setColumnAlign(BHalign.fill);
        buttonPane.setUniformColumnWidth(true);
        buttonPane.add(null, (BValue)this.okButton);
        buttonPane.add(null, (BValue)cancelButton);
        return new BBorderPane((BWidget)buttonPane, INSETS);
    }

    public void doUpdateNavTree() {
        TreeSelection selection = this.tree.getSelection();
        ArrayList<Object> selectedNodes = new ArrayList();
        if (selection != null) {
            selectedNodes = new ArrayList<TreeNode>(Arrays.asList(selection.getNodes()));
        }
        Model currentModel = (Model)this.tree.getModel();
        if (this.searchField.getText().length() == 0) {
            currentModel.reset();
        } else {
            currentModel.filterModel(this.searchField.getText().toLowerCase());
        }
        selection.deselectAll();
        int currentRootCount = currentModel.getRootCount();
        if (!selectedNodes.isEmpty() && currentRootCount > 0) {
            for (int i = 0; i < currentRootCount; ++i) {
                List<TreeNode> filteredSelectedNodes = this.checkChildren(currentModel.getRoot(i), selectedNodes);
                filteredSelectedNodes.forEach(treeNode -> selection.select(treeNode));
            }
        }
        this.tree.getModel().updateTree();
        this.treePane.doLayout(this.treePane.getChildWidgets());
    }

    private List<TreeNode> checkChildren(TreeNode parentNode, List<TreeNode> selectedNodes) {
        ArrayList<TreeNode> filteredSelectedNodes = new ArrayList<TreeNode>();
        for (int i = 0; i < parentNode.getChildCount(); ++i) {
            TreeNode childNode = parentNode.getChild(i);
            if (childNode instanceof SpecNode) {
                selectedNodes.forEach(node -> {
                    if (node instanceof SpecNode) {
                        BInstallableSpec childSpec = ((SpecNode)childNode).getInstallableSpec();
                        BInstallableSpec nodeSpec = ((SpecNode)((Object)node)).getInstallableSpec();
                        if (childSpec.getInstallableName().equals(nodeSpec.getInstallableName()) && childSpec.getVersion().compareTo((Object)nodeSpec.getVersion()) == 0) {
                            ArrayList<TreeNode> expandNodes = new ArrayList<TreeNode>(Arrays.asList(childNode.getPathFromRoot()));
                            for (TreeNode expandNode : expandNodes) {
                                expandNode.setExpanded(true);
                            }
                            childNode.setSelected(true);
                            filteredSelectedNodes.add(childNode);
                        }
                    }
                });
            }
            if (!childNode.hasChildren()) continue;
            this.checkChildren(childNode, selectedNodes);
        }
        return filteredSelectedNodes;
    }

    public void doSearchKeyEvent(BKeyEvent event) {
        if (event.getKeyCode() == 10 || event.getKeyCode() == 27 || event.getKeyCode() == 40 || event.getKeyCode() == 38 || event.getKeyCode() == 36 || event.getKeyCode() == 35 || event.getKeyCode() == 33 || event.getKeyCode() == 34) {
            this.tree.fireKeyEvent(event);
        }
    }

    private List<BInstallableSpec> getResult() {
        if (this.tree.getSelection() == null) {
            return null;
        }
        TreeSelection nodes = this.tree.getSelection();
        if (nodes == null || nodes.getNodes().length == 0) {
            return null;
        }
        ArrayList<BInstallableSpec> specs = new ArrayList<BInstallableSpec>();
        for (TreeNode node : nodes.getNodes()) {
            if (!(node instanceof SpecNode)) continue;
            specs.add(((SpecNode)node).getInstallableSpec());
        }
        return specs;
    }

    public static List<BInstallableSpec> show(BWidget owner, BObject jobTarget) {
        BInstallSoftwareDialog dialog = new BInstallSoftwareDialog(owner, jobTarget);
        dialog.setBoundsCenteredOnOwner();
        dialog.open();
        return dialog.getResult();
    }

    class CancelCommand
    extends Command {
        public CancelCommand(BWidget owner) {
            super(owner, UiLexicon.bajaui().getText("dialog.cancel"));
        }

        public CommandArtifact doInvoke() {
            BInstallSoftwareDialog.this.tree.getSelection().deselectAll();
            BInstallSoftwareDialog.this.close();
            return null;
        }
    }

    class OkCommand
    extends Command {
        public OkCommand(BWidget owner) {
            super(owner, UiLexicon.bajaui().getText("dialog.ok"));
        }

        public CommandArtifact doInvoke() {
            BInstallSoftwareDialog.this.close();
            return null;
        }
    }

    private static class Selection
    extends TreeSelection {
        private Command command;

        public Selection(Command command) {
            this.command = command;
        }

        public void updateTree() {
            super.updateTree();
            this.command.setEnabled(this.getNode() != null && this.getNode() instanceof SpecNode);
        }
    }

    private static class DetailCommand
    extends Command {
        private SpecNode spec;
        private static final int DIALOG_WIDTH = 500;
        private static final int DIALOG_HEIGHT = 350;

        public DetailCommand(SpecNode spec, BWidget owner) {
            super(owner, TYPE.getModule(), "InstallSoftwareFactory.command.details");
            this.spec = spec;
        }

        public CommandArtifact doInvoke() {
            try {
                Model model = (Model)this.spec.getModel();
                BProvisioningNiagaraNetworkExt ext = model.getExt();
                BInstallable installable = ext.getInstallableRegistry().findInstallable(this.spec.getInstallableSpec().asDependency(), null);
                BModuleView view = new BModuleView();
                view.loadValue((BObject)installable);
                BConstrainedPane dlgContent = new BConstrainedPane((BWidget)view);
                dlgContent.setFixedSize(500.0, 350.0);
                BDialog.message((BWidget)this.getOwner(), (String)"Software details", (Object)dlgContent);
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
            return null;
        }
    }

    private static class Controller
    extends TreeController {
        private Command command;

        public Controller(Command command) {
            this.command = command;
        }

        protected void doSelectAction(TreeNode target, double x, double y) {
            if (target != null && target instanceof SpecNode) {
                this.command.invoke();
            }
        }

        protected BMenu makePopup(TreeSubject subject) {
            TreeNode node = subject.getActiveNode();
            if (node instanceof SpecNode && ((SpecNode)node).getInstallableSpec().getInstallableType().equals((Object)BModuleInstallable.TYPE.getTypeSpec())) {
                BMenu menu = new BMenu();
                menu.add(null, (BValue)new BActionMenuItem((Command)new DetailCommand((SpecNode)node, this.command.getOwner())), null);
                return menu;
            }
            return null;
        }
    }

    private static class SpecNode
    extends TreeNode {
        private BInstallableSpec spec;
        private BImage icon;
        private static final BImage SECURITY_HIGH = BImage.make((String)"module://icons/x16/security-high.png");
        private static final BImage SECURITY_MEDIUM = BImage.make((String)"module://icons/x16/security-medium.png");
        private static final BImage SECURITY_LOW = BImage.make((String)"module://icons/x16/security-low.png");

        public SpecNode(SummaryNode parent, BInstallableSpec spec) {
            super((TreeNode)parent);
            this.spec = spec;
        }

        public String getText() {
            return this.spec.getVersion().toString(null);
        }

        public int getChildCount() {
            return 0;
        }

        public TreeNode getChild(int index) {
            return null;
        }

        public BImage getIcon() {
            if (this.icon != null) {
                return this.icon;
            }
            if (this.spec.getInstallableType().equals((Object)BModuleInstallable.TYPE.getTypeSpec())) {
                Model model = (Model)this.getModel();
                BProvisioningNiagaraNetworkExt ext = model.getExt();
                try {
                    BModuleInstallable installable = (BModuleInstallable)ext.getInstallableRegistry().findInstallable(this.spec.asDependency(), null);
                    BModulePart part = installable.getModulePart();
                    List statuses = part.getSignatureStatus(model.getCertValidator());
                    this.icon = statuses.contains(ModuleSignatureStatusEnum.OK) ? SECURITY_HIGH : (statuses.contains(ModuleSignatureStatusEnum.INVALID_SIGNATURE) ? SECURITY_LOW : SECURITY_MEDIUM);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.icon == null) {
                this.icon = BImage.make((BIcon)this.spec.getIcon());
            }
            return this.icon;
        }

        public BInstallableSpec getInstallableSpec() {
            return this.spec;
        }
    }

    private static class SummaryNode
    extends TreeNode {
        private BInstallableSummary summary;
        private List<SpecNode> children = null;

        public SummaryNode(Model model, BInstallableSummary summary) {
            super((TreeModel)model);
            this.summary = summary;
        }

        public String getText() {
            return this.summary.toString(null);
        }

        public int getChildCount() {
            return this.getChildren().size();
        }

        public TreeNode getChild(int index) {
            return this.getChildren().get(index);
        }

        public BImage getIcon() {
            return BImage.make((BIcon)this.summary.getIcon());
        }

        private List<SpecNode> getChildren() {
            if (this.children == null) {
                this.children = new ArrayList<SpecNode>();
                SlotCursor c = this.summary.getProperties();
                while (c.next(BInstallableSpec.class)) {
                    this.children.add(new SpecNode(this, (BInstallableSpec)c.get()));
                }
            }
            return this.children;
        }
    }

    private static class Model
    extends TreeModel {
        private CertificateChainValidator certValidator;
        private BProvisioningNiagaraNetworkExt ext;
        private List<BInstallableSummary> softwareSummaries;
        private List<SummaryNode> roots;

        public Model(BProvisioningNiagaraNetworkExt ext) {
            this.ext = ext;
            this.softwareSummaries = new ArrayList<BInstallableSummary>();
            ext.lease(4);
            SlotCursor c = ext.getSoftware().getProperties();
            while (c.next(BInstallableSummary.class)) {
                this.softwareSummaries.add((BInstallableSummary)c.get());
            }
            this.roots = new ArrayList<SummaryNode>();
            this.reset();
            this.certValidator = new CertificateChainValidator();
            CoreCryptoManager mgr = AccessController.doPrivileged(() -> CoreCryptoManager.get((ISecurityInfoProvider)SecurityInitializer.getInstance().getSecurityInfoProvider()));
            ICoreTrustStore trustStore = mgr.getSystemTrustStore();
            this.certValidator.addTrustAnchors(trustStore);
        }

        public void filterModel(String filter) {
            this.roots.clear();
            if (filter.indexOf(42) == -1 && filter.indexOf(37) == -1) {
                filter = filter + "*";
            }
            PatternFilter patternFilter = new PatternFilter(filter);
            this.softwareSummaries.forEach(summary -> {
                if (patternFilter.accept(summary.toString())) {
                    this.roots.add(new SummaryNode(this, (BInstallableSummary)((Object)summary)));
                }
            });
        }

        public void reset() {
            this.roots.clear();
            this.softwareSummaries.forEach(summary -> this.roots.add(new SummaryNode(this, (BInstallableSummary)((Object)summary))));
        }

        public int getRootCount() {
            return this.roots.size();
        }

        public TreeNode getRoot(int index) {
            return this.roots.get(index);
        }

        public BProvisioningNiagaraNetworkExt getExt() {
            return this.ext;
        }

        public CertificateChainValidator getCertValidator() {
            return this.certValidator;
        }
    }
}

