/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui.software;

import com.tridium.install.installable.BInstallable;
import com.tridium.platform.ui.util.BFileChooserDialog;
import com.tridium.provisioningNiagara.software.BInstallCleanDistStep;
import com.tridium.provisioningNiagara.software.BSoftwareContainer;
import com.tridium.provisioningNiagara.ui.software.BInstallCleanDistCredentialsDialog;
import com.tridium.provisioningNiagara.ui.software.BInstallSoftwareFactory;
import javax.baja.batchJob.BBatchJob;
import javax.baja.batchJob.BJobStep;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.IFileFilter;
import javax.baja.gx.BImage;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.file.ExtFileFilter;

@NiagaraType(agent={@AgentOn(types={"provisioningNiagara:InstallStep"})})
@NiagaraSingleton
public class BInstallCleanDistFactory
extends BInstallSoftwareFactory {
    public static final BInstallCleanDistFactory INSTANCE = new BInstallCleanDistFactory();
    public static final Type TYPE = Sys.loadType(BInstallCleanDistFactory.class);
    private static final BIcon icon = BIcon.std((String)"modules.png");

    @Override
    public Type getType() {
        return TYPE;
    }

    protected BInstallCleanDistFactory() {
    }

    @Override
    public String getDescription(Context cx) {
        return LEX.getText("InstallCleanDistFactory.description");
    }

    @Override
    public BJobStep makeStep(BWidget owner, BBatchJob currentBatchJob, BObject jobTarget, BObject source, Context cx) throws Exception {
        BIFile file;
        if (source instanceof BIFile) {
            file = (BIFile)source;
        } else {
            ExtFileFilter distFilter = new ExtFileFilter(LEX.getText("InstallCleanDistStep.fileFilterDescription"), new String[]{"dist"});
            file = BFileChooserDialog.chooseFile((BWidget)owner, (BImage)BImage.make((String)LEX.getText("InstallCleanDistStep.cleanDistDialog.icon")), (String)LEX.getText("InstallCleanDistStep.cleanDistDialog.title"), (String)LEX.getText("InstallCleanDistStep.cleanDistDialog.message"), (BIFile)BFileSystem.INSTANCE.findFile(new FilePath("!cleanDist")), (IFileFilter)distFilter, (IFileFilter)distFilter, null);
        }
        if (file == null) {
            return null;
        }
        BInstallable installable = BInstallable.make((BIFile)file);
        BInstallCleanDistStep step = new BInstallCleanDistStep(installable, file.getFileSpace().getSession(), true);
        if (!BSoftwareContainer.isCleanDistFile(installable)) {
            BDialog.error((BWidget)owner, (String)LEX.getText("InstallCleanDistStep.noDistFile.title"), (Object)LEX.getText("InstallCleanDistStep.noDistFile.message", new Object[]{file.getFileName()}));
            return null;
        }
        BInstallCleanDistCredentialsDialog dialog = new BInstallCleanDistCredentialsDialog(owner);
        dialog.show(step);
        if (dialog.isCanceled()) {
            return null;
        }
        if (2 == BDialog.open((BWidget)owner, (String)LEX.getText("InstallCleanDistFactory.warningTitle"), (Object)(LEX.getText("InstallCleanDistFactory.deployWarning") + "\n\n" + LEX.getText("InstallCleanDistFactory.distFileWarning", new Object[]{file.getFileName()}) + "\n\n" + LEX.getText("InstallCleanDistFactory.backupWarning") + "\n\n" + LEX.getText("InstallCleanDistFactory.bootstrapWarning") + "\n\n" + LEX.getText("InstallCleanDistFactory.credentialsWarning")), (int)3, (BImage)BDialog.WARNING_ICON, (String)null)) {
            return null;
        }
        step.setFactoryType(this.getType().getTypeSpec());
        return step;
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }
}

