/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui.program;

import com.tridium.batchJob.ui.ViewQueryParameter;
import com.tridium.crypto.core.cert.SigningUtil;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.BCommandDialog;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platform.ui.util.DialogCommand;
import com.tridium.provisioningNiagara.BNiagaraNetworkBatchAgent;
import com.tridium.provisioningNiagara.program.BProvisioningRobot;
import com.tridium.provisioningNiagara.program.BRobotJobStep;
import com.tridium.provisioningNiagara.ui.program.ProvisioningCompiler;
import com.tridium.provisioningNiagara.ui.program.ProvisioningRobotEditorCommands;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.console.BConsole;
import java.io.File;
import javax.baja.batchJob.BValueList;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.io.BIEncodable;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.ViewQuery;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraSlots;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BBlob;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.list.BCheckList;
import javax.baja.ui.list.DefaultListModel;
import javax.baja.ui.list.ListModel;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.Position;
import javax.baja.ui.text.TextParser;
import javax.baja.ui.text.parsers.JavaParser;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType(agent={@AgentOn(types={"provisioningNiagara:ProvisioningRobot"})})
@NiagaraSlots(actions={@NiagaraAction(name="codeTextModified")})
public class BProvisioningRobotEditor
extends BWbComponentView
implements BConsole.HyperlinkInterceptor {
    public static final Action codeTextModified = BProvisioningRobotEditor.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BProvisioningRobotEditor.class);
    protected static String defaultDepends = "program-rt";
    protected static String boilerplate = "// depends: " + defaultDepends + "\n\nimport javax.baja.sys.*;\n\n/*\n Provisioning Robot Programming Tips\n -----------------------------------\n \n 1) The class must be named RobotImpl, and must extend com.tridium.program.Robot.\n 2) List any direct module dependencies at the top of the source, using a comment:\n      \"// depends:\" module [ \"; \" module ] ...\n    Additional modules required by the listed modules will be identified automatically - for\n    example, it is not necessary to list baja if a module that depends on baja is also listed.\n    Note that the robot will fail to run on any station that is missing any of the required\n    modules.\n 3) The only method required to be implemented by Robot subclasses is run().\n 4) If the class imports from any modules that use the \"se\" or \"wb\" profiles, it will be\n    compiled using the Java 8 Standard Edition (SE) profile, otherwise it will be compiled using\n    the Java 8 compact3 profile.  Available Java API will differ accordingly.\n 5) Text written to System.out will appear in each station's console output, accessible by connecting\n    to the stations using the Application Director platform view.   Programmers will probably find\n    it more useful to send text output to the Robot superclass' \"log\" variable instead.  All text\n    written to \"log\" will be stored with the job's step execution details.\n 6) To find results for completed robot executions, you can use the Station Job List view on a\n    particular station's StationProxy extension, or the Niagara Network Job List view on the\n    network's provisioning extension.\n 7) Robots can be sent to stations for execution only when the stations have a Program Service.\n    The job step will fail for the station if the Program Service is missing.\n 8) Robots cannot be executed on Niagara AX systems. \n */ \npublic class RobotImpl\n  extends com.tridium.program.Robot\n{\n\n  public void run()\n    throws Exception\n  {\n    process(Sys.getStation());\n  }\n\n  public void process(BComponent c)\n    throws Exception\n  {\n    // do something here\n    log.println(c.toPathString() + \" [\" + c.getType() + \"]\");\n    \n    // recurse\n    BComponent[] kids = c.getChildComponents();\n    for(int i=0; i<kids.length; ++i)\n      process(kids[i]);\n  }\n\n}\n";
    protected static UiLexicon uiLex = UiLexicon.bajaui();
    protected static final Lexicon lex = Lexicon.make((String)"provisioningNiagara");
    static String statusOk = uiLex.getText("programEditor.status.ok");
    static String statusNeedsCompile = uiLex.getText("programEditor.status.needsCompile");
    static String statusError = uiLex.getText("programEditor.status.error");
    static String statusSigningError = uiLex.getText("programEditor.status.signingError");
    static String statusNotSigned = uiLex.getText("programEditor.status.notSigned");
    static String statusNotTimestamped = uiLex.getText("programEditor.status.notTimestamped");
    static BImage statusOkIcon = BImage.make((String)"module://icons/x16/shapes/circleGreen.png");
    static BImage statusWarningIcon = BImage.make((String)"module://icons/x16/shapes/circleGold.png");
    static BImage statusErrorIcon = BImage.make((String)"module://icons/x16/shapes/circleRed.png");
    protected ProvisioningRobotEditorCommands commands = new ProvisioningRobotEditorCommands(this);
    protected BTextEditor editor;
    protected BLabel status;
    protected BLabel statusLine2;
    protected ProvisioningCompiler compiler = new ProvisioningCompiler(this);
    protected boolean modified = false;

    public void codeTextModified() {
        this.invoke(codeTextModified, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BProvisioningRobotEditor() {
        this.editor = new BTextEditor();
        this.editor.setParser((TextParser)new JavaParser());
        this.linkTo(null, (BComponent)this.editor, (Slot)BTextEditor.textModified, (Slot)codeTextModified);
        this.setTransferWidget((BTransferWidget)this.editor);
        this.setCommandEnabled(6, true);
        this.setCommandEnabled(8, true);
        this.setCommandEnabled(7, true);
        this.setCommandEnabled(9, true);
        this.setCommandEnabled(10, true);
        this.status = new BLabel("status not initialized");
        this.statusLine2 = new BLabel("");
        BGridPane gridPane = new BGridPane(1);
        gridPane.setHalign(BHalign.left);
        gridPane.setColumnGap(10.0);
        gridPane.add(null, (BValue)this.status);
        gridPane.add(null, (BValue)this.statusLine2);
        BBorderPane statusPane = new BBorderPane((BWidget)gridPane, 5.0, 0.0, 10.0, 0.0);
        BTextEditorPane editorPane = new BTextEditorPane(this.editor);
        this.setContent((BWidget)new BEdgePane((BWidget)statusPane, null, null, null, (BWidget)editorPane));
        this.linkTo("lk0", (BComponent)editorPane.getEditor(), (Slot)BTextEditor.textModified, (Slot)setModified);
    }

    public void updateStatus() {
        if (this.modified || this.compiler.getClassName() == null || this.computeChecksum() != this.compiler.checksum) {
            this.status.setText(statusNeedsCompile);
            this.status.setImage(statusWarningIcon);
        } else {
            this.status.setText(statusOk);
            this.status.setImage(statusOkIcon);
        }
        BBlob signature = this.compiler.tempCode.getSignature();
        if (signature == BBlob.DEFAULT) {
            this.statusLine2.setText(statusNotSigned);
            this.statusLine2.setImage(statusWarningIcon);
        } else if (!SigningUtil.isTimestamped((byte[])this.compiler.tempCode.getClassFile().copyBytes(), (byte[])signature.copyBytes())) {
            this.statusLine2.setText(statusNotTimestamped);
            this.statusLine2.setImage(statusWarningIcon);
        } else {
            this.statusLine2.setText("");
            this.statusLine2.setImage(BImage.NULL);
        }
    }

    public void updateStatusToError() {
        this.status.setText(statusError);
        this.status.setImage(statusErrorIcon);
    }

    public void updateStatusToSigningError() {
        this.status.setText(statusSigningError);
        this.status.setImage(statusErrorIcon);
    }

    public int computeChecksum() {
        return this.editor.getText().hashCode();
    }

    public void doCodeTextModified() {
        if (!this.isModifiedStateLocked()) {
            this.setModified();
            this.modified = true;
            this.updateStatus();
        }
    }

    public void notifyCodeTextUpToDate() {
        this.modified = false;
    }

    public BMenu[] getViewMenus() {
        return this.commands.getViewMenus();
    }

    public BToolBar getViewToolBar() {
        return this.commands.getViewToolBar();
    }

    protected void doLoadValue(BObject value, Context cx) {
        BProvisioningRobot robot = (BProvisioningRobot)value;
        robot.lease(Integer.MAX_VALUE);
        this.compiler.load(robot);
        if (robot.getSource().trim().length() == 0) {
            this.editor.setText(boilerplate);
        } else {
            this.editor.setText(robot.getSource());
        }
        this.updateStatus();
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        BProvisioningRobot robot = (BProvisioningRobot)value;
        this.compiler.saveRobot(robot, this.getSource(), this.getDependencies());
        this.modified = false;
        this.updateStatus();
        return robot;
    }

    public void submitJob() throws Exception {
        BProvisioningRobot robot = (BProvisioningRobot)this.saveValue();
        BNiagaraNetwork nw = (BNiagaraNetwork)BOrd.make((String)"service:niagaraDriver:NiagaraNetwork").get(this.getCurrentValue());
        nw.lease(1);
        DefaultListModel cbModel = new DefaultListModel();
        BDevice[] devices = BNiagaraNetworkBatchAgent.INSTANCE.listBatchDevices((BDeviceNetwork)nw);
        if (devices.length == 0) {
            BDialog.message((BWidget)this, (String)lex.getText("ProvisioningRobotEditor.noStations.dlgTitle"), (Object)lex.getText("ProvisioningRobotEditor.noStations.dlgMessage"));
            return;
        }
        for (BDevice device : devices) {
            cbModel.addItem(BImage.make((BIcon)device.getIcon()), (Object)new StationItem(device));
        }
        BCheckList checkList = new BCheckList();
        checkList.setModel((ListModel)cbModel);
        if (devices.length == 1) {
            checkList.getSelection().select(0, true);
        }
        BBrush bgcolor = Theme.scrollPane().getControlBackground();
        BScrollPane scrollpane = new BScrollPane((BWidget)checkList);
        scrollpane.setViewportBackground(bgcolor);
        scrollpane.setBorderPolicy(BScrollBarPolicy.asNeeded);
        BFlowPane header = new BFlowPane(BHalign.left);
        header.add("label", (BValue)new BLabel(lex.getText("ProvisioningRobotEditor.stations.dlgMessage")));
        if (1 == BCommandDialog.open((BWidget)this, (String)lex.getText("ProvisioningRobotEditor.stations.dlgTitle"), (Object)new BBorderPane((BWidget)new BEdgePane((BWidget)header, (BWidget)new BBox(250.0, 0.0), (BWidget)new BBox(0.0, 300.0), null, (BWidget)new BBorderPane((BWidget)new BBorderPane((BWidget)scrollpane, BBorder.inset, BInsets.DEFAULT), 10.0, 0.0, 4.0, 0.0)), 4.0, 10.0, 4.0, 10.0), (DialogCommand[])new DialogCommand[]{new CheckAllCommand(checkList), DialogCommand.makeOk((BWidget)this), DialogCommand.makeCancel((BWidget)this)})) {
            StringBuilder query = new StringBuilder("provisioningNiagara:NiagaraNetworkJobBuilder?");
            int[] sel = checkList.getSelection().getItems();
            if (sel.length > 0) {
                BValueList stationIds = null;
                for (int selectedItem : sel) {
                    BString stationName = BString.make((String)((StationItem)checkList.getModel().getItem(selectedItem)).getStationName());
                    stationIds = stationIds == null ? BValueList.make((BValue)stationName) : BValueList.add((BValueList)stationIds, (BValue)stationName);
                }
                query.append("stations=");
                query.append(ViewQueryParameter.encode(stationIds));
                query.append(';');
            }
            query.append("steps=");
            query.append(ViewQueryParameter.encode((BIEncodable)new BRobotJobStep(robot)));
            BOrd ord = BOrd.make((BOrd)BOrd.make((String)"service:provisioningNiagara:ProvisioningNiagaraNetworkExt"), (OrdQuery)new ViewQuery(query.toString()));
            BWbShell shell = BWbShell.getWbShell((BWidget)this);
            shell.hyperlink(ord);
        }
    }

    public CommandArtifact invokeCommand(int id) throws Exception {
        switch (id) {
            case 6: {
                return this.editor.doFind();
            }
            case 8: {
                return this.editor.doFindNext();
            }
            case 7: {
                return this.editor.doFindPrev();
            }
            case 9: {
                return this.editor.doReplace();
            }
            case 10: {
                return this.editor.doGoto();
            }
        }
        return super.invokeCommand(id);
    }

    public String getDependencies() {
        String source = this.getSource();
        if (source.startsWith("// depends:")) {
            int colon = source.indexOf(58);
            int nl = source.indexOf(10);
            if (colon >= 0 && nl >= 0) {
                return source.trim().substring(colon + 1, nl);
            }
            return defaultDepends;
        }
        return defaultDepends;
    }

    public String getSource() {
        return this.editor.getText();
    }

    public boolean consoleHyperlink(File file, int line1, int col1, int line2, int col2) {
        if (!file.equals(this.compiler.java)) {
            return false;
        }
        this.highlight(line1, col1, line2, col2);
        return true;
    }

    public void highlight(int line1, int col1, int line2, int col2) {
        this.highlight(this.editor, line1, col1, line2, col2);
    }

    void highlight(BTextEditor text, int line1, int col1, int line2, int col2) {
        Position end = text.getModel().getEndPosition();
        Position p1 = new Position(line1 - 1, col1 - 1);
        Position p2 = new Position(line2 - 1, col2);
        if (p1.compareTo(end) > 0) {
            p1 = end;
        }
        if (p2.compareTo(end) > 0) {
            p2 = end;
        }
        text.getSelection().select(p1, p2);
        text.moveCaretPosition(p2);
        text.requestFocus();
    }

    private static class StationItem {
        private BNiagaraStation station;

        public StationItem(BDevice device) {
            this.station = (BNiagaraStation)device;
        }

        public String toString() {
            return this.station.getDisplayName(null);
        }

        public String getStationName() {
            return this.station.getStationName();
        }
    }

    private class CheckAllCommand
    extends DialogCommand {
        private BCheckList checkList;

        public CheckAllCommand(BCheckList checkList) {
            super((BWidget)BProvisioningRobotEditor.this, -1, lex, "ProvisioningRobotEditor.stations.checkAll");
            this.checkList = checkList;
        }

        public CommandArtifact doInvoke() {
            try {
                this.checkList.getSelection().selectAll();
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
            return null;
        }
    }
}

