/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui.license;

import com.tridium.nd.BNiagaraStation;
import com.tridium.platform.ui.util.AsyncCommand;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.BCommandBoundTable;
import com.tridium.platform.ui.util.BCommandEnablePolicy;
import com.tridium.platform.ui.util.CommandBindings;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platform.ui.util.SortableTableUtil;
import com.tridium.provisioningNiagara.license.BLicenseStationExt;
import com.tridium.provisioningNiagara.license.BLicenseStatus;
import com.tridium.provisioningNiagara.license.BSupervisorLicenses;
import com.tridium.ui.theme.Theme;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.baja.batchJob.BValueList;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.data.BIDataTable;
import javax.baja.gx.BBrush;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbComponentView;

public class BNetworkLicenseSummary
extends BWbComponentView
implements CommandBindings.Support {
    public static final Type TYPE = Sys.loadType(BNetworkLicenseSummary.class);
    private static final BIcon ICON = BIcon.std((String)"doc.png");
    private static final Lexicon LEX = Lexicon.make((String)"provisioningNiagara");
    private StationStatusModel model;
    private static final int COL_NAME = 0;
    private static final int COL_HOST_ID = 1;
    private static final int COL_STATUS = 2;
    private static final int COL_LAST_UPDATED = 3;

    public Type getType() {
        return TYPE;
    }

    public BNetworkLicenseSummary() {
        CommandBindings bindings = new CommandBindings();
        this.model = new StationStatusModel();
        bindings.setSupport((CommandBindings.Support)this);
        DetailsCommand detailsCommand = new DetailsCommand();
        bindings.addCommand((Command)detailsCommand, BCommandEnablePolicy.singleSelection);
        PollCommand pollCommand = new PollCommand();
        bindings.addCommand((Command)pollCommand, BCommandEnablePolicy.singleSelection);
        bindings.setDoubleClickCommand((Command)detailsCommand);
        BCommandBoundTable table = new BCommandBoundTable((TableModel)this.model, new CommandBindings.TableController(bindings));
        table.setSelection((TableSelection)new CommandBindings.TableSelection(bindings));
        BBrush bgcolor = Theme.scrollPane().getControlBackground();
        BScrollPane scrollpane = new BScrollPane((BWidget)table);
        scrollpane.setViewportBackground(bgcolor);
        scrollpane.setBorderPolicy(BScrollBarPolicy.asNeeded);
        this.setContent((BWidget)new BEdgePane((BWidget)new BBox(550.0, 0.0), (BWidget)new BBorderPane((BWidget)new BButtonPane(new Command[]{pollCommand}), BInsets.make((double)4.0, (double)5.0, (double)4.0, (double)5.0)), (BWidget)new BBox(0.0, 250.0), null, (BWidget)new BBorderPane((BWidget)new BBorderPane((BWidget)scrollpane, BBorder.inset, BInsets.DEFAULT), 0.0, 0.0, 4.0, 0.0)));
    }

    protected void doLoadValue(BObject value, Context context) throws Exception {
        BIDataTable data = (BIDataTable)BOrd.make((String)"service:niagaraDriver:NiagaraNetwork|bql:select slotPath from niagaraDriver:NiagaraStation stop").get((BObject)((BComponent)value).getComponentSpace());
        Column slotPathCol = data.getColumns().get(0);
        ArrayList<StationStatusRow> rows = new ArrayList<StationStatusRow>();
        TableCursor c = data.cursor();
        while (c.next()) {
            BNiagaraStation ns = (BNiagaraStation)BOrd.make((String)c.cell(slotPathCol).toString()).get(value);
            ns.lease(1);
            BLicenseStationExt ext = (BLicenseStationExt)ns.getMixIn(BLicenseStationExt.TYPE);
            rows.add(new StationStatusRow(ext));
        }
        this.model.load(rows);
    }

    protected BSupervisorLicenses getSupervisorLicenses() {
        return (BSupervisorLicenses)this.getCurrentValue();
    }

    public BIcon getIcon() {
        return ICON;
    }

    public void setBoundCommandEnabled(Command command, boolean bindingBasedState) {
        command.setEnabled(bindingBasedState);
    }

    private static class StationStatusModel
    extends TableModel
    implements SortableTableUtil.Model {
        private int sortColumn = 2;
        private boolean sortAscending = true;
        private boolean needsSort = false;
        private List<StationStatusRow> rows = new ArrayList<StationStatusRow>();

        public void load(List<StationStatusRow> rows) {
            this.rows = rows;
            for (StationStatusRow row : rows) {
                row.setModel(this);
            }
            this.sortValues((Comparator<SortableTableUtil.SortableRow>)new SortableTableUtil.OriginalOrderComparator((SortableTableUtil.Model)this));
        }

        public int getRowCount() {
            return this.rows.size();
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return LEX.getText("NetworkLicenseSummary.col.name");
                }
                case 1: {
                    return LEX.getText("NetworkLicenseSummary.col.hostId");
                }
                case 2: {
                    return LEX.getText("NetworkLicenseSummary.col.status");
                }
                case 3: {
                    return LEX.getText("NetworkLicenseSummary.col.lastUpdated");
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return this.getRow(row).getStationDisplayName() + " " + this.getRow(row).getExtension().getStatus();
                }
                case 1: {
                    return this.getRow(row).getHostId();
                }
                case 2: {
                    return this.getRow(row).getExtension().getLicenseStatus();
                }
                case 3: {
                    return this.getRow(row).getExtension().getLicenseStatus() == BLicenseStatus.unknown ? "" : this.getRow(row).getExtension().getLastUpdate().toString();
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public SortableTableUtil.SortableRow getSortableRow(int row) {
            return this.getRow(row);
        }

        public StationStatusRow getRow(int row) {
            return this.rows.get(row);
        }

        public boolean isColumnSortable(int col) {
            return true;
        }

        public void sortByColumn(int col, boolean ascending) {
            if (!this.needsSort && col == this.sortColumn && ascending == this.sortAscending) {
                return;
            }
            this.sortColumn = col;
            this.sortAscending = ascending;
            this.sortValues(null);
        }

        protected void sortValues(Comparator<SortableTableUtil.SortableRow> override) {
            this.needsSort = false;
            this.rows = new ArrayList<StationStatusRow>(this.rows);
            this.rows.sort((Comparator<StationStatusRow>)new SortableTableUtil.RowComparator((SortableTableUtil.Model)this, override));
            if (this.getTable() != null) {
                this.getTable().getSelection().deselectAll();
                this.updateTable(true);
            }
        }

        public boolean isSortAscending() {
            return this.sortAscending;
        }

        public int getSortColumn() {
            return this.sortColumn;
        }
    }

    private static class StationStatusRow
    extends Subscriber
    implements SortableTableUtil.SortableRow {
        private BLicenseStationExt licenseExt;
        private TableModel model = null;

        public StationStatusRow(BLicenseStationExt licenseExt) {
            this.licenseExt = licenseExt;
            this.subscribe((BComponent)licenseExt, Integer.MAX_VALUE);
        }

        public void event(BComponentEvent event) {
            if (this.model != null) {
                this.model.updateTable();
            }
        }

        public String getHostId() {
            return this.licenseExt.getLicenseSummary().getHostId();
        }

        public String getStationName() {
            return this.getStation().getStationName();
        }

        public String getStationDisplayName() {
            return this.getStation().getDisplayName(null);
        }

        public BNiagaraStation getStation() {
            return this.licenseExt.getNiagaraStation();
        }

        public BLicenseStatus getLicenseStatus() {
            return this.licenseExt.getLicenseStatus();
        }

        public BLicenseStationExt getExtension() {
            return this.licenseExt;
        }

        public Object getRowId() {
            return this.getStationName();
        }

        public int compareToRowForColumn(SortableTableUtil.SortableRow sRow, int columnId) {
            StationStatusRow row = (StationStatusRow)sRow;
            switch (columnId) {
                case 0: {
                    return TextUtil.toLowerCase((String)this.getStationDisplayName()).compareTo(TextUtil.toLowerCase((String)row.getStationDisplayName()));
                }
                case 1: {
                    return this.getHostId().compareTo(row.getHostId());
                }
                case 2: {
                    if (this.getLicenseStatus() == row.getLicenseStatus()) {
                        return TextUtil.toLowerCase((String)this.getStationDisplayName()).compareTo(TextUtil.toLowerCase((String)row.getStationDisplayName()));
                    }
                    if (this.getLicenseStatus().getOrdinal() > row.getLicenseStatus().getOrdinal()) {
                        return 1;
                    }
                    return -1;
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public void setModel(TableModel value) {
            this.model = value;
        }
    }

    private class PollCommand
    extends AsyncCommand {
        public PollCommand() {
            super((BWidget)BNetworkLicenseSummary.this, BNetworkLicenseSummary.this.getLexicon(), "NetworkLicenseSummary.pollCommand");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doInvokeAsync() {
            try {
                this.startActive();
                int[] rows = BNetworkLicenseSummary.this.model.getSelection().getRows();
                int limit = rows.length;
                if (limit == 0) {
                    limit = BNetworkLicenseSummary.this.model.getRowCount();
                }
                BValueList selected = BValueList.DEFAULT;
                for (int i = 0; i < limit; ++i) {
                    int idx = rows.length == 0 ? i : rows[i];
                    selected = BValueList.add((BValueList)selected, (BValue)BString.make((String)BNetworkLicenseSummary.this.model.getRow(idx).getStation().getStationName()));
                }
                BNetworkLicenseSummary.this.getSupervisorLicenses().updateStationLicenseStatus(selected);
            }
            catch (Exception e) {
                CommandUtil.error((Command)this, (Throwable)e);
            }
            finally {
                this.stopActive();
            }
        }
    }

    private class DetailsCommand
    extends Command {
        public DetailsCommand() {
            super((BWidget)BNetworkLicenseSummary.this, BNetworkLicenseSummary.this.getLexicon(), "NetworkLicenseSummary.detailsCommand");
        }

        public CommandArtifact doInvoke() {
            try {
                BWbShell shell = BWbShell.getWbShell((BWidget)BNetworkLicenseSummary.this);
                if (shell != null) {
                    shell.hyperlink(BNetworkLicenseSummary.this.model.getRow(BNetworkLicenseSummary.this.model.getSelection().getRow()).getExtension().getNavOrd());
                }
            }
            catch (Exception e) {
                CommandUtil.error((Command)this, (Throwable)e);
            }
            return null;
        }
    }
}

