/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui.credentials;

import com.tridium.provisioningNiagara.credentials.BSetStationUserPasswordJobStep;
import com.tridium.workbench.shell.BPasswordField;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="okButtonPressed", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()"), @NiagaraAction(name="cancelButtonPressed", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()"), @NiagaraAction(name="setModified", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()")})
public class BSetStationUserPasswordStepDialog
extends BDialog {
    public static final Action okButtonPressed = BSetStationUserPasswordStepDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Action cancelButtonPressed = BSetStationUserPasswordStepDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Action setModified = BSetStationUserPasswordStepDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Type TYPE = Sys.loadType(BSetStationUserPasswordStepDialog.class);
    public static final Lexicon lex = Lexicon.make((String)"provisioningNiagara");
    private BButton okButton;
    private BButton cancelButton;
    private BCheckBox useConnectionUsername;
    private BTextField username;
    private BPasswordField currentPassword;
    private BPasswordField newPassword;
    private BPasswordField confirmPassword;
    private BSetStationUserPasswordJobStep result;

    public void okButtonPressed(BWidgetEvent parameter) {
        this.invoke(okButtonPressed, (BValue)parameter, null);
    }

    public void cancelButtonPressed(BWidgetEvent parameter) {
        this.invoke(cancelButtonPressed, (BValue)parameter, null);
    }

    public void setModified(BWidgetEvent parameter) {
        this.invoke(setModified, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    private BSetStationUserPasswordStepDialog(BWidget owner) {
        super(owner, lex.getText("SetStationUserPasswordStepDialog.title"), true);
        this.setContent(this.buildDialog());
        this.setDefaultButton(this.okButton);
    }

    public static BSetStationUserPasswordJobStep show(BWidget owner) {
        BSetStationUserPasswordStepDialog dialog = new BSetStationUserPasswordStepDialog(owner);
        dialog.setBoundsCenteredOnOwner();
        dialog.setResizable(false);
        dialog.open();
        return dialog.getResult();
    }

    private BWidget buildDialog() {
        BEdgePane pane = new BEdgePane();
        pane.setTop(this.buildHeader());
        pane.setCenter(this.buildContent());
        pane.setBottom(this.buildButtonPane());
        return pane;
    }

    private BWidget buildHeader() {
        return new BWizardHeader(null, lex.getText("SetStationUserPasswordStepDialog.title"), lex.get("SetStationUserPasswordStepDialog.description"));
    }

    private BWidget buildContent() {
        this.useConnectionUsername = new BCheckBox(lex.getText("SetStationUserPasswordStepDialog.useConnectionUsername"), true);
        this.username = new BTextField();
        this.username.setEnabled(false);
        this.currentPassword = new BPasswordField();
        this.newPassword = new BPasswordField();
        this.confirmPassword = new BPasswordField();
        BGridPane editorPane = new BGridPane(2);
        editorPane.add(null, (BValue)new BLabel(lex.getText("SetStationUserPasswordStepDialog.username")));
        editorPane.add(null, (BValue)this.username);
        editorPane.add(null, (BValue)new BLabel(lex.getText("SetStationUserPasswordStepDialog.current")));
        editorPane.add(null, (BValue)this.currentPassword);
        editorPane.add(null, (BValue)new BLabel(lex.getText("SetStationUserPasswordStepDialog.new")));
        editorPane.add(null, (BValue)this.newPassword);
        editorPane.add(null, (BValue)new BLabel(lex.getText("SetStationUserPasswordStepDialog.confirm")));
        editorPane.add(null, (BValue)this.confirmPassword);
        BGridPane content = new BGridPane(1);
        content.add(null, (BValue)this.useConnectionUsername);
        content.add(null, (BValue)editorPane);
        return new BBorderPane((BWidget)content, 7.0, 7.0, 0.0, 7.0);
    }

    private BWidget buildButtonPane() {
        this.okButton = new BButton(UiLexicon.bajaui().getText("dialog.ok"));
        this.cancelButton = new BButton(UiLexicon.bajaui().getText("dialog.cancel"));
        this.linkTo("linkA", (BComponent)this.okButton, (Slot)BButton.actionPerformed, (Slot)okButtonPressed);
        this.linkTo("linkB", (BComponent)this.cancelButton, (Slot)BButton.actionPerformed, (Slot)cancelButtonPressed);
        this.linkTo("linkC", (BComponent)this.newPassword, (Slot)BPasswordField.textModified, (Slot)setModified);
        this.linkTo("linkD", (BComponent)this.confirmPassword, (Slot)BPasswordField.textModified, (Slot)setModified);
        this.linkTo("linkE", (BComponent)this.useConnectionUsername, (Slot)BCheckBox.actionPerformed, (Slot)setModified);
        BGridPane buttonPane = new BGridPane(2);
        buttonPane.setColumnAlign(BHalign.fill);
        buttonPane.setUniformColumnWidth(true);
        buttonPane.add(null, (BValue)this.okButton);
        buttonPane.add(null, (BValue)this.cancelButton);
        return new BBorderPane((BWidget)buttonPane, 7.0, 7.0, 7.0, 7.0);
    }

    public void doOkButtonPressed(BWidgetEvent event) throws Exception {
        BPassword confirm;
        BPassword password = this.newPassword.getPassword();
        if (!password.validate(confirm = this.confirmPassword.getPassword())) {
            BDialog.error((BWidget)this, (Object)lex.getText("SetStationUserPasswordStepDialog.passwordMismatch"));
            return;
        }
        this.result = new BSetStationUserPasswordJobStep();
        if (!this.useConnectionUsername.isSelected()) {
            String username = this.username.getText();
            if (username.isEmpty()) {
                BDialog.error((BWidget)this, (Object)lex.getText("SetStationUserPasswordStepDialog.usernameRequired"));
                return;
            }
            this.result.setUsername(username);
        }
        this.result.setCurrentPassword(this.currentPassword.getPassword());
        this.result.setNewPassword(password);
        this.close();
    }

    public void doCancelButtonPressed(BWidgetEvent event) {
        this.close();
    }

    public void doSetModified(BWidgetEvent event) {
        this.okButton.setEnabled(this.newPassword.getPassword().validate(this.confirmPassword.getPassword()));
        this.username.setEnabled(!this.useConnectionUsername.getSelected());
    }

    public BSetStationUserPasswordJobStep getResult() {
        return this.result;
    }
}

