/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui.credentials;

import com.tridium.provisioningNiagara.credentials.BAddStationUserStep;
import com.tridium.workbench.shell.BPasswordField;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizardHeader;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="okButtonPressed", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()"), @NiagaraAction(name="cancelButtonPressed", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()"), @NiagaraAction(name="passwordModified", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()")})
public class BAddStationUserStepDialog
extends BDialog {
    public static final Action okButtonPressed = BAddStationUserStepDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Action cancelButtonPressed = BAddStationUserStepDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Action passwordModified = BAddStationUserStepDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Type TYPE = Sys.loadType(BAddStationUserStepDialog.class);
    private BAddStationUserStep result;
    private final BButton okButton = new BButton();
    private final BButton cancelButton = new BButton();
    private final BTextField username = new BTextField();
    private final BPasswordField password = new BPasswordField();
    private final BPasswordField confirmedPassword = new BPasswordField();
    private final BCheckBox isAdmin = new BCheckBox();

    public void okButtonPressed(BWidgetEvent parameter) {
        this.invoke(okButtonPressed, (BValue)parameter, null);
    }

    public void cancelButtonPressed(BWidgetEvent parameter) {
        this.invoke(cancelButtonPressed, (BValue)parameter, null);
    }

    public void passwordModified(BWidgetEvent parameter) {
        this.invoke(passwordModified, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BAddStationUserStepDialog(BWidget owner) throws Exception {
        super(owner, "", true);
        this.setTitle(this.lexValue("title", new Object[0]));
        this.setContent(this.buildDialog());
        this.setDefaultButton(this.okButton);
    }

    public static BAddStationUserStep show(BWidget owner) throws Exception {
        BAddStationUserStepDialog dialog = new BAddStationUserStepDialog(owner);
        dialog.setBoundsCenteredOnOwner();
        dialog.setResizable(false);
        dialog.open();
        return dialog.getResult();
    }

    private BWidget buildDialog() throws Exception {
        BEdgePane pane = new BEdgePane();
        pane.setTop(this.buildHeader());
        pane.setCenter(this.buildContent());
        pane.setBottom(this.buildButtonPane());
        return pane;
    }

    private BWidget buildHeader() throws Exception {
        return new BWizardHeader(null, this.lexValue("title", new Object[0]), this.lexValue("description", new Object[0]));
    }

    private BWidget buildContent() throws Exception {
        BGridPane content = new BGridPane(1);
        BGridPane contentGrid = new BGridPane(2);
        contentGrid.add(null, (BValue)new BLabel(this.lexValue("username", new Object[0])));
        contentGrid.add(null, (BValue)this.username);
        contentGrid.add(null, (BValue)new BLabel(this.lexValue("password", new Object[0])));
        contentGrid.add(null, (BValue)this.password);
        contentGrid.add(null, (BValue)new BLabel(this.lexValue("confirmedPassword", new Object[0])));
        contentGrid.add(null, (BValue)this.confirmedPassword);
        content.add(null, (BValue)contentGrid);
        this.isAdmin.setText(this.lexValue("admin", new Object[0]));
        this.isAdmin.setSelected(false);
        this.isAdmin.setEnabled(true);
        content.add(null, (BValue)this.isAdmin);
        return new BBorderPane((BWidget)content, 7.0, 7.0, 0.0, 7.0);
    }

    private BWidget buildButtonPane() throws Exception {
        this.okButton.setText(UiLexicon.bajaui().getText("dialog.ok"));
        this.cancelButton.setText(UiLexicon.bajaui().getText("dialog.cancel"));
        this.linkTo("linkA", (BComponent)this.okButton, (Slot)BButton.actionPerformed, (Slot)okButtonPressed);
        this.linkTo("linkB", (BComponent)this.cancelButton, (Slot)BButton.actionPerformed, (Slot)cancelButtonPressed);
        this.linkTo("linkC", (BComponent)this.password, (Slot)BPasswordField.textModified, (Slot)passwordModified);
        this.linkTo("linkD", (BComponent)this.confirmedPassword, (Slot)BPasswordField.textModified, (Slot)passwordModified);
        BGridPane buttonPane = new BGridPane(2);
        buttonPane.setColumnAlign(BHalign.fill);
        buttonPane.setUniformColumnWidth(true);
        buttonPane.add(null, (BValue)this.okButton);
        buttonPane.add(null, (BValue)this.cancelButton);
        return new BBorderPane((BWidget)buttonPane, 7.0, 7.0, 7.0, 7.0);
    }

    public void doOkButtonPressed(BWidgetEvent event) throws Exception {
        BPassword confirmedValue;
        BPassword passwordValue = this.password.getPassword();
        if (!passwordValue.validate(confirmedValue = this.confirmedPassword.getPassword())) {
            BDialog.error((BWidget)this, (Object)this.lexValue("passwordMismatch", new Object[0]));
            return;
        }
        if (this.username.getText().isEmpty()) {
            BDialog.error((BWidget)this, (Object)this.lexValue("usernameRequired", new Object[0]));
            return;
        }
        this.result = new BAddStationUserStep(this.username.getText(), this.password.getPassword(), this.isAdmin.getSelected());
        this.close();
    }

    public void doCancelButtonPressed(BWidgetEvent event) throws Exception {
        this.close();
    }

    public void doPasswordModified(BWidgetEvent event) {
        this.okButton.setEnabled(this.password.getPassword().validate(this.confirmedPassword.getPassword()));
    }

    protected String lexValue(String key, Object ... parameters) {
        return this.getLexicon().getText(this.getType().getTypeName() + "." + key, parameters);
    }

    public BAddStationUserStep getResult() {
        return this.result;
    }
}

