/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui;

import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.ui.StationModel;
import com.tridium.provisioningNiagara.BPlatformConnection;
import com.tridium.provisioningNiagara.BProvisioningNiagaraNetworkExt;
import com.tridium.ui.theme.Theme;
import javax.baja.driver.BDeviceFolder;
import javax.baja.driver.BIDeviceFolder;
import javax.baja.driver.ui.device.BDeviceManager;
import javax.baja.driver.ui.device.DeviceController;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.ViewQuery;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableModel;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.component.table.BComponentTable;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrModel;

public class BProvisioningManager
extends BDeviceManager {
    public static final Type TYPE = Sys.loadType(BProvisioningManager.class);
    protected static final Lexicon LEX = Lexicon.make(BProvisioningManager.class);
    protected static final BBrush CUT_FG = BColor.make((int)100, (int)100, (int)100).toBrush();
    private static final String LEX_USER = LEX.getText("platformConnection.username");
    private static final String LEX_PASSWORD = LEX.getText("platformConnection.password");
    private static final String LEX_PORT = LEX.getText("platformConnection.port");
    private static final String LEX_SECURE = LEX.getText("platformConnection.secure");
    private static final String LEX_STATUS = LEX.getText("platformConnection.status");
    private static final String LEX_HEALTH = LEX.getText("platformConnection.health");
    private static final String LEX_NOT_PROVISIONING = LEX.getText("ProvisioningManager.notProvisioning");
    protected BIDeviceFolder folder;
    protected BNiagaraNetwork network;
    protected TableCellRenderer extRenderer = new ExtCellRenderer();
    protected TableCellRenderer renderer = new PlatformCellRenderer();
    protected BImage[] extIcons = new BImage[]{BImage.make((BIcon)BIcon.std((String)"computer.png")), BImage.make((String)"module://provisioningNiagara/icons/software.png")};
    protected String[] extNames = new String[]{"provisioningNiagara_StationProxy", "provisioningNiagara_SoftwareStationExt"};
    protected double extsWidth = 4 + this.extNames.length * 20 + 4;

    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    public void doLoadValue(BObject value, Context cx) {
        super.doLoadValue(value, cx);
        this.folder = (BIDeviceFolder)value;
        try {
            this.network = (BNiagaraNetwork)this.folder.getNetwork();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.network == null || ((BProvisioningNiagaraNetworkExt[])this.network.getChildren(BProvisioningNiagaraNetworkExt.class)).length == 0) {
            this.setContent((BWidget)new BLabel(LEX_NOT_PROVISIONING));
        }
    }

    protected class ExtCellRenderer
    extends PlatformCellRenderer {
        protected ExtCellRenderer() {
        }

        @Override
        public double getPreferredCellWidth(TableCellRenderer.Cell cell) {
            return BProvisioningManager.this.extsWidth;
        }

        @Override
        public void paintCell(Graphics g, TableCellRenderer.Cell cell) {
            this.paintCellBackground(g, cell);
            if (cell.value instanceof BDeviceFolder) {
                return;
            }
            for (int i = 0; i < BProvisioningManager.this.extIcons.length; ++i) {
                g.drawImage(BProvisioningManager.this.extIcons[i], (double)(4 + i * 20), (cell.height - 16.0) / 2.0);
            }
        }

        @Override
        public BBrush getBackground(TableCellRenderer.Cell cell) {
            if (cell.value instanceof BDeviceFolder) {
                return Theme.table().getGridBrush();
            }
            return super.getBackground(cell);
        }
    }

    protected class PlatformCellRenderer
    extends TableCellRenderer {
        protected PlatformCellRenderer() {
        }

        public BBrush getForeground(TableCellRenderer.Cell cell) {
            BComponent comp = this.getComponentTable().getComponentModel().getComponentAt(cell.row);
            if (comp instanceof BNiagaraStation) {
                try {
                    BNiagaraStation station = (BNiagaraStation)comp;
                    if (station.isPendingMove()) {
                        return CUT_FG;
                    }
                    BPlatformConnection conn = (BPlatformConnection)station.getMixIn(BPlatformConnection.TYPE);
                    BColor c = (BColor)conn.getStatus().getForegroundColor(null);
                    if (c != null) {
                        return c.toBrush();
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
            return super.getForeground(cell);
        }

        public BBrush getBackground(TableCellRenderer.Cell cell) {
            BComponent comp = this.getComponentTable().getComponentModel().getComponentAt(cell.row);
            if (comp instanceof BDeviceFolder) {
                return Theme.table().getGridBrush();
            }
            try {
                BNiagaraStation station = (BNiagaraStation)comp;
                BPlatformConnection conn = (BPlatformConnection)station.getMixIn(BPlatformConnection.TYPE);
                BColor c = (BColor)conn.getStatus().getBackgroundColor(null);
                if (c != null) {
                    return c.toBrush();
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            return super.getBackground(cell);
        }

        protected BComponentTable getComponentTable() {
            return BProvisioningManager.this.getModel().getTable();
        }

        public double getPreferredCellWidth(TableCellRenderer.Cell cell) {
            String s = this.getCellText(cell);
            double w = this.getFont(cell).width(s) + 12.0;
            if (cell.column == 0 && this.getComponentTable().getModel().getRowIcon(cell.row) != null) {
                w += 20.0;
            }
            return w;
        }

        public void paintCell(Graphics g, TableCellRenderer.Cell cell) {
            BImage icon;
            TableModel model = this.getComponentTable().getModel();
            this.paintCellBackground(g, cell);
            double x = 2.0;
            double y = (cell.height - 16.0) / 2.0;
            if (cell.column == 0 && (icon = model.getRowIcon(cell.row)) != null) {
                g.drawImage(icon, x, y);
                x += 20.0;
            }
            String s = this.getCellText(cell);
            BFont font = this.getFont(cell);
            switch (model.getColumnAlignment(cell.column).getOrdinal()) {
                case 2: {
                    x = cell.width - 2.0 - font.width(s);
                    break;
                }
                case 1: {
                    x = (cell.width - font.width(s)) / 2.0;
                }
            }
            g.setFont(font);
            g.drawString(s, x, (cell.height + font.getAscent() - font.getDescent()) / 2.0);
        }

        public String getCellText(TableCellRenderer.Cell cell) {
            if (cell.value instanceof BObject) {
                return ((BObject)cell.value).toString(null);
            }
            return String.valueOf(cell.value);
        }
    }

    protected class Exts
    extends MgrColumn {
        public Exts() {
            super(LEX.getText("ProvisioningManager.extsColumn"), 0);
        }

        public Object get(Object row) {
            return row;
        }

        public TableCellRenderer getCellRenderer() {
            return BProvisioningManager.this.extRenderer;
        }

        void cellDoubleClicked(BMgrTable table, BMouseEvent event, int row, int col) {
            BWbShell shell;
            RectGeom rect = table.getCellBounds(row, col);
            BComponent component = table.getComponentAt(row);
            if (component instanceof BDeviceFolder) {
                return;
            }
            int x = (int)(event.getX() - rect.x);
            int index = (x - 4) / 20;
            if (0 <= index && index < BProvisioningManager.this.extNames.length && (shell = table.getManager().getWbShell()) != null) {
                BOrd ord = BOrd.make((String)(component.getNavOrd().toString() + "/" + BProvisioningManager.this.extNames[index]));
                shell.hyperlink(new HyperlinkInfo(ord, (BInputEvent)event));
            }
        }
    }

    protected class Addr
    extends MgrColumn.Prop {
        public Addr() {
            super(BNiagaraStation.address, 4);
        }

        public TableCellRenderer getCellRenderer() {
            return BProvisioningManager.this.renderer;
        }
    }

    protected class Mixin
    extends MgrColumn.MixinProp {
        public Mixin(Type mixinType, String label, Property[] propPath, int flags) {
            super(mixinType, label, propPath, flags);
        }

        public Mixin(Type mixinType, Property[] propPath, int flags) {
            super(mixinType, propPath, flags);
        }

        public TableCellRenderer getCellRenderer() {
            return BProvisioningManager.this.renderer;
        }
    }

    protected class Name
    extends MgrColumn.Name {
        public Name() {
            super(4);
        }

        public TableCellRenderer getCellRenderer() {
            return BProvisioningManager.this.renderer;
        }
    }

    protected class Model
    extends StationModel {
        private MgrColumn nameCol;
        private MgrColumn extsCol;
        private MgrColumn addrCol;
        private MgrColumn statusCol;
        private MgrColumn healthCol;
        private MgrColumn userCol;
        private MgrColumn passCol;
        private MgrColumn portCol;
        private MgrColumn secureCol;
        private MgrColumn[] cols;

        public Model(BProvisioningManager manager) {
            super((BDeviceManager)manager);
            this.nameCol = new Name();
            this.extsCol = new Exts();
            this.addrCol = new Addr();
            this.statusCol = new Mixin(BPlatformConnection.TYPE, LEX_STATUS, new Property[]{BPlatformConnection.status}, 4);
            this.healthCol = new Mixin(BPlatformConnection.TYPE, LEX_HEALTH, new Property[]{BPlatformConnection.health}, 4);
            this.userCol = new Mixin(BPlatformConnection.TYPE, LEX_USER, new Property[]{BPlatformConnection.credentials, BUsernameAndPassword.username}, 3);
            this.passCol = new Mixin(BPlatformConnection.TYPE, LEX_PASSWORD, new Property[]{BPlatformConnection.credentials, BUsernameAndPassword.password}, 3);
            this.portCol = new Mixin(BPlatformConnection.TYPE, LEX_PORT, new Property[]{BPlatformConnection.port}, 3);
            this.secureCol = new Mixin(BPlatformConnection.TYPE, LEX_SECURE, new Property[]{BPlatformConnection.secure}, 3);
            this.cols = new MgrColumn[]{this.nameCol, this.extsCol, this.addrCol, this.statusCol, this.healthCol, this.userCol, this.passCol, this.portCol, this.secureCol};
        }

        protected String makeTableTitle() {
            return BProvisioningManager.this.getType().getDisplayName(null);
        }

        protected MgrColumn[] makeColumns() {
            return this.cols;
        }

        protected boolean subscribeToChild(BComponent parent, BComponent child) {
            return child instanceof BPlatformConnection;
        }
    }

    protected class Controller
    extends DeviceController {
        public Controller(BProvisioningManager manager) {
            super((BDeviceManager)manager);
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            return new MgrController.IMgrCommand[]{this.allDescendants, this.edit};
        }

        public void cellDoubleClicked(BMgrTable table, BMouseEvent event, int row, int col) {
            MgrColumn mgrCol = table.columnIndexToMgrColumn(col);
            if (mgrCol instanceof Exts) {
                ((Exts)mgrCol).cellDoubleClicked(table, event, row, col);
            } else {
                Model model = (Model)this.getManager().getModel();
                Type folderType = model.getFolderType();
                BComponent comp = this.getTable().getComponentAt(row);
                BWbShell shell = this.getManager().getWbShell();
                if (comp != null && comp.getType().is(folderType) && shell != null) {
                    shell.hyperlink(new HyperlinkInfo(BOrd.make((BOrd)comp.getNavOrd(), (OrdQuery)new ViewQuery(BProvisioningManager.this.getType().toString())), (BInputEvent)event));
                    return;
                }
                super.cellDoubleClicked(table, event, row, col);
            }
        }
    }
}

