/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.tls;

import com.tridium.fox.sys.BFoxService;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.nd.BNiagaraStation;
import com.tridium.platform.BPlatformSSLSettings;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.UpdateSSLSettingsMessage;
import com.tridium.provisioningNiagara.ProvisioningConnectionUtil;
import java.util.Collections;
import java.util.Set;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.driver.BDeviceJobStep;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.driver.BDevice;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.platform.RemoteStation;
import javax.baja.security.crypto.BSslTlsEnum;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.BWebService;

@NiagaraType
@NiagaraProperty(name="tlsLevel", type="BSslTlsEnum", defaultValue="BSslTlsEnum.DEFAULT")
public class BSetTlsLevelJobStep
extends BDeviceJobStep {
    public static final Property tlsLevel = BSetTlsLevelJobStep.newProperty((int)0, (BValue)BSslTlsEnum.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BSetTlsLevelJobStep.class);

    public BSslTlsEnum getTlsLevel() {
        return (BSslTlsEnum)this.get(tlsLevel);
    }

    public void setTlsLevel(BSslTlsEnum v) {
        this.set(tlsLevel, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BSetTlsLevelJobStep() {
    }

    public BSetTlsLevelJobStep(BSslTlsEnum tlsLevel) {
        this.setTlsLevel(tlsLevel);
    }

    protected void doRun(BBatchJobService svc, BDeviceStepDetails details, BDevice device, DeviceNetworkJobOp op) throws Exception {
        ProvisioningConnectionUtil util = new ProvisioningConnectionUtil(device, details);
        BDaemonSession session = util.getDaemonSession();
        if (!session.getHostProperties().isNiagara4()) {
            details.failed("provisioningNiagara", "SetTlsLevelJobStep.failed.notN4");
            details.complete(BJobState.failed);
            return;
        }
        boolean stationRunning = util.hasRunningStation();
        if (stationRunning) {
            BFoxSession foxSession = util.getEngagedFoxSession();
            try {
                BWebService webService = (BWebService)BOrd.make((String)"service:web:WebService").get((BObject)foxSession);
                webService.lease();
                webService.setHttpsMinProtocol(this.getTlsLevel());
                details.message("provisioningNiagara", "SetTlsLevelJobStep.webSet");
            }
            catch (Exception e) {
                details.message("provisioningNiagara", "SetTlsLevelJobStep.error.webService");
            }
            try {
                BFoxService foxService = (BFoxService)BOrd.make((String)"service:fox:FoxService").get((BObject)foxSession);
                foxService.lease();
                foxService.setFoxsMinProtocol(this.getTlsLevel());
                details.message("provisioningNiagara", "SetTlsLevelJobStep.foxSet");
            }
            catch (Exception e) {
                details.message("provisioningNiagara", "SetTlsLevelJobStep.error.foxService");
            }
            util.disengageFoxSession();
        } else {
            RemoteStation station = util.getRemoteStation(((BNiagaraStation)device).getStationName());
            try {
                station.updateStationTlsVersion(this.getTlsLevel().getTag());
                details.message("provisioningNiagara", "SetTlsLevelJobStep.webSet");
                details.message("provisioningNiagara", "SetTlsLevelJobStep.foxSet");
            }
            catch (Exception e) {
                details.message("provisioningNiagara", "SetTlsLevelJobStep.error.remoteStation");
            }
        }
        BRemoteDaemonPlatform remoteDaemonPlatform = util.getRemoteDaemonPlatform();
        BPlatformSSLSettings current = remoteDaemonPlatform.getPlatformSSLSettings();
        current.setSslAlgType(this.getTlsLevel());
        UpdateSSLSettingsMessage message = new UpdateSSLSettingsMessage(current, true);
        util.sendDaemonMessage((DaemonMessage)message);
        details.message("provisioningNiagara", "SetTlsLevelJobStep.platformSet");
        details.success();
    }

    public Set<BDevice> getParallelExecutionConflicts(BBatchJobService svc, BDevice device, Set<BDevice> allDevices, DeviceNetworkJobOp op) {
        return Collections.singleton(device);
    }
}

