/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.tls;

import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.io.ICoreKeyStore;
import com.tridium.fox.sys.BFoxService;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.nd.BNiagaraStation;
import com.tridium.platcrypto.daemon.BPlatCryptoManager;
import com.tridium.platform.BPlatformSSLSettings;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.UpdateSSLSettingsMessage;
import com.tridium.provisioningNiagara.ProvisioningConnectionUtil;
import java.util.Collections;
import java.util.Set;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.driver.BDeviceJobStep;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.platform.RemoteStation;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.BWebService;

@NiagaraType
@NiagaraProperty(name="alias", type="String", defaultValue="BString.DEFAULT")
public class BSetCertificateAliasJobStep
extends BDeviceJobStep {
    public static final Property alias = BSetCertificateAliasJobStep.newProperty((int)0, (BValue)BString.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BSetCertificateAliasJobStep.class);
    private static final BFacets TIMESTAMP_FORMAT = BFacets.make((String[])new String[]{"timeFormat", "showDate", "showTime", "showSeconds", "showMilliseconds"}, (BIDataValue[])new BIDataValue[]{BString.make((String)"YYYYMMDD_HHmmss"), BBoolean.TRUE, BBoolean.TRUE, BBoolean.TRUE, BBoolean.TRUE});

    public String getAlias() {
        return this.getString(alias);
    }

    public void setAlias(String v) {
        this.setString(alias, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BSetCertificateAliasJobStep() {
    }

    public BSetCertificateAliasJobStep(String alias) {
        this.setAlias(alias);
    }

    protected void doRun(BBatchJobService svc, BDeviceStepDetails details, BDevice device, DeviceNetworkJobOp op) throws Exception {
        ProvisioningConnectionUtil util = new ProvisioningConnectionUtil(device, details);
        String alias = this.getAlias();
        if (!BSetCertificateAliasJobStep.serverCertificateExists(util.getDaemonSession(), alias)) {
            details.vaFailed("SetCertificateAliasJobStep.failed.missingAlias", new String[]{alias});
            details.complete(BJobState.failed);
            return;
        }
        boolean stationRunning = util.hasRunningStation();
        if (stationRunning) {
            BFoxSession foxSession = util.getEngagedFoxSession();
            try {
                BWebService webService = (BWebService)BOrd.make((String)"service:web:WebService").get((BObject)foxSession);
                webService.lease();
                webService.setHttpsCert(alias);
                details.message("provisioningNiagara", "SetCertificateAliasJobStep.webSet");
            }
            catch (Exception e) {
                details.message("provisioningNiagara", "SetCertificateAliasJobStep.error.webService");
            }
            try {
                BFoxService foxService = (BFoxService)BOrd.make((String)"service:fox:FoxService").get((BObject)foxSession);
                foxService.lease();
                foxService.setFoxsCert(alias);
                details.message("provisioningNiagara", "SetCertificateAliasJobStep.foxSet");
            }
            catch (Exception e) {
                details.message("provisioningNiagara", "SetCertificateAliasJobStep.error.foxService");
            }
            util.disengageFoxSession();
        } else {
            RemoteStation station = util.getRemoteStation(((BNiagaraStation)device).getStationName());
            station.updateStationCertAlias(alias);
            details.message("provisioningNiagara", "SetCertificateAliasJobStep.webSet");
            details.message("provisioningNiagara", "SetCertificateAliasJobStep.foxSet");
        }
        BRemoteDaemonPlatform remoteDaemonPlatform = util.getRemoteDaemonPlatform();
        BPlatformSSLSettings current = remoteDaemonPlatform.getPlatformSSLSettings();
        current.setKeyAlias(alias);
        UpdateSSLSettingsMessage message = new UpdateSSLSettingsMessage(current, false);
        util.sendDaemonMessage((DaemonMessage)message);
        details.message("provisioningNiagara", "SetCertificateAliasJobStep.platformSet");
        details.success();
    }

    private static boolean serverCertificateExists(BDaemonSession session, String alias) throws Exception {
        return CertUtils.isValidServerCert((String)alias, (ICoreKeyStore)new BPlatCryptoManager(session).getKeyStore());
    }

    public Set<BDevice> getParallelExecutionConflicts(BBatchJobService svc, BDevice device, Set<BDevice> allDevices, DeviceNetworkJobOp op) {
        return Collections.singleton(device);
    }
}

