/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.template;

import com.tridium.data.BDataRow;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.data.BDataChannel;
import com.tridium.install.BVersion;
import com.tridium.nd.BNiagaraStation;
import com.tridium.provisioningNiagara.BProvisioningStationExt;
import com.tridium.template.TemplateConst;
import com.tridium.template.file.BNtplFile;
import com.tridium.template.ui.file.BWbDeployableNtplFile;
import com.tridium.util.EscUtil;
import java.util.ArrayList;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BIcon;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;
import javax.baja.util.Lexicon;

@NiagaraType(agent={@AgentOn(types={"niagaraDriver:NiagaraStation"})})
@NiagaraActions(value={@NiagaraAction(name="details", flags=16), @NiagaraAction(name="compare", parameterType="baja:Ord", defaultValue="BOrd.DEFAULT", returnType="BVector", flags=4)})
public class BTemplateStationExt
extends BProvisioningStationExt {
    public static final Action details = BTemplateStationExt.newAction((int)16, null);
    public static final Action compare = BTemplateStationExt.newAction((int)4, (BValue)BOrd.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BTemplateStationExt.class);
    Level PROVISION_LOG_LEVEL = Level.FINE;
    public static final String interest = "templateStationExt";
    private static final BIcon icon = BIcon.std((String)"files/ntpl.png");
    private static final Logger LOGGER = Logger.getLogger("provisioningNiagara");
    public static final Lexicon lex = Lexicon.make((String)"provisioningNiagara");

    public void details() {
        this.invoke(details, null, null);
    }

    public BVector compare(BOrd parameter) {
        return (BVector)this.invoke(compare, (BValue)parameter, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public String getDisplayNameInParent(Context cx) {
        return Lexicon.make((BModule)TYPE.getModule(), (Context)cx).getText("TemplateStationExt");
    }

    public void doDetails() throws Exception {
        if (this.isUnoperational()) {
            return;
        }
        TemplateQuery tq = new TemplateQuery();
        BITable itable = (BITable)this.runQuery(tq.toString());
        ColumnList columns = itable.getColumns();
        TableCursor cursor = itable.cursor();
        while (cursor.next()) {
            BDataRow dataRow = (BDataRow)cursor.get();
            for (Column c : columns.list()) {
                LOGGER.info(c.getName() + " = " + dataRow.cell(c).toString());
            }
        }
    }

    public BVector doCompare(BOrd ntplFileOrd) throws Exception {
        BVector resultVector = new BVector();
        if (this.isUnoperational()) {
            return resultVector;
        }
        BIFile ntplFile = (BIFile)ntplFileOrd.resolve().get();
        if (!ntplFile.getExtension().equalsIgnoreCase("ntpl")) {
            LOGGER.log(Level.WARNING, lex.getText("TemplateStationExt.fileOrdNotTemplateFile", new Object[]{ntplFileOrd}));
            return resultVector;
        }
        if (!(ntplFile instanceof BNtplFile)) {
            LOGGER.log(Level.WARNING, lex.getText("TemplateStationExt.fileOrdNotTemplate", new Object[]{ntplFileOrd}));
            return resultVector;
        }
        BWbDeployableNtplFile templateFile = BWbDeployableNtplFile.make((BNtplFile)((BNtplFile)ntplFile));
        InstanceQuery iq = new InstanceQuery(templateFile.getUID(), templateFile.getVendor());
        LOGGER.log(this.PROVISION_LOG_LEVEL, "BQL query: " + iq.toString());
        BITable itable = (BITable)this.runQuery(iq.toString());
        ColumnList columns = itable.getColumns();
        TableCursor cursor = itable.cursor();
        while (cursor.next()) {
            BDataRow dataRow = (BDataRow)cursor.get();
            BVersion deployedVersion = BVersion.ZERO;
            String deployedVendor = "";
            String deployedSlotPath = "";
            for (Column c : columns.list()) {
                LOGGER.log(this.PROVISION_LOG_LEVEL, c.getName() + " = " + dataRow.cell(c).toString());
                if (c.getName().contentEquals(TemplateConst.VERSION_TAG_NAME)) {
                    deployedVersion = new BVersion(dataRow.cell(c).toString());
                }
                if (c.getName().contentEquals(TemplateConst.VENDOR_TAG_NAME)) {
                    deployedVendor = dataRow.cell(c).toString();
                }
                if (!c.getName().contentEquals("slotPath")) continue;
                deployedSlotPath = dataRow.cell(c).toString();
            }
            BVersion cacheVersion = new BVersion(templateFile.getVersion());
            if (!deployedVendor.contentEquals(templateFile.getVendor())) {
                LOGGER.log(Level.WARNING, lex.getText("TemplateStationExt.vendorMismatch", new Object[]{templateFile.getTitle()}));
                continue;
            }
            int versionComparison = cacheVersion.compareTo((Object)deployedVersion);
            if (versionComparison == 0) continue;
            resultVector.add(SlotPath.escape((String)deployedSlotPath), (BValue)deployedVersion);
        }
        return resultVector;
    }

    private void compareResult(String title, String slotPath, String result) {
        LOGGER.log(Level.INFO, "Template " + title + " at slot path " + slotPath + " " + result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BObject runQuery(String queryString) throws Exception {
        BObject result;
        BNiagaraStation station = this.getNiagaraStation();
        BFoxClientConnection clientConnection = station.getClientConnection();
        BDataChannel channel = (BDataChannel)clientConnection.getChannels().get("data", BDataChannel.TYPE);
        BFoxClientConnection.StringInterest interest = new BFoxClientConnection.StringInterest(interest + Clock.ticks());
        try {
            clientConnection.engageNoRetry((BFoxClientConnection.Interest)interest);
            result = channel.resolve(BOrd.make((String)queryString));
        }
        finally {
            clientConnection.disengage((BFoxClientConnection.Interest)interest);
        }
        return result;
    }

    private String escape(String s) {
        return EscUtil.slot.escape(s).replaceAll("\\$", "\\$24");
    }

    public BIcon getIcon() {
        return icon;
    }

    private class InstanceQuery
    extends TemplateQuery {
        private InstanceQuery(BUuid uid, String vendor) {
            this.endQuery = " from baja:Component where ntpl$243atemplate != NULL and " + BTemplateStationExt.this.escape(TemplateConst.TEMPLATE_UID_TAG_ID.getQName()) + " = '" + uid + "' and " + BTemplateStationExt.this.escape(TemplateConst.TEMPLATE_VENDOR_TAG_ID.getQName()) + " = '" + vendor + "'";
        }
    }

    private class TemplateQuery {
        protected String startQuery = "station:|slot:/|bql:select ";
        protected String endQuery = " from baja:Component where ntpl$243atemplate != NULL";
        protected ArrayList<Pair> queryList = new ArrayList();

        private TemplateQuery() {
            this.queryList.add(new Pair(TemplateConst.TEMPLATE_VENDOR_TAG_ID.getName(), BTemplateStationExt.this.escape(TemplateConst.TEMPLATE_VENDOR_TAG_ID.getQName())));
            this.queryList.add(new Pair(TemplateConst.TEMPLATE_VERSION_TAG_ID.getName(), BTemplateStationExt.this.escape(TemplateConst.TEMPLATE_VERSION_TAG_ID.getQName())));
            this.queryList.add(new Pair(TemplateConst.TEMPLATE_TITLE_TAG_ID.getName(), BTemplateStationExt.this.escape(TemplateConst.TEMPLATE_TITLE_TAG_ID.getQName())));
            this.queryList.add(new Pair(TemplateConst.TEMPLATE_FILE_TAG_ID.getName(), BTemplateStationExt.this.escape(TemplateConst.TEMPLATE_FILE_TAG_ID.getQName())));
            this.queryList.add(new Pair("templateName", "templateConfig.templateName"));
            this.queryList.add(new Pair("slotPath", "slotPath"));
        }

        public String toString() {
            StringJoiner sj = new StringJoiner(",", this.startQuery, this.endQuery);
            for (Pair p : this.queryList) {
                sj.add(p.value + " as '" + p.key + "'");
            }
            return sj.toString();
        }
    }

    private class Pair {
        String key;
        String value;

        Pair(String k, String v) {
            this.key = k;
            this.value = v;
        }
    }
}

