/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.template;

import com.tridium.provisioningNiagara.ProvisioningConnectionUtil;
import com.tridium.provisioningNiagara.template.BAbstractDeployStep;
import com.tridium.provisioningNiagara.template.ProvisioningBulkDeployUtil;
import com.tridium.template.BTemplateConfig;
import com.tridium.template.ui.BulkDeployUtil;
import java.util.HashMap;
import java.util.logging.Level;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.file.BIFile;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.job.BJobState;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BStation;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BNameMap;

@NiagaraType
public class BDeployApplicationStep
extends BAbstractDeployStep {
    public static final Type TYPE = Sys.loadType(BDeployApplicationStep.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    public BDeployApplicationStep() {
    }

    public BDeployApplicationStep(BIFile srcFile) {
        this.setExcelFileOrd(srcFile.getOrdInSession());
    }

    @Override
    protected boolean installTemplate(BulkDeployUtil.DeployedWorksheet deployedWorksheet, BulkDeployUtil.DeployedRoot deployedRoot, ProvisioningBulkDeployUtil bulkDeploy, BDeviceStepDetails details, ProvisioningConnectionUtil util, DeviceNetworkJobOp opIn, HashMap<BComponent, BNameMap> displayNames) {
        if ("Application".contentEquals(deployedWorksheet.templateType)) {
            BStation station = bulkDeploy.installApplicationToStation(deployedWorksheet, deployedRoot, details, util, opIn);
            if (details.getState().isComplete()) {
                log.log(Level.WARNING, BulkDeployUtil.lex.getText("bulkDeploy.excelImport.applicationInstallError", new Object[]{details.getDeviceDisplayName()}));
                return false;
            }
            try {
                Thread.sleep(5000L);
                station.lease();
            }
            catch (IllegalStateException se) {
                log.log(Level.INFO, BulkDeployUtil.lex.getText("bulkDeploy.excelImport.applicationInstallError"));
            }
            catch (Exception se) {
                // empty catch block
            }
            BTemplateConfig templateConfig = BTemplateConfig.getConfigForRoot((BComponent)station);
            if (templateConfig == null) {
                log.log(Level.WARNING, BulkDeployUtil.lex.getText("bulkDeploy.excelImport.invalidTemplateError", new Object[]{deployedWorksheet.templateFile}));
                return false;
            }
            templateConfig.lease();
            templateConfig.subscribed();
            if (deployedRoot.getConfigs() != null) {
                details.message("template", "installApplication.applyingConfigs");
                bulkDeploy.setConfigsFromWorksheet(deployedWorksheet, deployedRoot, (BComponent)station, templateConfig, false);
            }
            if (deployedRoot.getOptionalConfigs() != null) {
                details.message("template", "installApplication.applyingOptionalConfigs");
                bulkDeploy.setOptionalConfigsFromWorksheet(deployedWorksheet, deployedRoot, (BComponent)station, templateConfig, false);
            }
            if (deployedRoot.getTags() != null) {
                details.message("template", "installApplication.applyingTags");
                bulkDeploy.setTagsFromWorksheet(deployedWorksheet, deployedRoot, (BComponent)station);
            }
            if (deployedRoot.isEnableHistories()) {
                BHistoryExt[] unconfigurableHistories;
                details.message("template", "installApplication.applyingHistories");
                for (BHistoryExt historyExt : unconfigurableHistories = bulkDeploy.unconfigurableHistoryExtensions((BComponent)station)) {
                    historyExt.setEnabled(true);
                }
            }
        } else {
            details.failed("provisioningNiagara", "DeployTemplateStep.appFileError", new String[]{deployedWorksheet.title});
            details.complete(BJobState.failed);
            return false;
        }
        return true;
    }

    @Override
    public String toString(Context cx) {
        return lex.getText("DeployApplicationFactory.display", new Object[]{this.getExcelFileOrd().toString()});
    }
}

