/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.systempassphrase;

import com.tridium.batchJob.driver.BIPrivilegedDeviceJobStep;
import com.tridium.platDaemon.ui.FipsOptionsHelper;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.SystemPasswordMessage;
import com.tridium.provisioningNiagara.ProvisioningConnectionUtil;
import java.security.AccessController;
import java.util.Collections;
import java.util.Set;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.driver.BDeviceJobStep;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.driver.BDevice;
import javax.baja.job.BJobState;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BPasswordStrength;
import javax.baja.xml.XElem;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="oldPassword", type="BPassword", defaultValue="BPassword.DEFAULT"), @NiagaraProperty(name="newPassword", type="BPassword", defaultValue="BPassword.DEFAULT"), @NiagaraProperty(name="isFips", type="BBoolean", defaultValue="BBoolean.FALSE")})
public class BSetSystemPassphraseJobStep
extends BDeviceJobStep
implements BIPrivilegedDeviceJobStep {
    public static final Property oldPassword = BSetSystemPassphraseJobStep.newProperty((int)0, (BValue)BPassword.DEFAULT, null);
    public static final Property newPassword = BSetSystemPassphraseJobStep.newProperty((int)0, (BValue)BPassword.DEFAULT, null);
    public static final Property isFips = BSetSystemPassphraseJobStep.newProperty((int)0, (boolean)BBoolean.FALSE.getBoolean(), null);
    public static final Type TYPE = Sys.loadType(BSetSystemPassphraseJobStep.class);

    public BPassword getOldPassword() {
        return (BPassword)this.get(oldPassword);
    }

    public void setOldPassword(BPassword v) {
        this.set(oldPassword, (BValue)v, null);
    }

    public BPassword getNewPassword() {
        return (BPassword)this.get(newPassword);
    }

    public void setNewPassword(BPassword v) {
        this.set(newPassword, (BValue)v, null);
    }

    public boolean getIsFips() {
        return this.getBoolean(isFips);
    }

    public void setIsFips(boolean v) {
        this.setBoolean(isFips, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BSetSystemPassphraseJobStep() {
    }

    public BSetSystemPassphraseJobStep(BPassword oldPassword, BPassword newPassword, boolean isFips) {
        this.setOldPassword(oldPassword);
        this.setNewPassword(newPassword);
        this.setIsFips(isFips);
    }

    public BSetSystemPassphraseJobStep(BPassword oldPassword, BPassword newPassword) {
        this(oldPassword, newPassword, false);
    }

    protected void doRun(BBatchJobService svc, BDeviceStepDetails details, BDevice device, DeviceNetworkJobOp op) throws Exception {
        ProvisioningConnectionUtil util = new ProvisioningConnectionUtil(device, details);
        BDaemonSession daemonSession = util.getDaemonSession();
        XElem systemPasswordInfo = util.getDaemonResponse((DaemonMessage)new SystemPasswordMessage());
        if (systemPasswordInfo.getb("readonly", false)) {
            details.failed("provisioningNiagara", "SetSystemPassphraseJobStep.readonlyPassword");
            details.complete(BJobState.failed);
            return;
        }
        BPassword oldPassword = BPassword.make((String)AccessController.doPrivileged(() -> ((BPassword)this.getOldPassword()).getValue()));
        BPassword newPassword = BPassword.make((String)AccessController.doPrivileged(() -> ((BPassword)this.getNewPassword()).getValue()));
        BPasswordStrength passwordStrength = FipsOptionsHelper.getInstance().getPasswordStrengthRequirements(this.getIsFips(), daemonSession);
        try {
            passwordStrength.isPasswordValid(AccessController.doPrivileged(() -> ((BPassword)this.getNewPassword()).getValue()));
        }
        catch (Exception e) {
            details.failed("provisioningNiagara", "SetSystemPassphraseJobStep.weakPassword");
            details.complete(BJobState.failed);
            return;
        }
        try {
            util.sendDaemonMessage((DaemonMessage)new SystemPasswordMessage(null, oldPassword, true, util.generateDaemonSessionSharedSecretKey("setsystempassphrase")));
        }
        catch (Exception e) {
            details.failed("provisioningNiagara", "SetSystemPassphraseJobStep.currentMismatch");
            details.complete(BJobState.failed);
            return;
        }
        try {
            util.sendDaemonMessage((DaemonMessage)new SystemPasswordMessage(newPassword, null, true, util.generateDaemonSessionSharedSecretKey("setsystempassphrase")));
        }
        catch (Exception e) {
            details.failed("provisioningNiagara", "SetSystemPassphraseJobStep.defaultPassphrase");
            details.complete(BJobState.failed);
            return;
        }
        try {
            util.sendDaemonMessage((DaemonMessage)new SystemPasswordMessage(newPassword, oldPassword, false, util.generateDaemonSessionSharedSecretKey("setsystempassphrase")));
        }
        catch (Exception e) {
            details.failed("provisioningNiagara", "SetSystemPassphraseJobStep.error", (Throwable)e);
            details.complete(BJobState.failed);
            return;
        }
        FipsOptionsHelper.getInstance().updateSystemPassphraseCookie(daemonSession.getHostProperties().isFips() || this.getIsFips(), daemonSession);
    }

    public Set<BDevice> getParallelExecutionConflicts(BBatchJobService svc, BDevice device, Set<BDevice> allDevices, DeviceNetworkJobOp op) {
        return Collections.singleton(device);
    }
}

