/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.software;

import com.tridium.install.InstallScenario;
import com.tridium.install.installable.BDistribution;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.provisioningNiagara.NiagaraNetworkJobOp;
import com.tridium.provisioningNiagara.software.BAbstractSoftwareStep;
import java.util.ArrayList;
import java.util.Arrays;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.file.BIFile;
import javax.baja.file.BajaFileUtil;
import javax.baja.job.BJobState;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public class BInstallStep
extends BAbstractSoftwareStep {
    public static final Property toInstall = BInstallStep.newProperty((int)1, (BValue)new BDistribution(), null);
    public static final Property shouldCleanUp = BInstallStep.newProperty((int)1, (boolean)false, null);
    public static final Type TYPE = Sys.loadType(BInstallStep.class);
    private BISession fileSession = null;
    public static final Lexicon lex = Lexicon.make((String)"provisioningNiagara");

    public BInstallable getToInstall() {
        return (BInstallable)this.get(toInstall);
    }

    public void setToInstall(BInstallable v) {
        this.set(toInstall, (BValue)v, null);
    }

    public boolean getShouldCleanUp() {
        return this.getBoolean(shouldCleanUp);
    }

    public void setShouldCleanUp(boolean v) {
        this.setBoolean(shouldCleanUp, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BInstallStep() {
    }

    public BInstallStep(BIFile toInstall, boolean shouldCleanUp) {
        this(BInstallable.makeRemote((BIFile)toInstall), toInstall.getFileSpace().getSession(), shouldCleanUp);
    }

    public BInstallStep(BInstallable toInstall, BISession fileSession, boolean shouldCleanUp) {
        this.setToInstall((BInstallable)toInstall.newCopy());
        this.setShouldCleanUp(shouldCleanUp);
        this.fileSession = fileSession;
    }

    public void prepareStep(BObject target) throws Exception {
        BISession targetSession;
        if (this.fileSession != null && !(targetSession = BOrd.toSession((BObject)target)).equals(this.fileSession)) {
            BIFile from = (BIFile)this.getToInstall().getInstallableFileOrd().get((BObject)this.fileSession);
            BBatchJobService batch = (BBatchJobService)BOrd.make((String)"service:batchJob:BatchJobService").get(target);
            BIFile to = batch.makeTempFile(from.getExtension());
            BajaFileUtil.pipe((BIFile)from, (BIFile)to);
            this.getToInstall().setInstallableFileOrd(to.getOrdInSession());
            this.setShouldCleanUp(true);
        }
    }

    @Override
    public InstallScenario updateInstallScenario(BDeviceStepDetails details, DaemonSessionTaskListener listener, InstallScenario scenario, NiagaraNetworkJobOp op) throws Exception {
        ArrayList<BInstallable> toInstall = new ArrayList<BInstallable>(Arrays.asList(scenario.getToInstall()));
        BInstallable installable = this.getToInstall().makeLocalInstance();
        if (installable == null) {
            details.failed("provisioningNiagara", "InstallStep.installableNotFound", this.getToInstall().getInstallableFileOrd().toString((Context)op));
            details.complete(BJobState.failed);
            return scenario;
        }
        toInstall.add(installable);
        return new InstallScenario(scenario.getTargetPlatform(), listener, scenario.getModulesToUninstall(), scenario.getUnmetDependencies(), toInstall.toArray(new BInstallable[toInstall.size()]), (InstallableRegistry)LocalInstallableRegistry.getInstance(), scenario.getCertValidator());
    }

    @Override
    public void deviceNetworkJobComplete(DeviceNetworkJobOp op) {
        if (this.getShouldCleanUp()) {
            BIFile file = (BIFile)this.getToInstall().getInstallableFileOrd().get();
            try {
                file.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public BIcon getIcon() {
        return this.getToInstall().getIcon();
    }

    public String toString(Context cx) {
        return lex.getText("InstallStep.display", new Object[]{this.getToInstall().toString(cx)});
    }
}

