/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.software;

import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.BPartInstallStatus;
import com.tridium.install.InstallScenario;
import com.tridium.install.InstallableFilter;
import com.tridium.install.Jre8AzulDistLicenseFeatureFilter;
import com.tridium.install.Qnx7DistLicenseFeatureFilter;
import com.tridium.install.SolutionParameters;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.BInstallableSpec;
import com.tridium.install.installable.BModuleInstallable;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.install.part.BModulePart;
import com.tridium.install.part.BPart;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.provisioningNiagara.NiagaraNetworkJobOp;
import com.tridium.provisioningNiagara.software.BAbstractSoftwareStep;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.io.BIEncodable;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperty(name="toInstallList", type="BVector", defaultValue="new BVector()")
public class BInstallCombinedBySpecStep
extends BAbstractSoftwareStep
implements BIEncodable {
    public static final Property toInstallList = BInstallCombinedBySpecStep.newProperty((int)0, (BValue)new BVector(), null);
    public static final Type TYPE = Sys.loadType(BInstallCombinedBySpecStep.class);
    public static final Lexicon lex = Lexicon.make((String)"provisioningNiagara");
    private static final Logger LOG = Logger.getLogger("provisioningNiagara");

    public BVector getToInstallList() {
        return (BVector)this.get(toInstallList);
    }

    public void setToInstallList(BVector v) {
        this.set(toInstallList, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BInstallCombinedBySpecStep() {
    }

    public BInstallCombinedBySpecStep(List<BInstallableSpec> specs) {
        specs.forEach(spec -> this.getToInstallList().add(SlotPath.escape((String)spec.toString(null)), spec.newCopy()));
    }

    @Override
    public InstallScenario updateInstallScenario(BDeviceStepDetails details, DaemonSessionTaskListener listener, InstallScenario scenario, NiagaraNetworkJobOp op) throws Exception {
        ArrayList<BDependency> deps = new ArrayList<BDependency>(Arrays.asList(scenario.getUnmetDependencies()));
        Property[] properties = this.getToInstallList().getPropertiesArray();
        InstallableRegistry provisioningRegistry = scenario.getInstallableRegistry();
        if (provisioningRegistry == null) {
            provisioningRegistry = LocalInstallableRegistry.getInstance();
        }
        for (int i = 0; i < properties.length; ++i) {
            BInstallableSpec spec = (BInstallableSpec)this.getToInstallList().get(properties[i]);
            BDependency dependency = spec.asDependency();
            BInstallable installable = provisioningRegistry.findInstallable(dependency, listener);
            BDaemonPlatform daemonPlatform = scenario.getTargetPlatform();
            if (installable.getType().is(BModuleInstallable.TYPE)) {
                BModulePart modulePart = ((BModuleInstallable)installable).getModulePart();
                BPartInstallStatus installStatus = this.checkPartStatus((BPart)modulePart, daemonPlatform);
                if (installStatus != BPartInstallStatus.noChange) {
                    deps.add(spec.asDependency());
                    continue;
                }
                details.message("provisioningNiagara", "InstallSoftwareStep.skipInstallableNoChange", modulePart.getPartName());
                continue;
            }
            deps.add(spec.asDependency());
        }
        BDaemonPlatform daemonPlatform = scenario.getTargetPlatform();
        SolutionParameters parameters = new SolutionParameters(listener);
        if (!daemonPlatform.getIsNpsdk()) {
            List licenses = daemonPlatform.getDaemonSession().fetchLicenses();
            Qnx7DistLicenseFeatureFilter qnx7Filter = new Qnx7DistLicenseFeatureFilter();
            Jre8AzulDistLicenseFeatureFilter jre8AzulFilter = new Jre8AzulDistLicenseFeatureFilter();
            qnx7Filter.setLicenses((Collection)licenses);
            jre8AzulFilter.setLicenses((Collection)licenses);
            parameters.addFilter((InstallableFilter)qnx7Filter);
            parameters.addFilter((InstallableFilter)jre8AzulFilter);
        }
        return new InstallScenario(scenario.getTargetPlatform(), scenario.getModulesToUninstall(), deps.toArray(new BDependency[deps.size()]), scenario.getToInstall(), BTimeZone.NULL, null, null, null, parameters, provisioningRegistry, scenario.getCertValidator());
    }

    public void encode(DataOutput out) throws IOException {
        Property[] properties = this.getToInstallList().getPropertiesArray();
        out.writeInt(properties.length);
        for (int i = 0; i < properties.length; ++i) {
            ((BInstallableSpec)this.getToInstallList().get(properties[i])).encode(out);
        }
    }

    public BObject decode(DataInput in) throws IOException {
        ArrayList<BInstallableSpec> specList = new ArrayList<BInstallableSpec>();
        int size = in.readInt();
        if (size < 0) {
            return new BInstallCombinedBySpecStep();
        }
        for (int i = 0; i < size; ++i) {
            BInstallableSpec spec = (BInstallableSpec)BInstallableSpec.DEFAULT.decode(in);
            specList.add(spec);
        }
        return new BInstallCombinedBySpecStep(specList);
    }

    public String encodeToString() throws IOException {
        StringBuilder sb = new StringBuilder();
        Property[] properties = this.getToInstallList().getPropertiesArray();
        for (int i = 0; i < properties.length; ++i) {
            if (i > 0) {
                sb.append('|');
            }
            sb.append(((BInstallableSpec)this.getToInstallList().get(properties[i])).encodeToString());
        }
        return sb.toString();
    }

    public BObject decodeFromString(String s) throws IOException {
        String[] values = TextUtil.split((String)s, (char)'|');
        if (values == null || values.length == 0) {
            return new BInstallCombinedBySpecStep();
        }
        ArrayList<BInstallableSpec> specList = new ArrayList<BInstallableSpec>();
        for (String value : values) {
            BInstallableSpec spec = (BInstallableSpec)BInstallableSpec.DEFAULT.decodeFromString(value);
            specList.add(spec);
        }
        return new BInstallCombinedBySpecStep(specList);
    }

    public BIcon getIcon() {
        return BModuleInstallable.TYPE.getTypeInfo().getIcon(null);
    }

    public String toString(Context cx) {
        StringBuilder sb = new StringBuilder();
        Property[] properties = this.getToInstallList().getPropertiesArray();
        for (int i = 0; i < properties.length; ++i) {
            if (i > 0) {
                sb.append("; ");
            }
            sb.append(this.getToInstallList().get(properties[i]).toString(cx));
        }
        return lex.getText("InstallBySpecStep.display", new Object[]{sb.toString()});
    }
}

