/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.software;

import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.BPartInstallStatus;
import com.tridium.install.InstallScenario;
import com.tridium.install.InstallableFilter;
import com.tridium.install.Jre8AzulDistLicenseFeatureFilter;
import com.tridium.install.Qnx7DistLicenseFeatureFilter;
import com.tridium.install.SolutionParameters;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.BInstallableSpec;
import com.tridium.install.installable.BModuleInstallable;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.install.part.BModulePart;
import com.tridium.install.part.BPart;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.provisioningNiagara.NiagaraNetworkJobOp;
import com.tridium.provisioningNiagara.software.BAbstractSoftwareStep;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.io.BIEncodable;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.Lexicon;

public class BInstallBySpecStep
extends BAbstractSoftwareStep
implements BIEncodable {
    public static final Property toInstall = BInstallBySpecStep.newProperty((int)0, (BValue)new BInstallableSpec(), null);
    public static final Type TYPE = Sys.loadType(BInstallBySpecStep.class);
    public static final Lexicon lex = Lexicon.make((String)"provisioningNiagara");

    public BInstallableSpec getToInstall() {
        return (BInstallableSpec)this.get(toInstall);
    }

    public void setToInstall(BInstallableSpec v) {
        this.set(toInstall, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BInstallBySpecStep() {
    }

    public BInstallBySpecStep(BInstallableSpec toInstall) {
        this.setToInstall((BInstallableSpec)toInstall.newCopy());
    }

    @Override
    public InstallScenario updateInstallScenario(BDeviceStepDetails details, DaemonSessionTaskListener listener, InstallScenario scenario, NiagaraNetworkJobOp op) throws Exception {
        ArrayList<BDependency> deps = new ArrayList<BDependency>(Arrays.asList(scenario.getUnmetDependencies()));
        BDependency dependency = this.getToInstall().asDependency();
        LocalInstallableRegistry provisioningRegistry = LocalInstallableRegistry.getInstance();
        BInstallable installable = provisioningRegistry.findInstallable(dependency, listener);
        BDaemonPlatform daemonPlatform = scenario.getTargetPlatform();
        if (installable.getType().is(BModuleInstallable.TYPE)) {
            BModulePart modulePart = ((BModuleInstallable)installable).getModulePart();
            BPartInstallStatus installStatus = this.checkPartStatus((BPart)modulePart, daemonPlatform);
            if (installStatus != BPartInstallStatus.noChange) {
                deps.add(this.getToInstall().asDependency());
            } else {
                details.message("provisioningNiagara", "InstallSoftwareStep.skipInstallableNoChange", modulePart.getPartName());
            }
        } else {
            deps.add(this.getToInstall().asDependency());
        }
        SolutionParameters parameters = new SolutionParameters(listener);
        if (!daemonPlatform.getIsNpsdk()) {
            List licenses = daemonPlatform.getDaemonSession().fetchLicenses();
            Qnx7DistLicenseFeatureFilter qnx7Filter = new Qnx7DistLicenseFeatureFilter();
            Jre8AzulDistLicenseFeatureFilter jre8AzulFilter = new Jre8AzulDistLicenseFeatureFilter();
            qnx7Filter.setLicenses((Collection)licenses);
            jre8AzulFilter.setLicenses((Collection)licenses);
            parameters.addFilter((InstallableFilter)qnx7Filter);
            parameters.addFilter((InstallableFilter)jre8AzulFilter);
        }
        return new InstallScenario(scenario.getTargetPlatform(), scenario.getModulesToUninstall(), deps.toArray(new BDependency[deps.size()]), scenario.getToInstall(), BTimeZone.NULL, null, null, null, parameters, (InstallableRegistry)LocalInstallableRegistry.getInstance(), scenario.getCertValidator());
    }

    public BIcon getIcon() {
        if (this.getToInstall().getInstallableType().isNull()) {
            return BModuleInstallable.TYPE.getTypeInfo().getIcon(null);
        }
        return this.getToInstall().getInstallableType().getTypeInfo().getIcon(null);
    }

    public String toString(Context cx) {
        return lex.getText("InstallBySpecStep.display", new Object[]{this.getToInstall().toString(cx)});
    }

    public void encode(DataOutput out) throws IOException {
        this.getToInstall().encode(out);
    }

    public BObject decode(DataInput in) throws IOException {
        BInstallableSpec spec = (BInstallableSpec)BInstallableSpec.DEFAULT.decode(in);
        return new BInstallBySpecStep(spec);
    }

    public String encodeToString() throws IOException {
        return this.getToInstall().encodeToString();
    }

    public BObject decodeFromString(String s) throws IOException {
        BInstallableSpec spec = (BInstallableSpec)BInstallableSpec.DEFAULT.decodeFromString(s);
        return new BInstallBySpecStep(spec);
    }
}

