/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.software;

import com.tridium.crypto.core.cert.CertificateChainValidator;
import com.tridium.crypto.core.cert.NoOpCertificateChainValidator;
import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.file.types.bog.BBogFile;
import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.BPartInstallStatus;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.install.BVersion;
import com.tridium.install.DaemonPlatformUtil;
import com.tridium.install.DependencyUtil;
import com.tridium.install.DistLicenseFeatureFilter;
import com.tridium.install.InstallScenario;
import com.tridium.install.ModuleSignatureStatusEnum;
import com.tridium.install.SolutionParameters;
import com.tridium.install.UnmeetableDependency;
import com.tridium.install.installable.BDistribution;
import com.tridium.install.installable.BFileInstallable;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.BModuleInstallable;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.install.part.BModelPart;
import com.tridium.install.part.BModulePart;
import com.tridium.install.part.BNrePart;
import com.tridium.install.part.BPart;
import com.tridium.install.part.BVmPart;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nre.RunnableWithException;
import com.tridium.nre.security.ModuleVerificationMode;
import com.tridium.nre.security.PBEEncodingInfo;
import com.tridium.nre.security.PBEValidator;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.platcrypto.daemon.BPlatCryptoManager;
import com.tridium.platform.daemon.BAppSurrogate;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.DaemonClientEncodingInfo;
import com.tridium.platform.daemon.file.StoreCache;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.message.OSUpdateMessage;
import com.tridium.platform.daemon.message.RefreshDaemonBinariesMessage;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.license.BEnvLicenseSummary;
import com.tridium.provisioningNiagara.BPlatformConnection;
import com.tridium.provisioningNiagara.NiagaraNetworkJobOp;
import com.tridium.provisioningNiagara.license.BLicenseStationExt;
import com.tridium.provisioningNiagara.license.BLicenseStatus;
import com.tridium.provisioningNiagara.software.BSoftwareStationExt;
import com.tridium.provisioningNiagara.software.BUpgradeOutOfDateStep;
import com.tridium.provisioningNiagara.station.BStationProxy;
import com.tridium.sys.license.dom.LicenseDatabase;
import com.tridium.sys.license.dom.VendorLicense;
import java.net.SocketException;
import java.security.AccessController;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.driver.BDeviceJobStep;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.driver.BDevice;
import javax.baja.file.BIFile;
import javax.baja.io.BIEncodable;
import javax.baja.job.BJobState;
import javax.baja.job.JobCancelException;
import javax.baja.naming.BHost;
import javax.baja.platform.BStationStatus;
import javax.baja.platform.ICancelHint;
import javax.baja.status.BStatus;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.Version;

public abstract class BAbstractSoftwareStep
extends BDeviceJobStep {
    public static final Type TYPE = Sys.loadType(BAbstractSoftwareStep.class);
    protected List<BAbstractSoftwareStep> combinedSteps = new ArrayList<BAbstractSoftwareStep>();
    private Version maxCoreVersion = null;
    private static final String CACERTS_ENTRY = "META-INF/install/cacerts";
    private static final String CACERTS_FIPS_ENTRY = "META-INF/install/cacerts.bcfks";
    private static final String STANDARD_STORE_TYPE = "JKS";
    private static final String FIPS_STORE_TYPE = "BCFKS";
    private static final String CACERTS_KEY = "jiUz!rHw2d8&i3kI";
    static final Logger log = Logger.getLogger("provisioningNiagara");

    public Type getType() {
        return TYPE;
    }

    public boolean canCombine(BDeviceJobStep step) {
        return step instanceof BAbstractSoftwareStep;
    }

    public void combine(BDeviceJobStep step) {
        this.combinedSteps.add((BAbstractSoftwareStep)step);
    }

    public void deviceNetworkJobComplete(DeviceNetworkJobOp op) {
        super.deviceNetworkJobComplete(op);
        for (BAbstractSoftwareStep combinedStep : this.combinedSteps) {
            combinedStep.deviceNetworkJobComplete(op);
        }
    }

    public void deviceJobStepComplete(BDeviceStepDetails details, DeviceNetworkJobOp op) {
        super.deviceJobStepComplete(details, op);
        for (BAbstractSoftwareStep combinedStep : this.combinedSteps) {
            combinedStep.deviceJobStepComplete(details, op);
        }
    }

    protected void doRun(BBatchJobService svc, BDeviceStepDetails details, BDevice device, DeviceNetworkJobOp opIn) throws Exception {
        try {
            NiagaraNetworkJobOp op = (NiagaraNetworkJobOp)opIn;
            BNiagaraStation station = (BNiagaraStation)device;
            this.checkCanceled((BDevice)station);
            BPlatformConnection platformConn = (BPlatformConnection)station.getMixIn(BPlatformConnection.TYPE);
            BDaemonSession daemonSession = platformConn.getDaemonSession();
            BSoftwareStationExt softwareExt = (BSoftwareStationExt)station.getMixIn(BSoftwareStationExt.TYPE);
            if (softwareExt.isUnoperational()) {
                details.failed("provisioningNiagara", "AbstractSoftwareStep.softwareExtUnoperational", new String[]{station.getDisplayName(null), BFormat.getEncodedPattern((BIEncodable)softwareExt.getStatus())});
                details.complete(BJobState.failed);
                return;
            }
            if (platformConn.isUnoperational()) {
                details.failed("provisioningNiagara", "AbstractSoftwareStep.platformConnUnoperational", new String[]{station.getDisplayName(null), BFormat.getEncodedPattern((BIEncodable)platformConn.getStatus())});
                details.complete(BJobState.failed);
                return;
            }
            if (daemonSession == null) {
                details.failed("provisioningNiagara", "AbstractSoftwareStep.platformConnUnavailable", new String[]{station.getDisplayName(null)});
                details.complete(BJobState.failed);
                return;
            }
            if (daemonSession.getHostProperties().getIsSoftwareReadonly()) {
                details.failed("provisioningNiagara", "AbstractSoftwareStep.softwareReadonly", new String[]{station.getDisplayName(null)});
                details.complete(BJobState.failed);
                return;
            }
            Listener listener = new Listener(details);
            BRemoteDaemonPlatform platform = BRemoteDaemonPlatform.make((BDaemonSession)daemonSession, (DaemonSessionTaskListener)listener, (boolean)false);
            platform.loadPreferredVerificationMode();
            SolutionParameters solutionParameters = new SolutionParameters((DaemonSessionTaskListener)listener);
            CertificateChainValidator certValidator = this.makeCertificateChainValidator(details, (BDaemonPlatform)platform, listener, solutionParameters);
            InstallScenario scenario = new InstallScenario((BDaemonPlatform)platform, (DaemonSessionTaskListener)listener, new String[0], new BDependency[0], new BInstallable[0], (InstallableRegistry)LocalInstallableRegistry.getInstance(), certValidator);
            ArrayList<BAbstractSoftwareStep> steps = new ArrayList<BAbstractSoftwareStep>();
            steps.add(this);
            steps.addAll(this.combinedSteps);
            BUpgradeOutOfDateStep upgrade = null;
            if (details.getState().isRunning()) {
                for (BAbstractSoftwareStep step : steps) {
                    this.checkCanceled(details.getDevice());
                    if (step instanceof BUpgradeOutOfDateStep) {
                        upgrade = (BUpgradeOutOfDateStep)step;
                    } else {
                        scenario = step.updateInstallScenario(details, listener, scenario, op);
                    }
                    if (details.getState().isRunning()) continue;
                    return;
                }
                if (upgrade != null) {
                    scenario = upgrade.updateInstallScenario(details, listener, scenario, op);
                }
                this.commitScenario(details, scenario, (BDaemonPlatform)platform, platformConn, softwareExt, op);
            }
        }
        catch (ICancelHint.CanceledException ce) {
            throw new JobCancelException((Throwable)ce);
        }
    }

    private CertificateChainValidator makeCertificateChainValidator(BDeviceStepDetails details, BDaemonPlatform platform, Listener listener, SolutionParameters solutionParameters) throws Exception {
        if (platform.getIsNpsdk()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Relaxing certificate validation for NPSDK platform.");
            }
            CertificateChainValidator validator = CertificateChainValidator.make((ICoreCryptoManager)new BPlatCryptoManager(platform.getDaemonSession()));
            validator.setLaxValidation(true);
            return validator;
        }
        DependencyUtil.AnalysisResults results = DependencyUtil.analyzeAllDependencies((BDaemonPlatform)platform, null, (Set)platform.getEnabledRuntimeProfiles(), (SolutionParameters)solutionParameters, (CertificateChainValidator)new NoOpCertificateChainValidator());
        InstallScenario scenario = results.getSolution();
        InstallScenario distScenario = this.getDistScenario(scenario, platform, listener, details);
        scenario = distScenario != null ? distScenario : scenario;
        KeyStore cacerts = null;
        block2: for (BInstallable inst : scenario.getToInstall()) {
            if (!(inst instanceof BDistribution)) continue;
            SlotCursor p = inst.getParts().getProperties();
            while (p.next()) {
                BPart part = (BPart)p.get();
                Type type = part.getType();
                if (!type.is(BVmPart.TYPE)) continue;
                cacerts = BAbstractSoftwareStep.extractCacerts(inst);
                continue block2;
            }
        }
        BPlatCryptoManager cryptoManager = new BPlatCryptoManager(platform.getDaemonSession());
        try {
            CertificateChainValidator validator = new CertificateChainValidator();
            validator.addTrustAnchors(cryptoManager.getUserTrustStore());
            if (cacerts != null) {
                validator.addTrustAnchors(cacerts);
            } else {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Cacerts not found in InstallScenario, using current platform system trust store.");
                }
                validator.addTrustAnchors(cryptoManager.getSystemTrustStore());
            }
            return validator;
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Error adding trust anchors to CertificateChainValidator.", e);
            return CertificateChainValidator.make((ICoreCryptoManager)cryptoManager);
        }
    }

    private InstallScenario getDistScenario(InstallScenario initialDistScenario, BDaemonPlatform platform, DaemonSessionTaskListener listener, BDeviceStepDetails details) throws Exception {
        Version licenseVersion = null;
        BLicenseStationExt licenseExt = (BLicenseStationExt)details.getDevice().getMixIn(BLicenseStationExt.TYPE);
        licenseVersion = licenseExt.makeLicenseSummary().getTridiumVersion();
        if (licenseExt.getLicenseStatus() != BLicenseStatus.upToDate) {
            licenseExt.makeLicenseSummary();
        }
        BEnvLicenseSummary licenseSummary = licenseExt.getLicenseSummary();
        VendorLicense[] licenses = AccessController.doPrivileged(() -> {
            VendorLicense[] lics = LicenseDatabase.LOCAL_INSTANCE.getLicenses(licenseSummary.getHostId(), licenseSummary.getBrandId());
            return lics;
        });
        InstallScenario solution = null;
        try (LocalInstallableRegistry.InstallableCursor c = (LocalInstallableRegistry.InstallableCursor)LocalInstallableRegistry.getInstance().getInstallables(true, listener, platform.getConfigDistFileName());){
            while (c.next(BDistribution.class)) {
                BDistribution d = (BDistribution)c.get();
                boolean acceptedDist = this.acceptInstallable((BInstallable)d, initialDistScenario, licenses, licenseVersion);
                InstallScenario s = initialDistScenario.solve(listener, null, null, new BInstallable[]{d}, (InstallableRegistry)LocalInstallableRegistry.getInstance());
                if (s.canCommit()) {
                    s = s.solve(listener, null, DependencyUtil.getPlatformModuleDependencies((BDaemonPlatform)platform, (BDistribution)d, (Set)s.getNewEnabledRuntimeProfiles()), null, (InstallableRegistry)LocalInstallableRegistry.getInstance());
                }
                if (s.canCommit()) {
                    solution = s;
                    break;
                }
                if (s.getExcludedInstallables().length != 0 || solution != null && s.getUnmeetableDependencies().length >= solution.getUnmeetableDependencies().length) continue;
                boolean wrongPlatform = false;
                for (UnmeetableDependency dep : s.getUnmeetableDependencies()) {
                    if (!dep.dependency.isPlatformDependency(platform)) continue;
                    wrongPlatform = true;
                    break;
                }
                if (wrongPlatform || !acceptedDist) continue;
                solution = s;
            }
        }
        return solution;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static KeyStore extractCacerts(BInstallable jreDist) {
        try {
            String keystoreType;
            String cacertsEntryName;
            BIFile distFile = AccessController.doPrivileged(() -> (BIFile)jreDist.getInstallableFileOrd().get());
            if (log.isLoggable(Level.FINE)) {
                log.fine(String.format("Searching for cacerts in JRE dist '%s'", distFile.getFilePath()));
            }
            if (SecurityInitializer.getInstance().isFips()) {
                cacertsEntryName = CACERTS_FIPS_ENTRY;
                keystoreType = FIPS_STORE_TYPE;
            } else {
                cacertsEntryName = CACERTS_ENTRY;
                keystoreType = STANDARD_STORE_TYPE;
            }
            try (ZipInputStream in = new ZipInputStream(AccessController.doPrivileged(() -> ((BIFile)distFile).getInputStream()));){
                ZipEntry zipEntry;
                while ((zipEntry = in.getNextEntry()) != null) {
                    if (!zipEntry.getName().equalsIgnoreCase(cacertsEntryName)) continue;
                    try {
                        KeyStore cacerts = KeyStore.getInstance(keystoreType);
                        cacerts.load(in, CACERTS_KEY.toCharArray());
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Loading cacerts from " + cacertsEntryName);
                        }
                        KeyStore keyStore = cacerts;
                        return keyStore;
                    }
                    catch (Exception exception) {
                    }
                }
                log.warning(String.format("Unable to find '%s' in JRE dist.", cacertsEntryName));
                KeyStore keyStore = null;
                return keyStore;
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Error searching for cacerts in JRE dist.", e);
            return null;
        }
    }

    protected boolean acceptInstallable(BInstallable installable, InstallScenario scenario, VendorLicense[] licenses, Version licenseVersion) {
        if (AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.commissioning.ignoreLicenseVersion")).booleanValue()) {
            return true;
        }
        try {
            Version maxCoreVersion = this.getMaxCoreVersion(licenseVersion);
            log.log(Level.FINE, String.format("Max Core Version = %s", maxCoreVersion.toString()));
            if (installable.getInstallableName().startsWith("nre-core") || installable.getInstallableName().equals("baja")) {
                if (installable.getVersion().getVendor().equalsIgnoreCase("tridium")) {
                    for (VendorLicense license : licenses) {
                        if (installable.getReleaseDate().isPresent()) {
                            if (!this.allowInstallableUnderSMA(installable, license)) continue;
                            log.log(Level.FINER, String.format("Passed allowInstallableUnderSMA(), Installable = %s, License = %s", installable.getInstallableName(), license.toString()));
                            return true;
                        }
                        boolean allowUnreleasedSoftware = this.allowUnreleasedSoftware(installable, license);
                        log.log(Level.FINER, String.format("allowUnreleasedSoftware() = %s, Installable = %s, License = %s", Boolean.toString(allowUnreleasedSoftware), installable.getInstallableName(), license.toString()));
                        return allowUnreleasedSoftware;
                    }
                } else {
                    for (VendorLicense license : licenses) {
                        if (!license.getMaintenanceExpiration().isPresent()) continue;
                        log.log(Level.FINER, String.format("3rd party (NPSDK) nre-core parts are allowed, Installable = %s, License = %s", installable.getInstallableName(), license.toString()));
                        return true;
                    }
                }
                if (installable.getVersion().getVendorVersion().compareTo(maxCoreVersion) >= 0) {
                    for (VendorLicense license : licenses) {
                        StringBuilder sb = new StringBuilder().append(license.getHostId()).append('.').append(license.getBrandId()).append('.').append(license.getVendor());
                        log.log(Level.FINE, "License '" + sb.toString() + "' specifies version '" + license.getVersion().toString() + "', installable '" + installable.getInstallableName() + "' requires '" + installable.getVersion().getVendorVersion() + "'");
                    }
                    return false;
                }
            } else if (installable instanceof BDistribution && BPart.matchesName((String)installable.getInstallableFileName(), (String)scenario.getTargetPlatform().getConfigDistFileName())) {
                for (BDependency configDep : installable.getAllDependencies()) {
                    if (configDep.getPartType() != BNrePart.TYPE) continue;
                    if (installable.getVersion().getVendor().equalsIgnoreCase("tridium")) {
                        for (VendorLicense license : licenses) {
                            if (installable.getReleaseDate().isPresent()) {
                                if (!this.allowInstallableUnderSMA(installable, license)) continue;
                                log.log(Level.FINER, String.format("Passed allowInstallableUnderSMA(), Installable = %s, License = %s", installable.getInstallableName(), license.toString()));
                                return true;
                            }
                            boolean allowUnreleasedSoftware = this.allowUnreleasedSoftware(installable, license);
                            log.log(Level.FINER, String.format("allowUnreleasedSoftware() = %s, Installable = %s, License = %s", Boolean.toString(allowUnreleasedSoftware), installable.getInstallableName(), license.toString()));
                            return allowUnreleasedSoftware;
                        }
                    } else {
                        for (VendorLicense license : licenses) {
                            if (!license.getMaintenanceExpiration().isPresent()) continue;
                            log.log(Level.FINER, String.format("3rd party (NPSDK) nre-core parts are allowed, Installable = %s, License = %s", installable.getInstallableName(), license.toString()));
                            return true;
                        }
                    }
                    if (configDep.getVersion().getVendorVersion().compareTo(maxCoreVersion) < 0) break;
                    for (VendorLicense license : licenses) {
                        StringBuilder sb = new StringBuilder().append(license.getHostId()).append('.').append(license.getBrandId()).append('.').append(license.getVendor());
                        log.log(Level.FINE, "License '" + sb.toString() + "' specifies version '" + license.getVersion().toString() + "', dependency '" + configDep.getPartName() + "' requires '" + configDep.getVersion().getVendorVersion() + "'");
                    }
                    return false;
                }
            }
            log.log(Level.FINER, String.format("Unrestricted parts are allowed, Installable = %s", installable.getInstallableName()));
            return true;
        }
        catch (Exception e) {
            log.log(Level.WARNING, String.format("Exception occurred when determining if %s was acceptable, disallowing installable", installable.getInstallableName()), e);
            return false;
        }
    }

    private boolean allowInstallableUnderSMA(BInstallable installable, VendorLicense license) {
        if (license.getMaintenanceExpiration().isPresent() && (Long)installable.getReleaseDate().get() <= (Long)license.getMaintenanceExpiration().get()) {
            log.log(Level.FINER, "Selected license specifies active SMA date '" + new Date((Long)license.getMaintenanceExpiration().get()) + "' for installable release date '" + installable.getReleaseDateString() + "', SMA permits installation of '" + installable.getInstallableName() + ":" + installable.getVersion().getVendorVersion() + "'");
            return true;
        }
        return false;
    }

    private boolean allowUnreleasedSoftware(BInstallable installable, VendorLicense license) {
        if (installable.getReleaseDate().isPresent()) {
            return true;
        }
        if (license.getUnreleasedSwAccessExpiration().isPresent()) {
            if ((Long)license.getUnreleasedSwAccessExpiration().get() > System.currentTimeMillis()) {
                log.log(Level.FINER, "Selected license specifies active 'unreleasedSwAccessExpiration' date '" + new Date((Long)license.getUnreleasedSwAccessExpiration().get()) + "', feature permits installation of unreleased installable '" + installable.getInstallableName() + ":" + installable.getVersion().getVendorVersion() + "'");
                return true;
            }
            StringBuilder sb = new StringBuilder().append(license.getHostId()).append('.').append(license.getBrandId()).append('.').append(license.getVendor());
            log.log(Level.FINE, "License '" + sb.toString() + "' feature 'unreleasedSwAccessExpiration' date '" + new Date((Long)license.getUnreleasedSwAccessExpiration().get()) + "' is not active, preventing installation of unreleased installable '" + installable.getInstallableName() + "'");
            return false;
        }
        return false;
    }

    private Version getMaxCoreVersion(Version licenseVersion) {
        if (this.maxCoreVersion == null) {
            this.maxCoreVersion = licenseVersion == null ? Version.ZERO : new Version(licenseVersion.major() + "." + (licenseVersion.minor() + 1));
        }
        return this.maxCoreVersion;
    }

    public abstract InstallScenario updateInstallScenario(BDeviceStepDetails var1, DaemonSessionTaskListener var2, InstallScenario var3, NiagaraNetworkJobOp var4) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void commitScenario(BDeviceStepDetails details, InstallScenario scenario, BDaemonPlatform platform, BPlatformConnection platformConn, BSoftwareStationExt softwareExt, NiagaraNetworkJobOp op) throws Exception {
        Listener listener = new Listener(details);
        BDaemonSession platformSession = platformConn.getDaemonSession();
        if (platformSession == null) {
            details.failed("provisioningNiagara", "AbstractSoftwareStep.platformConnUnavailable", new String[]{details.getDeviceDisplayName()});
            details.complete(BJobState.failed);
            return;
        }
        String sessionTimestamp = platformSession.getHostProperties().getSessionTimestamp();
        Map failed = (scenario = scenario.solve()).getSignatureFailures();
        if (!failed.isEmpty()) {
            ModuleVerificationMode verificationMode = scenario.getVerificationMode();
            for (Map.Entry entry : failed.entrySet()) {
                List statuses = (List)entry.getValue();
                for (ModuleSignatureStatusEnum status : statuses) {
                    if (status.isAcceptable(verificationMode)) continue;
                    details.message("provisioningNiagara", "AbstractSoftwareStep." + status.name() + ".error", new String[]{((BModuleInstallable)entry.getKey()).toString()});
                }
            }
            details.failed("provisioningNiagara", "AbstractSoftwareStep.signingError");
            details.complete(BJobState.failed);
            return;
        }
        UnmeetableDependency[] unmet = scenario.getUnmeetableDependencies();
        if (unmet.length > 0) {
            for (UnmeetableDependency anUnmet : unmet) {
                details.message("provisioningNiagara", "AbstractSoftwareStep.unmetDep.detail", new String[]{anUnmet.toString(null)});
                if (!(anUnmet.failedFilter instanceof DistLicenseFeatureFilter)) continue;
                String features = String.join((CharSequence)", ", ((DistLicenseFeatureFilter)anUnmet.failedFilter).getSatisfyingFeatures());
                details.vaMessage("AbstractSoftwareStep.unmetDep.missingFeature", new String[]{features});
            }
            details.failed("provisioningNiagara", "AbstractSoftwareStep.unmetDep");
            details.complete(BJobState.failed);
            return;
        }
        BInstallable[] toInstall = scenario.getToInstall();
        CertificateChainValidator certValidator = scenario.getCertValidator();
        for (BInstallable installable : toInstall) {
            BModulePart part;
            List statuses;
            if (!(installable instanceof BModuleInstallable) || (statuses = (part = ((BModuleInstallable)installable).getModulePart()).getSignatureStatus(certValidator)).contains(ModuleSignatureStatusEnum.OK)) continue;
            for (ModuleSignatureStatusEnum status : statuses) {
                details.message("provisioningNiagara", "AbstractSoftwareStep." + status.name() + ".warning", new String[]{installable.toString()});
            }
        }
        EncodingTestInfo encodingTestInfo = this.resolveEncodingInfo(details, scenario, platformSession);
        if (!encodingTestInfo.isEncodingCheckOK) {
            return;
        }
        Optional<Consumer<FileTransferMessage>> messageInitializer = this.updateMessageInitializer(encodingTestInfo.encodingInfo, platformSession);
        for (String aToUninstall : scenario.getModulesToUninstall()) {
            details.message("provisioningNiagara", "AbstractSoftwareStep.uninstalling", aToUninstall);
        }
        long flags = scenario.getProcessingFlags();
        boolean mustReboot = (flags & 0x10000L) > 0L;
        boolean mustRestartStation = false;
        BAppSurrogate[] runningApps = new BAppSurrogate[]{};
        if ((flags & 1L) == 0L && (flags & 2L) == 0L && (flags & 4L) > 0L) {
            BStationSurrogate[] accum = new ArrayList();
            BAppSurrogate[] bAppSurrogateArray = BAppSurrogate.makeAll((Type)BStationSurrogate.TYPE, (BDaemonSession)platformSession);
            int n = bAppSurrogateArray.length;
            for (int i = 0; i < n; ++i) {
                BInstallable[] station = bAppSurrogateArray[i];
                BStationStatus status = station.getAppStatus();
                if (status == BStationStatus.starting || status == BStationStatus.stopping) {
                    flags |= 2L;
                    break;
                }
                if (status != BStationStatus.running) continue;
                accum.add(station);
            }
            if ((flags & 2L) == 0L) {
                runningApps = accum.toArray(new BAppSurrogate[accum.size()]);
            }
        }
        if ((flags & 1L) > 0L || (flags & 2L) > 0L) {
            details.message("provisioningNiagara", "AbstractSoftwareStep.stopApps", platform.getNavDescription((Context)op));
            runningApps = BAppSurrogate.stopAllApps((BDaemonSession)platformSession, (Type)((flags & 1L) > 0L ? null : BStationSurrogate.TYPE), (ICancelHint)BStationProxy.stationShutdownCancelHint((ICancelHint)details, (RuntimeException)new LocalizableRuntimeException("provisioningNiagara", "ProvisioningJob.stationStopTimeout", new Object[]{softwareExt.getNiagaraStation().getDisplayName(null)})), (DaemonSessionTaskListener)listener);
            block14: for (BStationSurrogate allStation : BStationSurrogate.makeAll((BDaemonSession)platformSession)) {
                if (allStation.getStationStatus() == BStationStatus.idle) continue;
                for (BInstallable solutionInstallable : scenario.getToInstall()) {
                    BPart partToInstall = solutionInstallable.getPart();
                    if (partToInstall == null || !(partToInstall instanceof BNrePart)) continue;
                    DaemonPlatformUtil.doExtraStationShutdownTasks((BDaemonPlatform)platform, (DaemonSessionTaskListener)listener, (ICancelHint)details);
                    sessionTimestamp = platformSession.getHostProperties().getSessionTimestamp();
                    break block14;
                }
                break;
            }
            if (runningApps.length > 0 && !platform.getDaemonSession().getHostProperties().getAllowStationRestart()) {
                mustReboot = true;
                mustRestartStation = true;
            }
        }
        this.checkCanceled(details.getDevice());
        AtomicReference<InstallScenario> atomicScenario = new AtomicReference<InstallScenario>();
        atomicScenario.set(scenario);
        AccessController.doPrivileged(() -> {
            ((InstallScenario)atomicScenario.get()).commit((DaemonSessionTaskListener)listener, new StoreCache(), (ICancelHint)details, false, messageInitializer);
            return null;
        });
        this.checkCanceled(details.getDevice());
        if ((flags & 0x20000L) > 0L) {
            details.start("provisioningNiagara", "AbstractSoftwareStep.installOs", platform.getNavDescription((Context)op));
            platformSession.sendMessage((DaemonMessage)OSUpdateMessage.getInstance(), 90000);
            details.endSuccess();
            if (runningApps.length > 0) {
                mustRestartStation = true;
            }
            mustReboot = true;
        }
        if ((flags & 0x80000L) > 0L) {
            details.message("provisioningNiagara", "AbstractSoftwareStep.ignoreTcp");
        }
        BHost host = platformSession.getHost();
        RunnableWithException restartAction = null;
        if (mustReboot) {
            restartAction = () -> {
                details.start("provisioningNiagara", "AbstractSoftwareStep.rebooting", host.toString((Context)op));
                if (!platformSession.sendRebootRequest()) {
                    details.endFailed("provisioningNiagara", "RebootJobStep.requestFailed", new String[]{softwareExt.getNiagaraStation().getDisplayName(null)});
                    details.complete(BJobState.failed);
                    return;
                }
                platformConn.reset();
                details.endSuccess();
            };
        } else if ((flags & 0x40000L) > 0L) {
            restartAction = () -> {
                details.start("provisioningNiagara", "AbstractSoftwareStep.restartNiagarad", platform.getNavDescription((Context)op));
                try {
                    platformSession.sendMessage((DaemonMessage)RefreshDaemonBinariesMessage.getInstance());
                }
                catch (SocketException socketException) {
                    // empty catch block
                }
                platformConn.reset();
                details.endSuccess();
            };
        } else if (runningApps.length > 0) {
            if ((flags & 1L) == 0L && (flags & 2L) == 0L) {
                for (BAppSurrogate runningApp : runningApps) {
                    if (!(runningApp instanceof BStationSurrogate)) continue;
                    ((BStationSurrogate)runningApp).syncStationModulesAsync();
                }
            } else {
                for (BAppSurrogate runningApp : runningApps) {
                    this.checkCanceled(details.getDevice());
                    details.start("provisioningNiagara", "AbstractSoftwareStep.startApp", runningApp.toString((Context)op));
                    runningApp.startApp((ICancelHint)details, (DaemonSessionTaskListener)listener);
                    details.endSuccess();
                }
            }
        }
        if (restartAction != null) {
            platformConn.setStatus(BStatus.makeDisabled((BStatus)platformConn.getStatus(), (boolean)true));
            Logger daemonSessionLog = Logger.getLogger("platform.daemonSession");
            Level previousLevel = daemonSessionLog.getLevel();
            daemonSessionLog.setLevel(Level.SEVERE);
            BNiagaraStation niagaraStation = (BNiagaraStation)softwareExt.getDevice();
            try {
                restartAction.run();
                this.beforeReconnect(scenario, niagaraStation, platformConn, platformSession, details);
                details.start("provisioningNiagara", "AbstractSoftwareStep.reconnect", host.toString((Context)op));
                ICancelHint hint = BStationProxy.rebootCancelHint((ICancelHint)details, (RuntimeException)new LocalizableRuntimeException("provisioningNiagara", "ProvisioningJob.stationRebootTimeout", new Object[]{softwareExt.getNiagaraStation().getDisplayName(null)}));
                this.reconnect(platformSession, sessionTimestamp, hint, mustRestartStation, runningApps, op, listener, scenario, niagaraStation, details);
            }
            finally {
                try {
                    daemonSessionLog.setLevel(previousLevel);
                }
                catch (Exception exception) {}
                platformConn.setStatus(BStatus.makeDisabled((BStatus)platformConn.getStatus(), (boolean)false));
            }
        }
        softwareExt.takeSnapshot();
    }

    protected void beforeReconnect(InstallScenario scenario, BNiagaraStation station, BPlatformConnection platformConn, BDaemonSession platformSession, BDeviceStepDetails details) throws Exception {
    }

    protected void reconnect(BDaemonSession platformSession, String sessionTimestamp, ICancelHint hint, boolean mustRestartStation, BAppSurrogate[] runningApps, NiagaraNetworkJobOp op, Listener listener, InstallScenario scenario, BNiagaraStation station, BDeviceStepDetails details) throws Exception {
        if (platformSession.reconnect(sessionTimestamp, hint)) {
            if (mustRestartStation && runningApps.length > 0) {
                this.restartStation(platformSession, details, op, listener);
            }
        } else {
            throw new ICancelHint.CanceledException();
        }
        details.endSuccess();
    }

    protected void restartStation(BDaemonSession platformSession, BDeviceStepDetails details, NiagaraNetworkJobOp op, Listener listener) throws Exception {
        for (BAppSurrogate station : BAppSurrogate.makeAll((Type)BStationSurrogate.TYPE, (BDaemonSession)platformSession)) {
            details.message("provisioningNiagara", "AbstractSoftwareStep.startApp", station.toString((Context)op));
            station.startApp((ICancelHint)details, (DaemonSessionTaskListener)listener);
            details.message("provisioningNiagara", "AbstractSoftwareStep.appStarted", station.toString((Context)op));
        }
    }

    public Optional<String> getModelFromDist(BInstallable installable) {
        if (!(installable instanceof BDistribution)) {
            return Optional.empty();
        }
        BDistribution distribution = (BDistribution)installable;
        for (BDependency dependency : distribution.getAllDependencies()) {
            if (!dependency.getPartTypeSpec().equals((Object)BModelPart.TYPE.getTypeSpec())) continue;
            return Optional.of(dependency.getPartName());
        }
        return Optional.empty();
    }

    protected BPartInstallStatus checkPartStatus(BPart installPart, BDaemonPlatform platform) {
        if (installPart == null) {
            return BPartInstallStatus.notFound;
        }
        BPart currentPart = platform.getPart(installPart);
        if (currentPart == null) {
            return BPartInstallStatus.install;
        }
        BVersion currentVersion = currentPart.getVersion();
        BVersion installVersion = installPart.getVersion();
        switch (currentVersion.checkVersionRequirement(installVersion)) {
            case 2: {
                if (currentPart instanceof BModulePart) {
                    BModulePart currentModule = (BModulePart)currentPart;
                    BModulePart installModule = (BModulePart)installPart;
                    if (currentModule.getBuildAbsTime() != null && installModule.getBuildAbsTime() != null) {
                        int dateComp = installModule.getBuildAbsTime().compareTo((Object)currentModule.getBuildAbsTime());
                        if (dateComp > 0) {
                            return BPartInstallStatus.upgrade;
                        }
                        if (dateComp < 0) {
                            return BPartInstallStatus.downgrade;
                        }
                        return BPartInstallStatus.noChange;
                    }
                    return BPartInstallStatus.reinstall;
                }
                return BPartInstallStatus.reinstall;
            }
            case 8: 
            case 16: {
                return BPartInstallStatus.reinstall;
            }
            case 4: {
                return BPartInstallStatus.upgrade;
            }
            case 1: {
                return BPartInstallStatus.downgrade;
            }
        }
        return BPartInstallStatus.reinstall;
    }

    protected EncodingTestInfo resolveEncodingInfo(BDeviceStepDetails details, InstallScenario scenario, BDaemonSession session) throws Exception {
        EncodingTestInfo encodingTestInfo = new EncodingTestInfo();
        encodingTestInfo.isEncodingCheckOK = true;
        PBEEncodingInfo encodingInfo = null;
        for (BInstallable aToInstall : scenario.getToInstall()) {
            BBogFile bogFile;
            PBEEncodingInfo bogEncodingInfo;
            BIFile localFile;
            BDistribution dist;
            PBEEncodingInfo distEncodingInfo;
            if (session.getHostProperties().isNiagara4() && aToInstall instanceof BDistribution && (distEncodingInfo = (dist = (BDistribution)aToInstall).getManifest().getPBEEncodingInfo()) != null) {
                if (encodingInfo == null) {
                    encodingInfo = distEncodingInfo;
                    details.message("provisioningNiagara", "AbstractSoftwareStep.verifySystemPassPhrase", aToInstall.toString(null));
                    if (!session.validateSystemPassPhrase((PBEValidator)distEncodingInfo)) {
                        details.failed("provisioningNiagara", "AbstractSoftwareStep.systemPassPhraseMismatch", new String[]{aToInstall.toString(null), details.getDeviceDisplayName()});
                        details.complete(BJobState.failed);
                        encodingTestInfo.isEncodingCheckOK = false;
                        break;
                    }
                } else {
                    details.failed("provisioningNiagara", "AbstractSoftwareStep.multipleEncodedDist");
                    details.complete(BJobState.failed);
                    encodingTestInfo.isEncodingCheckOK = false;
                    break;
                }
            }
            if (session.getHostProperties().isNiagara4() && aToInstall instanceof BFileInstallable && (localFile = (BIFile)aToInstall.getInstallableFileOrd().get()).getFilePath().getName().equals("config.bog") && (bogEncodingInfo = (bogFile = new BBogFile(localFile.getStore())).getPBEEncodingInfo()) != null) {
                if (encodingInfo == null) {
                    encodingInfo = bogEncodingInfo;
                    details.message("provisioningNiagara", "AbstractSoftwareStep.verifySystemPassPhrase", aToInstall.toString(null));
                    if (!session.validateSystemPassPhrase((PBEValidator)bogEncodingInfo)) {
                        details.failed("provisioningNiagara", "AbstractSoftwareStep.systemPassPhraseMismatch", new String[]{aToInstall.toString(null), details.getDeviceDisplayName()});
                        details.complete(BJobState.failed);
                        encodingTestInfo.isEncodingCheckOK = false;
                        break;
                    }
                } else {
                    details.failed("provisioningNiagara", "AbstractSoftwareStep.multipleEncodedDist");
                    details.complete(BJobState.failed);
                    encodingTestInfo.isEncodingCheckOK = false;
                    break;
                }
            }
            details.message("provisioningNiagara", "AbstractSoftwareStep.installing", aToInstall.toString(null));
        }
        encodingTestInfo.encodingInfo = encodingInfo;
        return encodingTestInfo;
    }

    protected Optional<Consumer<FileTransferMessage>> updateMessageInitializer(PBEEncodingInfo encodingInfo, BDaemonSession session) throws Exception {
        return encodingInfo == null ? Optional.empty() : Optional.of(DaemonClientEncodingInfo.makeMessageInitializer((BDaemonSession)session, Optional.of(encodingInfo), Optional.empty()));
    }

    protected class EncodingTestInfo {
        protected boolean isEncodingCheckOK;
        protected PBEEncodingInfo encodingInfo;

        protected EncodingTestInfo() {
        }
    }

    public static class Listener
    implements DaemonSessionTaskListener {
        private BDeviceStepDetails details;
        private String lastTaskMessage = null;

        public Listener(BDeviceStepDetails details) {
            this.details = details;
        }

        public void taskStarted(DaemonSessionTask task) {
            this.taskUpdated(task);
        }

        public void taskUpdated(DaemonSessionTask task) {
            if (!task.getMessage().equals(this.lastTaskMessage)) {
                this.details.message(task.getMessage());
                this.lastTaskMessage = task.getMessage();
            }
        }

        public void taskFinished(DaemonSessionTask task) {
            this.taskUpdated(task);
        }

        public boolean isCancelEnabled() {
            return false;
        }
    }
}

