/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.license;

import com.tridium.install.BDaemonPlatform;
import com.tridium.install.installable.BInstallable;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.file.StoreCache;
import com.tridium.platform.daemon.message.ByteArrayFileTransferElement;
import com.tridium.platform.daemon.message.FileTransferMessageElement;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.license.BCertificateSummary;
import com.tridium.platform.license.BEnvLicenseSummary;
import com.tridium.platform.license.CertificateInfo;
import com.tridium.platform.license.LicenseInfo;
import com.tridium.sys.license.dom.VendorCertificate;
import com.tridium.sys.license.dom.VendorLicense;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.baja.platform.ICancelHint;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BLicenseInstallable
extends BInstallable {
    public static final Property installableName = BLicenseInstallable.newProperty((int)1, (String)"licenses", null);
    public static final Property description = BLicenseInstallable.newProperty((int)1, (String)"Installs licenses and/or certificates for a station", null);
    public static final Type TYPE = Sys.loadType(BLicenseInstallable.class);
    private List<LicenseInfo> licenses = new ArrayList<LicenseInfo>();
    private List<CertificateInfo> certs = new ArrayList<CertificateInfo>();
    private long processingFlags = 1L;

    public Type getType() {
        return TYPE;
    }

    public void addLicense(VendorLicense license) {
        this.licenses.add(new LicenseInfo(license, null));
    }

    public void addCertificate(VendorCertificate cert) {
        this.certs.add(new CertificateInfo(cert, null));
    }

    public BEnvLicenseSummary[] getLicenseSummaries() {
        return BEnvLicenseSummary.make((LicenseInfo[])this.licenses.toArray(new LicenseInfo[this.licenses.size()]));
    }

    public BCertificateSummary[] getCertificateSummaries() {
        return BCertificateSummary.make((CertificateInfo[])this.certs.toArray(new CertificateInfo[this.certs.size()]));
    }

    public long getProcessingFlags(BDaemonPlatform targetPlatform, DaemonSessionTaskListener taskListener) {
        return this.processingFlags;
    }

    public void setRebootFlag() {
        this.processingFlags |= 0x10000L;
    }

    public FileTransferMessageElement[] getTransferElements(BDaemonPlatform target, StoreCache cache, ICancelHint cancelHint, DaemonSessionTaskListener taskListener) throws Exception {
        ByteArrayOutputStream bytesOut;
        ArrayList<ByteArrayFileTransferElement> result = new ArrayList<ByteArrayFileTransferElement>();
        for (LicenseInfo info : this.licenses) {
            if (!info.vendorLicense.getHostId().equals("*") && !info.vendorLicense.getHostId().equals(target.getHostId())) continue;
            bytesOut = new ByteArrayOutputStream();
            info.write((OutputStream)bytesOut, true);
            result.add(new ByteArrayFileTransferElement(info.getInstalledFilePath(target.getIsNiagara4()), bytesOut.toByteArray(), (BDaemonFileSpace)target.getDaemonSession().getFileSpace()));
        }
        for (CertificateInfo cert : this.certs) {
            bytesOut = new ByteArrayOutputStream();
            cert.write((OutputStream)bytesOut, true);
            result.add(new ByteArrayFileTransferElement(cert.getInstalledFilePath(target.getIsNiagara4()), bytesOut.toByteArray(), (BDaemonFileSpace)target.getDaemonSession().getFileSpace()));
        }
        return result.toArray(new FileTransferMessageElement[result.size()]);
    }

    public void close() throws Exception {
    }

    public BInstallable makeLocalInstance() {
        return this;
    }
}

