/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.credentials;

import com.tridium.batchJob.driver.BIPrivilegedDeviceJobStep;
import com.tridium.niagarad.util.DaemonAuthUtil;
import com.tridium.nre.auth.GroupAccount;
import com.tridium.nre.auth.UserAccount;
import com.tridium.nre.util.LegacyStorageUtil;
import com.tridium.platDaemon.ui.FipsOptionsHelper;
import com.tridium.platform.daemon.message.AddMemberMessage;
import com.tridium.platform.daemon.message.AddUserMessage;
import com.tridium.platform.daemon.message.AuthenticationInfoMessage;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.DeleteMemberMessage;
import com.tridium.platform.daemon.message.DeleteUserMessage;
import com.tridium.platform.daemon.message.InitializeSessionMessage;
import com.tridium.provisioningNiagara.ProvisioningConnectionUtil;
import java.security.AccessController;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Logger;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.driver.BDeviceJobStep;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.driver.BDevice;
import javax.baja.job.BJobState;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.security.SharedSecretKey;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BPasswordStrength;
import javax.baja.util.Lexicon;
import javax.baja.xml.XElem;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="newName", type="String", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="newPassword", type="BPassword", defaultValue="BPassword.DEFAULT"), @NiagaraProperty(name="isFips", type="BBoolean", defaultValue="BBoolean.FALSE")})
public class BSetPlatformCredentialsJobStep
extends BDeviceJobStep
implements BIPrivilegedDeviceJobStep {
    public static final Property newName = BSetPlatformCredentialsJobStep.newProperty((int)0, (BValue)BString.DEFAULT, null);
    public static final Property newPassword = BSetPlatformCredentialsJobStep.newProperty((int)0, (BValue)BPassword.DEFAULT, null);
    public static final Property isFips = BSetPlatformCredentialsJobStep.newProperty((int)0, (boolean)BBoolean.FALSE.getBoolean(), null);
    public static final Type TYPE = Sys.loadType(BSetPlatformCredentialsJobStep.class);
    public static Logger log = Logger.getLogger("provisioning.setplatformcredentials");
    public static final Lexicon lex = Lexicon.make((String)"provisioningNiagara");

    public String getNewName() {
        return this.getString(newName);
    }

    public void setNewName(String v) {
        this.setString(newName, v, null);
    }

    public BPassword getNewPassword() {
        return (BPassword)this.get(newPassword);
    }

    public void setNewPassword(BPassword v) {
        this.set(newPassword, (BValue)v, null);
    }

    public boolean getIsFips() {
        return this.getBoolean(isFips);
    }

    public void setIsFips(boolean v) {
        this.setBoolean(isFips, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BSetPlatformCredentialsJobStep() {
    }

    public BSetPlatformCredentialsJobStep(String newName, BPassword newPassword, boolean isFips) {
        this.setNewName(newName);
        this.setNewPassword(newPassword);
        this.setIsFips(isFips);
    }

    public BSetPlatformCredentialsJobStep(String newName, BPassword newPassword) {
        this(newName, newPassword, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doRun(BBatchJobService svc, BDeviceStepDetails details, BDevice device, DeviceNetworkJobOp op) throws Exception {
        ProvisioningConnectionUtil util = new ProvisioningConnectionUtil(device, details);
        XElem authInfo = util.getDaemonResponse((DaemonMessage)new AuthenticationInfoMessage());
        XElem authElem = authInfo.elem("auth");
        assert (authElem != null);
        String authMethod = authElem.get("type");
        boolean authReadonly = authElem.getb("readonly", false);
        if (!DaemonAuthUtil.isNativeScheme((String)authMethod)) {
            log.warning(lex.getText("SetPlatformCredentialsJobStep.nativeOnly"));
            details.failed("provisioningNiagara", "SetPlatformCredentialsJobStep.nativeOnly");
            details.complete(BJobState.failed);
            return;
        }
        if (!util.getDaemonSession().getHostProperties().supportsServlet("acctmgt")) {
            log.warning(lex.getText("SetPlatformCredentialsJobStep.noAccountManagement"));
            details.failed("provisioningNiagara", "SetPlatformCredentialsJobStep.noAccountManagement");
            details.complete(BJobState.failed);
            return;
        }
        if (authReadonly) {
            log.warning(lex.getText("SetPlatformCredentialsJobStep.authReadonly"));
            details.failed("provisioningNiagara", "SetPlatformCredentialsJobStep.authReadonly");
            details.complete(BJobState.failed);
            return;
        }
        XElem elem = authElem.elem("admingroup");
        GroupAccount nativeAdminGroup = new GroupAccount(elem.get("name"), elem.get("id"));
        elem = authElem.elem("user");
        boolean defaultUserAccountPresent = elem.getb("default", false);
        BPasswordStrength passwordStrength = new BPasswordStrength(util.getDaemonSession().getPlatformPasswordStrengthRequirements());
        try {
            passwordStrength.isPasswordValid(AccessController.doPrivileged(() -> ((BPassword)this.getNewPassword()).getValue()));
        }
        catch (Exception e) {
            log.warning(lex.getText("SetPlatformCredentialsJobStep.strengthError"));
            details.failed("provisioningNiagara", "SetPlatformCredentialsJobStep.strengthError");
            details.complete(BJobState.failed);
            return;
        }
        UserAccount newUser = new UserAccount(nativeAdminGroup.getDomain() + "\\" + this.getNewName(), null, "", LegacyStorageUtil.encode((String)AccessController.doPrivileged(() -> ((BPassword)this.getNewPassword()).getValue()), (int)0));
        AddUserMessage addUserMessage = new AddUserMessage(newUser);
        SharedSecretKey secretKey = util.getDaemonSession().generateSharedSecretKey("setplatformcredentials_addUser");
        addUserMessage.setSharedKey(secretKey);
        AddMemberMessage addMemberMessage = new AddMemberMessage(nativeAdminGroup, newUser);
        util.sendDaemonMessage((DaemonMessage)addUserMessage);
        util.sendDaemonMessage((DaemonMessage)addMemberMessage);
        FipsOptionsHelper.getInstance().updateUserCookie(this.getNewName(), util.getDaemonSession().getHostProperties().isFips() && this.getIsFips(), util.getDaemonSession());
        BUsernameAndPassword newUserCredentials = new BUsernameAndPassword(this.getNewName(), this.getNewPassword());
        util.getPlatformConnection().setCredentials(newUserCredentials);
        util.getDaemonSession().sendMessage((DaemonMessage)new InitializeSessionMessage());
        if (defaultUserAccountPresent) {
            String defaultAccountUserName = elem.get("name", null);
            UserAccount removeAccount = new UserAccount(nativeAdminGroup.getDomain() + "\\" + defaultAccountUserName, null, null, null);
            DeleteMemberMessage deleteMemberMessage = new DeleteMemberMessage(nativeAdminGroup, removeAccount);
            DeleteUserMessage deleteUserMessage = new DeleteUserMessage(removeAccount);
            util.getDaemonSession().sendMessage((DaemonMessage)deleteMemberMessage);
            util.getDaemonSession().sendMessage((DaemonMessage)deleteUserMessage);
            FipsOptionsHelper.getInstance().updateUserCookie(defaultAccountUserName, util.getDaemonSession().getHostProperties().isFips() && this.getIsFips(), util.getDaemonSession());
        } else {
            log.warning(lex.getText("SetPlatformCredentialsJobStep.noDefault"));
            details.message("provisioningNiagara", "SetPlatformCredentialsJobStep.noDefault");
        }
        details.success();
    }

    public Set<BDevice> getParallelExecutionConflicts(BBatchJobService svc, BDevice device, Set<BDevice> allDevices, DeviceNetworkJobOp op) {
        return Collections.singleton(device);
    }
}

