/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.credentials;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.nd.BNiagaraStation;
import com.tridium.provisioningNiagara.ProvisioningConnectionUtil;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.driver.BDeviceJobStep;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.driver.BDevice;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BIUserCredentials;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;

@NiagaraType
@NiagaraProperty(name="username", type="String", defaultValue="")
public class BRemoveStationUserStep
extends BDeviceJobStep {
    public static final Property username = BRemoveStationUserStep.newProperty((int)0, (String)"", null);
    public static final Type TYPE = Sys.loadType(BRemoveStationUserStep.class);

    public String getUsername() {
        return this.getString(username);
    }

    public void setUsername(String v) {
        this.setString(username, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BRemoveStationUserStep() {
    }

    public BRemoveStationUserStep(String username) {
        this.setUsername(username);
    }

    protected void doRun(BBatchJobService svc, BDeviceStepDetails details, BDevice device, DeviceNetworkJobOp op) throws Exception {
        try (ProvisioningConnectionUtil util = new ProvisioningConnectionUtil(device, details);){
            BFoxSession foxSession = util.getEngagedFoxSession();
            this.removeUser((BNiagaraStation)device, details, foxSession);
        }
        catch (Exception e) {
            details.failed("provisioningNiagara", "RemoveStationUserStep.failed", (Throwable)e);
            details.complete(BJobState.failed);
        }
    }

    private void removeUser(BNiagaraStation station, BDeviceStepDetails details, BFoxSession foxSession) {
        BUserService service = (BUserService)BOrd.make((String)"service:baja:UserService").get((BObject)foxSession);
        service.lease();
        BFoxClientConnection clientConnection = station.getClientConnection();
        BIUserCredentials credentials = clientConnection.getCredentials();
        if (this.getUsername().equals(credentials.getUsername())) {
            details.vaFailed("RemoveStationUserStep.failed.userInUse", new String[]{this.getUsername()});
            details.complete(BJobState.failed);
        } else {
            BUser user = service.getUser(this.getUsername());
            if (user == null) {
                details.vaFailed("RemoveStationUserStep.failed.userNotFound", new String[]{this.getUsername()});
            } else {
                service.remove((BComplex)user);
                details.vaMessage("RemoveStationUserStep.userRemoved", new String[]{this.getUsername()});
            }
            details.success();
        }
    }

    public String toString(Context context) {
        return super.toString(context) + " (" + this.getUsername() + ")";
    }
}

