/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.component;

import java.security.AccessController;
import java.util.Collections;
import java.util.Set;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.driver.BDeviceJobStep;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.driver.BDevice;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.search.BResultsRequest;
import javax.baja.search.BSearchParams;
import javax.baja.search.BSearchResult;
import javax.baja.search.BSearchResultSet;
import javax.baja.search.BSearchService;
import javax.baja.security.BIDeferOwnership;
import javax.baja.security.BPassword;
import javax.baja.security.BPasswordAuthenticator;
import javax.baja.security.BPasswordCache;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIObject;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.NoSuchSlotException;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.BTypeConfig;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BUnrestrictedFolder;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="target", type="BOrd", defaultValue="BOrd.make(\"station:|slot:/\")"), @NiagaraProperty(name="propertyName", type="String", defaultValue=""), @NiagaraProperty(name="propertyType", type="BTypeSpec", defaultValue="BTypeSpec.make(BString.TYPE)"), @NiagaraProperty(name="value", type="BValue", flags=32, defaultValue="BString.DEFAULT"), @NiagaraProperty(name="addIfMissing", type="boolean", defaultValue="false"), @NiagaraProperty(name="multiTarget", type="boolean", defaultValue="false"), @NiagaraProperty(name="targetValueList", type="BVector", defaultValue="new BVector()"), @NiagaraProperty(name="useNeql", type="boolean", defaultValue="false"), @NiagaraProperty(name="neqlPredicate", type="String", defaultValue="")})
public class BSetPropertyJobStep
extends BDeviceJobStep {
    public static final Property target = BSetPropertyJobStep.newProperty((int)0, (BValue)BOrd.make((String)"station:|slot:/"), null);
    public static final Property propertyName = BSetPropertyJobStep.newProperty((int)0, (String)"", null);
    public static final Property propertyType = BSetPropertyJobStep.newProperty((int)0, (BValue)BTypeSpec.make((Type)BString.TYPE), null);
    public static final Property value = BSetPropertyJobStep.newProperty((int)32, (BValue)BString.DEFAULT, null);
    public static final Property addIfMissing = BSetPropertyJobStep.newProperty((int)0, (boolean)false, null);
    public static final Property multiTarget = BSetPropertyJobStep.newProperty((int)0, (boolean)false, null);
    public static final Property targetValueList = BSetPropertyJobStep.newProperty((int)0, (BValue)new BVector(), null);
    public static final Property useNeql = BSetPropertyJobStep.newProperty((int)0, (boolean)false, null);
    public static final Property neqlPredicate = BSetPropertyJobStep.newProperty((int)0, (String)"", null);
    public static final Type TYPE = Sys.loadType(BSetPropertyJobStep.class);
    private static final BIcon icon = BIcon.std((String)"property.png");

    public BOrd getTarget() {
        return (BOrd)this.get(target);
    }

    public void setTarget(BOrd v) {
        this.set(target, (BValue)v, null);
    }

    public String getPropertyName() {
        return this.getString(propertyName);
    }

    public void setPropertyName(String v) {
        this.setString(propertyName, v, null);
    }

    public BTypeSpec getPropertyType() {
        return (BTypeSpec)this.get(propertyType);
    }

    public void setPropertyType(BTypeSpec v) {
        this.set(propertyType, (BValue)v, null);
    }

    public BValue getValue() {
        return this.get(value);
    }

    public void setValue(BValue v) {
        this.set(value, v, null);
    }

    public boolean getAddIfMissing() {
        return this.getBoolean(addIfMissing);
    }

    public void setAddIfMissing(boolean v) {
        this.setBoolean(addIfMissing, v, null);
    }

    public boolean getMultiTarget() {
        return this.getBoolean(multiTarget);
    }

    public void setMultiTarget(boolean v) {
        this.setBoolean(multiTarget, v, null);
    }

    public BVector getTargetValueList() {
        return (BVector)this.get(targetValueList);
    }

    public void setTargetValueList(BVector v) {
        this.set(targetValueList, (BValue)v, null);
    }

    public boolean getUseNeql() {
        return this.getBoolean(useNeql);
    }

    public void setUseNeql(boolean v) {
        this.setBoolean(useNeql, v, null);
    }

    public String getNeqlPredicate() {
        return this.getString(neqlPredicate);
    }

    public void setNeqlPredicate(String v) {
        this.setString(neqlPredicate, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    /*
     * Exception decompiling
     */
    protected void doRun(BBatchJobService svc, BDeviceStepDetails details, BDevice device, DeviceNetworkJobOp op) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundSuperForBase(org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance)" because "bindingSuperContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.getIterableIterType(LoopLivenessClash.java:35)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.detect(LoopLivenessClash.java:66)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.detect(LoopLivenessClash.java:25)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:827)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean checkSingleValue(BValue value, BObject target, BDeviceStepDetails details) {
        if (target instanceof BUser && this.getPropertyName().equals(BUser.authenticator.getName())) {
            details.failed("provisioningNiagara", "SetPropertyJobStep.failed.userAuthenticator");
            details.complete(BJobState.failed);
            return false;
        }
        if (target instanceof BPasswordAuthenticator && this.getPropertyName().equals(BPasswordCache.password.getName())) {
            details.failed("provisioningNiagara", "SetPropertyJobStep.failed.userPassword");
            details.complete(BJobState.failed);
            return false;
        }
        if (value instanceof BUser) {
            details.failed("provisioningNiagara", "SetPropertyJobStep.failed.user");
            details.complete(BJobState.failed);
            return false;
        }
        return true;
    }

    private void setValueOnTarget(BValue value, BObject target, BDeviceStepDetails details) {
        if (value instanceof BPassword && ((BPassword)value).getPasswordEncoder().isReversible()) {
            value = BPassword.make((String)AccessController.doPrivileged(() -> ((BPassword)((BPassword)value)).getValue()));
        } else if (value instanceof BIDeferOwnership && value instanceof BComplex) {
            BSetPropertyJobStep.makePasswordsSharable((BComplex)value);
        }
        String targetString = this.getTarget().toString();
        if (target instanceof BComponent) {
            ((BComponent)target).lease();
            targetString = ((BComponent)target).getSlotPath().toDisplayString();
        }
        String escapedName = SlotPath.escape((String)this.getPropertyName());
        Property property = target.asComplex().getProperty(escapedName);
        if (property != null) {
            if (property.isFrozen() && !value.getType().is(property.getType())) {
                details.vaFailed("SetPropertyJobStep.failed.wrongType", new String[]{this.getPropertyName(), property.getDeclaringType().toString(), value.getType().toString()});
                details.complete(BJobState.failed);
            } else {
                target.asComplex().set(property, value);
                details.vaMessage("SetPropertyJobStep.set", new String[]{this.getPropertyName(), targetString, value.toString()});
                details.success();
            }
        } else if (this.getAddIfMissing()) {
            if (target.isComponent()) {
                target.asComponent().add(escapedName, value);
                details.vaMessage("SetPropertyJobStep.added", new String[]{this.getPropertyName(), targetString, value.toString()});
                details.success();
            } else {
                details.vaFailed("SetPropertyJobStep.failed.notComponent", new String[]{this.getPropertyName()});
                details.complete(BJobState.failed);
            }
        } else {
            details.vaFailed("SetPropertyJobStep.failed.missingProperty", new String[]{this.getPropertyName()});
            details.complete(BJobState.failed);
        }
    }

    private static void makePasswordsSharable(BComplex value) {
        Property[] properties;
        for (Property property : properties = value.getPropertiesArray()) {
            BValue propValue = value.get(property);
            if (propValue instanceof BPassword) {
                propValue = BPassword.make((String)AccessController.doPrivileged(() -> ((BPassword)((BPassword)propValue)).getValue()));
                value.set(property, propValue);
                continue;
            }
            if (!(propValue instanceof BIDeferOwnership) || !(propValue instanceof BComplex)) continue;
            BSetPropertyJobStep.makePasswordsSharable((BComplex)propValue);
        }
    }

    public void initValue(BValue value) {
        BTypeSpec typeSpec = BTypeSpec.make((Type)value.getType());
        this.setPropertyType(typeSpec);
        if (value instanceof BComplex) {
            BUnrestrictedFolder folder = new BUnrestrictedFolder();
            for (Property property : ((BComplex)value).getPropertiesArray()) {
                folder.add(property.getName(), ((BComplex)value).get(property).newCopy(true));
            }
            this.setValue((BValue)folder);
        } else {
            this.setValue(value);
        }
    }

    public BValue getInitializedValue() {
        BTypeSpec propertyType = this.getPropertyType();
        if (propertyType.getResolvedType().is(BComplex.TYPE)) {
            BComplex value = (BComplex)propertyType.getResolvedType().getInstance();
            BComplex storedValue = (BComplex)this.getValue();
            for (Property property : storedValue.getPropertiesArray()) {
                try {
                    value.set(property.getName(), storedValue.get(property).newCopy(true));
                }
                catch (NoSuchSlotException e) {
                    if (!value.getType().is(BTypeConfig.TYPE)) continue;
                    BTypeConfig typeConfigValue = (BTypeConfig)value;
                    BObject typeSpecObject = typeConfigValue.getTypeSpec().getInstance();
                    if (!(typeSpecObject instanceof BTypeConfig.IConfigurable)) {
                        throw e;
                    }
                    for (String key : ((BTypeConfig.IConfigurable)typeSpecObject).listConfig()) {
                        if (!SlotPath.escape((String)key).equals(property.getName())) continue;
                        typeConfigValue.add(SlotPath.escape((String)key), storedValue.get(property).newCopy(true), 1, ((BTypeConfig.IConfigurable)typeSpecObject).getConfigFacets(key), null);
                    }
                }
            }
            return value;
        }
        return this.getValue();
    }

    public void addByStationValue(String deviceName, BValue byStationValue) {
        BTypeSpec typeSpec = BTypeSpec.make((Type)byStationValue.getType());
        this.setPropertyType(typeSpec);
        if (byStationValue instanceof BComplex) {
            BUnrestrictedFolder folder = new BUnrestrictedFolder();
            for (Property property : ((BComplex)byStationValue).getPropertiesArray()) {
                folder.add(property.getName(), ((BComplex)byStationValue).get(property).newCopy(true));
            }
            this.getTargetValueList().add(deviceName, (BValue)folder);
        } else {
            this.getTargetValueList().add(deviceName, byStationValue);
        }
    }

    public BValue getByStationValue(String deviceName) {
        BTypeSpec propertyType = this.getPropertyType();
        Property[] byStationProperties = this.getTargetValueList().getPropertiesArray();
        if (byStationProperties == null || byStationProperties.length == 0) {
            return null;
        }
        for (Property p : byStationProperties) {
            if (!p.getName().contentEquals(deviceName)) continue;
            if (propertyType.getResolvedType().is(BComplex.TYPE)) {
                BComplex value = (BComplex)propertyType.getResolvedType().getInstance();
                BComplex storedValue = (BComplex)this.getTargetValueList().get(p);
                for (Property property : storedValue.getPropertiesArray()) {
                    value.set(property.getName(), storedValue.get(property).newCopy(true));
                }
                return value;
            }
            BValue value = this.getTargetValueList().get(p);
            return value.newCopy(true);
        }
        return null;
    }

    public static Array<BComponent> findMatchingObjects(String neqlPredicate, BSearchService searchService, BDeviceStepDetails details) {
        if (searchService == null || !searchService.getStatus().isValid()) {
            details.failed("provisioningNiagara", "SetPropertyJobStep.failed.noSearchService");
            details.complete(BJobState.failed);
            return null;
        }
        BComponent rootComponent = searchService.getComponentSpace().getRootComponent();
        BSearchParams bSearchParams = new BSearchParams("neql:" + neqlPredicate, (BIObject)rootComponent);
        BOrd searchTask = searchService.search(bSearchParams).relativizeToSession();
        try {
            searchService.getComponentSpace().sync();
        }
        catch (Exception e) {
            details.failed("provisioningNiagara", "SetPropertyJobStep.failed.spaceSync", e.getLocalizedMessage(), (Throwable)e);
            details.complete(BJobState.failed);
            return null;
        }
        BSearchResultSet results = null;
        boolean resultsComplete = false;
        int startItem = 0;
        Array matchingObjects = new Array(BComponent.class);
        long maxTicks = Clock.ticks() + 60000L;
        while (!resultsComplete && Clock.ticks() < maxTicks) {
            resultsComplete = results != null && results.getResultsComplete();
            BResultsRequest resultsRequest = BResultsRequest.make((BOrd)searchTask, (int)startItem, (int)10);
            results = searchService.retrieveResults(resultsRequest);
            startItem += results.getResultCount();
            SlotCursor props = results.getResults().getProperties();
            while (props.next()) {
                BSearchResult result = (BSearchResult)props.get();
                BOrd ord = result.getOrd().relativizeToSession();
                BObject object = ord.get((BObject)searchService);
                if (!(object instanceof BComponent)) continue;
                BComponent comp = (BComponent)object;
                matchingObjects.add((Object)comp);
            }
            try {
                Thread.sleep(50L);
            }
            catch (Exception e) {
                details.failed("provisioningNiagara", "SetPropertyJobStep.failed.idlingThread", e.getLocalizedMessage(), (Throwable)e);
                details.complete(BJobState.failed);
                return null;
            }
        }
        return matchingObjects;
    }

    public BIcon getIcon() {
        return icon;
    }

    public String toString(Context cx) {
        String targetType = this.getUseNeql() ? "NEQL" : "ORD";
        String targetString = this.getUseNeql() ? this.getNeqlPredicate() : this.getTarget().toString();
        String valueString = this.getMultiTarget() ? "Unique per device" : this.getInitializedValue().toString();
        return this.getLexicon().getText("SetPropertyJobStep.display", new Object[]{targetType, targetString, valueString});
    }

    public Set<BDevice> getParallelExecutionConflicts(BBatchJobService svc, BDevice device, Set<BDevice> allDevices, DeviceNetworkJobOp op) {
        return Collections.singleton(device);
    }
}

