/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.certificate;

import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.cert.NPKCS10CertificationRequest;
import com.tridium.crypto.core.cert.NSigningParameters;
import com.tridium.crypto.core.cert.NX509Certificate;
import com.tridium.crypto.core.cert.NX509CertificateEntry;
import com.tridium.crypto.core.cert.NX509Extension;
import com.tridium.crypto.core.io.CoreCryptoManager;
import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.crypto.core.io.ICoreKeyStore;
import com.tridium.nre.security.ISecurityInfoProvider;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.platcrypto.core.BCertManagerService;
import com.tridium.platcrypto.daemon.BPlatCryptoManager;
import com.tridium.platcrypto.fox.ChannelCryptoManager;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.provisioningNiagara.ProvisioningConnectionUtil;
import java.security.AccessController;
import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.driver.BDeviceJobStep;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.driver.BDevice;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="serverCertAlias", type="String", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="caCertAlias", type="String", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="caPassword", type="BPassword", defaultValue="BPassword.DEFAULT"), @NiagaraProperty(name="notBefore", type="baja:AbsTime", defaultValue="BAbsTime.DEFAULT"), @NiagaraProperty(name="notAfter", type="baja:AbsTime", defaultValue="BAbsTime.DEFAULT")})
public class BSignCertJobStep
extends BDeviceJobStep {
    public static final Property serverCertAlias = BSignCertJobStep.newProperty((int)0, (BValue)BString.DEFAULT, null);
    public static final Property caCertAlias = BSignCertJobStep.newProperty((int)0, (BValue)BString.DEFAULT, null);
    public static final Property caPassword = BSignCertJobStep.newProperty((int)0, (BValue)BPassword.DEFAULT, null);
    public static final Property notBefore = BSignCertJobStep.newProperty((int)0, (BValue)BAbsTime.DEFAULT, null);
    public static final Property notAfter = BSignCertJobStep.newProperty((int)0, (BValue)BAbsTime.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BSignCertJobStep.class);

    public String getServerCertAlias() {
        return this.getString(serverCertAlias);
    }

    public void setServerCertAlias(String v) {
        this.setString(serverCertAlias, v, null);
    }

    public String getCaCertAlias() {
        return this.getString(caCertAlias);
    }

    public void setCaCertAlias(String v) {
        this.setString(caCertAlias, v, null);
    }

    public BPassword getCaPassword() {
        return (BPassword)this.get(caPassword);
    }

    public void setCaPassword(BPassword v) {
        this.set(caPassword, (BValue)v, null);
    }

    public BAbsTime getNotBefore() {
        return (BAbsTime)this.get(notBefore);
    }

    public void setNotBefore(BAbsTime v) {
        this.set(notBefore, (BValue)v, null);
    }

    public BAbsTime getNotAfter() {
        return (BAbsTime)this.get(notAfter);
    }

    public void setNotAfter(BAbsTime v) {
        this.set(notAfter, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BSignCertJobStep() {
    }

    public BSignCertJobStep(String serverCertAlias, String caCertAlias, BPassword caPassword, BAbsTime notBefore, BAbsTime notAfter) {
        this.setServerCertAlias(serverCertAlias);
        this.setCaCertAlias(caCertAlias);
        this.setCaPassword(caPassword);
        this.setNotBefore(notBefore);
        this.setNotAfter(notAfter);
    }

    protected void doRun(BBatchJobService svc, BDeviceStepDetails details, BDevice device, DeviceNetworkJobOp op) throws Exception {
        NX509Extension[] extensions;
        PrivateKey privateKey;
        X509Certificate caCertificate;
        NPKCS10CertificationRequest csr;
        BPlatCryptoManager remoteCoreCryptoManager;
        ICoreCryptoManager localCoreCryptoManager;
        try {
            localCoreCryptoManager = (ICoreCryptoManager)AccessController.doPrivileged(() -> CoreCryptoManager.get((ISecurityInfoProvider)SecurityInitializer.getInstance().getSecurityInfoProvider()));
        }
        catch (Exception e) {
            details.failed("provisioningNiagara", "SignCertJobStep.failed.remoteCcm", (Throwable)e);
            details.complete(BJobState.failed);
            return;
        }
        ProvisioningConnectionUtil util = new ProvisioningConnectionUtil(device, details);
        boolean stationRunning = util.hasRunningStation();
        Object session = stationRunning ? util.getEngagedFoxSession() : util.getDaemonSession();
        if (stationRunning) {
            BCertManagerService remoteCertService = (BCertManagerService)BOrd.make((String)"service:platCrypto:CertManagerService").get((BObject)session);
            remoteCoreCryptoManager = new ChannelCryptoManager((BComponent)remoteCertService);
        } else {
            remoteCoreCryptoManager = new BPlatCryptoManager((BDaemonSession)session);
        }
        try {
            csr = remoteCoreCryptoManager.generateCSR(this.getServerCertAlias(), null);
        }
        catch (Exception e) {
            util.disengageFoxSession();
            details.failed("provisioningNiagara", "SignCertJobStep.failed.csr", (Throwable)e);
            details.complete(BJobState.failed);
            return;
        }
        if (csr == null) {
            util.disengageFoxSession();
            details.failed("provisioningNiagara", "SignCertJobStep.failed.csr");
            details.complete(BJobState.failed);
            return;
        }
        try {
            caCertificate = localCoreCryptoManager.getKeyStore().getCertificate(this.getCaCertAlias());
            if (caCertificate == null) {
                details.failed("provisioningNiagara", "SignCertJobStep.failed.ca");
                details.complete(BJobState.failed);
                return;
            }
            privateKey = (PrivateKey)localCoreCryptoManager.getKeyStore().getKey(this.getCaCertAlias(), AccessController.doPrivileged(() -> ((BPassword)this.getCaPassword()).getValue()).toCharArray());
        }
        catch (Exception e) {
            details.failed("provisioningNiagara", "SignCertJobStep.failed.caPassword", (Throwable)e);
            details.complete(BJobState.failed);
            return;
        }
        NX509CertificateEntry ca = NX509CertificateEntry.make(null, (X509Certificate[])new X509Certificate[]{caCertificate}, (PrivateKey)privateKey);
        Date notBeforeDate = new Date(this.getNotBefore().getMillis());
        Date notAfterDate = new Date(this.getNotAfter().getMillis());
        NSigningParameters params = NSigningParameters.make((Date)notBeforeDate, (Date)notAfterDate);
        for (NX509Extension ext : extensions = csr.getExtensions()) {
            params.addExtension(ext);
        }
        NX509Certificate signedCertificate = CertUtils.signCertificate((NPKCS10CertificationRequest)csr, (NX509CertificateEntry)ca, (NSigningParameters)params);
        X509Certificate[] caChain = localCoreCryptoManager.getKeyStore().getCertificateChain(this.getCaCertAlias());
        X509Certificate[] certChain = new X509Certificate[caChain.length + 1];
        certChain[0] = signedCertificate.getCertificate();
        System.arraycopy(caChain, 0, certChain, 1, caChain.length);
        ICoreKeyStore keyStore = remoteCoreCryptoManager.getKeyStore();
        PrivateKey serverPrivateKey = (PrivateKey)keyStore.getKey(this.getServerCertAlias(), null);
        if (serverPrivateKey == null) {
            details.failed("provisioningNiagara", "SignCertJobStep.failed.remoteCert");
            details.complete(BJobState.failed);
            return;
        }
        keyStore.setKeyEntry(this.getServerCertAlias(), (Key)serverPrivateKey, null, certChain);
        keyStore.save();
        util.reset();
        details.message("provisioningNiagara", "SignCertJobStep.signed");
        details.success();
    }

    public Set<BDevice> getParallelExecutionConflicts(BBatchJobService svc, BDevice device, Set<BDevice> allDevices, DeviceNetworkJobOp op) {
        return Collections.singleton(device);
    }
}

