/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.certificate;

import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.cert.KeyPurpose;
import com.tridium.crypto.core.cert.NCertificateParameters;
import com.tridium.platcrypto.core.BCertManagerService;
import com.tridium.platcrypto.daemon.BPlatCryptoManager;
import com.tridium.platcrypto.fox.ChannelCryptoManager;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.provisioningNiagara.ProvisioningConnectionUtil;
import java.security.AccessController;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.driver.BDeviceJobStep;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.driver.BDevice;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="alias", type="String", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="commonName", type="String", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="organizationalUnit", type="String", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="organization", type="String", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="locality", type="String", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="stateProvince", type="String", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="countryCode", type="String", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="notBefore", type="baja:AbsTime", defaultValue="BAbsTime.DEFAULT"), @NiagaraProperty(name="notAfter", type="baja:AbsTime", defaultValue="BAbsTime.DEFAULT"), @NiagaraProperty(name="keySize", type="int", defaultValue="2048"), @NiagaraProperty(name="purpose", type="int", defaultValue="1"), @NiagaraProperty(name="alternateServerName", type="String", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="emailAddress", type="String", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="password", type="BPassword", defaultValue="BPassword.DEFAULT")})
public class BGenerateCertJobStep
extends BDeviceJobStep {
    public static final Property alias = BGenerateCertJobStep.newProperty((int)0, (BValue)BString.DEFAULT, null);
    public static final Property commonName = BGenerateCertJobStep.newProperty((int)0, (BValue)BString.DEFAULT, null);
    public static final Property organizationalUnit = BGenerateCertJobStep.newProperty((int)0, (BValue)BString.DEFAULT, null);
    public static final Property organization = BGenerateCertJobStep.newProperty((int)0, (BValue)BString.DEFAULT, null);
    public static final Property locality = BGenerateCertJobStep.newProperty((int)0, (BValue)BString.DEFAULT, null);
    public static final Property stateProvince = BGenerateCertJobStep.newProperty((int)0, (BValue)BString.DEFAULT, null);
    public static final Property countryCode = BGenerateCertJobStep.newProperty((int)0, (BValue)BString.DEFAULT, null);
    public static final Property notBefore = BGenerateCertJobStep.newProperty((int)0, (BValue)BAbsTime.DEFAULT, null);
    public static final Property notAfter = BGenerateCertJobStep.newProperty((int)0, (BValue)BAbsTime.DEFAULT, null);
    public static final Property keySize = BGenerateCertJobStep.newProperty((int)0, (int)2048, null);
    public static final Property purpose = BGenerateCertJobStep.newProperty((int)0, (int)1, null);
    public static final Property alternateServerName = BGenerateCertJobStep.newProperty((int)0, (BValue)BString.DEFAULT, null);
    public static final Property emailAddress = BGenerateCertJobStep.newProperty((int)0, (BValue)BString.DEFAULT, null);
    public static final Property password = BGenerateCertJobStep.newProperty((int)0, (BValue)BPassword.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BGenerateCertJobStep.class);
    public static final Lexicon lex = Lexicon.make((String)"provisioningNiagara");

    public String getAlias() {
        return this.getString(alias);
    }

    public void setAlias(String v) {
        this.setString(alias, v, null);
    }

    public String getCommonName() {
        return this.getString(commonName);
    }

    public void setCommonName(String v) {
        this.setString(commonName, v, null);
    }

    public String getOrganizationalUnit() {
        return this.getString(organizationalUnit);
    }

    public void setOrganizationalUnit(String v) {
        this.setString(organizationalUnit, v, null);
    }

    public String getOrganization() {
        return this.getString(organization);
    }

    public void setOrganization(String v) {
        this.setString(organization, v, null);
    }

    public String getLocality() {
        return this.getString(locality);
    }

    public void setLocality(String v) {
        this.setString(locality, v, null);
    }

    public String getStateProvince() {
        return this.getString(stateProvince);
    }

    public void setStateProvince(String v) {
        this.setString(stateProvince, v, null);
    }

    public String getCountryCode() {
        return this.getString(countryCode);
    }

    public void setCountryCode(String v) {
        this.setString(countryCode, v, null);
    }

    public BAbsTime getNotBefore() {
        return (BAbsTime)this.get(notBefore);
    }

    public void setNotBefore(BAbsTime v) {
        this.set(notBefore, (BValue)v, null);
    }

    public BAbsTime getNotAfter() {
        return (BAbsTime)this.get(notAfter);
    }

    public void setNotAfter(BAbsTime v) {
        this.set(notAfter, (BValue)v, null);
    }

    public int getKeySize() {
        return this.getInt(keySize);
    }

    public void setKeySize(int v) {
        this.setInt(keySize, v, null);
    }

    public int getPurpose() {
        return this.getInt(purpose);
    }

    public void setPurpose(int v) {
        this.setInt(purpose, v, null);
    }

    public String getAlternateServerName() {
        return this.getString(alternateServerName);
    }

    public void setAlternateServerName(String v) {
        this.setString(alternateServerName, v, null);
    }

    public String getEmailAddress() {
        return this.getString(emailAddress);
    }

    public void setEmailAddress(String v) {
        this.setString(emailAddress, v, null);
    }

    public BPassword getPassword() {
        return (BPassword)this.get(password);
    }

    public void setPassword(BPassword v) {
        this.set(password, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BGenerateCertJobStep() {
    }

    public BGenerateCertJobStep(String alias, String commonName, String organizationalUnit, String organization, String locality, String stateProvince, String countryCode, BAbsTime notBefore, BAbsTime notAfter, int keySize, int purpose, String alternativeServerName, String emailAddress, BPassword password) {
        this.setAlias(alias);
        this.setCommonName(commonName);
        this.setOrganizationalUnit(organizationalUnit);
        this.setOrganization(organization);
        this.setLocality(locality);
        this.setStateProvince(stateProvince);
        this.setCountryCode(countryCode);
        this.setNotBefore(notBefore);
        this.setNotAfter(notAfter);
        this.setKeySize(keySize);
        this.setPurpose(purpose);
        this.setAlternateServerName(alternativeServerName);
        this.setEmailAddress(emailAddress);
        if (password != null) {
            this.setPassword(password);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRun(BBatchJobService svc, BDeviceStepDetails details, BDevice device, DeviceNetworkJobOp op) throws Exception {
        BPlatCryptoManager ccm;
        ProvisioningConnectionUtil util = new ProvisioningConnectionUtil(device, details);
        boolean stationRunning = util.hasRunningStation();
        Object session = stationRunning ? util.getEngagedFoxSession() : util.getDaemonSession();
        String tempName = this.getCommonName();
        if (tempName.equals(lex.getText("GenerateCertDialog.hostname"))) {
            tempName = session.getHost().getHostname();
        }
        String dn = CertUtils.assembleDN((String)(tempName.length() > 0 ? tempName : null), (String)(this.getOrganizationalUnit().length() > 0 ? this.getOrganizationalUnit() : null), (String)(this.getOrganization().length() > 0 ? this.getOrganization() : null), (String)(this.getLocality().length() > 0 ? this.getLocality() : null), (String)(this.getStateProvince().length() > 0 ? this.getStateProvince() : null), (String)(this.getCountryCode().length() > 0 ? this.getCountryCode() : null));
        NCertificateParameters certParams = new NCertificateParameters(this.getAlias(), dn, dn, new Date(this.getNotBefore().getMillis()), new Date(this.getNotAfter().getMillis()), this.getKeySize(), KeyPurpose.values()[this.getPurpose()], this.getAlternateServerName().length() > 0 ? this.getAlternateServerName() : null, this.getEmailAddress().length() > 0 ? this.getEmailAddress() : null, this.getPassword() != null && !this.getPassword().isDefault() ? AccessController.doPrivileged(() -> ((BPassword)this.getPassword()).getValue()) : null);
        if (stationRunning) {
            BCertManagerService remoteCertService = (BCertManagerService)BOrd.make((String)"service:platCrypto:CertManagerService").get((BObject)session);
            ccm = new ChannelCryptoManager((BComponent)remoteCertService);
        } else {
            ccm = new BPlatCryptoManager((BDaemonSession)session);
        }
        try {
            details.message("provisioningNiagara", "GenerateCertJobStep.generating");
            int requestId = ccm.generateSelfSignedCert(certParams);
            while (true) {
                int status;
                if ((status = ccm.getCertGenerationStatus(requestId)) == -1) {
                    details.failed("provisioningNiagara", "GenerateCertJobStep.failed");
                    details.complete(BJobState.failed);
                    break;
                }
                if (status == 2) {
                    details.message("provisioningNiagara", "GenerateCertJobStep.generated");
                    details.success();
                    break;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
            }
        }
        finally {
            util.reset();
        }
    }

    public Set<BDevice> getParallelExecutionConflicts(BBatchJobService svc, BDevice device, Set<BDevice> allDevices, DeviceNetworkJobOp op) {
        return Collections.singleton(device);
    }
}

