/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara;

import com.tridium.authn.AuthenticationClient;
import com.tridium.fox.sys.BFoxChannelRegistry;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.provisioningNiagara.BNiagaraProvisioningChannel;
import com.tridium.provisioningNiagara.BPlatformConnection;
import com.tridium.provisioningNiagara.BProvisioningStationExt;
import com.tridium.provisioningNiagara.backup.BBackupStationExt;
import com.tridium.provisioningNiagara.bootstrap.BDeviceBootstrapExt;
import com.tridium.provisioningNiagara.license.BLicenseStationExt;
import com.tridium.provisioningNiagara.license.BSupervisorLicenses;
import com.tridium.provisioningNiagara.software.BSoftwareContainer;
import com.tridium.provisioningNiagara.software.BSoftwareStationExt;
import com.tridium.provisioningNiagara.software.ProvisioningRegistry;
import com.tridium.provisioningNiagara.station.BStationPollScheduler;
import com.tridium.provisioningNiagara.station.BStationProxy;
import com.tridium.provisioningNiagara.template.BTemplateStationExt;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceExt;
import javax.baja.fox.BFoxProxySession;
import javax.baja.license.Feature;
import javax.baja.naming.BHost;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BIUserCredentials;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeNotFoundException;
import javax.baja.units.BUnit;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="software", type="provisioningNiagara:SoftwareContainer", defaultValue="new BSoftwareContainer()", flags=3), @NiagaraProperty(name="licenses", type="provisioningNiagara:SupervisorLicenses", defaultValue="new BSupervisorLicenses()", flags=1), @NiagaraProperty(name="pollScheduler", type="provisioningNiagara:StationPollScheduler", defaultValue="new BStationPollScheduler()"), @NiagaraProperty(name="deviceRebootTimeout", type="int", defaultValue="600", facets={@Facet(name="BFacets.UNITS", value="BUnit.getUnit(\"second\")"), @Facet(name="BFacets.MIN", value="0"), @Facet(name="BFacets.MAX", value="Integer.MAX_VALUE")}), @NiagaraProperty(name="stationShutdownTimeout", type="int", defaultValue="180", facets={@Facet(name="BFacets.UNITS", value="BUnit.getUnit(\"second\")"), @Facet(name="BFacets.MIN", value="0"), @Facet(name="BFacets.MAX", value="Integer.MAX_VALUE")}), @NiagaraProperty(name="connectTimeout", type="int", defaultValue="60000", facets={@Facet(name="BFacets.UNITS", value="BUnit.getUnit(\"millisecond\")"), @Facet(name="BFacets.MIN", value="0"), @Facet(name="BFacets.MAX", value="Integer.MAX_VALUE")}), @NiagaraProperty(name="socketTimeout", type="int", defaultValue="5000", facets={@Facet(name="BFacets.UNITS", value="BUnit.getUnit(\"millisecond\")"), @Facet(name="BFacets.MIN", value="0"), @Facet(name="BFacets.MAX", value="Integer.MAX_VALUE")})})
public class BProvisioningNiagaraNetworkExt
extends BAbstractService {
    public static final Property software = BProvisioningNiagaraNetworkExt.newProperty((int)3, (BValue)new BSoftwareContainer(), null);
    public static final Property licenses = BProvisioningNiagaraNetworkExt.newProperty((int)1, (BValue)new BSupervisorLicenses(), null);
    public static final Property pollScheduler = BProvisioningNiagaraNetworkExt.newProperty((int)0, (BValue)new BStationPollScheduler(), null);
    public static final Property deviceRebootTimeout = BProvisioningNiagaraNetworkExt.newProperty((int)0, (int)600, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"second")), (BFacets)BFacets.make((String)"min", (int)0)), (BFacets)BFacets.make((String)"max", (int)Integer.MAX_VALUE)));
    public static final Property stationShutdownTimeout = BProvisioningNiagaraNetworkExt.newProperty((int)0, (int)180, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"second")), (BFacets)BFacets.make((String)"min", (int)0)), (BFacets)BFacets.make((String)"max", (int)Integer.MAX_VALUE)));
    public static final Property connectTimeout = BProvisioningNiagaraNetworkExt.newProperty((int)0, (int)60000, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"millisecond")), (BFacets)BFacets.make((String)"min", (int)0)), (BFacets)BFacets.make((String)"max", (int)Integer.MAX_VALUE)));
    public static final Property socketTimeout = BProvisioningNiagaraNetworkExt.newProperty((int)0, (int)5000, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"millisecond")), (BFacets)BFacets.make((String)"min", (int)0)), (BFacets)BFacets.make((String)"max", (int)Integer.MAX_VALUE)));
    public static final Type TYPE = Sys.loadType(BProvisioningNiagaraNetworkExt.class);
    private static final Type[] serviceTypes = new Type[]{TYPE};
    private static final BIcon icon = BIcon.std((String)"provisioning.png");
    private ProvisioningRegistry installableRegistry = null;
    private boolean serviceStarted = false;
    private CompletableFuture<Void> whenServiceStarted = new CompletableFuture();
    private static final Logger logger = Logger.getLogger("provisioningNiagara");

    public BSoftwareContainer getSoftware() {
        return (BSoftwareContainer)this.get(software);
    }

    public void setSoftware(BSoftwareContainer v) {
        this.set(software, (BValue)v, null);
    }

    public BSupervisorLicenses getLicenses() {
        return (BSupervisorLicenses)this.get(licenses);
    }

    public void setLicenses(BSupervisorLicenses v) {
        this.set(licenses, (BValue)v, null);
    }

    public BStationPollScheduler getPollScheduler() {
        return (BStationPollScheduler)this.get(pollScheduler);
    }

    public void setPollScheduler(BStationPollScheduler v) {
        this.set(pollScheduler, (BValue)v, null);
    }

    public int getDeviceRebootTimeout() {
        return this.getInt(deviceRebootTimeout);
    }

    public void setDeviceRebootTimeout(int v) {
        this.setInt(deviceRebootTimeout, v, null);
    }

    public int getStationShutdownTimeout() {
        return this.getInt(stationShutdownTimeout);
    }

    public void setStationShutdownTimeout(int v) {
        this.setInt(stationShutdownTimeout, v, null);
    }

    public int getConnectTimeout() {
        return this.getInt(connectTimeout);
    }

    public void setConnectTimeout(int v) {
        this.setInt(connectTimeout, v, null);
    }

    public int getSocketTimeout() {
        return this.getInt(socketTimeout);
    }

    public void setSocketTimeout(int v) {
        this.setInt(socketTimeout, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BNiagaraNetwork getNetwork() {
        return (BNiagaraNetwork)this.getParent();
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BNiagaraNetwork;
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property == enabled) {
            this.updateStatus();
        }
    }

    public Type[] getServiceTypes() {
        return serviceTypes;
    }

    public void started() {
        logger.fine("Enabling provisioning mix-ins");
        long startTimeMS = Clock.ticks();
        BComponentSpace space = this.getComponentSpace();
        space.enableMixIn(BPlatformConnection.TYPE);
        space.enableMixIn(BStationProxy.TYPE);
        space.enableMixIn(BSoftwareStationExt.TYPE);
        space.enableMixIn(BBackupStationExt.TYPE);
        space.enableMixIn(BLicenseStationExt.TYPE);
        space.enableMixIn(BTemplateStationExt.TYPE);
        space.enableMixIn(BDeviceBootstrapExt.TYPE);
        logger.fine(() -> String.format("Provisioning mix-ins enabled in %dms", Clock.ticks() - startTimeMS));
    }

    public void serviceStarted() {
        logger.fine("Initializing provisioning service");
        long startTimeMS = Clock.ticks();
        if (this.serviceStarted) {
            return;
        }
        this.serviceStarted = true;
        try {
            Sys.getService((Type)Sys.getType((String)"provisioning:ProvisioningService"));
            this.configFail("Cannot have ProvisioningService and ProvisioningNiagaraNetworkExt on the same station");
            this.whenServiceStarted().complete(null);
            return;
        }
        catch (ModuleNotFoundException | ServiceNotFoundException | TypeNotFoundException throwable) {
            if (this.getProperty("backupSchedule") != null) {
                Logger.getLogger("provisioningNiagara").warning("ProvisioningNiagaraNetworkExt backup schedule is deprecated, and will not trigger backups");
            }
            try {
                Sys.getService((Type)Sys.getType((String)"batchJob:BatchJobService"));
            }
            catch (ServiceNotFoundException snfe) {
                this.configFail("ProvisioningNiagaraNetworkExt requires that a BatchJobService be installed");
                this.whenServiceStarted().completeExceptionally(snfe);
                return;
            }
            BBatchJobService batch = (BBatchJobService)Sys.getService((Type)Sys.getType((String)"batchJob:BatchJobService"));
            ((CompletableFuture)batch.whenServiceStarted().exceptionally(e -> {
                this.whenServiceStarted().completeExceptionally((Throwable)e);
                this.configFail("ProvisioningNiagaraNetworkExt startup FAILED: BatchJobService not started successfully");
                Logger.getLogger("provisioningNiagara").log(Level.SEVERE, "BatchJobService not started successfully", (Throwable)e);
                return null;
            })).thenApplyAsync(ignored -> {
                try {
                    if (BFoxChannelRegistry.getPrototype().get("niagaraProv") == null) {
                        BFoxChannelRegistry.getPrototype().add("niagaraProv", (BValue)new BNiagaraProvisioningChannel());
                    }
                    this.updateStatus();
                    this.getSoftware().serviceStarted();
                    this.whenServiceStarted().complete(null);
                    Logger.getLogger("provisioningNiagara").log(Level.INFO, "Provisioning Network Extension Startup Complete");
                }
                catch (Throwable e) {
                    this.configFail("ProvisioningNiagaraNetworkExt startup FAILED");
                    Logger.getLogger("provisioningNiagara").log(Level.SEVERE, "ProvisioningNiagaraNetworkExt startup FAILED", e);
                    this.whenServiceStarted().completeExceptionally(e);
                }
                return null;
            });
            logger.fine(() -> String.format("Provisioning service initialized in %dms", Clock.ticks() - startTimeMS));
            return;
        }
    }

    public void serviceStopped() {
        this.serviceStarted = false;
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "provisioning");
    }

    public boolean completesStarted() {
        return true;
    }

    public CompletableFuture<Void> whenServiceStarted() {
        return this.whenServiceStarted;
    }

    public void updateStatus() {
        int oldStatus = this.getStatus().getBits();
        super.updateStatus();
        int newStatus = this.getStatus().getBits();
        if (oldStatus != newStatus) {
            this.updateStatusForAllProvisioningExtensions();
        }
    }

    private void updateStatusForAllProvisioningExtensions() {
        BNiagaraNetwork nn = null;
        try {
            nn = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            // empty catch block
        }
        if (nn == null) {
            return;
        }
        for (BDevice device : nn.getDevices()) {
            for (BDeviceExt ext : device.getDeviceExts()) {
                if (!(ext instanceof BPlatformConnection) && !(ext instanceof BProvisioningStationExt)) continue;
                try {
                    ext.updateStatus();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static BFoxProxySession getFoxProxySession(BNiagaraStation station) {
        BFoxClientConnection clientConnection = station.getClientConnection();
        BFoxSession session = (BFoxSession)BFoxProxySession.make((BHost)station.getRemoteHost(), (int)clientConnection.getPort(), (boolean)clientConnection.getUseFoxs(), (BIUserCredentials)clientConnection.getCredentials());
        station.configureFoxClientConnection(session.getConnection());
        session.getConnection().setAuthenticationClient((AuthenticationClient)session.getConnection());
        return session;
    }

    public ProvisioningRegistry getInstallableRegistry() {
        if (this.installableRegistry == null) {
            BFoxSession session = (BFoxSession)this.getSession();
            BNiagaraProvisioningChannel channel = (BNiagaraProvisioningChannel)session.getConnection().getChannels().get("niagaraProv", BNiagaraProvisioningChannel.TYPE);
            this.installableRegistry = new ProvisioningRegistry(channel);
        }
        return this.installableRegistry;
    }

    public BIcon getIcon() {
        return icon;
    }
}

