/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara;

import com.tridium.authn.AuthenticationClient;
import com.tridium.authn.SimpleAuthenticationClient;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.TransientExemptionApprover;
import com.tridium.platcrypto.daemon.wb.BDaemonSecureSession;
import com.tridium.platform.BIPlatformConnection;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonSSLRequiredException;
import com.tridium.platform.daemon.DaemonSessionListener;
import com.tridium.platform.daemon.NiagaraPlatformDaemon;
import com.tridium.platform.daemon.message.XmlResponseMessage;
import com.tridium.provisioningNiagara.BPlatformWorker;
import com.tridium.provisioningNiagara.BProvisioningNiagaraNetworkExt;
import com.tridium.provisioningNiagara.BProvisioningStationExt;
import com.tridium.util.RetryUtil;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.driver.BDeviceExt;
import javax.baja.driver.ping.BIPingable;
import javax.baja.driver.ping.BPingHealth;
import javax.baja.driver.ping.BPingMonitor;
import javax.baja.naming.BHost;
import javax.baja.net.HttpsConnection;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.security.ExemptionApprover;
import javax.baja.nre.security.ExemptionHandler;
import javax.baja.platform.PlatformDaemon;
import javax.baja.security.AuthenticationException;
import javax.baja.security.BICredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BIMixIn;
import javax.baja.sys.BIcon;
import javax.baja.sys.BModule;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;

@NiagaraType(agent={@AgentOn(types={"niagaraDriver:NiagaraStation"})})
@NiagaraProperties(value={@NiagaraProperty(name="status", type="baja:Status", defaultValue="BStatus.ok", flags=75), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=3), @NiagaraProperty(name="port", type="int", defaultValue="5011"), @NiagaraProperty(name="credentials", type="baja:UsernameAndPassword", defaultValue="new BUsernameAndPassword()"), @NiagaraProperty(name="secure", type="boolean", defaultValue="true"), @NiagaraProperty(name="health", type="driver:PingHealth", defaultValue="new BPingHealth()", flags=65), @NiagaraProperty(name="alarmSourceInfo", type="alarm:AlarmSourceInfo", defaultValue="initAlarmSourceInfo()"), @NiagaraProperty(name="worker", type="provisioningNiagara:PlatformWorker", defaultValue="new BPlatformWorker()", flags=4)})
@NiagaraActions(value={@NiagaraAction(name="ping", flags=16), @NiagaraAction(name="ackAlarm", parameterType="alarm:AlarmRecord", defaultValue="new BAlarmRecord()", returnType="baja:Boolean", flags=4)})
public class BPlatformConnection
extends BDeviceExt
implements BIMixIn,
BIPingable,
DaemonSessionListener,
BIPlatformConnection {
    public static final Property status = BPlatformConnection.newProperty((int)75, (BValue)BStatus.ok, null);
    public static final Property faultCause = BPlatformConnection.newProperty((int)3, (String)"", null);
    public static final Property port = BPlatformConnection.newProperty((int)0, (int)5011, null);
    public static final Property credentials = BPlatformConnection.newProperty((int)0, (BValue)new BUsernameAndPassword(), null);
    public static final Property secure = BPlatformConnection.newProperty((int)0, (boolean)true, null);
    public static final Property health = BPlatformConnection.newProperty((int)65, (BValue)new BPingHealth(), null);
    public static final Property alarmSourceInfo = BPlatformConnection.newProperty((int)0, (BValue)BPlatformConnection.initAlarmSourceInfo(), null);
    public static final Property worker = BPlatformConnection.newProperty((int)4, (BValue)new BPlatformWorker(), null);
    public static final Action ping = BPlatformConnection.newAction((int)16, null);
    public static final Action ackAlarm = BPlatformConnection.newAction((int)4, (BValue)new BAlarmRecord(), null);
    public static final Type TYPE = Sys.loadType(BPlatformConnection.class);
    private static final BIcon icon = BIcon.std((String)"connection.png");
    static final int FATAL_FAULT = 1;
    private BDaemonSession daemonSession = null;
    private final Object sessionMonitor = new Object();
    private int flags = 0;
    private int oldStatus = -1;
    private boolean pingActive = false;
    private HealthSubscriber healthSubscriber = null;
    private boolean bootstrap = false;
    private static final int MAX_HOST_LENGTH = 2000;
    private AlarmSupport alarmSupport = new AlarmSupport((BIAlarmSource)this, "");
    private static final Logger logger = Logger.getLogger("provisioningNiagara");
    public static final Function<Integer, Integer> DAEMON_SESSION_RETRY_DECAY = callCount -> (int)(5000.0 * Math.pow(2.0, (double)callCount.intValue() - 1.0));

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public int getPort() {
        return this.getInt(port);
    }

    public void setPort(int v) {
        this.setInt(port, v, null);
    }

    public BUsernameAndPassword getCredentials() {
        return (BUsernameAndPassword)this.get(credentials);
    }

    public void setCredentials(BUsernameAndPassword v) {
        this.set(credentials, (BValue)v, null);
    }

    public boolean getSecure() {
        return this.getBoolean(secure);
    }

    public void setSecure(boolean v) {
        this.setBoolean(secure, v, null);
    }

    public BPingHealth getHealth() {
        return (BPingHealth)this.get(health);
    }

    public void setHealth(BPingHealth v) {
        this.set(health, (BValue)v, null);
    }

    public BAlarmSourceInfo getAlarmSourceInfo() {
        return (BAlarmSourceInfo)this.get(alarmSourceInfo);
    }

    public void setAlarmSourceInfo(BAlarmSourceInfo v) {
        this.set(alarmSourceInfo, (BValue)v, null);
    }

    public BPlatformWorker getWorker() {
        return (BPlatformWorker)this.get(worker);
    }

    public void setWorker(BPlatformWorker v) {
        this.set(worker, (BValue)v, null);
    }

    public void ping() {
        this.invoke(ping, null, null);
    }

    public BBoolean ackAlarm(BAlarmRecord parameter) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public String getDisplayNameInParent(Context cx) {
        return Lexicon.make((BModule)TYPE.getModule(), (Context)cx).getText("PlatformConnection");
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BNiagaraStation;
    }

    public void started() throws Exception {
        Property p = this.getProperty("pingTrigger");
        if (p != null) {
            this.remove(p);
        }
        this.healthSubscriber = new HealthSubscriber();
        this.checkFatalFault();
        this.updateStatus();
    }

    public void stopped() {
        if (this.healthSubscriber != null) {
            this.healthSubscriber.unsubscribeAll();
            this.healthSubscriber = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property == port || property == credentials || property == secure) {
            this.reset();
            if (property == secure) {
                Object object = this.sessionMonitor;
                synchronized (object) {
                    this.daemonSession = null;
                }
            }
            if (property == credentials) {
                this.clearFault();
                this.updateStatus();
            }
        } else if (property == status) {
            BNiagaraStation station = this.getNiagaraStation();
            for (BDeviceExt ext : station.getDeviceExts()) {
                if (!(ext instanceof BProvisioningStationExt)) continue;
                try {
                    ext.updateStatus();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFuture post(Action action, BValue argument, Context cx) {
        if (action == ping) {
            Object object = this.sessionMonitor;
            synchronized (object) {
                if (!this.pingActive) {
                    this.pingActive = true;
                    return this.getWorker().postAsync((Runnable)new Invocation((BComponent)this, ping, null, null));
                }
            }
            return null;
        }
        return super.post(action, argument, cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPing() {
        try {
            if (!this.isRunning() || this.isFatalFault() || this.isDisabled()) {
                return;
            }
            try {
                this.getDaemonSession();
                if (this.daemonSession != null) {
                    this.daemonSession.connect();
                    this.daemonSession.sendMessages(new XmlResponseMessage[0], BDaemonSession.DEFAULT_TIMEOUT);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            Object object = this.sessionMonitor;
            synchronized (object) {
                this.pingActive = false;
            }
        }
    }

    public BPingMonitor getMonitor() {
        return this.getNetwork().getMonitor();
    }

    public void pingOk() {
        if (this.getDevice().isRunning()) {
            this.getHealth().pingOk();
            this.clearFault();
            if (this.getStatus().isDown()) {
                this.updateStatus();
            }
        }
    }

    public void pingFail(String cause) {
        this.getHealth().pingFail(cause);
    }

    public BBoolean doAckAlarm(BAlarmRecord ackRequest) {
        return this.getHealth().doAckAlarm(ackRequest);
    }

    private static BAlarmSourceInfo initAlarmSourceInfo() {
        BAlarmSourceInfo asi = new BAlarmSourceInfo();
        asi.setSourceName(BFormat.make((String)"%parent.parent.parent.displayName% %parent.parent.displayName% %parent.displayName%"));
        asi.setToOffnormalText(BFormat.make((String)"%lexicon(driver:pingFail)%"));
        asi.setToNormalText(BFormat.make((String)"%lexicon(driver:pingSuccess)%"));
        return asi;
    }

    public final boolean isDown() {
        return this.getStatus().isDown();
    }

    public final boolean isDisabled() {
        return this.getStatus().isDisabled();
    }

    public final boolean isFault() {
        return this.getStatus().isFault();
    }

    protected void setFault(String cause) {
        if (!this.getStatus().isFault()) {
            int bits = this.getStatus().getBits();
            this.setFaultCause(cause);
            this.setStatus(BStatus.make((int)(bits |= 2)));
        }
    }

    protected void clearFault() {
        if (!this.fatalFault() && this.getStatus().isFault() && !this.getNiagaraStation().isFault()) {
            int bits = this.getStatus().getBits();
            this.setFaultCause("");
            this.setStatus(BStatus.make((int)(bits &= 0xFFFFFFFD)));
        }
    }

    public final boolean isUnoperational() {
        return this.isFatalFault() || this.isFault() || this.isDisabled();
    }

    public final boolean isFatalFault() {
        return this.fatalFault();
    }

    private void checkFatalFault() {
        if (this.fatalFault()) {
            return;
        }
        try {
            BProvisioningNiagaraNetworkExt nwExt = (BProvisioningNiagaraNetworkExt)Sys.getService((Type)BProvisioningNiagaraNetworkExt.TYPE);
            if (nwExt.isFatalFault()) {
                this.fatalFault(true);
                this.setFaultCause("Network extension fault: " + nwExt.getFaultCause());
                return;
            }
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            // empty catch block
        }
        if (this.getNiagaraStation() == null) {
            this.fatalFault(true);
            this.setFaultCause("Not under NiagaraStation");
            return;
        }
        if (this.getNiagaraStation().isFatalFault()) {
            this.fatalFault(true);
            this.setFaultCause("Device fault: " + this.getNiagaraStation().getFaultCause());
            return;
        }
        if (this.getNiagaraNetwork() == null) {
            this.fatalFault(true);
            this.setFaultCause("Not under NiagaraNetwork");
            return;
        }
        if (this.getNiagaraNetwork().isFatalFault()) {
            this.fatalFault(true);
            this.setFaultCause("Network fault: " + this.getNiagaraNetwork().getFaultCause());
        }
    }

    public BNiagaraStation getNiagaraStation() {
        return (BNiagaraStation)this.getDevice();
    }

    public BNiagaraNetwork getNiagaraNetwork() {
        return (BNiagaraNetwork)this.getNetwork();
    }

    public BDaemonSession getDaemonSession() throws Exception, AuthenticationException {
        BProvisioningNiagaraNetworkExt ext = (BProvisioningNiagaraNetworkExt)Sys.getService((Type)BProvisioningNiagaraNetworkExt.TYPE);
        return this.getDaemonSession(ext.getConnectTimeout(), ext.getSocketTimeout(), true);
    }

    public BDaemonSession getDaemonSession(int connectionTimeout, int socketTimeout, boolean doHealthCheck) throws Exception, AuthenticationException {
        if (doHealthCheck && (!this.isRunning() || this.isFatalFault() || this.isDisabled())) {
            return null;
        }
        return (BDaemonSession)RetryUtil.make(() -> this.createOrConnectDaemonSession(socketTimeout), exception -> {
            if (exception instanceof AuthenticationException) {
                throw exception;
            }
            if (exception instanceof BDaemonSession.DaemonConnectException && exception.getCause() instanceof SSLException) {
                throw exception;
            }
            if (exception instanceof SecurityException) {
                throw exception;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("BPlatformConnection createOrConnectDaemonSession for '" + this.getNiagaraStation().getRemoteHost() + "' retrying on Exception '" + exception + "'...");
            }
            return exception;
        }, DAEMON_SESSION_RETRY_DECAY, (int)connectionTimeout).call();
    }

    private BDaemonSession createOrConnectDaemonSession(int socketTimeout) throws Exception {
        Object object = this.sessionMonitor;
        synchronized (object) {
            try {
                if (this.daemonSession == null || !this.getNiagaraStation().getRemoteHost().equals((Object)this.daemonSession.getHost()) || this.getNiagaraStation().getBootstrap() != this.bootstrap) {
                    this.reset();
                    BHost host = this.getNiagaraStation().getRemoteHost();
                    try {
                        this.daemonSession = this.makeDaemonSession(host, this.getPort(), this.getSecure());
                        this.connect(this.daemonSession, socketTimeout);
                    }
                    catch (DaemonSSLRequiredException e) {
                        Integer newPort = this.getSSLPort(e.getNewLocation());
                        this.daemonSession = this.makeDaemonSession(host, this.getPort(), true);
                        this.connect(this.daemonSession, socketTimeout);
                        this.setSecure(true);
                        this.setPort(newPort);
                    }
                } else if (!this.daemonSession.isConnected()) {
                    logger.fine(() -> String.format("Connecting to existing daemon session [%s:%s]", this.daemonSession.getRemoteHost(), this.daemonSession.getRemotePort()));
                    this.daemonSession.connect(socketTimeout);
                }
                return this.daemonSession;
            }
            catch (Exception e) {
                this.reset();
                throw e;
            }
        }
    }

    private BDaemonSession makeDaemonSession(BHost host, int port, boolean secure) throws Exception {
        this.bootstrap = this.getNiagaraStation().getBootstrap();
        SSLSocketFactory factory = null;
        if (this.bootstrap) {
            try {
                factory = AccessController.doPrivileged(() -> {
                    SSLSocketFactory sslSocketFactory = (SSLSocketFactory)HttpsConnection.getDefaultSocketFactory();
                    if (sslSocketFactory instanceof ExemptionHandler) {
                        ((ExemptionHandler)sslSocketFactory).setExemptionApprover((ExemptionApprover)new TransientExemptionApprover());
                    }
                    return sslSocketFactory;
                });
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        }
        if (secure) {
            BDaemonSecureSession session = (BDaemonSecureSession)BDaemonSecureSession.make((BHost)host, (int)port);
            session.setSSLSocketFactory(factory);
            return session;
        }
        return BDaemonSession.make((BHost)host, (int)port);
    }

    private Integer getSSLPort(String newLocation) {
        try {
            int lastIdx;
            if (newLocation != null && newLocation.length() < 2000 && newLocation.startsWith("https://") && (lastIdx = newLocation.lastIndexOf(":")) > 0) {
                return Integer.valueOf(newLocation.substring(lastIdx + 1, newLocation.length() - 1));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 5011;
    }

    private void connect(BDaemonSession session, int socketTimeout) throws Exception {
        logger.fine(() -> String.format("Connecting to new daemon session [%s:%s]", this.daemonSession.getRemoteHost(), this.daemonSession.getRemotePort()));
        BUsernameAndPassword credentials = this.getCredentials();
        BUsernameAndPassword genericCredentials = new BUsernameAndPassword(credentials.getUsername(), AccessController.doPrivileged(() -> ((BPassword)credentials.getPassword()).getValue()));
        this.daemonSession.addListener((DaemonSessionListener)this);
        this.daemonSession.setCredentials((BICredentials)genericCredentials, true, socketTimeout);
        this.daemonSession.setAuthenticationClient((AuthenticationClient)new SimpleAuthenticationClient(genericCredentials));
        this.daemonSession.connect(socketTimeout);
    }

    public PlatformDaemon getPlatformDaemon() throws Exception {
        return NiagaraPlatformDaemon.make((BDaemonSession)this.getDaemonSession(), null);
    }

    public void reset() {
        if (this.daemonSession != null) {
            try {
                this.daemonSession.removeListener((DaemonSessionListener)this);
                this.daemonSession.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.daemonSession = null;
    }

    public void sessionConnected(BDaemonSession session) {
        this.pingOk();
    }

    public void sessionDisconnected(BDaemonSession session) {
        if (this.getStatus().isDisabled()) {
            return;
        }
        this.getHealth().setDown(true);
        this.updateStatus();
    }

    public void sessionConnectionError(BDaemonSession session, Throwable cause) {
        if (this.getStatus().isDisabled()) {
            return;
        }
        logger.log(Level.FINE, "Session connection error", cause);
        if (cause instanceof AuthenticationException) {
            this.pingFail("Authentication Failed");
            this.setFault("Authentication Failed");
        } else if (cause instanceof BDaemonSession.DaemonConnectException) {
            BDaemonSession.DaemonConnectException dce = (BDaemonSession.DaemonConnectException)cause;
            if (((BDaemonSession.DaemonConnectException)cause).isFatal()) {
                this.pingFail(cause.toString());
                this.setFault(cause.toString());
            }
        } else {
            this.clearFault();
            this.pingFail(cause.toString());
        }
    }

    public void updateStatus() {
        BStatus prov;
        int newStatus = this.getStatus().getBits();
        BNiagaraStation station = this.getNiagaraStation();
        if (station == null) {
            this.fatalFault(true);
            this.setFaultCause("Not under NiagaraStation");
        }
        if (this.getCredentials().getUsername().trim().length() == 0) {
            newStatus |= 2;
            this.setFaultCause("Missing user name");
        }
        try {
            String password = AccessController.doPrivileged(() -> ((BPassword)this.getCredentials().getPassword()).getValue());
            if (password == null || password.trim().length() == 0) {
                newStatus |= 2;
                this.setFaultCause("Missing password");
            }
        }
        catch (SecurityException securityException) {
            newStatus |= 2;
            this.setFaultCause("Password keyring failure");
        }
        BStatus device = station == null ? BStatus.ok : station.getStatus();
        BProvisioningNiagaraNetworkExt nwExt = null;
        try {
            nwExt = (BProvisioningNiagaraNetworkExt)Sys.getService((Type)BProvisioningNiagaraNetworkExt.TYPE);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            // empty catch block
        }
        BStatus bStatus = prov = nwExt == null ? BStatus.ok : nwExt.getStatus();
        newStatus = device.isDisabled() || prov.isDisabled() ? (newStatus |= 1) : (newStatus &= 0xFFFFFFFE);
        newStatus = this.getHealth().inFailure() ? (newStatus |= 4) : (newStatus &= 0xFFFFFFFB);
        if (this.fatalFault()) {
            newStatus |= 2;
        } else if (nwExt == null) {
            newStatus |= 2;
            this.setFaultCause("No niagara provisioning network extension");
        } else if (device.isFault()) {
            newStatus |= 2;
            this.setFaultCause("Device fault: " + this.getNiagaraStation().getFaultCause());
        }
        if (this.oldStatus == newStatus) {
            return;
        }
        this.setStatus(BStatus.make((int)newStatus));
        this.oldStatus = newStatus;
    }

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        if (x == 502) {
            return this.alarmSupport;
        }
        return super.fw(x, a, b, c, d);
    }

    public BIcon getIcon() {
        return icon;
    }

    private boolean fatalFault() {
        return (this.flags & 1) != 0;
    }

    private void fatalFault(boolean b) {
        this.flags = b ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    private class HealthSubscriber
    extends Subscriber {
        private BAbsTime lastFailTime;
        private BAbsTime lastOkTime;

        public HealthSubscriber() {
            this.subscribe((BComponent)BPlatformConnection.this.getNiagaraStation(), 1);
            this.lastFailTime = BPlatformConnection.this.getNiagaraStation().getHealth().getLastFailTime();
            this.lastOkTime = BPlatformConnection.this.getNiagaraStation().getHealth().getLastOkTime();
        }

        public void event(BComponentEvent event) {
            BPingHealth health;
            if (!(event.getId() != 0 || event.getSlot().asProperty() != BNiagaraStation.health || (health = (BPingHealth)event.getValue()).getLastFailTime().equals((Object)this.lastFailTime) && health.getLastOkTime().equals((Object)this.lastOkTime))) {
                this.lastFailTime = health.getLastFailTime();
                this.lastOkTime = health.getLastOkTime();
                BPlatformConnection.this.ping();
            }
        }
    }
}

