/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara;

import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.provisioningNiagara.BProvisioningStationExt;
import java.util.ArrayList;
import java.util.HashSet;
import javax.baja.batchJob.driver.BNetworkBatchAgent;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.data.BIDataTable;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.naming.BOrd;
import javax.baja.registry.TypeInfo;
import javax.baja.space.BSpace;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BNiagaraNetworkBatchAgent
extends BNetworkBatchAgent {
    public static final BNiagaraNetworkBatchAgent INSTANCE = new BNiagaraNetworkBatchAgent();
    public static final Type TYPE = Sys.loadType(BNiagaraNetworkBatchAgent.class);
    private static TypeInfo[] EXT_TYPES = null;

    public Type getType() {
        return TYPE;
    }

    public BSimple getBatchDeviceId(BDevice device) {
        return BString.make((String)((BNiagaraStation)device).getStationName());
    }

    public BDevice getBatchDevice(BDeviceNetwork nw, BSimple deviceId) {
        if (!(nw instanceof BNiagaraNetwork)) {
            return null;
        }
        if (EXT_TYPES == null) {
            EXT_TYPES = Sys.getRegistry().getConcreteTypes(BProvisioningStationExt.TYPE.getTypeInfo());
        }
        StringBuilder bql = new StringBuilder("bql:select slotPath from niagaraDriver:NiagaraStation stop where name = '");
        bql.append(deviceId.toString());
        bql.append("' and ( ");
        for (int i = 0; i < EXT_TYPES.length; ++i) {
            if (i > 0) {
                bql.append("or ");
            }
            bql.append(EXT_TYPES[i].getModuleName());
            bql.append('_');
            bql.append(EXT_TYPES[i].getTypeName());
            bql.append(".enabled ");
        }
        bql.append(')');
        BITable table = (BITable)BOrd.make((String)bql.toString()).get((BObject)nw);
        TableCursor c = table.cursor();
        if (c.next()) {
            Column slotPathCol = table.getColumns().get(0);
            String stationPath = c.cell(slotPathCol).toString();
            return (BNiagaraStation)BOrd.make((String)stationPath).get((BObject)nw);
        }
        return null;
    }

    public BDeviceNetwork getDeviceNetwork(BDevice device) {
        return ((BNiagaraStation)device).getNiagaraNetwork();
    }

    public BDevice[] listBatchDevices(BDeviceNetwork nw) {
        ArrayList<BNiagaraStation> result = new ArrayList<BNiagaraStation>();
        try {
            nw.lease(1);
            BSpace space = BOrd.toSpace((BObject)nw);
            if (EXT_TYPES == null) {
                EXT_TYPES = Sys.getRegistry().getConcreteTypes(BProvisioningStationExt.TYPE.getTypeInfo());
            }
            StringBuilder bql = new StringBuilder("bql:select slotPath from niagaraDriver:NiagaraStation stop ");
            for (int i = 0; i < EXT_TYPES.length; ++i) {
                if (i == 0) {
                    bql.append("where ");
                } else {
                    bql.append("or ");
                }
                bql.append(EXT_TYPES[i].getModuleName());
                bql.append('_');
                bql.append(EXT_TYPES[i].getTypeName());
                bql.append(".enabled ");
            }
            BIDataTable table = (BIDataTable)BOrd.make((String)bql.toString()).get((BObject)nw);
            Column slotPathCol = table.getColumns().get(0);
            HashSet<String> usedPaths = new HashSet<String>();
            TableCursor c = table.cursor();
            while (c.next()) {
                String stationPath = c.cell(slotPathCol).toString();
                if (usedPaths.contains(stationPath)) continue;
                BNiagaraStation station = (BNiagaraStation)BOrd.make((String)stationPath).get((BObject)space);
                usedPaths.add(stationPath);
                result.add(station);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (BDevice[])result.toArray(new BNiagaraStation[result.size()]);
    }

    public boolean isBatchDevice(BDevice device) {
        if (!(device instanceof BNiagaraStation)) {
            return false;
        }
        BIDataTable table = (BIDataTable)BOrd.make((String)"bql:select slotPath from provisioningNiagara:ProvisioningStationExt stop where enabled").get((BObject)device);
        return table.cursor().next();
    }
}

