/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.seriestransform.graph;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.Registry;
import javax.baja.registry.TypeInfo;
import javax.baja.seriestransform.exceptions.SchemaException;
import javax.baja.seriestransform.exceptions.SourceException;
import javax.baja.seriestransform.exceptions.TransformException;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

@NiagaraType
public abstract class BTransformFunction
extends BObject {
    public static final Type TYPE = Sys.loadType(BTransformFunction.class);
    private static HashMap<BTypeSpec, BTransformFunction> table = new HashMap();
    public static final Logger log = Logger.getLogger("seriesTransform.functions");
    public static final Lexicon lex = Lexicon.make(BTransformFunction.class);
    private static final String ERR_SERIES_NOT_FOUND = "functions.err.seriesNotFound";

    public Type getType() {
        return TYPE;
    }

    public abstract void applyFunction(Map<String, List<? extends BComplex>> var1, String[] var2, Property var3, BComplex var4) throws TransformException;

    public abstract String getFunctionName();

    public abstract String getFunctionDesc();

    public abstract Type getReturnType();

    public abstract Type[] getArgumentTypes();

    public boolean isCumulative() {
        return true;
    }

    public final List<? extends BComplex> getSeriesRecords(Map<String, List<? extends BComplex>> series, String seriesName) {
        List<Object> records = new LinkedList();
        if (null != seriesName && series.containsKey(seriesName)) {
            records = series.get(seriesName);
        } else {
            log.severe(this.getFunctionName() + " failed.");
            log.severe(lex.getText(ERR_SERIES_NOT_FOUND, new Object[]{seriesName}));
        }
        return records;
    }

    public static final BUnit getUnits(Property slot) {
        BFacets facets = slot.getFacets();
        BUnit dstUnits = BUnit.NULL;
        if (null != facets && null != facets.get("units")) {
            dstUnits = (BUnit)facets.get("units");
        }
        return dstUnits;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void setRecordValue(BComplex record, Property destProp, BValue value) throws SchemaException {
        if (null == value) return;
        if (null == record.getProperty(destProp.getName())) {
            BFacets facets = destProp.getFacets();
            if (!(record instanceof BComponent)) throw new SchemaException(lex.getText("fault.msg.schema.invalidField", new Object[]{destProp.getName()}));
            ((BComponent)record).add(destProp.getName(), value, 0, facets, null);
            return;
        } else {
            record.set(destProp, value);
        }
    }

    public static final BNumber convertToUnits(BNumber value, BUnit sourceUnit, BUnit targetUnit) throws SourceException {
        if (null == sourceUnit) {
            sourceUnit = BUnit.NULL;
        }
        if (null == targetUnit) {
            targetUnit = BUnit.NULL;
        }
        if (sourceUnit.isNull() && targetUnit.isNull() || sourceUnit.encodeToString().equals(targetUnit.encodeToString())) {
            return value;
        }
        if (sourceUnit.isNull() || targetUnit.isNull() || null == value || !sourceUnit.isConvertible(targetUnit)) {
            throw new SourceException(lex.getText("resolve.err.sourceseries.units", new Object[]{sourceUnit, targetUnit}));
        }
        double converted = sourceUnit.convertTo(targetUnit, value.getDouble());
        return BDouble.make((double)converted);
    }

    public static final String getSeriesName(String qualifiedName) {
        String seriesName = "";
        if (null != qualifiedName) {
            String[] split = TextUtil.split((String)qualifiedName, (char)'.');
            seriesName = split.length > 1 ? split[0] : qualifiedName;
        }
        return seriesName;
    }

    public static final String getFieldName(String qualifiedName) {
        String fieldName = "";
        if (null != qualifiedName) {
            String[] split = TextUtil.split((String)qualifiedName, (char)'.');
            fieldName = split.length > 1 ? split[1] : qualifiedName;
        }
        return fieldName;
    }

    private static void loadFunctionTable() {
        TypeInfo[] concreteTypes;
        Registry registry = Sys.getRegistry();
        for (TypeInfo typeInfo : concreteTypes = registry.getConcreteTypes(TYPE.getTypeInfo())) {
            BTransformFunction function = (BTransformFunction)typeInfo.getInstance();
            table.put(typeInfo.getTypeSpec(), function);
        }
    }

    public static final BTransformFunction getFunction(BTypeSpec functionSpec) {
        if (table.isEmpty()) {
            BTransformFunction.loadFunctionTable();
        }
        return table.get(functionSpec);
    }

    public static final List<BTransformFunction> getAllFunctions() {
        LinkedList<BTransformFunction> functions = new LinkedList<BTransformFunction>();
        if (table.isEmpty()) {
            BTransformFunction.loadFunctionTable();
        }
        Set<BTypeSpec> keys = table.keySet();
        for (BTypeSpec key : keys) {
            BTransformFunction function = table.get(key);
            functions.add(function);
        }
        return functions;
    }

    public String toString(Context context) {
        return this.getFunctionName();
    }
}

