/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.timeshift;

import com.tridium.seriestransform.SeriesColumn;
import com.tridium.seriestransform.timeshift.BTimeShiftTable;
import java.util.LinkedList;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.seriestransform.BSeriesTransformTable;
import javax.baja.seriestransform.graph.BGraphNode;
import javax.baja.seriestransform.graph.BSeriesSchema;
import javax.baja.seriestransform.graph.GraphNodeParams;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="shift", type="BRelTime", defaultValue="BRelTime.DEFAULT")
public class BTimeShiftNode
extends BGraphNode {
    public static final Property shift = BTimeShiftNode.newProperty((int)0, (BValue)BRelTime.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BTimeShiftNode.class);

    public BRelTime getShift() {
        return (BRelTime)this.get(shift);
    }

    public void setShift(BRelTime v) {
        this.set(shift, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    protected BSeriesTransformTable[] doResolve(BSeriesTransformTable[] inputs, GraphNodeParams params, BOrd base) {
        LinkedList<BTimeShiftTable> results = new LinkedList<BTimeShiftTable>();
        for (BSeriesTransformTable table : inputs) {
            BTimeShiftTable filterTable = new BTimeShiftTable(this.getName(), this.getSchema(), this.getShift(), table);
            results.add(filterTable);
        }
        return results.toArray(new BSeriesTransformTable[results.size()]);
    }

    @Override
    public BSeriesSchema doGetSchema() {
        BSeriesSchema schema = new BSeriesSchema();
        schema.add(SeriesColumn.COL_TIMESTAMP, (BValue)BAbsTime.TYPE.getTypeSpec(), 0, BFacets.make((String)"min", (BIDataValue)BAbsTime.DEFAULT), null);
        BGraphNode[] inputSources = this.getSources();
        if (inputSources.length > 0) {
            BGraphNode src = inputSources[0];
            return src.getSchema();
        }
        return schema;
    }

    @Override
    public void doCheckSchema() {
        this.getTransformInputs().setStatus(BStatus.ok);
        this.getTransformInputs().setValue("schema");
    }

    public BIcon getIcon() {
        String iconsrc = lex.getText("timeshift.icon");
        return BIcon.make((BOrd)BOrd.make((String)iconsrc));
    }
}

