/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.rpc;

import com.tridium.json.JSONObject;
import com.tridium.json.JSONWriter;
import com.tridium.json.quick.QuickJSONWriter;
import com.tridium.seriestransform.SchemaCheckUtil;
import com.tridium.seriestransform.graph.BTransformGraph;
import com.tridium.webChart.WebChartUtil;
import java.io.StringWriter;
import java.util.List;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.security.BIProtected;
import javax.baja.seriestransform.graph.BSeriesSchema;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BTypeSpec;

@NiagaraType
public final class BSeriesTransformWebChartQueryRpc
extends BComponent {
    public static final Type TYPE = Sys.loadType(BSeriesTransformWebChartQueryRpc.class);

    public Type getType() {
        return TYPE;
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box), @Transport(type=TransportType.web)})
    public static JSONObject getInfo(List<String> args, Context cx) throws Exception {
        int i;
        StringWriter writer = new StringWriter();
        Array displayPaths = new Array(String.class);
        Array errors = new Array(String.class);
        Array valueFacets = new Array(String.class);
        Array recordTypes = new Array(String.class);
        Array timezoneIDs = new Array(String.class);
        for (int i2 = 0; i2 < args.size(); ++i2) {
            String string = args.get(i2);
            if (string.equals("")) continue;
            BOrd ord = BOrd.make((String)string).relativizeToSession().normalize();
            BObject o = ord.get(null, cx);
            if (o instanceof BIProtected && !((BIProtected)o).getPermissions(cx).hasOperatorRead()) {
                return null;
            }
            if (o instanceof BTransformGraph) {
                BObject object;
                BFacets facets;
                BSeriesSchema schema;
                BTransformGraph transformGraph = (BTransformGraph)o;
                String error = SchemaCheckUtil.getCannotChartReason(transformGraph, cx);
                if (error != null) {
                    errors.add((Object)error);
                }
                if ((schema = transformGraph.getSchema()).hasField("value")) {
                    facets = schema.getFieldFacets("value");
                    if (facets != null) {
                        valueFacets.add((Object)facets.encodeToString());
                    } else {
                        valueFacets.add((Object)"");
                    }
                    BTypeSpec fieldTypeSpec = schema.getFieldType("value");
                    recordTypes.add((Object)("" + fieldTypeSpec));
                }
                if (schema.hasField("timestamp") && (facets = schema.getFieldFacets("timestamp")) != null && (object = facets.getFacet("TimeZone")) instanceof BTimeZone) {
                    BTimeZone timeZone = (BTimeZone)object;
                    timezoneIDs.add((Object)timeZone.getId());
                }
            }
            displayPaths.add((Object)WebChartUtil.getNavDisplayPath((BObject)o, (Context)cx));
        }
        JSONWriter out = QuickJSONWriter.make((Appendable)writer);
        out.object();
        out.key("valueFacets").array();
        for (i = 0; i < valueFacets.size(); ++i) {
            out.value(valueFacets.get(i));
        }
        out.endArray();
        out.key("recordTypes").array();
        for (i = 0; i < recordTypes.size(); ++i) {
            out.value(recordTypes.get(i));
        }
        out.endArray();
        out.key("errors").array();
        for (i = 0; i < errors.size(); ++i) {
            out.value(errors.get(i));
        }
        out.endArray();
        out.key("displayPaths").array();
        for (i = 0; i < displayPaths.size(); ++i) {
            out.value(displayPaths.get(i));
        }
        out.endArray();
        out.key("timezoneIDs").array();
        for (i = 0; i < timezoneIDs.size(); ++i) {
            out.value(timezoneIDs.get(i));
        }
        out.endArray();
        out.endObject();
        return new JSONObject(writer.toString());
    }
}

