/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.rollup;

import com.tridium.seriestransform.aggregate.BAggregateNode;
import com.tridium.seriestransform.functions.BFunctionMap;
import com.tridium.seriestransform.functions.BFunctionMapping;
import com.tridium.seriestransform.rollup.BRollupInterval;
import com.tridium.seriestransform.rollup.BRollupIntervalEnum;
import com.tridium.seriestransform.rollup.BRollupTable;
import java.util.LinkedList;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.seriestransform.BSeriesTransformTable;
import javax.baja.seriestransform.exceptions.TransformException;
import javax.baja.seriestransform.graph.BTransformFunction;
import javax.baja.seriestransform.graph.GraphNodeParams;
import javax.baja.sys.BComplex;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperty(name="interval", type="BRollupInterval", defaultValue="new BRollupInterval()")
public class BRollupNode
extends BAggregateNode {
    public static final Property interval = BRollupNode.newProperty((int)0, (BValue)new BRollupInterval(), null);
    public static final Type TYPE = Sys.loadType(BRollupNode.class);
    private static final Lexicon lex = Lexicon.make(BRollupNode.class);
    private static final String ERR_INVALID_TIME = lex.getText("rollup.error.invalidinterval");

    public BRollupInterval getInterval() {
        return (BRollupInterval)this.get(interval);
    }

    public void setInterval(BRollupInterval v) {
        this.set(interval, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public boolean allowNonCumulative() {
        return false;
    }

    @Override
    protected BSeriesTransformTable[] doResolve(BSeriesTransformTable[] inputs, GraphNodeParams params, BOrd base) throws TransformException {
        BFunctionMap functionMap = this.getFunctionMap();
        BFunctionMapping[] functionMappings = this.getFunctionMappings(functionMap);
        BRollupInterval interval = this.getInterval();
        BRollupIntervalEnum desc = interval.getDesc();
        BRelTime time = interval.getTime();
        if (desc == BRollupIntervalEnum.custom && time == BRelTime.DEFAULT) {
            this.markFault(ERR_INVALID_TIME);
            throw new BajaRuntimeException(ERR_INVALID_TIME);
        }
        LinkedList<BRollupTable> results = new LinkedList<BRollupTable>();
        for (BSeriesTransformTable table : inputs) {
            results.add(new BRollupTable(this.getName(), this.getSchema(), interval, table, functionMappings));
        }
        return results.toArray(new BSeriesTransformTable[results.size()]);
    }

    @Override
    public BIcon getIcon() {
        String iconsrc = lex.getText("rollup.icon");
        return BIcon.make((BOrd)BOrd.make((String)iconsrc));
    }

    public void started() throws Exception {
        this.checkFunctionMap();
    }

    private void checkFunctionMap() {
        BFunctionMapping[] children;
        BFunctionMap functionMap = this.getFunctionMap();
        for (BFunctionMapping mapping : children = (BFunctionMapping[])functionMap.getChildren(BFunctionMapping.class)) {
            BTypeSpec functionTypeSpec = mapping.getFunctionTypeSpec();
            BTransformFunction function = BTransformFunction.getFunction(functionTypeSpec);
            if (function.isCumulative()) continue;
            functionMap.remove((BComplex)mapping);
        }
    }
}

