/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.quantize;

import com.tridium.seriestransform.IntervalSeriesCursor;
import com.tridium.seriestransform.interval.BSeriesInterval;
import com.tridium.seriestransform.interval.BSeriesIntervalEnum;
import java.util.Iterator;
import java.util.LinkedList;
import javax.baja.collection.BITable;
import javax.baja.collection.Row;
import javax.baja.collection.TableCursor;
import javax.baja.nre.util.IFilter;
import javax.baja.nre.util.SortUtil;
import javax.baja.seriestransform.SeriesTransformRow;
import javax.baja.seriestransform.graph.BSeriesSchema;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BMonth;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.timezone.BTimeZone;

public class QuantizationCursor<T extends BComplex>
extends IntervalSeriesCursor<T> {
    private static final String ERR_UNORDERED_TIMESTAMPS = "cursors.quantization.interval.unordered";
    private static final String ERR_SMALL_INTERVAL = lex.getText("cursors.quantization.interval.toosmall");
    private static final String ERR_INVALID_SCHEMA = lex.getText("fault.msg.invalidIntervalSchema");
    private BComponent currentRecord = new BComponent();
    private final BITable<T> timeSeries;
    private final Cursor<T> innerCursor;
    private final String keyField;
    private BRelTime definedInterval = BRelTime.DEFAULT;
    private BSeriesIntervalEnum intervalType = BSeriesIntervalEnum.auto;
    private boolean isNextAvailable = true;

    public QuantizationCursor(BSeriesSchema schema, BITable<T> series, BSeriesInterval interval, IFilter filter) {
        super(series);
        this.timeSeries = series;
        this.definedInterval = interval.getTime();
        this.intervalType = interval.getDesc();
        this.filter = filter;
        this.innerCursor = series.cursor();
        this.currentRecord = QuantizationCursor.createTemplateRecord(schema);
        this.keyField = schema.getKeyField();
        this.initTimes();
    }

    protected void initTimes() {
        this.initTimes(this.timeSeries);
        this.intervalDefined = this.intervalType != BSeriesIntervalEnum.auto && (this.intervalType != BSeriesIntervalEnum.custom || this.definedInterval.getMillis() >= 1000L);
        if (!this.intervalDefined) {
            this.makeDefaultInterval();
        }
    }

    public boolean advanceCursor() {
        if (!this.isNextAvailable) {
            return false;
        }
        while (this.isNextAvailable = this.innerCursor.next()) {
            if (!(this.innerCursor.get() instanceof BComplex)) continue;
            BComplex record = (BComplex)this.innerCursor.get();
            if (null != this.filter && !this.filter.accept((Object)record)) {
                return this.next();
            }
            BAbsTime timestamp = (BAbsTime)record.get(this.keyField);
            if (null == timestamp || timestamp.equals((Object)BAbsTime.DEFAULT)) continue;
            if (null == this.intervalStartTime || this.intervalStartTime == BAbsTime.DEFAULT) {
                BAbsTime base = this.makeBaselineTimestamp(timestamp);
                this.initInterval(base);
            }
            if (this.intervalCalibrated(timestamp)) {
                record.set(this.keyField, (BValue)this.intervalStartTime);
                QuantizationCursor.copyRecord(record, this.currentRecord);
                return true;
            }
            return false;
        }
        return false;
    }

    public Row<T> row() {
        return new SeriesTransformRow<BComponent>(this.getTable(), this.currentRecord);
    }

    protected void closeCursor() {
        this.innerCursor.close();
    }

    private BAbsTime makeBaselineTimestamp(BAbsTime timestamp) {
        if (this.intervalType == BSeriesIntervalEnum.yearly) {
            return BAbsTime.make((int)timestamp.getYear(), (BMonth)BMonth.january, (int)1);
        }
        if (this.intervalType == BSeriesIntervalEnum.monthly) {
            return BAbsTime.make((int)timestamp.getYear(), (BMonth)timestamp.getMonth(), (int)1);
        }
        if (this.intervalType == BSeriesIntervalEnum.daily || this.definedInterval.getDays() > 0) {
            return BAbsTime.make((int)timestamp.getYear(), (BMonth)timestamp.getMonth(), (int)timestamp.getDay());
        }
        BasicContext ctx = null;
        if (timestamp.inDaylightTime()) {
            BFacets daylightModeFacet = BFacets.make((String)"timeMode", (int)3);
            ctx = new BasicContext((Context)daylightModeFacet);
        }
        if (this.intervalType == BSeriesIntervalEnum.hourly || this.definedInterval.getHours() > 0) {
            return BAbsTime.make((int)timestamp.getYear(), (BMonth)timestamp.getMonth(), (int)timestamp.getDay(), (int)timestamp.getHour(), (int)0, (int)0, (int)0, (BTimeZone)timestamp.getTimeZone(), (Context)ctx);
        }
        if (this.intervalType == BSeriesIntervalEnum.thirtyMin) {
            int minute = QuantizationCursor.getBaseQuantum(timestamp.getMinute(), 30);
            return BAbsTime.make((int)timestamp.getYear(), (BMonth)timestamp.getMonth(), (int)timestamp.getDay(), (int)timestamp.getHour(), (int)minute, (int)0, (int)0, (BTimeZone)timestamp.getTimeZone(), (Context)ctx);
        }
        if (this.intervalType == BSeriesIntervalEnum.fifteenMin) {
            int minute = QuantizationCursor.getBaseQuantum(timestamp.getMinute(), 15);
            return BAbsTime.make((int)timestamp.getYear(), (BMonth)timestamp.getMonth(), (int)timestamp.getDay(), (int)timestamp.getHour(), (int)minute, (int)0, (int)0, (BTimeZone)timestamp.getTimeZone(), (Context)ctx);
        }
        if (this.intervalType == BSeriesIntervalEnum.fiveMin) {
            int minute = QuantizationCursor.getBaseQuantum(timestamp.getMinute(), 5);
            return BAbsTime.make((int)timestamp.getYear(), (BMonth)timestamp.getMonth(), (int)timestamp.getDay(), (int)timestamp.getHour(), (int)minute, (int)0, (int)0, (BTimeZone)timestamp.getTimeZone(), (Context)ctx);
        }
        if (this.definedInterval.getMinutes() > 0) {
            int minute = QuantizationCursor.getBaseQuantum(timestamp.getMinute(), this.definedInterval.getMinutes());
            return BAbsTime.make((int)timestamp.getYear(), (BMonth)timestamp.getMonth(), (int)timestamp.getDay(), (int)timestamp.getHour(), (int)minute, (int)0, (int)0, (BTimeZone)timestamp.getTimeZone(), (Context)ctx);
        }
        if (this.definedInterval.getSeconds() > 0) {
            int seconds = QuantizationCursor.getBaseQuantum(timestamp.getSecond(), this.definedInterval.getSeconds());
            return BAbsTime.make((int)timestamp.getYear(), (BMonth)timestamp.getMonth(), (int)timestamp.getDay(), (int)timestamp.getHour(), (int)timestamp.getMinute(), (int)seconds, (int)0, (BTimeZone)timestamp.getTimeZone(), (Context)ctx);
        }
        if (this.definedInterval.getMillis() > 0L) {
            return BAbsTime.make((int)timestamp.getYear(), (BMonth)timestamp.getMonth(), (int)timestamp.getDay(), (int)timestamp.getHour(), (int)timestamp.getMinute(), (int)timestamp.getSecond(), (int)0, (BTimeZone)timestamp.getTimeZone(), (Context)ctx);
        }
        return timestamp;
    }

    private static int getBaseQuantum(int quantumValue, int interval) {
        if (interval == 0 || quantumValue == 0) {
            return 0;
        }
        return quantumValue / interval * interval;
    }

    private boolean intervalCalibrated(BAbsTime timestamp) {
        if (null == timestamp) {
            return false;
        }
        if (this.intervalStartTime == null && this.intervalEndTime == null) {
            return true;
        }
        if (this.intervalStartTime == null && this.intervalEndTime != null) {
            return timestamp.isBefore(this.intervalEndTime);
        }
        if (this.intervalStartTime != null && this.intervalEndTime == null) {
            return !timestamp.isBefore(this.intervalStartTime);
        }
        if (null != this.intervalStartTime && this.intervalStartTime.getMillis() <= timestamp.getMillis() && timestamp.isBefore(this.intervalEndTime)) {
            return true;
        }
        if (timestamp.getMillis() >= this.intervalEndTime.getMillis()) {
            if (timestamp.getMillis() - this.intervalEndTime.getMillis() > this.definedInterval.getMillis()) {
                timestamp = this.makeBaselineTimestamp(timestamp);
                this.initInterval(timestamp);
            } else {
                this.updateIntervalPeriod();
            }
            return this.intervalCalibrated(timestamp);
        }
        if (timestamp.isBefore(this.intervalStartTime)) {
            String text = lex.getText(ERR_UNORDERED_TIMESTAMPS, new Object[]{timestamp});
            log.severe(text);
            throw new RuntimeException(text);
        }
        return false;
    }

    protected void initInterval(BAbsTime baseSeriesStartTime) {
        this.intervalStartTime = baseSeriesStartTime;
        switch (this.intervalType.getOrdinal()) {
            case 0: {
                if (!this.intervalDefined) {
                    this.makeDefaultInterval();
                }
                if (!this.intervalDefined) break;
                this.intervalEndTime = this.intervalStartTime.add(this.definedInterval);
                break;
            }
            case 1: {
                this.intervalEndTime = this.intervalStartTime.add(this.definedInterval);
                break;
            }
            case 2: {
                this.intervalEndTime = this.intervalStartTime.add(BRelTime.makeMinutes((int)5));
                break;
            }
            case 3: {
                this.intervalEndTime = this.intervalStartTime.add(BRelTime.makeMinutes((int)15));
                break;
            }
            case 4: {
                this.intervalEndTime = this.intervalStartTime.add(BRelTime.makeMinutes((int)30));
                break;
            }
            case 5: {
                this.intervalEndTime = this.intervalStartTime.add(BRelTime.HOUR);
                break;
            }
            case 6: {
                this.intervalEndTime = this.intervalStartTime.nextDay();
                break;
            }
            case 7: {
                this.intervalEndTime = this.intervalStartTime.nextMonth();
                break;
            }
            case 8: {
                this.intervalEndTime = this.intervalStartTime.nextYear();
            }
        }
    }

    protected void makeDefaultInterval() {
        BRelTime seconds;
        TableCursor cursor = this.timeSeries.cursor();
        TableCursor sizeCheck = this.timeSeries.cursor();
        LinkedList<BRelTime> timeSamples = new LinkedList<BRelTime>();
        BAbsTime prevTimestamp = BAbsTime.DEFAULT;
        int checkSize = 0;
        int max = 10000;
        while (sizeCheck.next() && ++checkSize != max) {
        }
        int sampleSizeLimit = (int)((double)checkSize * 0.1);
        while (cursor.next() && timeSamples.size() < sampleSizeLimit) {
            BComplex record = (BComplex)cursor.get();
            BAbsTime time = (BAbsTime)record.get(this.keyField);
            if (null == time) {
                throw new BajaRuntimeException(ERR_INVALID_SCHEMA);
            }
            if (prevTimestamp != BAbsTime.DEFAULT) {
                BRelTime delta = prevTimestamp.delta(time);
                if (delta.getSeconds() > 0) {
                    timeSamples.add(delta);
                } else {
                    timeSamples.add(BRelTime.makeSeconds((int)1));
                }
            }
            prevTimestamp = time;
        }
        int size = timeSamples.size();
        if (size == 0) {
            this.intervalDefined = false;
            return;
        }
        Object[] values = new BRelTime[size];
        int i = 0;
        Iterator it = timeSamples.iterator();
        while (it.hasNext()) {
            values[i] = (BRelTime)it.next();
            ++i;
        }
        SortUtil.sort((Object[])values);
        if (size % 2 == 1) {
            int index = (int)Math.floor(size / 2);
            Object median = values[index];
            seconds = BRelTime.makeSeconds((int)(median.getMillisPart() > 500L ? median.getSeconds() + 1 : median.getSeconds()));
        } else {
            Object a = values[size / 2];
            Object b = values[size / 2 - 1];
            long avg = (a.getMillis() + b.getMillis()) / 2L;
            BRelTime realAvg = BRelTime.make((long)avg);
            seconds = BRelTime.makeSeconds((int)realAvg.getSeconds());
        }
        if (seconds == BRelTime.DEFAULT) {
            throw new RuntimeException(ERR_SMALL_INTERVAL);
        }
        this.definedInterval = seconds;
        this.intervalType = BSeriesIntervalEnum.custom;
        this.intervalDefined = true;
    }

    protected void updateIntervalPeriod() {
        switch (this.intervalType.getOrdinal()) {
            case 0: 
            case 1: {
                this.intervalStartTime = this.intervalStartTime.add(this.definedInterval);
                this.intervalEndTime = this.intervalEndTime.add(this.definedInterval);
                break;
            }
            case 8: {
                this.intervalStartTime = this.intervalStartTime.nextYear();
                this.intervalEndTime = this.intervalEndTime.nextYear();
                break;
            }
            case 7: {
                this.intervalStartTime = this.intervalStartTime.nextMonth();
                this.intervalEndTime = this.intervalEndTime.nextMonth();
                break;
            }
            case 6: {
                this.intervalStartTime = this.intervalStartTime.nextDay();
                this.intervalEndTime = this.intervalEndTime.nextDay();
                break;
            }
            case 5: {
                this.intervalStartTime = this.intervalStartTime.add(BRelTime.HOUR);
                this.intervalEndTime = this.intervalEndTime.add(BRelTime.HOUR);
                break;
            }
            case 4: {
                this.intervalStartTime = this.intervalStartTime.add(THIRTY_MIN);
                this.intervalEndTime = this.intervalEndTime.add(THIRTY_MIN);
                break;
            }
            case 3: {
                this.intervalStartTime = this.intervalStartTime.add(FIFTEEN_MIN);
                this.intervalEndTime = this.intervalEndTime.add(FIFTEEN_MIN);
                break;
            }
            case 2: {
                this.intervalStartTime = this.intervalStartTime.add(FIVE_MIN);
                this.intervalEndTime = this.intervalEndTime.add(FIVE_MIN);
            }
        }
    }
}

