/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.functions;

import java.util.List;
import java.util.Map;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.seriestransform.exceptions.SourceException;
import javax.baja.seriestransform.exceptions.TransformException;
import javax.baja.seriestransform.graph.BTransformFunction;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BNumber;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;

@NiagaraType
public class BSumSeries
extends BTransformFunction {
    public static final Type TYPE = Sys.loadType(BSumSeries.class);
    protected static final Lexicon lex = Lexicon.make(BTransformFunction.class);
    private static final String FUNCTION_NAME = lex.getText("functions.name.sumSeries");
    private static final String FUNCTION_DESC = lex.getText("functions.desc.sumSeries");

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public Type getReturnType() {
        return BNumber.TYPE;
    }

    @Override
    public Type[] getArgumentTypes() {
        return new Type[]{BNumber.TYPE};
    }

    @Override
    public String getFunctionName() {
        return FUNCTION_NAME;
    }

    @Override
    public String getFunctionDesc() {
        return FUNCTION_DESC;
    }

    @Override
    public void applyFunction(Map<String, List<? extends BComplex>> series, String[] srcProps, Property dstSlot, BComplex resultRecord) throws TransformException {
        BDouble sum = null;
        BUnit dstUnits = BSumSeries.getUnits(dstSlot);
        for (String name : srcProps) {
            String seriesName = BSumSeries.getSeriesName(name);
            String fieldName = BSumSeries.getFieldName(name);
            List<? extends BComplex> records = this.getSeriesRecords(series, seriesName);
            for (BComplex bComplex : records) {
                Property srcProp = bComplex.getProperty(fieldName);
                try {
                    BNumber check = this.sumValues((BNumber)sum, bComplex, srcProp, dstUnits);
                    if (check.equals((Object)BDouble.NaN)) continue;
                    sum = check;
                }
                catch (SourceException e) {
                    sum = BDouble.NaN;
                }
            }
        }
        BSumSeries.setRecordValue(resultRecord, dstSlot, sum);
    }

    protected BNumber sumValues(BNumber curSum, BComplex source, Property field, BUnit dstUnits) throws SourceException {
        BUnit origUnits;
        BValue value = source.get(field);
        BFacets facets = field.getFacets();
        BUnit bUnit = origUnits = facets != null ? (BUnit)facets.get("units") : BUnit.NULL;
        if (value instanceof BNumber) {
            BNumber number = BSumSeries.convertToUnits((BNumber)value, origUnits, dstUnits);
            curSum = null == curSum ? number : this.addValues(number, curSum);
        }
        return curSum;
    }

    protected BNumber addValues(BNumber a, BNumber b) {
        if (null == a || null == b || Double.isNaN(a.getNumeric()) || Double.isNaN(b.getNumeric())) {
            return BDouble.NaN;
        }
        if (a instanceof BDouble) {
            return BDouble.make((double)(a.getDouble() + b.getDouble()));
        }
        if (a instanceof BFloat) {
            return BFloat.make((float)(a.getFloat() + b.getFloat()));
        }
        if (a instanceof BLong) {
            return BLong.make((long)(a.getLong() + b.getLong()));
        }
        if (a instanceof BInteger) {
            return BInteger.make((int)(a.getInt() + b.getInt()));
        }
        return BDouble.make((double)(a.getDouble() + b.getDouble()));
    }
}

