/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.composite;

import com.tridium.seriestransform.IntervalSeriesCursor;
import com.tridium.seriestransform.SubCursor;
import com.tridium.seriestransform.composite.CompositeMapping;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.baja.collection.AbstractCursor;
import javax.baja.collection.BITable;
import javax.baja.collection.Row;
import javax.baja.nre.util.IFilter;
import javax.baja.seriestransform.BSeriesTransformTable;
import javax.baja.seriestransform.SeriesTransformRow;
import javax.baja.seriestransform.graph.BSeriesSchema;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Cursor;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;

public class CompositeCursor
extends IntervalSeriesCursor<BComplex> {
    private final BComponent currentRecord;
    private final List<SubCursor<BComplex>> subCursors = new LinkedList<SubCursor<BComplex>>();
    private final String keyField;

    public CompositeCursor(BSeriesSchema schema, CompositeMapping[] compositeMappings, IFilter filter, BITable<BComplex> table) {
        super(table);
        this.keyField = schema.getKeyField();
        this.filter = null;
        this.currentRecord = CompositeCursor.createTemplateRecord(schema);
        this.createSubCursors(compositeMappings);
    }

    private void createSubCursors(CompositeMapping[] mappings) {
        for (CompositeMapping cm : mappings) {
            BSeriesTransformTable c = cm.getTable();
            Map<String, String> propertyMappings = cm.getPropertyMappings();
            String keyField = c.getSchema().getKeyField();
            this.subCursors.add(new MappingCursor((Cursor<BComplex>)c.cursor(), keyField, propertyMappings));
        }
    }

    public boolean advanceCursor() {
        BAbsTime baseTime = this.getBaseTime();
        if (baseTime.equals((Object)BAbsTime.DEFAULT)) {
            return false;
        }
        CompositeCursor.clearRecord((BComplex)this.currentRecord);
        this.currentRecord.set(this.keyField, (BValue)baseTime);
        for (SubCursor<BComplex> subCursor : this.subCursors) {
            MappingCursor sc = (MappingCursor)subCursor;
            BComplex record = sc.get(baseTime);
            Map<String, String> propMappings = sc.getMappings();
            if (null == record) continue;
            for (Map.Entry<String, String> entry : propMappings.entrySet()) {
                String srcPropName = entry.getValue();
                Property property = this.currentRecord.getProperty(entry.getKey());
                BFacets facets = property.getFacets();
                BValue value = record.get(srcPropName);
                this.currentRecord.set(entry.getKey(), value);
                Slot slot = this.currentRecord.getSlot(entry.getKey());
                this.currentRecord.setFacets(slot, facets);
            }
        }
        return true;
    }

    public Row<BComplex> row() {
        return new SeriesTransformRow<BComponent>(this.getTable(), this.currentRecord);
    }

    protected void closeCursor() {
        this.subCursors.forEach(AbstractCursor::close);
    }

    private BAbsTime getBaseTime() {
        BAbsTime timeMarker = BAbsTime.DEFAULT;
        ListIterator<SubCursor<BComplex>> iterator = this.subCursors.listIterator();
        while (iterator.hasNext()) {
            MappingCursor mc = (MappingCursor)iterator.next();
            if (mc.next()) {
                BAbsTime timestamp = mc.getTimestamp();
                if (timeMarker != BAbsTime.DEFAULT && !timestamp.isBefore(timeMarker)) continue;
                timeMarker = timestamp;
                continue;
            }
            iterator.remove();
            return this.getBaseTime();
        }
        return timeMarker;
    }

    protected static class MappingCursor
    extends SubCursor<BComplex> {
        private final Map<String, String> propMappings;

        public MappingCursor(Cursor<BComplex> c, String keyField, Map<String, String> propMappings) {
            super(c, keyField);
            this.propMappings = propMappings;
        }

        public Map<String, String> getMappings() {
            return this.propMappings;
        }
    }
}

