/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.cleanser.replacers;

import com.tridium.seriestransform.cleanser.CleanserCursor;
import com.tridium.seriestransform.cleanser.interfaces.BIDetector;
import com.tridium.seriestransform.cleanser.interfaces.BIValueReplacer;
import javax.baja.collection.BITable;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDouble;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Cursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BReplaceWithNextGood
extends BObject
implements BIValueReplacer {
    public static final Type TYPE = Sys.loadType(BReplaceWithNextGood.class);
    private Cursor<? extends BComplex> lookAheadCursor;
    private int parentCursorPosition;
    private int lookaheadCursorPosition;
    private BIDetector detector;
    BDouble nextGood;

    public Type getType() {
        return TYPE;
    }

    @Override
    public BValue supplyReplacement(BValue data) {
        return this.getNextGood();
    }

    private BDouble getNextGood() {
        if (this.nextGood != null) {
            return this.nextGood;
        }
        if (this.findNextGood()) {
            return this.nextGood;
        }
        return BDouble.make((double)0.0);
    }

    private boolean findNextGood() {
        while (this.lookAheadCursor.next()) {
            ++this.lookaheadCursorPosition;
            BComplex complex = (BComplex)this.lookAheadCursor.get();
            if (this.detector.isDataBad(complex)) continue;
            this.nextGood = CleanserCursor.extractFromRecord(complex);
            return true;
        }
        return false;
    }

    @Override
    public void examineEntry(BValue entry) {
        ++this.parentCursorPosition;
        if (this.parentCursorPosition > this.lookaheadCursorPosition) {
            ++this.lookaheadCursorPosition;
            this.nextGood = null;
            this.lookAheadCursor.next();
            BComplex complex = (BComplex)this.lookAheadCursor.get();
            this.detector.isDataBad(complex);
        }
    }

    @Override
    public void initialize(BITable<? extends BComplex> table, BIDetector chosenDetector) {
        this.lookAheadCursor = table.cursor();
        this.detector = chosenDetector;
    }
}

