/*
 * Decompiled with CFR 0.152.
 */
package obix.xml;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.baja.xml.XInputStreamReader;
import obix.xml.XElem;
import obix.xml.XException;
import obix.xml.XNs;
import obix.xml.XText;

public class XParser {
    public static final int EOF = -1;
    public static final int ELEM_START = 1;
    public static final int ELEM_END = 2;
    public static final int TEXT = 3;
    private static final byte[] charMap;
    private static final int CT_SPACE = 1;
    private static final int CT_NAME = 2;
    private static final String[] internCache;
    private XInputStreamReader in;
    private int pushback = -1;
    private int line = 1;
    private int col;
    private int type;
    private XText text = new XText();
    private int depth;
    private XElem[] stack = new XElem[256];
    private XNs[][] nsStack = new XNs[256][];
    private XNs defaultNs;
    private XText buf = new XText();
    private XText entityBuf = new XText();
    private String name;
    private String prefix;
    private boolean popStack;
    private boolean emptyElem;

    public static XParser make(File file) throws Exception {
        return XParser.make(new BufferedInputStream(new FileInputStream(file)));
    }

    public static XParser make(String xml) throws Exception {
        return XParser.make(new ByteArrayInputStream(xml.getBytes()));
    }

    public static XParser make(InputStream in) throws Exception {
        return new XParser(in);
    }

    protected XParser(InputStream in) throws IOException {
        this.in = new XInputStreamReader(in);
    }

    public String getEncoding() throws IOException {
        return this.in.getEncoding();
    }

    public boolean isZipped() throws IOException {
        return this.in.isZipped();
    }

    public final XElem parse() throws Exception {
        return this.parse(true);
    }

    public final XElem parse(boolean close) throws Exception {
        if (this.next() != 1) {
            if (close) {
                this.close();
            }
            throw this.error("Expecting element start");
        }
        return this.parseCurrent(close);
    }

    public final XElem parseCurrent() throws Exception {
        return this.parseCurrent(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final XElem parseCurrent(boolean close) throws Exception {
        try {
            XElem root;
            int depth = 1;
            XElem cur = root = this.elem().copy();
            while (depth > 0) {
                int type = this.next();
                if (type == 1) {
                    XElem oldCur = cur;
                    cur = this.elem().copy();
                    oldCur.addContent(cur);
                    ++depth;
                    continue;
                }
                if (type == 2) {
                    cur = cur.parent();
                    --depth;
                    continue;
                }
                if (type == 3) {
                    cur.addContent(this.text().copy());
                    continue;
                }
                if (type != -1) continue;
                throw new EOFException();
            }
            XElem xElem = root;
            return xElem;
        }
        finally {
            if (close) {
                this.close();
            }
        }
    }

    public final int next() throws Exception {
        if (this.popStack) {
            this.popStack = false;
            this.pop();
        }
        if (this.emptyElem) {
            this.emptyElem = false;
            this.popStack = true;
            this.type = 2;
            return 2;
        }
        while (true) {
            int c;
            try {
                c = this.read();
            }
            catch (EOFException e) {
                this.type = -1;
                return -1;
            }
            if (c == 60) {
                c = this.read();
                if (c == 33) {
                    c = this.read();
                    if (c == 45) {
                        c = this.read();
                        if (c != 45) {
                            throw this.error("Expecting comment");
                        }
                        this.skipComment();
                        continue;
                    }
                    if (c == 91) {
                        this.consume("CDATA[");
                        this.parseCDATA();
                        this.type = 3;
                        return 3;
                    }
                    if (c == 68) {
                        this.consume("OCTYPE");
                        this.skipDocType();
                        continue;
                    }
                    throw this.error("Unexpected markup");
                }
                if (c == 63) {
                    this.skipPI();
                    continue;
                }
                if (c == 47) {
                    this.parseElemEnd();
                    this.popStack = true;
                    this.type = 2;
                    return 2;
                }
                this.parseElemStart(c);
                this.type = 1;
                return 1;
            }
            if (this.parseText(c)) break;
        }
        this.type = 3;
        return 3;
    }

    public void skip() throws Exception {
        this.skip(this.depth);
    }

    public void skip(int toDepth) throws Exception {
        int type;
        do {
            if (this.type != 2 || this.depth != toDepth) continue;
            return;
        } while ((type = this.next()) != -1);
        throw new EOFException();
    }

    public final int type() {
        return this.type;
    }

    public final int depth() {
        return this.depth;
    }

    public final XElem elem() {
        if (this.depth < 1) {
            return null;
        }
        return this.stack[this.depth - 1];
    }

    public final XElem elem(int depth) {
        if (depth < 0 || depth >= this.depth) {
            return null;
        }
        return this.stack[depth];
    }

    public final XText text() {
        if (this.type == 3) {
            return this.text;
        }
        return null;
    }

    public final int line() {
        return this.line;
    }

    public final int column() {
        return this.col;
    }

    public final void close() {
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void parseElemStart(int c) throws Exception {
        XElem elem = this.push();
        this.parseQName(c);
        elem.name = this.name;
        elem.line = this.line;
        String prefix = this.prefix;
        boolean resolveAttrNs = false;
        while (true) {
            boolean sp = this.skipSpace();
            c = this.read();
            if (c == 62) break;
            if (c == 47) {
                c = this.read();
                if (c != 62) {
                    throw this.error("Expecting /> empty element");
                }
                this.emptyElem = true;
                break;
            }
            if (!sp) {
                throw this.error("Expecting space before attribute");
            }
            resolveAttrNs |= this.parseAttr(c, elem);
        }
        elem.ns = prefix == null ? this.defaultNs : this.prefixToNs(prefix);
        if (resolveAttrNs) {
            for (int i = 0; i < elem.attrSize; ++i) {
                if (elem.attr[i * 3 + 1] == null) continue;
                elem.attr[i * 3 + 1] = this.prefixToNs((String)elem.attr[i * 3 + 1]);
            }
        }
    }

    private void parseElemEnd() throws Exception {
        this.parseQName(this.read());
        XNs ns = null;
        ns = this.prefix == null ? this.defaultNs : this.prefixToNs(this.prefix);
        if (this.depth == 0) {
            throw this.error("Element end without start");
        }
        XElem elem = this.stack[this.depth - 1];
        if (!elem.name.equals(this.name) || elem.ns != ns) {
            throw this.error("Expecting end of element '" + elem.qname() + "'[" + elem.line + "]");
        }
        this.skipSpace();
        if (this.read() != 62) {
            throw this.error("Expecting > end of element");
        }
    }

    private boolean parseAttr(int c, XElem elem) throws Exception {
        this.parseQName(c);
        String prefix = this.prefix;
        String name = this.name;
        this.skipSpace();
        if (this.read() != 61) {
            throw this.error("Expecting '='");
        }
        this.skipSpace();
        c = this.read();
        if (c != 34 && c != 39) {
            throw this.error("Expecting quoted attribute value");
        }
        String value = this.parseString(c);
        if (prefix == null) {
            if (name.equals("xmlns")) {
                this.pushNs(elem, "", value);
            }
        } else if (prefix.equals("xmlns")) {
            this.pushNs(elem, name, value);
            prefix = null;
            name = "xmlns:" + name;
        } else if (prefix.equalsIgnoreCase("xml")) {
            prefix = null;
            name = "xml:" + name;
        }
        elem.addAttrImpl(prefix, name, value);
        return prefix != null;
    }

    private void parseQName(int c) throws Exception {
        this.prefix = null;
        this.name = this.parseName(c);
        c = this.read();
        if (c == 58) {
            this.prefix = this.name;
            this.name = this.parseName(this.read());
        } else {
            this.pushback = c;
        }
    }

    private String parseString(int quote) throws Exception {
        int c;
        XText buf = this.buf;
        buf.setLength(0);
        while ((c = this.read()) != quote) {
            buf.append(this.toCharData(c));
        }
        return this.bufToString();
    }

    private String parseName(int c) throws Exception {
        if (!XParser.isName(c)) {
            throw this.error("Expected XML name");
        }
        XText buf = this.buf;
        buf.setLength(0);
        buf.append(c);
        while (XParser.isName(c = this.read())) {
            buf.append(c);
        }
        this.pushback = c;
        return this.bufToString();
    }

    private void parseCDATA() throws Exception {
        XText text = this.text;
        text.length = 0;
        text.cdata = true;
        int c2 = -1;
        int c1 = -1;
        int c0 = -1;
        while (true) {
            c2 = c1;
            c1 = c0;
            c0 = this.read();
            if (c2 == 93 && c1 == 93 && c0 == 62) {
                text.setLength(text.length - 2);
                return;
            }
            text.append(c0);
        }
    }

    private boolean parseText(int c) throws Exception {
        XText text = this.text;
        text.length = 0;
        text.cdata = false;
        text.append(this.toCharData(c));
        boolean gotText = !XParser.isSpace(c);
        while (true) {
            try {
                c = this.read();
            }
            catch (EOFException e) {
                if (gotText) {
                    throw e;
                }
                return false;
            }
            if (c == 60) {
                this.pushback = c;
                return gotText;
            }
            if (!XParser.isSpace(c)) {
                gotText = true;
            }
            text.append(this.toCharData(c));
        }
    }

    private boolean skipSpace() throws Exception {
        int c = this.read();
        if (!XParser.isSpace(c)) {
            this.pushback = c;
            return false;
        }
        while (XParser.isSpace(c = this.read())) {
        }
        this.pushback = c;
        return true;
    }

    private void skipComment() throws Exception {
        int c2 = -1;
        int c1 = -1;
        int c0 = -1;
        do {
            c2 = c1;
            c1 = c0;
            c0 = this.read();
        } while (c2 != 45 || c1 != 45);
        if (c0 != 62) {
            throw this.error("Cannot have -- in middle of comment");
        }
    }

    private void skipPI() throws Exception {
        int c1 = -1;
        int c0 = -1;
        do {
            c1 = c0;
            c0 = this.read();
        } while (c1 != 63 || c0 != 62);
    }

    private void skipDocType() throws Exception {
        int depth = 1;
        do {
            int c;
            if ((c = this.read()) == 60) {
                ++depth;
            }
            if (c != 62) continue;
            --depth;
        } while (depth != 0);
    }

    private void consume(String s) throws Exception {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (this.read() == s.charAt(i)) continue;
            throw this.error("Expected '" + s + "'");
        }
    }

    private int read() throws Exception {
        int c = this.pushback;
        if (c != -1) {
            this.pushback = -1;
            return c;
        }
        c = this.in.read();
        if (c < 0) {
            throw new EOFException();
        }
        if (c == 10) {
            ++this.line;
            this.col = 0;
            return 10;
        }
        if (c == 13) {
            int lookAhead = this.in.read();
            if (lookAhead != 10) {
                this.pushback = lookAhead;
            }
            ++this.line;
            this.col = 0;
            return 10;
        }
        ++this.col;
        return c;
    }

    private int toCharData(int c) throws Exception {
        if (c == 60) {
            throw this.error("Invalid markup in char data");
        }
        if (c != 38) {
            return c;
        }
        c = this.read();
        if (c == 35) {
            c = this.in.read();
            ++this.col;
            int x = 0;
            int base = 10;
            if (c == 120) {
                base = 16;
            } else {
                x = this.toNum(x, c, base);
            }
            c = this.in.read();
            ++this.col;
            while (c != 59) {
                x = this.toNum(x, c, base);
                c = this.in.read();
                ++this.col;
            }
            return (char)x;
        }
        XText ebuf = this.entityBuf;
        ebuf.setLength(0);
        ebuf.append(c);
        while ((c = this.read()) != 59) {
            ebuf.append(c);
        }
        String entity = ebuf.string().intern();
        if (entity == "lt") {
            return 60;
        }
        if (entity == "gt") {
            return 62;
        }
        if (entity == "amp") {
            return 38;
        }
        if (entity == "quot") {
            return 34;
        }
        if (entity == "apos") {
            return 39;
        }
        throw this.error("Unsupported entity &" + entity + ";");
    }

    private int toNum(int x, int c, int base) throws Exception {
        x *= base;
        if (48 <= c && c <= 57) {
            return x + (c - 48);
        }
        if (base == 16) {
            if (97 <= c && c <= 102) {
                return x + 10 + (c - 97);
            }
            if (65 <= c && c <= 70) {
                return x + 10 + (c - 65);
            }
        }
        throw this.error("Expected base " + base + " number");
    }

    private String bufToString() {
        char ch;
        if (this.buf.length == 1 && ' ' <= (ch = this.buf.data[0]) && ch < '\u0080') {
            return internCache[ch];
        }
        return this.buf.string();
    }

    private XNs prefixToNs(String prefix) {
        for (int i = this.depth - 1; i >= 0; --i) {
            XNs[] ns = this.nsStack[i];
            if (ns == null) continue;
            for (int j = 0; j < ns.length; ++j) {
                if (!ns[j].prefix.equals(prefix)) continue;
                return ns[j];
            }
        }
        throw new XException("Undeclared namespace prefix '" + prefix + "'");
    }

    private void pushNs(XElem elem, String prefix, String value) {
        XNs[] list;
        XNs ns = new XNs(prefix, value);
        ns.declaringElem = elem;
        if (prefix == "") {
            this.defaultNs = value.equals("") ? null : ns;
        }
        if ((list = this.nsStack[this.depth - 1]) == null) {
            list = new XNs[]{ns};
        } else {
            XNs[] temp = new XNs[list.length + 1];
            System.arraycopy(list, 0, temp, 0, list.length);
            temp[list.length] = ns;
            list = temp;
        }
        this.nsStack[this.depth - 1] = list;
    }

    private void reEvalDefaultNs() {
        this.defaultNs = null;
        for (int i = this.depth - 1; i >= 0; --i) {
            XNs[] ns = this.nsStack[i];
            if (ns == null) continue;
            for (int j = 0; j < ns.length; ++j) {
                if (!ns[j].isDefault()) continue;
                if (!ns[j].uri.equals("")) {
                    this.defaultNs = ns[j];
                }
                return;
            }
        }
    }

    private XElem push() {
        XElem elem = this.stack[this.depth];
        if (elem == null) {
            elem = this.stack[this.depth] = new XElem();
        }
        ++this.depth;
        elem.clearAttr();
        return elem;
    }

    private void pop() {
        --this.depth;
        XNs[] ns = this.nsStack[this.depth];
        if (ns != null) {
            this.nsStack[this.depth] = null;
            this.reEvalDefaultNs();
        }
    }

    private XException error(String msg) {
        return new XException(msg, this.line, this.col);
    }

    static boolean isName(int c) {
        return c < 128 ? (charMap[c] & 2) != 0 : true;
    }

    static boolean isSpace(int c) {
        return c < 128 ? (charMap[c] & 1) != 0 : false;
    }

    static {
        int i;
        charMap = new byte[128];
        for (i = 97; i <= 122; ++i) {
            XParser.charMap[i] = 2;
        }
        for (i = 65; i <= 90; ++i) {
            XParser.charMap[i] = 2;
        }
        for (i = 48; i <= 57; ++i) {
            XParser.charMap[i] = 2;
        }
        XParser.charMap[45] = 2;
        XParser.charMap[46] = 2;
        XParser.charMap[95] = 2;
        XParser.charMap[10] = 1;
        XParser.charMap[13] = 1;
        XParser.charMap[32] = 1;
        XParser.charMap[9] = 1;
        internCache = new String[128];
        for (i = 32; i < 128; ++i) {
            XParser.internCache[i] = new String(new char[]{(char)i}).intern();
        }
    }
}

