/*
 * Decompiled with CFR 0.152.
 */
package obix.net;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import obix.Contract;
import obix.List;
import obix.Obj;
import obix.Op;
import obix.Reltime;
import obix.Uri;
import obix.net.ObixSession;
import obix.net.WatchListener;

public class SessionWatch {
    public boolean debug = false;
    ObixSession session;
    String name;
    Obj watchObj;
    long lease;
    Uri leaseHref;
    Uri addHref;
    Uri removeHref;
    Uri pollChangesHref;
    Uri pollRefreshHref;
    Uri deleteHref;
    ArrayList<Item> items = new ArrayList();
    HashMap<String, Item> hrefToItem = new HashMap();
    long pollPeriod;
    long lastPollAttempt;
    long lastPollSuccess;
    Thread poller;
    boolean alive;
    ArrayList<WatchListener> listeners = new ArrayList();

    static SessionWatch make(ObixSession session, String name, long pollPeriod) throws Exception {
        if (session.watchService == null) {
            throw new Exception("Lobby missing watchService with valid href");
        }
        Op makeOp = (Op)session.watchService.get("make");
        if (makeOp == null || makeOp.getNormalizedHref() == null) {
            throw new Exception("watchService missing op with valid href");
        }
        Obj watchObj = session.invoke(makeOp, new Obj());
        SessionWatch watch = new SessionWatch(session, name, watchObj, pollPeriod);
        watch.start();
        return watch;
    }

    private SessionWatch(ObixSession session, String name, Obj watchObj, long pollPeriod) throws Exception {
        this.session = session;
        this.name = name;
        this.watchObj = watchObj;
        this.addHref = watchObj.getChildHref("add");
        this.removeHref = watchObj.getChildHref("remove");
        this.pollChangesHref = watchObj.getChildHref("pollChanges");
        this.pollRefreshHref = watchObj.getChildHref("pollRefresh");
        this.deleteHref = watchObj.getChildHref("delete");
        Reltime lease = (Reltime)watchObj.get("lease");
        if (lease == null) {
            throw new Exception("Watch missing lease object " + watchObj);
        }
        this.lease = lease.get();
        this.leaseHref = lease.getNormalizedHref();
        this.setPollPeriod(pollPeriod);
    }

    public ObixSession getSession() {
        return this.session;
    }

    public Obj getWatchObj() {
        return this.watchObj;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "Watch:" + this.name + " :: " + (this.watchObj != null ? this.watchObj.getHref() : null);
    }

    public int size() {
        return this.items.size();
    }

    public Obj get(int index) {
        Item i = this.items.get(index);
        return i != null ? i.obj : null;
    }

    public Obj get(Uri href) {
        Item i = this.hrefToItem.get(href.toString());
        return i != null ? i.obj : null;
    }

    public long getLastUpdate(int index) {
        return this.items.get((int)index).lastUpdate;
    }

    public Obj[] list() {
        Obj[] list = new Obj[this.items.size()];
        for (int i = 0; i < list.length; ++i) {
            list[i] = this.get(i);
        }
        return list;
    }

    public Iterator<String> hrefs() {
        return this.hrefToItem.keySet().iterator();
    }

    public Obj add(Uri href) throws Exception {
        return this.add(new Uri[]{href})[0];
    }

    public Obj[] add(Uri[] hrefs) throws Exception {
        Obj in = new Obj();
        in.setIs(new Contract("obix:WatchIn"));
        in.add(new List("hrefs", new Contract("obix:Uri")).addAll(hrefs));
        Obj out = this.session.invoke(this.addHref, in);
        if (this.debug) {
            System.out.println("-- ADD: " + this.name);
            out.dump();
        }
        Obj[] added = out.get("values").list();
        long now = System.currentTimeMillis();
        for (int i = 0; i < added.length; ++i) {
            Obj obj = added[i];
            String href = obj.getHref().toString();
            Item item = this.hrefToItem.get(href);
            if (item == null) {
                item = new Item();
                this.hrefToItem.put(href, item);
                this.items.add(item);
            }
            item.obj = obj;
            item.lastUpdate = now;
        }
        return added;
    }

    public void remove(Uri[] hrefs) throws Exception {
        Item[] items = new Item[hrefs.length];
        for (int i = 0; i < items.length; ++i) {
            items[i] = this.hrefToItem.get(hrefs[i].toString());
        }
        this.remove(items, hrefs);
    }

    public void remove(int[] indexes) throws Exception {
        Item[] items = new Item[indexes.length];
        Uri[] hrefs = new Uri[items.length];
        for (int i = 0; i < items.length; ++i) {
            items[i] = this.items.get(indexes[i]);
            hrefs[i] = items[i].obj.getHref();
        }
        this.remove(items, hrefs);
    }

    private void remove(Item[] items, Uri[] hrefs) throws Exception {
        Obj in = new Obj();
        in.setIs(new Contract("obix:WatchIn"));
        in.add(new List("hrefs", new Contract("obix:Uri")).addAll(hrefs));
        if (this.debug) {
            System.out.println("-- Remove: " + this.name);
            in.dump();
        }
        this.session.invoke(this.removeHref, in);
        for (int i = 0; i < items.length; ++i) {
            Item item = items[i];
            this.items.remove(item);
            this.hrefToItem.remove(item.obj.getHref().toString());
        }
    }

    public long getLease() {
        return this.lease;
    }

    public long setLease(long desiredLease) throws Exception {
        if (this.leaseHref == null) {
            throw new Exception("Lease time missing href");
        }
        Reltime x = new Reltime(desiredLease);
        x.setHref(this.leaseHref);
        x = (Reltime)this.session.write(x);
        this.lease = x.get();
        return this.lease;
    }

    public long getPollPeriod() {
        return this.pollPeriod;
    }

    public long setPollPeriod(long pollPeriod) throws Exception {
        long desiredLease = pollPeriod + 5000L;
        if (desiredLease > this.lease) {
            this.setLease(desiredLease);
        }
        if (desiredLease > this.lease && (pollPeriod = this.lease - 5000L) < 100L) {
            throw new Exception("Lease time is too short: " + this.lease);
        }
        this.pollPeriod = pollPeriod;
        return this.pollPeriod;
    }

    public long lastPollAttempt() {
        return this.lastPollAttempt;
    }

    public long lastPollSuccess() {
        return this.lastPollSuccess;
    }

    public void pollChanges() throws Exception {
        this.poll(this.pollChangesHref, false);
    }

    public void pollRefresh() throws Exception {
        this.poll(this.pollRefreshHref, true);
    }

    private void poll(Uri opHref, boolean refresh) throws Exception {
        this.lastPollAttempt = System.currentTimeMillis();
        Obj out = this.session.invoke(opHref, null);
        long now = System.currentTimeMillis();
        if (this.debug) {
            System.out.println("-- POLL: " + this.name + " [refresh=" + refresh + "]");
            out.dump();
        }
        Obj[] values = ((List)out.get("values")).list();
        for (int i = 0; i < values.length; ++i) {
            Obj obj = values[i];
            String href = obj.getHref().toString();
            Item item = this.hrefToItem.get(href);
            if (item == null) {
                System.out.println("WARNING: polled href not in my list: " + href);
                continue;
            }
            item.obj = obj;
            item.lastUpdate = now;
            this.fireChanged(obj);
        }
        this.lastPollSuccess = now;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(WatchListener listener) {
        ArrayList<WatchListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(WatchListener listener) {
        ArrayList<WatchListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WatchListener[] getListeners() {
        ArrayList<WatchListener> arrayList = this.listeners;
        synchronized (arrayList) {
            return this.listeners.toArray(new WatchListener[this.listeners.size()]);
        }
    }

    public void fireChanged(Obj obj) {
        WatchListener[] listeners = this.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            try {
                listeners[i].changed(obj);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void fireClosed() {
        WatchListener[] listeners = this.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            try {
                listeners[i].closed(this);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void delete() {
        this.stop();
        try {
            this.session.invoke(this.deleteHref, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.session.watches.remove(this.name);
        this.session = null;
    }

    void start() {
        this.poller = new Thread(this.toString() + "-Poller"){

            @Override
            public void run() {
                SessionWatch.this.pollLoop();
            }
        };
        this.alive = true;
        this.poller.start();
    }

    void stop() {
        this.alive = false;
        if (this.poller != null) {
            this.poller.interrupt();
        }
        this.poller = null;
    }

    void pollLoop() {
        while (this.alive) {
            long nextPollAttempt = this.lastPollAttempt + this.pollPeriod;
            long now = System.currentTimeMillis();
            try {
                long sleepTime = nextPollAttempt - now;
                if (sleepTime > 0L) {
                    Thread.sleep(sleepTime);
                }
                if (!this.alive) continue;
                this.pollChanges();
            }
            catch (Exception e) {
                e.printStackTrace();
                if (this.alive && this.session != null) {
                    this.session.watches.remove(this.name);
                    this.session = null;
                }
                this.alive = false;
            }
        }
        this.fireClosed();
    }

    static class Item {
        Obj obj;
        long lastUpdate;

        Item() {
        }
    }
}

