/*
 * Decompiled with CFR 0.152.
 */
package obix.net;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.CookieManager;
import java.net.HttpCookie;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.StringJoiner;
import javax.baja.naming.BHost;
import javax.baja.naming.BIpHost;
import javax.baja.net.HttpConnection;
import javax.baja.net.HttpsConnection;
import javax.net.SocketFactory;
import obix.Err;
import obix.Obj;
import obix.Op;
import obix.Uri;
import obix.io.Base64;
import obix.io.ObixDecoder;
import obix.io.ObixEncoder;
import obix.io.ObixXmlDecoder;
import obix.io.ObixXmlEncoder;
import obix.net.BatchIn;
import obix.net.ErrException;
import obix.net.SessionWatch;
import obix.net.WatchListener;

public class ObixSession {
    Uri authority;
    Uri lobbyUri;
    Uri batchUri;
    Obj lobby;
    Obj about;
    Obj watchService;
    String username;
    String password;
    String authHeader;
    HashMap<String, SessionWatch> watches = new HashMap();
    int timeout;
    private boolean closeOnSend = true;
    private final Object SocketFactoryLock = new Object();
    private SocketFactory socketFactory;
    private final CookieManager cookieManager = new CookieManager();

    public ObixSession(Uri lobbyUri, String username, String password) {
        this(lobbyUri, username, password, 0);
    }

    public ObixSession(Uri lobbyUri, String username, String password, int timeout) {
        this.authority = lobbyUri.getAuthorityUri();
        this.lobbyUri = lobbyUri;
        this.username = username;
        this.password = password;
        this.authHeader = "Basic " + Base64.encode(username + ':' + password);
        this.timeout = timeout;
    }

    public Uri getAuthority() {
        return this.authority;
    }

    public boolean contains(Uri uri) {
        return this.authority.contains(uri);
    }

    public Uri getLobbyUri() {
        return this.lobbyUri;
    }

    public Obj getLobby() {
        if (this.lobby == null) {
            throw new IllegalStateException("Session not open");
        }
        return this.lobby;
    }

    public String getUsername() {
        return this.username;
    }

    public String toString() {
        return this.authority.toString();
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean getCloseOnSend() {
        return this.closeOnSend;
    }

    public void setCloseOnSend(boolean close) {
        this.closeOnSend = close;
    }

    public void open() throws Exception {
        Obj watchService;
        this.lobby = this.read(this.lobbyUri);
        this.batchUri = this.lobby.get("batch").getNormalizedHref();
        Obj about = this.lobby.get("about");
        if (about != null && about.getHref() != null) {
            this.about = this.read(about.getNormalizedHref());
        }
        if ((watchService = this.lobby.get("watchService")) != null && watchService.getHref() != null) {
            this.watchService = this.read(watchService.getNormalizedHref());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.SocketFactoryLock;
        synchronized (object) {
            this.socketFactory = null;
        }
    }

    public Obj ping() throws Exception {
        return this.read(this.about.getNormalizedHref());
    }

    public Obj read(Uri uri) throws Exception {
        return ObixSession.makeDecoder(this.open(uri)).decode();
    }

    public Obj write(Obj obj) throws Exception {
        Uri href = obj.getNormalizedHref();
        if (href == null) {
            throw new Exception("obj.href is null");
        }
        return this.send(href, "PUT", obj);
    }

    public Obj invoke(Op op, Obj in) throws Exception {
        Uri href = op.getNormalizedHref();
        if (href == null) {
            throw new Exception("op.href is null");
        }
        return this.invoke(href, in);
    }

    public Obj invoke(Uri href, Obj in) throws Exception {
        if (in == null) {
            in = new Obj();
            in.setNull(true);
        }
        return this.send(href, "POST", in);
    }

    public BatchIn makeBatch() throws Exception {
        if (this.batchUri == null) {
            throw new Exception("Lobby missing batch op");
        }
        return new BatchIn(this);
    }

    public InputStream open(Uri uri) throws Exception {
        HttpConnection conn = this.setupHttpConnection(uri);
        conn.connect();
        int rc = conn.getStatusCode();
        if (rc / 100 > 2) {
            throw new IOException("HTTP connection failed resp code=" + rc);
        }
        List cookies = conn.getResponseHeaders("Set-Cookie");
        if (cookies != null) {
            for (String cookie : cookies) {
                this.cookieManager.getCookieStore().add(null, HttpCookie.parse(cookie).get(0));
            }
        }
        if (this.closeOnSend) {
            ByteArrayInputStream bIn;
            DataInputStream dIn = new DataInputStream(conn.getInputStream());
            if (conn.getContentLength() >= 0) {
                byte[] buf = new byte[conn.getContentLength()];
                dIn.readFully(buf);
                bIn = new ByteArrayInputStream(buf);
            } else {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                int c = dIn.read();
                while (c >= 0) {
                    os.write(c);
                    c = dIn.read();
                }
                bIn = new ByteArrayInputStream(os.toByteArray());
            }
            conn.close();
            return bIn;
        }
        return conn.getInputStream();
    }

    public SessionWatch[] getWatches() {
        return this.watches.values().toArray(new SessionWatch[this.watches.size()]);
    }

    public SessionWatch getWatch(String name) {
        return this.watches.get(name);
    }

    public SessionWatch makeWatch(String name, long pollPeriod) throws Exception {
        return this.makeWatch(name, pollPeriod, null);
    }

    public SessionWatch makeWatch(String name, long pollPeriod, WatchListener listener) throws Exception {
        if (this.watches.get(name) != null) {
            throw new IllegalArgumentException("Duplicate watch name: " + name);
        }
        SessionWatch watch = SessionWatch.make(this, name, pollPeriod);
        this.watches.put(name, watch);
        if (listener != null) {
            watch.addListener(listener);
        }
        return watch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpConnection makeHttpConnection(String url) throws IOException {
        URL parsedUrl = new URL(url);
        String protocol = parsedUrl.getProtocol().toLowerCase();
        String host = parsedUrl.getHost();
        int port = parsedUrl.getPort();
        if (port < 0) {
            port = parsedUrl.getDefaultPort();
        }
        String file = parsedUrl.getFile();
        BIpHost ipHost = new BIpHost(host);
        if ("https".equalsIgnoreCase(protocol)) {
            Object object = this.SocketFactoryLock;
            synchronized (object) {
                if (this.socketFactory == null) {
                    this.socketFactory = HttpsConnection.getDefaultSocketFactory();
                }
                return new HttpsConnection((BHost)ipHost, port, file, this.socketFactory);
            }
        }
        if ("http".equalsIgnoreCase(protocol)) {
            return new HttpConnection((BHost)ipHost, port, file);
        }
        throw new MalformedURLException("unsupported protocol: " + protocol);
    }

    private HttpConnection setupHttpConnection(String uri) throws Exception {
        return this.setupHttpConnection(new Uri(uri));
    }

    protected HttpConnection setupHttpConnection(Uri uri) throws Exception {
        Uri abs = uri.normalize(this.lobbyUri);
        if (!this.contains(abs)) {
            throw new IllegalArgumentException("Uri not contained by this session: " + abs);
        }
        HttpConnection conn = this.makeHttpConnection(abs.get());
        if (!this.cookieManager.getCookieStore().getCookies().isEmpty()) {
            StringJoiner joiner = new StringJoiner(";");
            for (HttpCookie cookie : this.cookieManager.getCookieStore().getCookies()) {
                joiner.add(cookie.toString());
            }
            conn.setRequestHeader("Cookie", joiner.toString());
        }
        conn.setRequestHeader("Authorization", this.authHeader);
        conn.setTimeout(this.timeout);
        return conn;
    }

    private Obj send(Uri href, String method, Obj payload) throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ObixEncoder enc = ObixSession.makeEncoder(os);
        enc.encode(payload);
        enc.flush();
        HttpConnection conn = this.setupHttpConnection(href);
        int rc = "PUT".equalsIgnoreCase(method) ? conn.put(conn.getUri(), "text/xml", os.toByteArray()) : conn.post(conn.getUri(), "text/xml", os.toByteArray());
        if (rc == 100) {
            rc = "PUT".equalsIgnoreCase(method) ? conn.putComplete() : conn.postComplete();
        }
        if (rc / 100 > 2) {
            throw new Exception("Invalid response code " + rc);
        }
        InputStream in = conn.getInputStream();
        Obj result = ObixSession.makeDecoder(in).decode();
        try {
            in.close();
            conn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result instanceof Err) {
            throw new ErrException((Err)result);
        }
        if (result.getHref() == null) {
            result.setHref(this.authority);
        }
        return result;
    }

    private static ObixEncoder makeEncoder(OutputStream out) throws IOException {
        return new ObixXmlEncoder(out);
    }

    private static ObixDecoder makeDecoder(InputStream in) throws Exception {
        return new ObixXmlDecoder(in);
    }
}

