/*
 * Decompiled with CFR 0.152.
 */
package obix.io;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import obix.Obj;
import obix.Uri;
import obix.io.ObixXmlDecoder;

public abstract class ObixDecoder {
    protected final InputStream in;
    private boolean useContracts = true;
    protected Map<String, Obj> fragIds = new HashMap<String, Obj>();
    protected Map<String, FragRefs> fragRefs = new HashMap<String, FragRefs>();

    public static Obj fromString(String s) {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(s.getBytes("UTF-8"));
            ObixDecoder decoder = ObixDecoder.make(in);
            return decoder.decodeDocument();
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    public static ObixDecoder make(InputStream in) throws Exception {
        return new ObixXmlDecoder(in);
    }

    public ObixDecoder(InputStream in) throws Exception {
        this.in = in;
    }

    public boolean getUseContracts() {
        return this.useContracts;
    }

    public void setUseContracts(boolean useContracts) {
        this.useContracts = useContracts;
    }

    public Obj decodeDocument() throws Exception {
        return this.decode();
    }

    public abstract Obj decode() throws Exception;

    static class FragRefs {
        List<Uri> uris = new ArrayList<Uri>(4);
        List<Object> elems = new ArrayList<Object>(4);

        FragRefs() {
        }
    }
}

