/*
 * Decompiled with CFR 0.152.
 */
package obix.asm;

import obix.asm.OpCodes;

public final class Jvm
implements OpCodes {
    public static final int MAGIC = -889275714;
    public static final int MINOR_VERSION = 3;
    public static final int MAJOR_VERSION = 45;
    public static final int ACC_PUBLIC = 1;
    public static final int ACC_PRIVATE = 2;
    public static final int ACC_PROTECTED = 4;
    public static final int ACC_STATIC = 8;
    public static final int ACC_FINAL = 16;
    public static final int ACC_SUPER = 32;
    public static final int ACC_SYNCHRONIZED = 32;
    public static final int ACC_VOLATILE = 64;
    public static final int ACC_TRANSIENT = 128;
    public static final int ACC_NATIVE = 256;
    public static final int ACC_INTERFACE = 512;
    public static final int ACC_ABSTRACT = 1024;
    public static final int CONSTANT_Utf8 = 1;
    public static final int CONSTANT_Integer = 3;
    public static final int CONSTANT_Float = 4;
    public static final int CONSTANT_Long = 5;
    public static final int CONSTANT_Double = 6;
    public static final int CONSTANT_Class = 7;
    public static final int CONSTANT_String = 8;
    public static final int CONSTANT_Fieldref = 9;
    public static final int CONSTANT_Methodref = 10;
    public static final int CONSTANT_InterfaceMethodref = 11;
    public static final int CONSTANT_NameAndType = 12;
    public static final String ATTR_SOURCE_FILE = "SourceFile";
    public static final String ATTR_CONSTANT_VALUE = "ConstantValue";
    public static final String ATTR_CODE = "Code";
    public static final String ATTR_EXCEPTIONS = "Exceptions";
    public static final String ATTR_LINE_NUMBER_TABLE = "LineNumberTable";
    public static final String ATTR_LOCAL_VARIABLE_TABLE = "LocalVariableTable";
    public static final String ATTR_INNER_CLASSES = "InnerClasses";
    public static final String ATTR_SYNTHETIC = "Synthetic";
    public static final String ATTR_DEPRECATED = "Deprecated";
    public static final int T_BOOLEAN = 4;
    public static final int T_CHAR = 5;
    public static final int T_FLOAT = 6;
    public static final int T_DOUBLE = 7;
    public static final int T_BYTE = 8;
    public static final int T_SHORT = 9;
    public static final int T_INT = 10;
    public static final int T_LONG = 11;
    static final byte NONE = 0;
    static final byte U1 = 1;
    static final byte U2 = 2;
    static final byte B2 = 3;
    static final byte B4 = 4;
    static final byte SPECIAL = 5;
    static final byte[] OPCODE_ARGS = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 1, 2, 2, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 5, 0, 2, 1, 2, 0, 0, 2, 2, 0, 0, 0, 0, 3, 3, 4, 4};

    public static String fieldDescriptor(Class<?> cls) {
        if (cls.isPrimitive()) {
            if (cls.equals(Byte.TYPE)) {
                return "B";
            }
            if (cls.equals(Character.TYPE)) {
                return "C";
            }
            if (cls.equals(Double.TYPE)) {
                return "D";
            }
            if (cls.equals(Float.TYPE)) {
                return "F";
            }
            if (cls.equals(Integer.TYPE)) {
                return "I";
            }
            if (cls.equals(Long.TYPE)) {
                return "J";
            }
            if (cls.equals(Short.TYPE)) {
                return "S";
            }
            if (cls.equals(Boolean.TYPE)) {
                return "Z";
            }
            if (cls.equals(Void.TYPE)) {
                return "V";
            }
            throw new IllegalStateException();
        }
        if (cls.isArray()) {
            return "[" + Jvm.fieldDescriptor(cls.getComponentType());
        }
        return "L" + cls.getName().replace('.', '/') + ";";
    }

    public static String methodDescriptor(Class<?>[] paramTypes, Class<?> returnType) {
        StringBuffer s = new StringBuffer("(");
        if (paramTypes != null) {
            for (int i = 0; i < paramTypes.length; ++i) {
                s.append(Jvm.fieldDescriptor(paramTypes[i]));
            }
        }
        s.append(")").append(Jvm.fieldDescriptor(returnType));
        return s.toString();
    }
}

