/*
 * Decompiled with CFR 0.152.
 */
package obix;

import obix.Val;

public class Time
extends Val {
    private int hour;
    private int min;
    private int sec;
    private int ms;
    private Time minTime;
    private Time maxTime;
    private String tz;

    public Time(String name, int hour, int min, int sec, int ms) {
        super(name);
        this.set(hour, min, sec, ms);
    }

    public Time(String name) {
        super(name);
    }

    public Time(int hour, int min, int sec, int ms) {
        this.set(hour, min, sec, ms);
    }

    public Time(int hour, int min, int sec) {
        this.set(hour, min, sec, 0);
    }

    public Time(long millis) {
        this.set(millis);
    }

    public Time() {
    }

    public long getMillis() {
        return (long)this.hour * 3600000L + (long)this.min * 60000L + (long)this.sec * 1000L + (long)this.ms;
    }

    public final int getHour() {
        return this.hour;
    }

    public final int getMinute() {
        return this.min;
    }

    public final int getSecond() {
        return this.sec;
    }

    public final int getMillisecond() {
        return this.ms;
    }

    public void set(int hour, int min, int sec, int ms) {
        if (hour < 0 || hour > 23) {
            throw new IllegalArgumentException("hour not 0-23: " + hour);
        }
        if (min < 0 || min > 59) {
            throw new IllegalArgumentException("min not 0-59: " + min);
        }
        if (sec < 0 || sec > 59) {
            throw new IllegalArgumentException("sec not 0-59: " + sec);
        }
        if (ms < 0 || ms > 999) {
            throw new IllegalArgumentException("ms not 0-999: " + ms);
        }
        this.hour = hour;
        this.min = min;
        this.sec = sec;
        this.ms = ms;
    }

    public void set(long millis) {
        this.hour = (int)(millis / 3600000L);
        this.min = (int)((millis -= (long)this.hour * 3600000L) / 60000L);
        this.sec = (int)((millis -= (long)this.min * 60000L) / 1000L);
        this.ms = (int)(millis -= (long)this.sec * 1000L);
    }

    @Override
    public String getElement() {
        return "time";
    }

    @Override
    public int getBinCode() {
        return 44;
    }

    @Override
    public boolean valEquals(Val that) {
        if (that instanceof Time) {
            return this.getMillis() == ((Time)that).getMillis();
        }
        return false;
    }

    @Override
    public int compareTo(Val that) {
        long b;
        long a = this.getMillis();
        if (a == (b = ((Time)that).getMillis())) {
            return 0;
        }
        if (a < b) {
            return -1;
        }
        return 1;
    }

    @Override
    public String encodeVal() {
        StringBuffer s = new StringBuffer();
        if (this.hour < 10) {
            s.append('0');
        }
        s.append(this.hour);
        s.append(':');
        if (this.min < 10) {
            s.append('0');
        }
        s.append(this.min);
        s.append(':');
        if (this.sec < 10) {
            s.append('0');
        }
        s.append(this.sec);
        if (this.ms != 0) {
            s.append('.');
            if (this.ms < 10) {
                s.append("00");
            } else if (this.ms < 100) {
                s.append('0');
            }
            s.append(this.ms);
        }
        return s.toString();
    }

    public static Time parse(String s) throws Exception {
        Time r = new Time();
        r.decodeVal(s);
        return r;
    }

    @Override
    public void decodeVal(String s) throws Exception {
        try {
            if (s.charAt(2) != ':') {
                throw new Exception();
            }
            int hour = Integer.parseInt(s.substring(0, 2));
            int min = Integer.parseInt(s.substring(3, 5));
            int sec = 0;
            int ms = 0;
            if (s.length() > 5) {
                if (s.charAt(5) != ':') {
                    throw new Exception();
                }
                sec = Integer.parseInt(s.substring(6, 8));
                if (s.length() > 8) {
                    if (s.charAt(8) != '.') {
                        throw new Exception();
                    }
                    if (s.length() >= 9) {
                        ms += (s.charAt(9) - 48) * 100;
                    }
                    if (s.length() >= 10) {
                        ms += (s.charAt(10) - 48) * 10;
                    }
                    if (s.length() >= 11) {
                        ms += (s.charAt(11) - 48) * 1;
                    }
                }
            }
            this.set(hour, min, sec, ms);
        }
        catch (Exception e) {
            throw new Exception("Invalid time: " + s);
        }
    }

    public Time getMin() {
        return this.minTime;
    }

    public void setMin(Time min) {
        this.minTime = min;
    }

    public Time getMax() {
        return this.maxTime;
    }

    public void setMax(Time max) {
        this.maxTime = max;
    }

    public String getTz() {
        return this.tz;
    }

    public void setTz(String tz) {
        this.tz = tz;
    }
}

