/*
 * Decompiled with CFR 0.152.
 */
package obix;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import obix.Contract;
import obix.Obj;
import obix.Ref;
import obix.Uri;
import obix.asm.ObixAssembler;
import obix.contracts.ContractInit;

public class ContractRegistry {
    static ContractClassLoader loader = new ContractClassLoader();
    static Map<String, String> map = new HashMap<String, String>();
    static Map<String, Class<?>> cache = new HashMap();
    static Class<?> NotFound = ContractRegistry.class;
    static Map<String, String> baseContracts = new HashMap<String, String>();

    public static Obj toObj(Class<?> base, Contract contract) {
        try {
            return (Obj)ContractRegistry.toClass(base, contract).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.toString());
        }
    }

    public static Class<?> toClass(Class<?> base, Contract contract) {
        if (contract == null || contract.size() == 0 || contract.containsOnlyObj() || base == Ref.class) {
            return base;
        }
        String key = base.getName() + ": " + contract.toString();
        Class<?> cls = cache.get(key);
        if (cls == NotFound) {
            return base;
        }
        if (cls != null) {
            return cls;
        }
        try {
            cls = ContractRegistry.compile(base, contract);
            if (cls == null) {
                cache.put(key, NotFound);
                return base;
            }
            cache.put(key, cls);
            return cls;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot compile contract: " + key, e);
        }
    }

    private static Class<?> compile(Class<?> base, Contract contract) throws Exception {
        Class<?> cls;
        Uri[] list = contract.list();
        ArrayList acc = new ArrayList();
        for (int i = 0; i < list.length; ++i) {
            String baseClassName;
            cls = loader.getClass(list[i]);
            if (cls != null) {
                acc.add(cls);
            }
            if ((baseClassName = baseContracts.get(list[i].get())) == null) continue;
            if (base != Obj.class && !base.getName().equals(baseClassName)) {
                throw new IllegalArgumentException("Base conflicts with contract: " + base.getName() + " and " + list[i].get());
            }
            base = Class.forName(baseClassName);
        }
        if (acc.size() == 0) {
            return base;
        }
        Class[] interfaces = acc.toArray(new Class[acc.size()]);
        cls = ObixAssembler.compile(base, interfaces);
        System.out.println("-- Compile: " + base.getName() + ": " + contract + " -> " + cls.getName());
        return cls;
    }

    public static void put(String href, String className) {
        ContractRegistry.put(new Uri(href), className);
    }

    public static void put(Uri href, String className) {
        if (map.get(href.get()) != null) {
            throw new IllegalStateException("The specified href is already mapped: " + href);
        }
        map.put(href.get(), className);
        cache.clear();
    }

    public static void put(String href, Class<?> loadedClass) {
        loader.put(href, loadedClass);
    }

    public static void put(Uri href, Class<?> loadedClass) {
        loader.put(href, loadedClass);
    }

    public static ClassLoader getContractClassLoader() {
        return loader;
    }

    static {
        baseContracts.put("obix:obj", "obix.Obj");
        baseContracts.put("obix:bool", "obix.Bool");
        baseContracts.put("obix:int", "obix.Int");
        baseContracts.put("obix:real", "obix.Real");
        baseContracts.put("obix:str", "obix.Str");
        baseContracts.put("obix:enum", "obix.Enum");
        baseContracts.put("obix:abstime", "obix.Abstime");
        baseContracts.put("obix:reltime", "obix.Reltime");
        baseContracts.put("obix:uri", "obix.Uri");
        baseContracts.put("obix:list", "obix.List");
        baseContracts.put("obix:op", "obix.Op");
        baseContracts.put("obix:event", "obix.Event");
        baseContracts.put("obix:ref", "obix.Ref");
        baseContracts.put("obix:err", "obix.Err");
        ContractInit.init();
    }

    private static class ContractClassLoader
    extends ClassLoader {
        private HashMap<String, Class<?>> classMap = new HashMap();

        public ContractClassLoader() {
            super(ContractClassLoader.class.getClassLoader());
        }

        public void put(String href, Class<?> loadedClass) {
            this.put(new Uri(href), loadedClass);
        }

        public void put(Uri href, Class<?> loadedClass) {
            ContractRegistry.put(href, loadedClass.getName());
            this.classMap.put(loadedClass.getName(), loadedClass);
        }

        public Class<?> getClass(Uri uri) throws Exception {
            String className = map.get(uri.get());
            return className == null ? null : this.loadClass(className);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            Class<?> result = this.classMap.get(name);
            return result == null ? super.findClass(name) : result;
        }
    }
}

