/*
 * Decompiled with CFR 0.152.
 */
package obix;

import java.util.ArrayList;
import java.util.StringTokenizer;
import obix.Uri;

public class Contract {
    static final Contract Obj = new Contract("obix:obj");
    Uri[] list;
    String string;

    public Contract(String list) {
        this(Contract.parse(list));
        this.string = list;
    }

    public Contract(String[] list) {
        this.list = new Uri[list.length];
        for (int i = 0; i < list.length; ++i) {
            this.list[i] = new Uri(list[i]);
        }
    }

    public Contract(Uri[] list) {
        this.list = list;
    }

    public static Uri[] parse(String list) {
        StringTokenizer st = new StringTokenizer(list, " ");
        ArrayList<Uri> acc = new ArrayList<Uri>();
        while (st.hasMoreTokens()) {
            acc.add(new Uri(st.nextToken()));
        }
        return acc.toArray(new Uri[acc.size()]);
    }

    public Uri primary() {
        return this.list[0];
    }

    public int size() {
        return this.list.length;
    }

    public Uri get(int index) {
        return this.list[index];
    }

    public Uri[] list() {
        return this.list;
    }

    public boolean contains(Uri uri) {
        for (int i = 0; i < this.list.length; ++i) {
            if (!this.list[i].equals(uri)) continue;
            return true;
        }
        return false;
    }

    public boolean containsOnlyObj() {
        return this.list.length == 1 && this.list[0].get().equals("obix:obj");
    }

    public boolean equals(Object that) {
        if (that instanceof Contract) {
            return this.toString().equals(that.toString());
        }
        return false;
    }

    public String encodeJava() {
        return "new Contract(\"" + this.toString() + "\")";
    }

    public String toString() {
        if (this.string == null) {
            StringBuffer s = new StringBuffer();
            for (int i = 0; i < this.list.length; ++i) {
                if (i > 0) {
                    s.append(' ');
                }
                s.append(this.list[i].encodeVal());
            }
            this.string = s.toString();
        }
        return this.string;
    }
}

