/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platwifi;

import com.tridium.platwifi.BWifiFreqBandEnum;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BHapdHwModeEnum
extends BFrozenEnum {
    public static final int IEEE_802_11A = 1;
    public static final int IEEE_802_11B = 2;
    public static final int IEEE_802_11G = 3;
    public static final int IEEE_802_11N = 4;
    public static final BHapdHwModeEnum ieee802_11a = new BHapdHwModeEnum(1);
    public static final BHapdHwModeEnum ieee802_11b = new BHapdHwModeEnum(2);
    public static final BHapdHwModeEnum ieee802_11g = new BHapdHwModeEnum(3);
    public static final BHapdHwModeEnum ieee802_11n = new BHapdHwModeEnum(4);
    public static final Type TYPE = Sys.loadType(BHapdHwModeEnum.class);
    public static final BHapdHwModeEnum DEFAULT = ieee802_11a;

    public Type getType() {
        return TYPE;
    }

    public static BHapdHwModeEnum make(int ordinal) {
        return (BHapdHwModeEnum)ieee802_11a.getRange().get(ordinal, false);
    }

    public static BHapdHwModeEnum make(String tag) {
        return (BHapdHwModeEnum)ieee802_11a.getRange().get(tag);
    }

    private BHapdHwModeEnum(int ordinal) {
        super(ordinal);
    }

    public String makeConfFileLine(BWifiFreqBandEnum band) {
        switch (this.getOrdinal()) {
            case 1: {
                return "hw_mode=a\n";
            }
            case 2: {
                return "hw_mode=b\n";
            }
            case 3: {
                return "hw_mode=g\n";
            }
            case 4: {
                if (band.getOrdinal() == 0) {
                    return "hw_mode=g\n";
                }
                return "hw_mode=a\n";
            }
        }
        return "hw_mode=g\n";
    }

    public String getRadioString() {
        switch (this.getOrdinal()) {
            case 1: {
                return "IEEE-802.11a";
            }
            case 2: {
                return "IEEE-802.11b";
            }
            case 3: {
                return "IEEE-802.11g";
            }
            case 4: {
                return "IEEE-802.11n";
            }
        }
        return "";
    }
}

